/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWordDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class SplusDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected SplusWordDetector fWordDetector = new SplusWordDetector();
    protected static char[] fgBrackets = new char[]{'{', '}', '(', ')', '[', ']', '\"', '\"'};

    public void doubleClicked(ITextViewer iTextViewer) {
        this.fPos = iTextViewer.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = iTextViewer;
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    protected boolean matchBracketsAt() {
        int n = fgBrackets.length;
        int n2 = fgBrackets.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            int n3;
            IDocument iDocument = this.fText.getDocument();
            char c = iDocument.getChar(this.fPos - 1);
            char c2 = iDocument.getChar(this.fPos);
            for (n3 = 0; n3 < fgBrackets.length; n3 += 2) {
                if (c != fgBrackets[n3]) continue;
                this.fStartPos = this.fPos - 1;
                n = n3;
            }
            for (n3 = 1; n3 < fgBrackets.length; n3 += 2) {
                if (c2 != fgBrackets[n3]) continue;
                this.fEndPos = this.fPos;
                n2 = n3;
            }
            if (this.fStartPos > -1 && n < n2) {
                this.fEndPos = this.searchForClosingBracket(this.fStartPos, c, fgBrackets[n + 1], iDocument);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            } else if (this.fEndPos > -1) {
                this.fStartPos = this.searchForOpenBracket(this.fEndPos, fgBrackets[n2 - 1], c2, iDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    protected boolean matchWord() {
        IDocument iDocument = this.fText.getDocument();
        try {
            char c;
            int n;
            for (n = this.fPos; n >= 0 && this.fWordDetector.isWordPart(c = iDocument.getChar(n)); --n) {
            }
            this.fStartPos = n;
            int n2 = iDocument.getLength();
            for (n = this.fPos; n < n2 && this.fWordDetector.isWordPart(c = iDocument.getChar(n)); ++n) {
            }
            this.fEndPos = n;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        int n3 = 1;
        int n4 = iDocument.getLength();
        for (n2 = n + 1; n2 < n4 && n3 > 0; ++n2) {
            char c3 = iDocument.getChar(n2);
            if (c3 == c && c3 != c2) {
                ++n3;
                continue;
            }
            if (c3 != c2) continue;
            --n3;
        }
        if (n3 == 0) {
            return n2 - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        int n3 = 1;
        for (n2 = n - 1; n2 >= 0 && n3 > 0; --n2) {
            char c3 = iDocument.getChar(n2);
            if (c3 == c2 && c3 != c) {
                ++n3;
                continue;
            }
            if (c3 != c) continue;
            --n3;
        }
        if (n3 == 0) {
            return n2 + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }
}

