/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.graph;

import com.insightful.controls.SplusWin32Tools;
import com.insightful.gdevice.SCanvas;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.eclipse.graph.SWTExportGraphCommand;
import com.insightful.splus.eclipse.graph.SWTGraphColorsDialog;
import com.insightful.splus.eclipse.graph.SWTGraphOptionsDialog;
import com.insightful.splus.graph.CanvasTabbedPane;
import com.insightful.splus.graph.GraphFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class SWTGraphFrame {
    private SWTJavaGraphHandler javaGraphHandler;
    private Shell m_shell = null;

    public SWTGraphFrame(Display display, SCanvas sCanvas) {
        this(display, sCanvas, null, null, null, null);
    }

    public SWTGraphFrame(Display display, SCanvas sCanvas, Image image, Image[] imageArray, String string, Point point) {
        this.m_shell = new Shell(display);
        if (image != null) {
            this.m_shell.setImage(image);
        }
        if (imageArray != null && imageArray.length != 0) {
            this.m_shell.setImages(imageArray);
        }
        this.m_shell.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this.m_shell, 0x1000000);
        this.javaGraphHandler = new SWTJavaGraphHandler(this.m_shell, composite, sCanvas);
        this.m_shell.setText(SWTJavaGraphHandler.getTitle(string));
        Dimension dimension = null;
        if (sCanvas != null) {
            dimension = new Dimension(sCanvas.getUserSize());
        }
        if (dimension == null || dimension.width < 1 || dimension.height < 1) {
            dimension = new Dimension(520, 390);
        }
        dimension.width = Math.min(1000, Math.max(100, dimension.width));
        dimension.height = Math.min(1000, Math.max(100, dimension.height));
        this.m_shell.setSize(dimension.width + 10, dimension.height + 60);
        this.show();
    }

    public void show() {
        this.m_shell.open();
        this.javaGraphHandler.registerJavaGraph();
    }

    public static class SWTJavaGraphHandler
    implements SplusPrintable,
    SaveAsable,
    ShellListener {
        protected static int graphNameCounter = 0;
        protected Shell m_shell;
        protected Composite m_canvasComposite;
        protected SCanvas m_canvas;
        protected CanvasTabbedPane m_paneTabs;
        protected Frame m_frame;
        private int m_hwnd = 0;

        public SWTJavaGraphHandler(Shell shell, Composite composite, SCanvas sCanvas) {
            this.m_shell = shell;
            this.m_canvas = sCanvas;
            this.m_canvasComposite = composite;
            this.init();
        }

        public static String getTitle(String string) {
            String string2 = string;
            if (string2 == null || string2.length() == 0) {
                string2 = "Graph Window " + ++graphNameCounter;
            }
            return string2;
        }

        public void addCanvas(SCanvas sCanvas) {
            this.getTabbedPane().addCanvasTab(sCanvas);
        }

        public CanvasTabbedPane getTabbedPane() {
            return this.m_paneTabs;
        }

        protected void init() {
            this.setupJavaGraphGUI();
            this.addShellListeners();
            this.createMenuBar();
        }

        protected void setupJavaGraphGUI() {
            this.m_paneTabs = new CanvasTabbedPane();
            this.m_frame = SWT_AWT.new_Frame((Composite)this.m_canvasComposite);
            this.m_frame.add((Component)this.m_paneTabs);
            this.m_frame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    SWTJavaGraphHandler.this.doClose();
                }
            });
            this.m_paneTabs.setActiveCanvas(this.m_canvas);
            this.m_paneTabs.addCanvasTab(this.m_canvas);
        }

        protected void addShellListeners() {
            this.m_shell.addShellListener((ShellListener)this);
        }

        protected String[] getFileStrings() {
            String[] stringArray = new String[]{"Save As...", "Print...", "Close"};
            return stringArray;
        }

        protected String[] getFileAccelerators() {
            String[] stringArray = new String[]{"A", "P", "C"};
            return stringArray;
        }

        protected SelectionAdapter[] getFileAdapters() {
            final SWTJavaGraphHandler sWTJavaGraphHandler = this;
            SelectionAdapter[] selectionAdapterArray = new SelectionAdapter[]{new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.saveAs(SWTJavaGraphHandler.this.m_frame, SplusSystem.getCwd());
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_shell.getDisplay().asyncExec((Runnable)new PrintCommand(sWTJavaGraphHandler));
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.doClose();
                }
            }};
            return selectionAdapterArray;
        }

        protected String[] getZoomStrings() {
            String[] stringArray = new String[]{"Zoom In", "Zoom Out", "Zoom to Rectangle", "Fit in Window"};
            return stringArray;
        }

        protected SelectionAdapter[] getZoomAdapters() {
            SWTJavaGraphHandler sWTJavaGraphHandler = this;
            SelectionAdapter[] selectionAdapterArray = new SelectionAdapter[]{new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_paneTabs.zoom(1.5);
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_paneTabs.zoom(0.6666666865348816);
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_paneTabs.zoomToRect();
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_paneTabs.zoomToFrame();
                }
            }};
            return selectionAdapterArray;
        }

        protected String[] getOptionsStrings() {
            String[] stringArray = new String[]{"Set Graph Colors...", "Graph Options..."};
            return stringArray;
        }

        protected String[] getOptionsAccelerators() {
            String[] stringArray = new String[]{"C", "G"};
            return stringArray;
        }

        protected SelectionAdapter[] getOptionsAdapters() {
            SWTJavaGraphHandler sWTJavaGraphHandler = this;
            SelectionAdapter[] selectionAdapterArray = new SelectionAdapter[]{new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!GraphFrame.isLegacyGraphicsMode()) {
                                MessageBox messageBox = new MessageBox(SWTJavaGraphHandler.this.m_shell, 0);
                                messageBox.setMessage(GraphFrame.getColorSetErrorMsg());
                                messageBox.setText(GraphFrame.getColorSetErrorTitle());
                                messageBox.open();
                                return;
                            }
                            SCanvas sCanvas = SWTJavaGraphHandler.this.m_paneTabs.getCanvas();
                            SWTGraphColorsDialog sWTGraphColorsDialog = new SWTGraphColorsDialog(SWTJavaGraphHandler.this.m_shell, sCanvas, false);
                            sWTGraphColorsDialog.open();
                        }
                    });
                }
            }, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SWTJavaGraphHandler.this.m_shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            SWTGraphOptionsDialog sWTGraphOptionsDialog = new SWTGraphOptionsDialog(SWTJavaGraphHandler.this.m_shell);
                            sWTGraphOptionsDialog.open();
                        }
                    });
                }
            }};
            return selectionAdapterArray;
        }

        protected void createMenuBar() {
            int n;
            Menu menu = new Menu((Decorations)this.m_shell, 2);
            this.m_shell.setMenuBar(menu);
            MenuItem menuItem = new MenuItem(menu, 64);
            menuItem.setText("File");
            menuItem.setAccelerator(70);
            Menu menu2 = new Menu((Decorations)this.m_shell, 4);
            menuItem.setMenu(menu2);
            String[] stringArray = this.getFileStrings();
            String[] stringArray2 = this.getFileAccelerators();
            SelectionAdapter[] selectionAdapterArray = this.getFileAdapters();
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("Close")) {
                    new MenuItem(menu2, 2);
                }
                this.newMenuItem(menu2, 0, stringArray[n], stringArray2[n].charAt(0), (SelectionListener)selectionAdapterArray[n]);
            }
            menuItem = new MenuItem(menu, 64);
            menuItem.setText("View");
            menuItem.setAccelerator(86);
            menu2 = new Menu((Decorations)this.m_shell, 4);
            menuItem.setMenu(menu2);
            menuItem = new MenuItem(menu2, 64);
            menuItem.setText("Zoom Graph");
            menu2 = new Menu((Decorations)this.m_shell, 4);
            menuItem.setMenu(menu2);
            stringArray = this.getZoomStrings();
            selectionAdapterArray = this.getZoomAdapters();
            for (n = 0; n < stringArray.length; ++n) {
                this.newMenuItem(menu2, 0, stringArray[n], (SelectionListener)selectionAdapterArray[n]);
            }
            menuItem = new MenuItem(menu, 64);
            menuItem.setText("Options");
            menuItem.setAccelerator(80);
            menu2 = new Menu((Decorations)this.m_shell, 4);
            menuItem.setMenu(menu2);
            stringArray = this.getOptionsStrings();
            stringArray2 = this.getOptionsAccelerators();
            selectionAdapterArray = this.getOptionsAdapters();
            for (n = 0; n < stringArray.length; ++n) {
                this.newMenuItem(menu2, 0, stringArray[n], stringArray2[n].charAt(0), (SelectionListener)selectionAdapterArray[n]);
            }
        }

        public void registerJavaGraph() {
            if (System.getProperty("splus.use.win32") != null) {
                this.m_hwnd = SplusWin32Tools.getHwnd((Frame)this.m_frame);
                SplusWinSessionImpl.setDialogRegister((int)this.m_hwnd, (boolean)true);
            }
        }

        public void deregisterJavaGraph() {
            int n;
            boolean bl = true;
            if (System.getProperty("splus.use.win32") != null) {
                boolean bl2 = bl = !SplusWinSessionImpl.isWindowsGUIClosing();
            }
            if ((n = this.getDeviceNumber()) > 0) {
                this.unlinkCanvases();
                if (bl) {
                    if (SplusSystem.getEngineQueryHandler() != null) {
                        String string = "{dev.off(" + n + ");vector(\"missing\",0)}\n";
                        SplusSystem.getEngineQueryHandler().processDataQuery(string, 5);
                    } else {
                        String string = "Closing this window does not close the S-PLUS device.\nExecute dev.off(" + n + ") to close the device.";
                    }
                }
            } else {
                this.unlinkCanvases();
                this.cleanUpCanvasMemory();
            }
            if (System.getProperty("splus.use.win32") != null) {
                SplusWinSessionImpl.setDialogRegister((int)this.m_hwnd, (boolean)false);
            }
        }

        public void doClose() {
            if (this.m_shell == null || this.m_shell.isDisposed() || this.m_shell.getDisplay() == null) {
                return;
            }
            this.m_shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (SWTJavaGraphHandler.this.m_shell != null && !SWTJavaGraphHandler.this.m_shell.isDisposed()) {
                        SWTJavaGraphHandler.this.m_shell.close();
                    }
                    SWTJavaGraphHandler.this.m_shell = null;
                }
            });
        }

        public void shellActivated(ShellEvent shellEvent) {
            if (System.getProperty("splus.use.win32") != null) {
                // empty if block
            }
        }

        public int getDeviceNumber() {
            for (int i = 0; i < this.m_paneTabs.getTabCount(); ++i) {
                SCanvas sCanvas = this.m_paneTabs.getCanvas(i);
                int n = sCanvas.getDeviceNumber();
                if (n <= 0) continue;
                return n;
            }
            return 0;
        }

        protected void cleanUpCanvasMemory() {
            if (this.m_paneTabs != null) {
                this.m_paneTabs.removeAllTabs();
                this.m_paneTabs.removeAll();
                this.m_paneTabs = null;
            }
            new Thread("SWTGraphFrame-memoryCleanUp"){

                public void run() {
                    if (SWTJavaGraphHandler.this.m_frame != null) {
                        SWTJavaGraphHandler.this.m_frame.removeAll();
                        SWTJavaGraphHandler.this.m_frame.dispose();
                        SWTJavaGraphHandler.this.m_frame = null;
                    }
                }
            }.start();
            if (!this.m_canvasComposite.isDisposed()) {
                this.m_canvasComposite.setVisible(false);
                this.m_canvasComposite.dispose();
            }
        }

        public void unlinkCanvases() {
            for (int i = 0; i < this.m_paneTabs.getTabCount(); ++i) {
                SCanvas sCanvas = this.m_paneTabs.getCanvas(i);
                sCanvas.unlinkGraphicsDevice();
                sCanvas.clearBackgroundRGBA();
                sCanvas.releaseMemory();
                sCanvas.clear();
            }
            this.cleanUpCanvasMemory();
        }

        public void shellClosed(ShellEvent shellEvent) {
            this.deregisterJavaGraph();
        }

        public void shellDeactivated(ShellEvent shellEvent) {
            if (System.getProperty("splus.use.win32") != null) {
                // empty if block
            }
        }

        public void shellDeiconified(ShellEvent shellEvent) {
        }

        public void shellIconified(ShellEvent shellEvent) {
        }

        public void shellOpened(ShellEvent shellEvent) {
        }

        public int getNumberOfPages() {
            return this.m_paneTabs.getTabCount();
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            return -1;
        }

        public File saveAs(Frame frame, File file) {
            if (file != null) {
                SplusSystem.setCwd((File)file);
            }
            SWTExportGraphCommand sWTExportGraphCommand = new SWTExportGraphCommand(frame, this.m_paneTabs, this.m_shell);
            sWTExportGraphCommand.doExecute();
            return SplusSystem.getCwd();
        }

        public void save() {
        }

        MenuItem newMenuItem(Menu menu, int n, String string, int n2, SelectionListener selectionListener) {
            MenuItem menuItem = this.newMenuItem(menu, n, string, selectionListener);
            menuItem.setAccelerator(n2);
            return menuItem;
        }

        MenuItem newMenuItem(Menu menu, int n, String string, SelectionListener selectionListener) {
            MenuItem menuItem = new MenuItem(menu, n);
            menuItem.setText(string);
            menuItem.addSelectionListener(selectionListener);
            return menuItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage createBufferedImage(SCanvas sCanvas) {
            int n = 576;
            int n2 = Math.max(1, (int)((double)n / 1.33333));
            BufferedImage bufferedImage = new BufferedImage(n, n2, 4);
            Dimension dimension = sCanvas.getBestFitSize(new Dimension(n, n2));
            int n3 = sCanvas.getWidth();
            int n4 = sCanvas.getHeight();
            try {
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(sCanvas.getBackgroundColor());
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.translate((n - dimension.width) / 2, (n2 - dimension.height) / 2);
                sCanvas.setSize(dimension.width, dimension.height);
                sCanvas.paint((Graphics)graphics2D);
                graphics2D.dispose();
            }
            finally {
                sCanvas.setSize(n3, n4);
            }
            return bufferedImage;
        }

        public Image createImage(SCanvas sCanvas, Display display) {
            BufferedImage bufferedImage = this.createBufferedImage(sCanvas);
            int n = bufferedImage.getHeight();
            int n2 = bufferedImage.getWidth();
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData(n2, n, 32, paletteData);
            for (int i = 0; i < dataBufferInt.getNumBanks(); ++i) {
                int[] nArray = dataBufferInt.getData(i);
                imageData.setPixels(0, i, nArray.length, nArray, 0);
            }
            return new Image((Device)display, imageData);
        }

        public class PrintCommand
        implements Pageable,
        Runnable {
            private SplusPrintable m_printable = null;
            private PrinterJob m_printerJob;
            private PageFormat m_pageFormat;

            public PrintCommand(SplusPrintable splusPrintable) {
                this.m_printable = splusPrintable;
            }

            public void run() {
                this.doExecute();
            }

            public boolean doExecute() {
                if (this.m_printable != null) {
                    PrintDialog printDialog = new PrintDialog(SWTJavaGraphHandler.this.m_shell, 32768);
                    PrinterData printerData = printDialog.open();
                    Printer printer = new Printer(printerData);
                    Display display = SWTJavaGraphHandler.this.m_shell.getDisplay();
                    for (int i = 0; i < SWTJavaGraphHandler.this.m_paneTabs.getTabCount(); ++i) {
                        SCanvas sCanvas = SWTJavaGraphHandler.this.m_paneTabs.getCanvas(i);
                        Image image = SWTJavaGraphHandler.this.createImage(sCanvas, display);
                        ImageData imageData = image.getImageData();
                        imageData.transparentPixel = -1;
                        Point point = display.getDPI();
                        Point point2 = printer.getDPI();
                        int n = point2.x / point.x;
                        Rectangle rectangle = printer.computeTrim(0, 0, 0, 0);
                        if (!printer.startJob("Test Print")) continue;
                        GC gC = new GC((Drawable)printer);
                        if (printer.startPage()) {
                            gC.drawImage(image, 0, 0, imageData.width, imageData.height, -rectangle.x, -rectangle.y, n * imageData.width, n * imageData.height);
                            printer.endPage();
                        }
                        printer.endJob();
                        gC.dispose();
                    }
                    printer.dispose();
                    return true;
                }
                return false;
            }

            public int getNumberOfPages() {
                return this.m_printable.getNumberOfPages();
            }

            public PageFormat getPageFormat(int n) {
                return this.m_pageFormat;
            }

            public Printable getPrintable(int n) {
                return this.m_printable;
            }
        }
    }
}

