/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.context.FastSplusPartitionParser;
import com.insightful.splus.eclipse.preferences.util.SplusStringListEditor;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SplusOutlinePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_WATCH_FXNS = "watchFxns";
    public static final String P_SHOW_ANON_FUNS = "showAnonFuns";
    public static boolean m_defaultsCreated = false;

    public SplusOutlinePreferencePage() {
        super(1);
        this.setPreferenceStore(SplusEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Spotfire S+ Outline options");
        this.initializeDefaults();
    }

    public static String[] getWatchFunctions() {
        if (!m_defaultsCreated) {
            new SplusOutlinePreferencePage();
        }
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(P_WATCH_FXNS);
        return SplusOutlinePreferencePage.convertFromCommaSepList(string);
    }

    public static boolean showAnonymousFuns() {
        if (!m_defaultsCreated) {
            new SplusOutlinePreferencePage();
        }
        boolean bl = SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_SHOW_ANON_FUNS);
        return bl;
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(P_SHOW_ANON_FUNS, true);
        iPreferenceStore.setDefault(P_WATCH_FXNS, SplusOutlinePreferencePage.convertToCommaSepList(FastSplusPartitionParser.defaultWatchFunctions));
        m_defaultsCreated = true;
    }

    public static String convertToCommaSepList(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static String[] convertFromCommaSepList(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = (String)stringTokenizer.nextElement();
        }
        return stringArray;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.addField((FieldEditor)new BooleanFieldEditor(P_SHOW_ANON_FUNS, "Show &Anonymous Functions in Outline", composite));
        this.addField(new SplusStringListEditor(P_WATCH_FXNS, "Functions to &Watch", composite, this));
    }

    public boolean performOk() {
        return this.saveStartupCodeInfo() && super.performOk();
    }

    public void performApply() {
        this.saveStartupCodeInfo();
        super.performApply();
    }

    public boolean saveStartupCodeInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.restoreSyntaxDefaults();
    }

    private void restoreSyntaxDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
    }
}

