/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.packages.SplusInstallLoadUpdatePackagesDialog;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SplusPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_SPLUS_SHOME = "splus.shome";
    public static final String P_JAVA_GRAPH = "java.graph";
    public static final String P_PDF_VIEWER = "pdf.viewer";
    public static final String P_STARTUP_CODE = "startupCode";
    public static final String P_RUN_STARTUP_CODE = "runStartupCode";
    public static final String P_SEND_TO_CONSOLE = "alwaysConsole";
    public static boolean m_defaultsCreated = false;
    private Combo fRepositories;
    private Button fRunCodeCheckbox;
    private Text fRunCodeText;

    public SplusPreferencePage() {
        super(1);
        this.setPreferenceStore(SplusEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Spotfire S+ Workbench options");
        this.initializeDefaults();
    }

    public static boolean getIntegratedJavaGraph() {
        if (!m_defaultsCreated) {
            new SplusPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_JAVA_GRAPH);
    }

    public static String getPDFViewerLocation() {
        if (!m_defaultsCreated) {
            new SplusPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getString(P_PDF_VIEWER);
    }

    public static String getStartupCode() {
        boolean bl;
        if (!m_defaultsCreated) {
            new SplusPreferencePage();
        }
        if (!(bl = SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_RUN_STARTUP_CODE))) {
            return null;
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getString(P_STARTUP_CODE);
    }

    public static boolean getDoStartupCode() {
        if (!m_defaultsCreated) {
            new SplusPreferencePage();
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_RUN_STARTUP_CODE);
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (SplusEditorPlugin.g_isWindowsOS) {
            iPreferenceStore.setDefault(P_PDF_VIEWER, "");
        } else {
            iPreferenceStore.setDefault(P_PDF_VIEWER, "acroread");
        }
        iPreferenceStore.setDefault(P_JAVA_GRAPH, true);
        iPreferenceStore.setDefault(P_RUN_STARTUP_CODE, SplusEditorPlugin.g_isWindowsOS);
        iPreferenceStore.setDefault(P_STARTUP_CODE, "library(bigdata, first=T)");
        iPreferenceStore.setDefault(P_SEND_TO_CONSOLE, false);
        m_defaultsCreated = true;
    }

    public static String convertToCommaSepList(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static String[] convertFromCommaSepList(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = (String)stringTokenizer.nextElement();
        }
        return stringArray;
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        this.createScriptComponent(composite);
        FileFieldEditor fileFieldEditor = new FileFieldEditor(P_PDF_VIEWER, "Set PDF Viewer Location", composite){

            protected boolean checkState() {
                String string = this.getTextControl().getText();
                if (string.equals(this.getPreferenceStore().getDefaultString(SplusPreferencePage.P_PDF_VIEWER))) {
                    return true;
                }
                return string.length() != 0;
            }
        };
        fileFieldEditor.setFileExtensions(new String[]{"*.exe"});
        this.addField((FieldEditor)fileFieldEditor);
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(P_JAVA_GRAPH, "Integrate Java Graphs into the Spotfire S+ Workbench", composite);
        this.addField((FieldEditor)booleanFieldEditor);
        BooleanFieldEditor booleanFieldEditor2 = new BooleanFieldEditor(P_SEND_TO_CONSOLE, "Send Output from Run action to Console view", composite);
        this.addField((FieldEditor)booleanFieldEditor2);
        this.createRepositoryComponent(composite);
    }

    public boolean performOk() {
        return this.saveStartupCodeInfo() && this.saveRepositories() && super.performOk();
    }

    public void performApply() {
        this.saveStartupCodeInfo();
        super.performApply();
    }

    public boolean saveStartupCodeInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (this.fRunCodeCheckbox != null) {
            iPreferenceStore.setValue(P_RUN_STARTUP_CODE, this.fRunCodeCheckbox.getSelection());
        }
        if (this.fRunCodeText != null) {
            iPreferenceStore.setValue(P_STARTUP_CODE, this.fRunCodeText.getText());
        }
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.restoreSyntaxDefaults();
    }

    private void restoreSyntaxDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = iPreferenceStore.getDefaultBoolean(P_RUN_STARTUP_CODE);
        if (this.fRunCodeCheckbox != null) {
            this.fRunCodeCheckbox.setSelection(bl);
        }
        if (this.fRunCodeText != null) {
            this.fRunCodeText.setText(iPreferenceStore.getDefaultString(P_STARTUP_CODE));
            this.fRunCodeText.setEnabled(bl);
        }
    }

    private Composite createRepositoryComponent(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Spotfire S+ Package Repository:");
        this.fRepositories = new Combo(composite2, 0);
        this.fRepositories.setLayoutData((Object)new GridData(768));
        SplusInstallLoadUpdatePackagesDialog.loadRepositoryList(this.fRepositories);
        return composite2;
    }

    private boolean saveRepositories() {
        SplusInstallLoadUpdatePackagesDialog.saveRepositoryList(this.fRepositories);
        return true;
    }

    private Composite createScriptComponent(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        composite2.setLayoutData((Object)gridData);
        boolean bl = SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_RUN_STARTUP_CODE);
        this.fRunCodeCheckbox = new Button(composite2, 32);
        this.fRunCodeCheckbox.setText("&Run code on startup:");
        this.fRunCodeCheckbox.setSelection(bl);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fRunCodeCheckbox.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        this.fRunCodeText = new Text(composite3, 2050);
        this.fRunCodeText.setText(SplusEditorPlugin.getDefault().getPluginPreferences().getString(P_STARTUP_CODE));
        this.fRunCodeText.setEnabled(bl);
        gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        this.fRunCodeText.setLayoutData((Object)gridData);
        this.fRunCodeCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SplusPreferencePage.this.fRunCodeText.setEnabled(SplusPreferencePage.this.fRunCodeCheckbox.getSelection());
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SplusPreferencePage.this.fRunCodeText.setEnabled(SplusPreferencePage.this.fRunCodeCheckbox.getSelection());
            }
        });
        return composite2;
    }

    public static boolean getSendRunOutputToConsole() {
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(P_SEND_TO_CONSOLE);
    }
}

