/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.views.util.AdaptedViewerWrapper;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class SplusConsole
extends AbstractConsole {
    public static String NAME = "Spotfire S+ Command Line";
    private SplusConsolePage m_page;
    private boolean m_createDummy;

    public SplusConsole() {
        this(true);
    }

    public SplusConsole(boolean bl) {
        super(NAME, null, true);
        this.m_createDummy = bl;
    }

    public boolean isDummy() {
        return this.m_createDummy;
    }

    public IPageBookViewPage createPage(IConsoleView iConsoleView) {
        this.m_page = new SplusConsolePage(this.m_createDummy);
        return this.m_page;
    }

    public TextViewer getTextViewer() {
        if (this.m_page != null) {
            return this.m_page.getTextViewer();
        }
        return null;
    }

    public void showEnd() {
        if (this.m_page != null) {
            this.m_page.m_viewer.asyncShowEnd();
        }
    }

    public void setConsoleEditable(boolean bl) {
        if (this.m_page != null && this.m_page.getTextViewer() != null) {
            this.m_page.getTextViewer().setEditable(bl);
        }
    }

    public static class SplusConsolePage
    extends Page {
        private AdaptedViewerWrapper m_viewer;
        private boolean m_createDummy;
        private IWorkbenchPart m_part;

        public SplusConsolePage(boolean bl) {
            this.m_createDummy = bl;
        }

        public void init(IPageSite iPageSite) {
            super.init(iPageSite);
            this.m_part = iPageSite.getPage().getActivePart();
        }

        public void createControl(Composite composite) {
            if (this.m_createDummy) {
                Composite composite2 = new Composite(composite, 0);
                return;
            }
            ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
            int n = 770;
            try {
                this.m_viewer = new AdaptedViewerWrapper(composite, n, consoleHistoryDocument, this.m_part);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.hookContextMenu();
            this.getSite().setSelectionProvider(this.m_viewer.getSelectionProvider());
            NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection) {
                ((DefaultConnection)noConnection).getOutputHandler();
            }
        }

        private void hookContextMenu() {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    SplusConsolePage.this.m_viewer.fillMenu(iMenuManager);
                }
            });
            this.m_viewer.hookContextMenu(menuManager, this.getSite().getPage().getActivePart().getSite());
        }

        public Control getControl() {
            return this.m_viewer.getControl();
        }

        public TextViewer getTextViewer() {
            return this.m_viewer.getViewer();
        }

        public void setActionBars(IActionBars iActionBars) {
            this.m_viewer.fillMenu(iActionBars.getMenuManager());
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_viewer.getCutAction());
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.m_viewer.getCopyAction());
            iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.m_viewer.getPasteAction());
        }

        public void setFocus() {
            this.getControl().setFocus();
        }
    }
}

