/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusEditorMessages;
import com.insightful.splus.eclipse.preferences.SplusConsolePreferencePage;
import com.insightful.splus.eclipse.preferences.SplusOutputPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import com.insightful.splus.eclipse.views.util.IHistoryListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.FindReplaceAction;

public class ViewerWrapper
implements LineStyleListener,
LineBackgroundListener,
VerifyListener,
MouseListener,
KeyListener,
IDocumentListener,
IHistoryListener,
IPropertyChangeListener,
VerifyKeyListener {
    public static final Color DEFAULT_OUTPUT_COLOR = new Color(null, 127, 0, 0);
    public Color DEFAULT_BACKGROUND = new Color(null, 239, 239, 239);
    protected Color OUTPUT_COLOR = this.getOutputColor();
    public Font CONSOLE_FONT = null;
    protected TextViewer m_viewer;
    protected AbstractDocument m_document;
    protected MoveCursor m_moveCursor;
    private IWorkbenchPart m_actualView = null;
    private FindReplaceAction m_findAction = null;
    private Action m_copyAction = null;
    private Action m_cutAction = null;
    private Action m_saveAction = null;
    private Action m_printAction = null;
    private Action m_selectAllAction = null;
    private Action m_pasteAction = null;
    private Action m_clearAction = null;
    private Action m_prefAction = null;
    private Clipboard m_clipboard = null;

    public static FontData getDefaultFontData() {
        return new FontData("Courier", 10, 0);
    }

    public ViewerWrapper(Composite composite, int n, AbstractDocument abstractDocument, IWorkbenchPart iWorkbenchPart) {
        this.m_document = abstractDocument;
        this.createViewer(composite, abstractDocument, n);
        this.DEFAULT_BACKGROUND = this.m_viewer.getTextWidget().getBackground();
        this.changeFont(ViewerWrapper.getDefaultFontData());
        Color color = this.getBackgroundColor();
        if (color != null) {
            this.m_viewer.getTextWidget().setBackground(color);
        }
        StyledText styledText = this.m_viewer.getTextWidget();
        styledText.setToolTipText("");
        styledText.addLineStyleListener((LineStyleListener)this);
        styledText.addLineBackgroundListener((LineBackgroundListener)this);
        styledText.addVerifyListener((VerifyListener)this);
        styledText.addMouseListener((MouseListener)this);
        styledText.addKeyListener((KeyListener)this);
        this.m_viewer.appendVerifyKeyListener((VerifyKeyListener)this);
        this.m_viewer.setEditable(true);
        this.m_viewer.setDocument((IDocument)abstractDocument);
        abstractDocument.addDocumentListener((IDocumentListener)this);
        if (abstractDocument instanceof ConsoleHistoryDocument) {
            ConsoleHistoryDocument consoleHistoryDocument = (ConsoleHistoryDocument)abstractDocument;
            consoleHistoryDocument.addHistoryListener(this);
        }
        this.changeFont(this.getPreferenceFont());
        styledText.setKeyBinding(17039362, 0x1000002);
        styledText.setKeyBinding(0x1040001, 0x1000001);
        styledText.setKeyBinding(27, 0);
        this.m_actualView = iWorkbenchPart;
        this.m_moveCursor = new MoveCursor(this);
        SplusEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void changeFont(FontData fontData) {
        Display display = this.m_viewer.getControl().getDisplay();
        if (fontData != null) {
            this.CONSOLE_FONT = new Font((Device)display, fontData);
            this.m_viewer.getTextWidget().setFont(this.CONSOLE_FONT);
        }
        this.m_viewer.invalidateTextPresentation();
        this.m_viewer.refresh();
    }

    protected void createViewer(Composite composite, AbstractDocument abstractDocument, int n) {
        this.m_viewer = new TextViewer(composite, n){

            protected StyledText createTextWidget(Composite composite, int n) {
                return new StyledText(composite, n){

                    public void paste() {
                        ViewerWrapper.this.doPaste();
                    }

                    public void copy() {
                        ViewerWrapper.this.doCopy();
                    }

                    public void cut() {
                        ViewerWrapper.this.doCut();
                    }
                };
            }
        };
    }

    protected void doCopy() {
        this.m_copyAction.run();
    }

    protected void doCut() {
        this.m_cutAction.run();
    }

    protected void doPaste() {
        this.m_pasteAction.run();
    }

    public TextViewer getViewer() {
        return this.m_viewer;
    }

    protected FindReplaceAction getFindAction() {
        if (this.m_findAction == null) {
            ResourceBundle resourceBundle = SplusEditorMessages.getResourceBundle();
            this.m_findAction = new FindReplaceAction(resourceBundle, "find_replace_action.", this.m_actualView);
            this.m_findAction.setText("Find");
            this.m_findAction.setAccelerator(262214);
            this.m_findAction.setEnabled(true);
        }
        return this.m_findAction;
    }

    protected Action getCutAction() {
        if (this.m_cutAction == null) {
            this.m_cutAction = new CutAction();
        }
        return this.m_cutAction;
    }

    protected Action getCopyAction() {
        if (this.m_copyAction == null) {
            this.m_copyAction = new CopyAction();
        }
        return this.m_copyAction;
    }

    protected Action getPasteAction() {
        if (this.m_pasteAction == null) {
            this.m_pasteAction = new PasteAction();
        }
        return this.m_pasteAction;
    }

    protected void showEnd() {
        int n = this.m_document.getNumberOfLines();
        try {
            int n2 = this.m_document.getLineOffset(n - 1);
            StyledText styledText = this.m_viewer.getTextWidget();
            if (styledText != null && n2 > 0) {
                styledText.setCaretOffset(n2);
                styledText.showSelection();
            }
            int n3 = n2 + this.m_document.getLineLength(n - 1);
            if (styledText != null && n3 > 0) {
                styledText.setSelection(n3, n3);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void asyncShowEnd() {
        int n = this.m_document.getNumberOfLines();
        try {
            int n2 = this.m_document.getLineOffset(n - 1);
            int n3 = n2 + this.m_document.getLineLength(n - 1);
            this.m_moveCursor.update(n3);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        StyleRange styleRange = new StyleRange();
        try {
            int n = this.m_document.getLineOfOffset(lineStyleEvent.lineOffset);
            styleRange.start = this.m_document.getLineOffset(n);
            styleRange.length = this.m_document.getLineLength(n);
            styleRange.foreground = this.OUTPUT_COLOR;
            if (this.CONSOLE_FONT != null) {
                FontData fontData = this.CONSOLE_FONT.getFontData()[0];
                this.setLineInfo(this.CONSOLE_FONT, fontData, styleRange);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        lineStyleEvent.styles = new StyleRange[]{styleRange};
    }

    protected void setLineInfo(Font font, FontData fontData, StyleRange styleRange) {
        try {
            styleRange.getClass().getField("font").set(styleRange, font);
        }
        catch (Exception exception) {
            Class<?> clazz = fontData.getClass();
            try {
                Object object = clazz.getField("data").get(fontData);
                styleRange.strikeout = object.getClass().getField("lfStrikeOut").get(object).equals(new Integer(1));
                styleRange.underline = object.getClass().getField("lfUnderline").get(object).equals(new Integer(1));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            styleRange.fontStyle = fontData.getStyle();
        }
    }

    public void lineGetBackground(LineBackgroundEvent lineBackgroundEvent) {
    }

    public Control getControl() {
        return this.m_viewer.getControl();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.m_viewer;
    }

    public void verifyText(VerifyEvent verifyEvent) {
        if (verifyEvent.widget instanceof StyledText) {
            verifyEvent.doit = false;
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1 && this.getControl().getMenu() != null) {
            this.getControl().getMenu().setVisible(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        switch (verifyEvent.keyCode) {
            case 0x100000A: {
                ISelection iSelection = this.getSelectionProvider().getSelection();
                String string = "";
                if (iSelection instanceof TextSelection) {
                    string = ((TextSelection)iSelection).getText();
                }
                SplusEditorPlugin.getDefault().sendCmd("help(\"" + string + "\")");
                break;
            }
            case 27: {
                this.doEscape();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.stateMask == 262144) {
            switch (keyEvent.keyCode) {
                case 108: {
                    this.m_clearAction.run();
                    break;
                }
                case 112: {
                    this.m_printAction.run();
                    break;
                }
                case 115: {
                    this.m_saveAction.run();
                    break;
                }
                case 97: {
                    this.m_selectAllAction.run();
                    break;
                }
                case 102: {
                    this.getFindAction().run();
                }
            }
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public void documentChanged(DocumentEvent documentEvent) {
        this.asyncShowEnd();
    }

    public void historySelectedBlockChanged(ConsoleHistoryDocument consoleHistoryDocument) {
    }

    public void historySelectedBlockChanged(ConsoleHistoryDocument consoleHistoryDocument, boolean bl) {
    }

    public void historyRemoved(ConsoleHistoryDocument consoleHistoryDocument) {
        this.asyncShowEnd();
    }

    public void historyAdded(ConsoleHistoryDocument consoleHistoryDocument, int n) {
        this.asyncShowEnd();
    }

    public void historyInput(ConsoleHistoryDocument consoleHistoryDocument, int n, int n2) {
        this.asyncShowEnd();
    }

    public Clipboard getClipboard() {
        if (this.m_clipboard == null) {
            this.m_clipboard = new Clipboard(this.m_viewer.getControl().getShell().getDisplay());
        }
        return this.m_clipboard;
    }

    public void hookContextMenu(MenuManager menuManager, IWorkbenchPartSite iWorkbenchPartSite) {
        Menu menu = menuManager.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.m_viewer);
    }

    private void createActions() {
        if (this.m_selectAllAction == null) {
            this.m_selectAllAction = new SelectAllAction();
        }
        if (this.m_saveAction == null) {
            this.m_saveAction = new SaveAction();
        }
        if (this.m_printAction == null) {
            this.m_printAction = new PrintAction();
        }
        if (this.m_clearAction == null) {
            this.m_clearAction = new ClearAction();
        }
        if (this.m_prefAction == null) {
            this.m_prefAction = new PreferenceAction();
        }
        this.getCopyAction().setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.getCutAction().setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.getPasteAction().setActionDefinitionId("org.eclipse.ui.edit.paste");
    }

    protected void doEscape() {
        DefaultConnection defaultConnection;
        NoConnection noConnection;
        if (this.m_document instanceof ConsoleHistoryDocument && (noConnection = SplusEditorPlugin.getDefault().getConnection()) instanceof DefaultConnection && (defaultConnection = (DefaultConnection)noConnection).isEngineBusy()) {
            defaultConnection.setEscaped();
        }
    }

    public void fillMenu(IMenuManager iMenuManager) {
        this.fillMenu(iMenuManager, true);
    }

    public void fillMenu(IMenuManager iMenuManager, boolean bl) {
        this.createActions();
        if (bl) {
            iMenuManager.add((IAction)this.m_clearAction);
            iMenuManager.add((IContributionItem)new Separator());
        }
        iMenuManager.add((IAction)this.m_copyAction);
        iMenuManager.add((IAction)this.m_cutAction);
        iMenuManager.add((IAction)this.m_pasteAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.getFindAction());
        iMenuManager.add((IAction)this.m_selectAllAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.m_saveAction);
        iMenuManager.add((IAction)this.m_printAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.m_prefAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void putContentsInClipboard() {
        TextTransfer[] textTransferArray = new TextTransfer[]{TextTransfer.getInstance()};
        Object[] objectArray = new Object[]{this.getDocumentAsText()};
        this.getClipboard().setContents(objectArray, (Transfer[])textTransferArray);
    }

    protected String[] getPreferencePageIds() {
        String[] stringArray = new String[]{"com.insightful.splus.eclipse.editors.spluseditor.preferences.SplusOutputPreferencePage"};
        return stringArray;
    }

    protected void doPrint() {
        try {
            Shell shell = this.m_viewer.getControl().getShell();
            TextViewer textViewer = new TextViewer((Composite)shell, this.m_viewer.getTextWidget().getStyle());
            textViewer.getTextWidget().setFont(SplusEditorPlugin.getDefaultFont(shell.getDisplay()));
            Document document = new Document();
            document.replace(0, 0, this.getDocumentAsText());
            textViewer.setDocument((IDocument)document);
            textViewer.getTextWidget().print();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String getLinePrompt(int n) {
        return "";
    }

    public String getDocumentAsText() {
        boolean bl = SplusConsolePreferencePage.getCopyPrompts();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Point point = this.getViewer().getSelectedRange();
            int n = point.x == -1 ? 0 : point.x;
            int n2 = point.y == -1 ? this.m_document.getLength() : point.y;
            int n3 = this.m_document.getLineOfOffset(n);
            int n4 = this.m_document.getLineOfOffset(n + n2);
            int n5 = n - this.m_document.getLineOffset(n3);
            int n6 = n + n2 - this.m_document.getLineOffset(n4);
            boolean bl2 = n5 == 0;
            for (int i = n3; i <= n4; ++i) {
                if (bl && (i != n3 || bl2)) {
                    stringBuffer.append(this.getLinePrompt(i));
                }
                int n7 = this.m_document.getLineOffset(i);
                int n8 = this.m_document.getLineLength(i);
                String string = this.m_document.get(n7, n8);
                if (i == n3) {
                    if (i != n4) {
                        stringBuffer.append(string.substring(n5));
                        continue;
                    }
                    stringBuffer.append(string.substring(n5, n6));
                    continue;
                }
                if (i == n4) {
                    stringBuffer.append(string.substring(0, n6));
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        String string;
        Shell shell = this.m_viewer.getControl().getShell();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        String string2 = fileDialog.open();
        while (true) {
            if (string2 == null) {
                if (iProgressMonitor != null) {
                    iProgressMonitor.setCanceled(true);
                }
                return;
            }
            File file = new File(string2);
            if (!file.exists() || MessageDialog.openQuestion((Shell)shell, (String)"Question", (String)(string = "The file " + string2 + " already exists.  Do you want to replace the existing file?"))) break;
            string2 = fileDialog.open();
        }
        boolean bl = false;
        try {
            string = this.getDocumentAsText();
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            String string3 = "Error in Save";
            String string4 = exception.getMessage();
            if (string4.startsWith("Attempted to begin")) {
                string4 = "Failed attempting to save file onto an existing project file.  \nRemove existing file from project first.";
            }
            MessageDialog.openError((Shell)shell, (String)string3, (String)string4);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(!bl);
        }
    }

    protected String getOutputColorPreferenceName() {
        return SplusOutputPreferencePage.getOutputPreferencePage().outputPropertyName();
    }

    protected String getFontPreferenceName() {
        return SplusOutputPreferencePage.getOutputPreferencePage().fontPropertyName();
    }

    protected String getBackgroundPreferenceName() {
        return SplusOutputPreferencePage.getOutputPreferencePage().backgroundPropertyName();
    }

    protected String getBackgroundColorPreferenceName() {
        return SplusOutputPreferencePage.getOutputPreferencePage().backgroundColorPropertyName();
    }

    protected Color getBackgroundColor() {
        return SplusOutputPreferencePage.getOutputViewBackground();
    }

    protected FontData getPreferenceFont() {
        return SplusOutputPreferencePage.getOutputViewConsoleFont();
    }

    protected Color getOutputColor() {
        return SplusOutputPreferencePage.getOutputViewOutputColor();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(this.getOutputColorPreferenceName())) {
            Object object = propertyChangeEvent.getNewValue();
            RGB rGB = object instanceof RGB ? (RGB)object : StringConverter.asRGB((String)((String)object));
            this.OUTPUT_COLOR = SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(rGB);
            this.m_viewer.invalidateTextPresentation();
            this.m_viewer.refresh();
        } else if (string.equals(this.getFontPreferenceName())) {
            Object object = propertyChangeEvent.getNewValue();
            FontData fontData = object instanceof FontData ? (FontData)object : new FontData((String)object);
            this.changeFont(fontData);
        } else if (propertyChangeEvent.getProperty().equals(this.getBackgroundPreferenceName()) || propertyChangeEvent.getProperty().equals(this.getBackgroundColorPreferenceName())) {
            Color color = this.getBackgroundColor();
            if (color == null) {
                this.getViewer().getTextWidget().setBackground(this.DEFAULT_BACKGROUND);
            } else {
                this.getViewer().getTextWidget().setBackground(color);
            }
            this.m_viewer.invalidateTextPresentation();
            this.m_viewer.refresh();
        }
    }

    public class SaveAction
    extends Action {
        public SaveAction() {
            super("Save");
            this.setAccelerator(262227);
        }

        public void run() {
            ViewerWrapper.this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public class SelectAllAction
    extends Action {
        public SelectAllAction() {
            super("Select All");
            this.setAccelerator(262209);
        }

        public void run() {
            ViewerWrapper.this.m_viewer.doOperation(7);
        }
    }

    public class PrintAction
    extends Action {
        public PrintAction() {
            super("Print");
            this.setAccelerator(262224);
        }

        public boolean isEnabled() {
            return Printer.getDefaultPrinterData() != null;
        }

        public void run() {
            final Shell shell = ViewerWrapper.this.m_viewer.getControl().getShell();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (Printer.getDefaultPrinterData() == null) {
                        ErrorDialog.openError((Shell)shell, (String)"Default printer not found", (String)"Error", null, (int)4);
                    }
                    ViewerWrapper.this.doPrint();
                }
            });
        }
    }

    public class PasteAction
    extends Action {
        public PasteAction() {
            super("Paste");
        }

        public boolean isEnabled() {
            return ViewerWrapper.this.m_document instanceof ConsoleHistoryDocument;
        }

        public void run() {
            ViewerWrapper.this.m_viewer.doOperation(5);
        }
    }

    public class CutAction
    extends Action {
        public CutAction() {
            super("Cut");
            this.setAccelerator(262232);
        }

        public boolean isEnabled() {
            return ViewerWrapper.this.m_document instanceof ConsoleHistoryDocument;
        }

        public void run() {
            ViewerWrapper.this.putContentsInClipboard();
            ViewerWrapper.this.m_viewer.doOperation(6);
        }
    }

    public class CopyAction
    extends Action {
        public CopyAction() {
            super("Copy");
            this.setAccelerator(262211);
        }

        public void run() {
            ViewerWrapper.this.putContentsInClipboard();
        }
    }

    public class ClearAction
    extends Action {
        public ClearAction() {
            super("Clear");
            this.setAccelerator(262220);
            this.setToolTipText("Clear console text");
        }

        public void run() {
            Runnable runnable = new Runnable(){

                public void run() {
                    SplusEditorPlugin.getDefault().getConsoleDocument().clear();
                }
            };
            Display display = ViewerWrapper.this.getControl().getShell().getDisplay();
            display.asyncExec(runnable);
        }
    }

    public class PreferenceAction
    extends Action {
        public PreferenceAction() {
            super("Preferences...");
        }

        public void run() {
            String[] stringArray = ViewerWrapper.this.getPreferencePageIds();
            Shell shell = ViewerWrapper.this.getControl().getShell();
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)stringArray[0], (String[])stringArray, null).open();
        }
    }

    public class MoveCursor
    implements Runnable {
        private Boolean isRunningObject = new Boolean(false);
        private ViewerWrapper wrapper = null;
        private int scheduled = 0;
        private int end = 0;

        public MoveCursor(ViewerWrapper viewerWrapper2) {
            this.wrapper = viewerWrapper2;
        }

        public void update(int n) {
            this.end = n;
            if (this.scheduled == 0) {
                this.scheduled = 1;
                SplusEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Boolean bl = this.isRunningObject;
            synchronized (bl) {
                this.wrapper.m_viewer.getSelectionProvider().setSelection((ISelection)new TextSelection(this.end, 0));
                if (this.wrapper.m_viewer.getTextWidget() != null) {
                    this.wrapper.m_viewer.getTextWidget().showSelection();
                }
                this.scheduled = 0;
            }
        }
    }
}

