/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess.servlet;

import com.insightful.webdavaccess.IWebdavAlias;
import com.insightful.webdavaccess.IWebdavAuthorization;
import com.insightful.webdavaccess.IWebdavStorage;
import com.insightful.webdavaccess.ResourceLocks;
import com.insightful.webdavaccess.WebdavAliasFactory;
import com.insightful.webdavaccess.WebdavAuthorizationFactory;
import com.insightful.webdavaccess.WebdavStoreFactory;
import com.insightful.webdavaccess.exceptions.AccessDeniedException;
import com.insightful.webdavaccess.exceptions.ObjectAlreadyExistsException;
import com.insightful.webdavaccess.exceptions.ObjectNotFoundException;
import com.insightful.webdavaccess.exceptions.UnauthenticatedException;
import com.insightful.webdavaccess.exceptions.WebdavException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.util.MD5Encoder;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.util.XMLWriter;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.webdav.lib.util.WebdavStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebdavServlet
extends HttpServlet {
    private static final long serialVersionUID = -3879804749319022302L;
    private static Log log = LogFactory.getLog(WebdavServlet.class);
    public static final String WEBDAV_AUTHENTICATION_IMPLEMENTATION = "webdavAuthorizationImplementation";
    public static final String WEBDAV_ALIAS_IMPLEMENTATION = "webdavAliasManagerImplementation";
    public static final String WEBDAV_RESOURCE_IMPLEMENTATION = "webdavStoreImplementation";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_DELETE = "DELETE";
    public static final String TOMCAT_CSS = "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}HR {color : #525D76;}";
    protected static MessageDigest md5Helper;
    protected static final MD5Encoder md5Encoder;
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static int BUF_SIZE;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final SimpleDateFormat creationDateFormat;
    private static final String READONLY_PARAMETER = "readonly";
    private boolean readOnly;
    public static final String DEBUG_PARAMETER = "servletDebug";
    protected static URLEncoder urlEncoder;
    private ResourceLocks fResLocks = null;
    private IWebdavStorage fStore = null;
    private IWebdavAuthorization fAuthorize = null;
    private IWebdavAlias fAliasManager = null;
    private static int fdebug;
    private WebdavStoreFactory fFactory;
    private Hashtable fParameter;

    public void init() throws ServletException {
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        String clazz = this.getServletConfig().getInitParameter(WEBDAV_RESOURCE_IMPLEMENTATION);
        try {
            String aliasImpl;
            this.fFactory = new WebdavStoreFactory(WebdavServlet.class.getClassLoader().loadClass(clazz));
            this.fParameter = new Hashtable();
            Enumeration initParameterNames = this.getServletConfig().getInitParameterNames();
            while (initParameterNames.hasMoreElements()) {
                String key = (String)initParameterNames.nextElement();
                this.fParameter.put(key, this.getServletConfig().getInitParameter(key));
            }
            String readonlyString = (String)this.fParameter.get(READONLY_PARAMETER);
            this.readOnly = readonlyString != null && readonlyString.equalsIgnoreCase("true");
            this.fStore = this.fFactory.getStore();
            this.fResLocks = new ResourceLocks();
            String debugString = (String)this.fParameter.get(DEBUG_PARAMETER);
            fdebug = debugString == null ? 0 : Integer.parseInt(debugString);
            String authImpl = this.getServletConfig().getInitParameter(WEBDAV_AUTHENTICATION_IMPLEMENTATION);
            if (authImpl != null && authImpl.trim().length() > 0) {
                WebdavAuthorizationFactory factory = new WebdavAuthorizationFactory(WebdavServlet.class.getClassLoader().loadClass(authImpl));
                this.fAuthorize = factory.getAuthorization();
            }
            if ((aliasImpl = this.getServletConfig().getInitParameter(WEBDAV_ALIAS_IMPLEMENTATION)) != null && aliasImpl.trim().length() > 0) {
                WebdavAliasFactory factory = new WebdavAliasFactory(WebdavServlet.class.getClassLoader().loadClass(aliasImpl));
                this.fAliasManager = factory.getAliasManager();
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, AuthenticationException {
        String method = req.getMethod();
        if (fdebug == 1) {
            String s;
            log.debug((Object)"WebdavServlet REQUEST:  -----------------");
            log.debug((Object)("Method = " + method));
            log.debug((Object)("Time: " + System.currentTimeMillis()));
            log.debug((Object)("Path: " + this.getRelativePath(req)));
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                log.debug((Object)("Header: " + s + " " + req.getHeader(s)));
            }
            e = req.getAttributeNames();
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                log.debug((Object)("Attribute: " + s + " " + req.getAttribute(s)));
            }
            e = req.getParameterNames();
            while (e.hasMoreElements()) {
                s = (String)e.nextElement();
                log.debug((Object)("Parameter: " + s + " " + req.getParameter(s)));
            }
        }
        try {
            this.fStore.begin(req, this.fParameter, this.getServletContext().getRealPath("/"));
            if (this.fAuthorize != null) {
                this.fAuthorize.authorize(req);
            }
            resp.setStatus(200);
            try {
                if (method.equals(METHOD_PROPFIND)) {
                    this.doPropfind(req, resp);
                } else if (method.equals(METHOD_PROPPATCH)) {
                    this.doProppatch(req, resp);
                } else if (method.equals(METHOD_MKCOL)) {
                    this.doMkcol(req, resp);
                } else if (method.equals(METHOD_COPY)) {
                    this.doCopy(req, resp);
                } else if (method.equals(METHOD_MOVE)) {
                    this.doMove(req, resp);
                } else if (method.equals(METHOD_PUT)) {
                    this.doPut(req, resp);
                } else if (method.equals(METHOD_GET)) {
                    this.doGet(req, resp, true);
                } else if (method.equals(METHOD_OPTIONS)) {
                    this.doOptions(req, resp);
                } else if (method.equals(METHOD_HEAD)) {
                    this.doHead(req, resp);
                } else if (method.equals(METHOD_DELETE)) {
                    this.doDelete(req, resp);
                } else {
                    super.service(req, resp);
                }
                this.fStore.commit();
            }
            catch (IOException e) {
                log.error((Object)"WebdavServer internal error: ", (Throwable)e);
                resp.sendError(500);
                this.fStore.rollback();
                throw new ServletException((Throwable)e);
            }
        }
        catch (UnauthenticatedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            log.error((Object)"WebdavServer internal error: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void recursiveParseProperties(String currentPath, HttpServletRequest req, XMLWriter generatedXML, int propertyFindType, Vector properties, int depth) throws WebdavException {
        this.parseProperties(req, generatedXML, currentPath, propertyFindType, properties);
        String[] names = this.fStore.getChildrenNames(currentPath);
        if (names != null && depth > 0) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                String newPath = currentPath;
                if (!newPath.endsWith("/")) {
                    newPath = newPath + "/";
                }
                newPath = newPath + name;
                this.recursiveParseProperties(newPath, req, generatedXML, propertyFindType, properties, depth - 1);
            }
        }
    }

    private PropertyNodeType getPropertyNodeAndType(ServletRequest req) throws ServletException {
        PropertyNodeType nodeType = new PropertyNodeType(1);
        if (req.getContentLength() != 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                NodeList childList = rootElement.getChildNodes();
                block6: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block6;
                        }
                        case 1: {
                            if (currentNode.getNodeName().endsWith("prop")) {
                                nodeType.setType(0);
                                nodeType.setNode(currentNode);
                            }
                            if (currentNode.getNodeName().endsWith("propname")) {
                                nodeType.setType(2);
                            }
                            if (!currentNode.getNodeName().endsWith("allprop")) continue block6;
                            nodeType.setType(1);
                        }
                    }
                }
            }
            catch (Exception e) {}
        } else {
            nodeType.setType(1);
        }
        return nodeType;
    }

    private Properties getProperties(ServletRequest req) throws ServletException {
        Properties props = new Properties();
        if (req.getContentLength() == 0) {
            return props;
        }
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            NodeList childList = rootElement.getChildNodes();
            block5: for (int i = 0; i < childList.getLength(); ++i) {
                Node currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 1: {
                        if ("set".equals(currentNode.getLocalName())) {
                            NodeList propList = currentNode.getChildNodes();
                            for (int j = 0; j < propList.getLength(); ++j) {
                                Node propNode = propList.item(j);
                                if (!"prop".equals(propNode.getLocalName())) continue;
                                NodeList propNodes = propNode.getChildNodes();
                                for (int k = 0; k < propNodes.getLength(); ++k) {
                                    Node node = propNodes.item(k);
                                    String pname = node.getNodeName();
                                    if (pname == null || pname.trim().length() == 0) continue;
                                    String value = node.getTextContent();
                                    props.setProperty(pname, value);
                                }
                            }
                            continue block5;
                        }
                        if (!"remove".equals(currentNode.getLocalName())) continue block5;
                        continue block5;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return props;
    }

    private String getParentPath(String path) {
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            return path.substring(0, slash);
        }
        return null;
    }

    private DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("jaxp failed");
        }
        return documentBuilder;
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return this.fAliasManager != null ? this.fAliasManager.getResourceDestination(result) : result;
        }
        String servletPath = request.getServletPath();
        String result = request.getPathInfo();
        if (result == null) {
            result = servletPath + "/";
            return this.fAliasManager != null ? this.fAliasManager.getResourceDestination(result) : result;
        }
        if (!result.startsWith(servletPath + "/")) {
            result = servletPath + result;
        }
        if (result == null || result.equals("")) {
            result = servletPath;
        }
        return this.fAliasManager != null ? this.fAliasManager.getResourceDestination(result) : result;
    }

    private Vector getPropertiesFromXML(Node propNode) {
        Vector<String> properties = new Vector<String>();
        NodeList childList = propNode.getChildNodes();
        block4: for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            switch (currentNode.getNodeType()) {
                case 3: {
                    continue block4;
                }
                case 1: {
                    String nodeName = currentNode.getNodeName();
                    String propertyName = null;
                    propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                    properties.addElement(propertyName);
                }
            }
        }
        return properties;
    }

    private int getDepth(HttpServletRequest req) {
        int depth = 3;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null) {
            if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            } else if (depthStr.equals("infinity")) {
                depth = 3;
            }
        }
        return depth;
    }

    private String getCleanPath(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lockOwner = "doOptions" + System.nanoTime() + req.toString();
        String path = this.getRelativePath(req);
        if (this.fResLocks.lock(path, lockOwner, false, 0)) {
            try {
                resp.addHeader("DAV", "1, 2");
                String methodsAllowed = this.determineMethodsAllowed(this.fStore.objectExists(path), this.fStore.isFolder(path));
                resp.addHeader("Allow", methodsAllowed);
                resp.addHeader("MS-Author-Via", "DAV");
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this.fResLocks.unlock(path, lockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lockOwner = "doPropfind" + System.nanoTime() + req.toString();
        String path = this.getRelativePath(req);
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        int depth = this.getDepth(req);
        if (this.fResLocks.lock(path, lockOwner, false, depth)) {
            try {
                if (!this.fStore.objectExists(path)) {
                    resp.setStatus(404);
                    return;
                }
                Vector properties = null;
                path = this.getCleanPath(this.getRelativePath(req));
                PropertyNodeType nodeType = this.getPropertyNodeAndType((ServletRequest)req);
                if (nodeType.getType() == 0) {
                    properties = this.getPropertiesFromXML(nodeType.getNode());
                }
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                XMLWriter generatedXML = new XMLWriter(resp.getWriter());
                generatedXML.writeXMLHeader();
                generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                if (depth == 0) {
                    this.parseProperties(req, generatedXML, path, nodeType.getType(), properties);
                } else {
                    this.recursiveParseProperties(path, req, generatedXML, nodeType.getType(), properties, depth);
                }
                generatedXML.writeElement(null, "multistatus", 1);
                generatedXML.sendData();
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this.fResLocks.unlock(path, lockOwner);
            }
        } else {
            log.error((Object)("WebdavServer unable to lock resource " + lockOwner));
            resp.sendError(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
        } else {
            String lockOwner = "doProppatch" + System.nanoTime() + req.toString();
            String path = this.getRelativePath(req);
            if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
                resp.sendError(403);
                return;
            }
            if (this.fResLocks.lock(path, lockOwner, false, -1)) {
                try {
                    if (!this.fStore.objectExists(path)) {
                        resp.setStatus(404);
                        return;
                    }
                    Properties properties = this.getProperties((ServletRequest)req);
                    this.fStore.setCustomProperties(path, properties);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp, boolean includeBody) throws ServletException, IOException {
        String lockOwner = "doGet" + System.nanoTime() + req.toString();
        String path = this.getRelativePath(req);
        if (this.fResLocks.lock(path, lockOwner, false, 0)) {
            try {
                if (this.fStore.isResource(path)) {
                    String mimeType;
                    if (path.endsWith("/") || path.endsWith("\\")) {
                        resp.sendError(404, req.getRequestURI());
                        return;
                    }
                    long lastModified = this.fStore.getLastModified(path).getTime();
                    resp.setDateHeader("last-modified", lastModified);
                    long resourceLength = this.fStore.getResourceLength(path);
                    if (resourceLength > 0L) {
                        if (resourceLength <= Integer.MAX_VALUE) {
                            resp.setContentLength((int)resourceLength);
                        } else {
                            resp.setHeader("content-length", "" + resourceLength);
                        }
                    }
                    if ((mimeType = this.getServletContext().getMimeType(path)) != null) {
                        resp.setContentType(mimeType);
                    }
                    if (!includeBody) return;
                    ServletOutputStream out = resp.getOutputStream();
                    InputStream in = this.fStore.getResourceContent(path);
                    try {
                        int read = -1;
                        byte[] copyBuffer = new byte[BUF_SIZE];
                        while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                            out.write(copyBuffer, 0, read);
                        }
                        return;
                    }
                    finally {
                        in.close();
                        out.flush();
                        out.close();
                    }
                }
                if (includeBody && this.fStore.isFolder(path)) {
                    this.renderHtml(path, (OutputStream)resp.getOutputStream(), req.getContextPath());
                    resp.setContentType("text/html");
                    return;
                }
                if (!this.fStore.objectExists(path) && includeBody) {
                    resp.setStatus(404);
                    return;
                }
                String requestUri = (String)req.getAttribute("javax.servlet.include.request_uri");
                if (requestUri == null) {
                    requestUri = req.getRequestURI();
                } else {
                    resp.getWriter().write("The requested resource (" + requestUri + ") is not available");
                }
                resp.sendError(404, requestUri);
                return;
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
                return;
            }
            catch (ObjectAlreadyExistsException e) {
                resp.sendError(404, req.getRequestURI());
                return;
            }
            catch (WebdavException e) {
                resp.sendError(500);
                return;
            }
            finally {
                this.fResLocks.unlock(path, lockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }

    protected void renderHtml(String contextPath, OutputStream stream, String prefix) throws IOException, ServletException {
        String parent;
        int slash;
        String path = contextPath;
        OutputStreamWriter osWriter = new OutputStreamWriter(stream, "UTF8");
        PrintWriter writer = new PrintWriter(osWriter);
        StringBuffer sb = new StringBuffer();
        String rewrittenContextPath = this.rewriteUrl(contextPath);
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>");
        sb.append("Directory " + path);
        sb.append("</title>\r\n");
        sb.append("<STYLE><!--");
        sb.append(TOMCAT_CSS);
        sb.append("--></STYLE> ");
        sb.append("</head>\r\n");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append("Directory " + path);
        String parentDirectory = path;
        if (parentDirectory.endsWith("/")) {
            parentDirectory = parentDirectory.substring(0, parentDirectory.length() - 1);
        }
        if ((slash = parentDirectory.lastIndexOf(47)) >= 0 && (parent = path.substring(0, slash)).trim().length() > 0) {
            sb.append(" - <a href=\"");
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(this.rewriteUrl(parent));
            if (!parent.endsWith("/")) {
                sb.append("/");
            }
            sb.append("\">");
            sb.append("<b>");
            sb.append("Parent Directory " + parent);
            sb.append("</b>");
            sb.append("</a>");
        }
        sb.append("</h1>");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Filename");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
        sb.append("Size");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
        sb.append("lastModified");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        try {
            String[] children = this.fStore.getChildrenNames(contextPath);
            boolean shade = false;
            for (int i = 0; i < children.length; ++i) {
                boolean exists;
                String child = children[i];
                String resourceName = child;
                String trimmed = resourceName;
                if (trimmed.equalsIgnoreCase("WEB-INF") || trimmed.equalsIgnoreCase("META-INF")) continue;
                String resourcePath = rewrittenContextPath;
                if (!resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                if (!(exists = this.fStore.objectExists(resourcePath = resourcePath + resourceName))) continue;
                sb.append("<tr");
                if (shade) {
                    sb.append(" bgcolor=\"#eeeeee\"");
                }
                sb.append(">\r\n");
                shade = !shade;
                boolean isDir = this.fStore.isFolder(resourcePath);
                sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
                sb.append("<a href=\"");
                if (prefix != null) {
                    sb.append(prefix);
                }
                sb.append(resourcePath);
                if (isDir) {
                    sb.append("/");
                }
                sb.append("\"><tt>");
                sb.append(RequestUtil.filter(trimmed));
                if (isDir) {
                    sb.append("/");
                }
                sb.append("</tt></a></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                if (isDir) {
                    sb.append("&nbsp;");
                } else {
                    try {
                        sb.append(this.renderSize(this.fStore.getResourceLength(resourcePath)));
                    }
                    catch (WebdavException e) {
                        sb.append(this.renderSize(-1L));
                    }
                }
                sb.append("</tt></td>\r\n");
                sb.append("<td align=\"right\"><tt>");
                try {
                    sb.append(this.fStore.getLastModified(resourcePath));
                }
                catch (WebdavException e) {
                    sb.append("?");
                }
                sb.append("</tt></td>\r\n");
                sb.append("</tr>\r\n");
            }
        }
        catch (WebdavException e) {
            throw new ServletException("Error accessing resource", (Throwable)e);
        }
        sb.append("</table>\r\n");
        sb.append("<HR size=\"1\" noshade=\"noshade\">");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        writer.write(sb.toString());
        writer.flush();
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getContentLength() > 0) {
            resp.sendError(501);
        } else if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            String lockOwner = "doMkcol" + System.nanoTime() + req.toString();
            if (this.fResLocks.lock(path, lockOwner, true, 0)) {
                try {
                    if (parentPath != null && this.fStore.isFolder(parentPath)) {
                        boolean isFolder = this.fStore.isFolder(path);
                        if (!this.fStore.objectExists(path)) {
                            try {
                                this.fStore.createFolder(path);
                            }
                            catch (ObjectAlreadyExistsException e) {
                                String methodsAllowed = this.determineMethodsAllowed(true, isFolder);
                                resp.addHeader("Allow", methodsAllowed);
                                resp.sendError(405);
                            }
                        }
                        String methodsAllowed = this.determineMethodsAllowed(true, isFolder);
                        resp.addHeader("Allow", methodsAllowed);
                        resp.sendError(405);
                    }
                    resp.sendError(409);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.readOnly) {
            String lockOwner;
            String path = this.getRelativePath(req);
            if (this.fResLocks.lock(path, lockOwner = "doDelete" + System.nanoTime() + req.toString(), true, -1)) {
                try {
                    Hashtable errorList = new Hashtable();
                    this.deleteResource(path, errorList, req, resp);
                    if (errorList.isEmpty()) return;
                    this.sendReport(req, resp, errorList);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            String lockOwner = "doPut" + System.nanoTime() + req.toString();
            if (this.fResLocks.lock(path, lockOwner, true, -1)) {
                try {
                    if (parentPath != null && this.fStore.isFolder(parentPath) && !this.fStore.isFolder(path)) {
                        if (!this.fStore.objectExists(path)) {
                            this.fStore.createResource(path);
                            resp.setStatus(201);
                        } else {
                            resp.setStatus(204);
                        }
                        this.fStore.setResourceContent(path, (InputStream)req.getInputStream(), null, null);
                        resp.setContentLength((int)this.fStore.getResourceLength(path));
                    }
                    resp.sendError(409);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePath(req);
        if (!this.readOnly) {
            String lockOwner = "doCopy" + System.nanoTime() + req.toString();
            if (this.fResLocks.lock(path, lockOwner, false, -1)) {
                try {
                    this.copyResource(req, resp);
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(409, req.getRequestURI());
                }
                catch (ObjectNotFoundException e) {
                    resp.sendError(404, req.getRequestURI());
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
        } else {
            resp.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.readOnly) {
            String lockOwner;
            String path = this.getRelativePath(req);
            if (this.fResLocks.lock(path, lockOwner = "doMove" + System.nanoTime() + req.toString(), false, -1)) {
                try {
                    String destinationPath = this.copyResource(req, resp);
                    if (destinationPath != null) {
                        Hashtable errorList = new Hashtable();
                        this.deleteResource(path, errorList, req, resp);
                        if (!errorList.isEmpty()) {
                            this.sendReport(req, resp, errorList);
                        }
                        if (this.fAliasManager == null) return;
                        this.fAliasManager.resourceMovedNotification(path, destinationPath);
                        return;
                    }
                    resp.sendError(500);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.fResLocks.unlock(path, lockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    private String generateNamespaceDeclarations() {
        return " xmlns=\"DAV:\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String copyResource(HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        String lockOwner;
        String path;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            resp.sendError(400);
            return null;
        }
        int protocolIndex = (destinationPath = RequestUtil.URLDecode(destinationPath, "UTF8")).indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        destinationPath = this.normalize(destinationPath);
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((path = this.getRelativePath(req)).equals(destinationPath)) {
            resp.sendError(403);
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        if (this.fResLocks.lock(destinationPath, lockOwner = "copyResource" + System.nanoTime() + req.toString(), true, -1)) {
            try {
                if (!this.fStore.objectExists(path)) {
                    resp.sendError(500);
                    String string = null;
                    return string;
                }
                boolean exists = this.fStore.objectExists(destinationPath);
                Hashtable errorList = new Hashtable();
                if (overwrite) {
                    if (exists) {
                        this.deleteResource(destinationPath, errorList, req, resp);
                    } else {
                        resp.setStatus(201);
                    }
                } else {
                    if (exists) {
                        resp.sendError(412);
                        String string = null;
                        return string;
                    }
                    resp.setStatus(201);
                }
                this.copy(path, destinationPath, errorList, req, resp);
                if (errorList.isEmpty()) return destinationPath;
                this.sendReport(req, resp, errorList);
                return destinationPath;
            }
            finally {
                this.fResLocks.unlock(destinationPath, lockOwner);
            }
        } else {
            resp.sendError(500);
            return null;
        }
    }

    private void copy(String sourcePath, String destinationPath, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException, IOException {
        if (this.fStore.isResource(sourcePath)) {
            this.fStore.copyResource(sourcePath, destinationPath);
        } else if (this.fStore.isFolder(sourcePath)) {
            this.copyFolder(sourcePath, destinationPath, errorList, req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void copyFolder(String sourcePath, String destinationPath, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        this.fStore.createFolder(destinationPath);
        boolean infiniteDepth = true;
        if (req.getHeader("depth") != null && req.getHeader("depth").equals("0")) {
            infiniteDepth = false;
        }
        if (infiniteDepth) {
            String[] children = this.fStore.getChildrenNames(sourcePath);
            for (int i = children.length - 1; i >= 0; --i) {
                children[i] = "/" + children[i];
                try {
                    if (this.fStore.isResource(sourcePath + children[i])) {
                        this.fStore.copyResource(sourcePath + children[i], destinationPath + children[i]);
                        continue;
                    }
                    this.copyFolder(sourcePath + children[i], destinationPath + children[i], errorList, req, resp);
                    continue;
                }
                catch (AccessDeniedException e) {
                    errorList.put(destinationPath + children[i], new Integer(403));
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    errorList.put(destinationPath + children[i], new Integer(404));
                    continue;
                }
                catch (ObjectAlreadyExistsException e) {
                    errorList.put(destinationPath + children[i], new Integer(409));
                    continue;
                }
                catch (WebdavException e) {
                    errorList.put(destinationPath + children[i], new Integer(500));
                }
            }
        }
    }

    private void deleteResource(String path, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws IOException, WebdavException {
        resp.setStatus(204);
        if (!this.readOnly) {
            if (this.fStore.isResource(path)) {
                this.fStore.removeObject(path);
            } else if (this.fStore.isFolder(path)) {
                this.deleteFolder(path, errorList, req, resp);
                this.fStore.removeObject(path);
            } else {
                resp.sendError(404);
            }
        } else {
            resp.sendError(403);
        }
    }

    private void deleteFolder(String path, Hashtable errorList, HttpServletRequest req, HttpServletResponse resp) throws WebdavException {
        String[] children = this.fStore.getChildrenNames(path);
        for (int i = children.length - 1; i >= 0; --i) {
            children[i] = "/" + children[i];
            try {
                if (this.fStore.isResource(path + children[i])) {
                    this.fStore.removeObject(path + children[i]);
                    continue;
                }
                this.deleteFolder(path + children[i], errorList, req, resp);
                this.fStore.removeObject(path + children[i]);
                continue;
            }
            catch (AccessDeniedException e) {
                errorList.put(path + children[i], new Integer(403));
                continue;
            }
            catch (ObjectNotFoundException e) {
                errorList.put(path + children[i], new Integer(404));
                continue;
            }
            catch (WebdavException e) {
                errorList.put(path + children[i], new Integer(500));
            }
        }
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable errorList) throws IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = (String)pathList.nextElement();
            int errorCode = (Integer)errorList.get(errorPath);
            generatedXML.writeElement(null, "response", 0);
            generatedXML.writeElement(null, "href", 0);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(absoluteUri + toAppend);
            generatedXML.writeElement(null, "href", 1);
            generatedXML.writeElement(null, "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + WebdavStatus.getStatusText((int)errorCode));
            generatedXML.writeElement(null, "status", 1);
            generatedXML.writeElement(null, "response", 1);
        }
        generatedXML.writeElement(null, "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector propertiesVector) throws WebdavException {
        String creationdate = this.getISOCreationDate(this.fStore.getCreationDate(path).getTime());
        boolean isFolder = this.fStore.isFolder(path);
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        String lastModified = formatter.format(this.fStore.getLastModified(path));
        String resourceLength = String.valueOf(this.fStore.getResourceLength(path));
        generatedXML.writeElement(null, "response", 0);
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText((int)200));
        generatedXML.writeElement(null, "href", 0);
        String href = req.getContextPath();
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (isFolder && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement(null, "href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeProperty(null, "creationdate", creationdate);
                generatedXML.writeElement(null, "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement(null, "displayname", 1);
                if (!isFolder) {
                    generatedXML.writeProperty(null, "getlastmodified", lastModified);
                    generatedXML.writeProperty(null, "getcontentlength", resourceLength);
                    String contentType = this.getServletContext().getMimeType(path);
                    if (contentType != null) {
                        generatedXML.writeProperty(null, "getcontenttype", contentType);
                    }
                    generatedXML.writeProperty(null, "getetag", this.getETag(path, resourceLength, lastModified));
                    generatedXML.writeElement(null, "resourcetype", 2);
                } else {
                    generatedXML.writeElement(null, "resourcetype", 0);
                    generatedXML.writeElement(null, "collection", 2);
                    generatedXML.writeElement(null, "resourcetype", 1);
                }
                Properties customProperties = this.fStore.getCustomProperties(path);
                if (customProperties != null && customProperties.size() > 0) {
                    Enumeration<Object> en = customProperties.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        generatedXML.writeProperty(null, key, customProperties.getProperty(key));
                    }
                }
                generatedXML.writeProperty(null, "source", "");
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                generatedXML.writeElement(null, "creationdate", 2);
                generatedXML.writeElement(null, "displayname", 2);
                if (!isFolder) {
                    generatedXML.writeElement(null, "getcontentlanguage", 2);
                    generatedXML.writeElement(null, "getcontentlength", 2);
                    generatedXML.writeElement(null, "getcontenttype", 2);
                    generatedXML.writeElement(null, "getetag", 2);
                    generatedXML.writeElement(null, "getlastmodified", 2);
                }
                generatedXML.writeElement(null, "resourcetype", 2);
                generatedXML.writeElement(null, "source", 2);
                generatedXML.writeElement(null, "lockdiscovery", 2);
                Properties customProperties = this.fStore.getCustomProperties(path);
                if (customProperties != null && customProperties.size() > 0) {
                    customProperties = this.fStore.getCustomProperties(path);
                    Enumeration<Object> en = customProperties.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        generatedXML.writeElement(null, key, 2);
                    }
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                Enumeration properties = propertiesVector.elements();
                Properties customProperties = this.fStore.getCustomProperties(path);
                while (properties.hasMoreElements()) {
                    String property = (String)properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty(null, "creationdate", creationdate);
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement(null, "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeElement(null, "getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontentlength", resourceLength);
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(path));
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getetag", this.getETag(path, resourceLength, lastModified));
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (isFolder) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty(null, "getlastmodified", lastModified);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (isFolder) {
                            generatedXML.writeElement(null, "resourcetype", 0);
                            generatedXML.writeElement(null, "collection", 2);
                            generatedXML.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty(null, "source", "");
                        continue;
                    }
                    if (customProperties != null && customProperties.containsKey(property)) {
                        generatedXML.writeProperty(null, property, customProperties.getProperty(property));
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText((int)404));
                generatedXML.writeElement(null, "propstat", 0);
                generatedXML.writeElement(null, "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement(null, (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement(null, "prop", 1);
                generatedXML.writeElement(null, "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement(null, "status", 1);
                generatedXML.writeElement(null, "propstat", 1);
            }
        }
        generatedXML.writeElement(null, "response", 1);
    }

    protected String getETag(String path, String resourceLength, String lastModified) {
        return "W/\"" + resourceLength + "-" + lastModified + "\"";
    }

    protected String rewriteUrl(String path) {
        return urlEncoder.encode(path);
    }

    private String getISOCreationDate(long creationDate) {
        StringBuffer creationDateValue = new StringBuffer(creationDateFormat.format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    private String determineMethodsAllowed(boolean exists, boolean isFolder) {
        StringBuffer methodsAllowed = new StringBuffer();
        try {
            if (exists) {
                methodsAllowed.append("OPTIONS, GET, HEAD, POST, DELETE, TRACE");
                methodsAllowed.append(", PROPPATCH, COPY, MOVE, LOCK, UNLOCK, PROPFIND");
                if (isFolder) {
                    methodsAllowed.append(", PUT");
                }
                return methodsAllowed.toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        methodsAllowed.append("OPTIONS, MKCOL, PUT, LOCK");
        return methodsAllowed.toString();
    }

    static {
        md5Encoder = new MD5Encoder();
        BUF_SIZE = 50000;
        creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        urlEncoder = new URLEncoder();
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        fdebug = -1;
    }

    private class PropertyNodeType {
        Node node = null;
        int type = 1;

        public PropertyNodeType(int type) {
            this.type = type;
        }

        public PropertyNodeType(Node propNode, int type) {
            this.node = propNode;
            this.type = type;
        }

        protected Node getNode() {
            return this.node;
        }

        protected void setNode(Node node) {
            this.node = node;
        }

        protected int getType() {
            return this.type;
        }

        protected void setType(int type) {
            this.type = type;
        }
    }
}

