/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class ChildTestIterator
extends LocPathIterator {
    public ChildTestIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        int whatToShow = compiler.getWhatToShow(firstStepPos);
        if ((whatToShow & 0x43) == 0 || whatToShow == -1) {
            this.initNodeTest(whatToShow);
        } else {
            this.initNodeTest(whatToShow, compiler.getStepNS(firstStepPos), compiler.getStepLocalName(firstStepPos));
        }
        this.initPredicateInfo(compiler, firstStepPos);
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        ChildTestIterator clone = (ChildTestIterator)super.cloneWithReset();
        clone.resetProximityPositions();
        return clone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node nextNode() throws DOMException {
        Node node;
        int savedStart;
        VariableStack vars;
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node next = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return next;
        }
        if (this.m_foundLast) {
            return null;
        }
        if (this.m_lastFetched == null) {
            this.resetProximityPositions();
        }
        if (this.m_varStackPos != -1) {
            vars = this.m_execContext.getVarStack();
            savedStart = vars.getSearchStart();
            vars.setSearchStart(this.m_varStackPos);
            vars.pushContextPosition(this.m_varStackContext);
        } else {
            vars = null;
            savedStart = 0;
        }
        try {
            Node next;
            do {
                next = this.m_lastFetched == null ? this.m_context.getFirstChild() : this.m_lastFetched.getNextSibling();
                this.m_lastFetched = next;
            } while (next != null && this.acceptNode(next) != 1 && next != null);
            if (next != null) {
                if (this.m_cachedNodes != null) {
                    this.m_cachedNodes.addElement(this.m_lastFetched);
                }
                ++this.m_next;
                Node node2 = next;
                Object var6_7 = null;
                if (this.m_varStackPos == -1) return node2;
                vars.setSearchStart(savedStart);
                vars.popContextPosition();
                return node2;
            }
            this.m_foundLast = true;
            node = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (this.m_varStackPos == -1) throw throwable;
            vars.setSearchStart(savedStart);
            vars.popContextPosition();
            throw throwable;
        }
        Object var6_8 = null;
        if (this.m_varStackPos == -1) return node;
        vars.setSearchStart(savedStart);
        vars.popContextPosition();
        return node;
    }
}

