/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoUndoManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class JGoDocument
implements JGoObjectCollection,
Transferable,
Serializable {
    private JGoLayer myDefaultLayer = null;
    private JGoLayer myFirstLayer = null;
    private JGoLayer myLastLayer = null;
    private Dimension myDocumentSize = new Dimension(0, 0);
    private Point myDocumentTopLeft = new Point(0, 0);
    private Color myPaperColor = Color.white;
    private boolean myModifiable = true;
    private transient boolean \u012c = false;
    private static transient DataFlavor \u012d = null;
    private static transient DataFlavor[] \u012e = null;
    private transient Vector \u012f = null;
    private transient JGoDocumentEvent \u0130 = null;
    private transient JGoUndoManager \u011e = null;

    public JGoDocument() {
        this.myDefaultLayer = new JGoLayer();
        this.myDefaultLayer.\u00c0(this);
        this.myFirstLayer = this.myDefaultLayer;
        this.myLastLayer = this.myDefaultLayer;
    }

    public Dimension getDocumentSize() {
        return this.myDocumentSize;
    }

    public void setDocumentSize(int n, int n2) {
        Dimension dimension = this.getDocumentSize();
        if (dimension.width != n || dimension.height != n2) {
            Dimension dimension2 = new Dimension(dimension);
            this.myDocumentSize.width = n;
            this.myDocumentSize.height = n2;
            this.fireUpdate(5, 0, null, 0, dimension2);
        }
    }

    public final void setDocumentSize(Dimension dimension) {
        this.setDocumentSize(dimension.width, dimension.height);
    }

    protected void updateDocumentSize(JGoObject jGoObject) {
        Dimension dimension = this.getDocumentSize();
        Point point = this.getDocumentTopLeft();
        Rectangle rectangle = jGoObject.getBoundingRect();
        int n = Math.min(point.x, rectangle.x);
        int n2 = Math.min(point.y, rectangle.y);
        int n3 = Math.max(point.x + dimension.width, rectangle.x + rectangle.width);
        int n4 = Math.max(point.y + dimension.height, rectangle.y + rectangle.height);
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n < point.x || n2 < point.y) {
            this.setDocumentTopLeft(n, n2);
        }
        if (n5 > dimension.width || n6 > dimension.height) {
            this.setDocumentSize(n5, n6);
        }
    }

    public Point getDocumentTopLeft() {
        return this.myDocumentTopLeft;
    }

    public void setDocumentTopLeft(int n, int n2) {
        Point point = this.getDocumentTopLeft();
        if (point.x != n || point.y != n2) {
            Point point2 = new Point(point);
            this.myDocumentTopLeft.x = n;
            this.myDocumentTopLeft.y = n2;
            this.fireUpdate(9, 0, null, 0, point2);
        }
    }

    public final void setDocumentTopLeft(Point point) {
        this.setDocumentTopLeft(point.x, point.y);
    }

    public Color getPaperColor() {
        return this.myPaperColor;
    }

    public void setPaperColor(Color color) {
        Color color2 = this.getPaperColor();
        if (color != color2 && color != null && !color.equals(color2)) {
            this.myPaperColor = color;
            this.fireUpdate(6, 0, null, 0, color2);
        }
    }

    public boolean isModifiable() {
        return this.myModifiable;
    }

    public void setModifiable(boolean bl) {
        boolean bl2 = this.isModifiable();
        if (bl2 != bl) {
            this.myModifiable = bl;
            this.fireUpdate(8, 0, null, bl2 ? 1 : 0, null);
        }
    }

    public int getNumObjects() {
        int n = 0;
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            n += jGoLayer.getNumObjects();
            jGoLayer = jGoLayer.getNextLayer();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.getNumObjects() == 0;
    }

    public JGoListPosition addObjectAtHead(JGoObject jGoObject) {
        return this.getFirstLayer().addObjectAtHead(jGoObject);
    }

    public JGoListPosition addObjectAtTail(JGoObject jGoObject) {
        return this.getLastLayer().addObjectAtTail(jGoObject);
    }

    public JGoListPosition insertObjectBefore(JGoListPosition jGoListPosition, JGoObject jGoObject) {
        if (jGoListPosition == null || jGoObject == null) {
            return null;
        }
        JGoObject jGoObject2 = this.getObjectAtPos(jGoListPosition);
        return jGoObject2.getLayer().insertObjectBefore(jGoListPosition, jGoObject);
    }

    public JGoListPosition insertObjectAfter(JGoListPosition jGoListPosition, JGoObject jGoObject) {
        if (jGoListPosition == null || jGoObject == null) {
            return null;
        }
        JGoObject jGoObject2 = this.getObjectAtPos(jGoListPosition);
        return jGoObject2.getLayer().insertObjectAfter(jGoListPosition, jGoObject);
    }

    public void bringObjectToFront(JGoObject jGoObject) {
        this.getLastLayer().bringObjectToFront(jGoObject);
    }

    public void sendObjectToBack(JGoObject jGoObject) {
        this.getFirstLayer().sendObjectToBack(jGoObject);
    }

    public void removeObject(JGoObject jGoObject) {
        if (jGoObject == null) {
            return;
        }
        JGoLayer jGoLayer = jGoObject.getLayer();
        if (jGoLayer == null) {
            return;
        }
        if (jGoLayer.getDocument() != this) {
            return;
        }
        jGoLayer.removeObject(jGoObject);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
        return jGoObject.getLayer().removeObjectAtPos(jGoListPosition);
    }

    public void deleteContents() {
        while (this.getLastLayer() != this.getFirstLayer()) {
            this.removeLayer(this.getLastLayer());
        }
        this.getFirstLayer().removeAll();
        this.setDocumentSize(0, 0);
    }

    public JGoObject pickObject(Point point, boolean bl) {
        JGoLayer jGoLayer = this.getLastLayer();
        while (jGoLayer != null) {
            JGoObject jGoObject;
            if (jGoLayer.isVisible() && (jGoObject = jGoLayer.pickObject(point, bl)) != null) {
                return jGoObject;
            }
            jGoLayer = jGoLayer.getPrevLayer();
        }
        return null;
    }

    public JGoListPosition getFirstObjectPos() {
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            JGoListPosition jGoListPosition = jGoLayer.getFirstObjectPos();
            if (jGoListPosition != null) {
                return jGoListPosition;
            }
            jGoLayer = jGoLayer.getNextLayer();
        }
        return null;
    }

    public JGoListPosition getLastObjectPos() {
        JGoLayer jGoLayer = this.getLastLayer();
        while (jGoLayer != null) {
            JGoListPosition jGoListPosition = jGoLayer.getLastObjectPos();
            if (jGoListPosition != null) {
                return jGoListPosition;
            }
            jGoLayer = jGoLayer.getPrevLayer();
        }
        return null;
    }

    public JGoListPosition getNextObjectPos(JGoListPosition jGoListPosition) {
        JGoObjectCollection jGoObjectCollection;
        if (jGoListPosition == null) {
            return null;
        }
        Object object = jGoListPosition.obj;
        if (object instanceof JGoObjectCollection && !(jGoObjectCollection = (JGoObjectCollection)object).isEmpty()) {
            return jGoObjectCollection.getFirstObjectPos();
        }
        jGoListPosition = jGoListPosition.next;
        while (jGoListPosition == null) {
            Serializable serializable;
            jGoObjectCollection = ((JGoObject)object).getParent();
            if (jGoObjectCollection == null) {
                serializable = ((JGoObject)object).getLayer();
                serializable = ((JGoLayer)serializable).getNextLayer();
                while (serializable != null) {
                    JGoListPosition jGoListPosition2 = ((JGoLayer)serializable).getFirstObjectPos();
                    if (jGoListPosition2 != null) {
                        return jGoListPosition2;
                    }
                    serializable = ((JGoLayer)serializable).getNextLayer();
                }
                return null;
            }
            serializable = ((JGoArea)jGoObjectCollection).\u010b();
            object = jGoObjectCollection;
            jGoListPosition = ((JGoListPosition)serializable).next;
        }
        return jGoListPosition;
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        JGoObject jGoObject = jGoListPosition.obj;
        while (jGoObject.getParent() != null) {
            jGoListPosition = jGoObject.getParent().\u010b();
            jGoObject = jGoObject.getParent();
        }
        jGoListPosition = jGoListPosition.next;
        if (jGoListPosition == null) {
            JGoLayer jGoLayer = jGoObject.getLayer();
            jGoLayer = jGoLayer.getNextLayer();
            while (jGoLayer != null) {
                JGoListPosition jGoListPosition2 = jGoLayer.getFirstObjectPos();
                if (jGoListPosition2 != null) {
                    return jGoListPosition2;
                }
                jGoLayer = jGoLayer.getNextLayer();
            }
        }
        return jGoListPosition;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        return jGoListPosition.prev;
    }

    public JGoObject getObjectAtPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        return jGoListPosition.obj;
    }

    public JGoListPosition findObject(JGoObject jGoObject) {
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            JGoListPosition jGoListPosition = jGoLayer.findObject(jGoObject);
            if (jGoListPosition != null) {
                return jGoListPosition;
            }
            jGoLayer = jGoLayer.getNextLayer();
        }
        return null;
    }

    public void addDocumentListener(JGoDocumentListener jGoDocumentListener) {
        if (!this.\u012c().contains(jGoDocumentListener)) {
            this.\u012c().addElement(jGoDocumentListener);
        }
    }

    public void removeDocumentListener(JGoDocumentListener jGoDocumentListener) {
        this.\u012c().removeElement(jGoDocumentListener);
    }

    Vector \u012c() {
        if (this.\u012f == null) {
            this.\u012f = new Vector();
        }
        return this.\u012f;
    }

    public final void fireUpdate(int n, int n2, Object object) {
        this.fireUpdate(n, n2, object, 0, null);
    }

    public void fireUpdate(int n, int n2, Object object, int n3, Object object2) {
        this.\u012d(n, n2, object, n3, object2);
    }

    void \u012d(int n, int n2, Object object, int n3, Object object2) {
        if (this.isSuspendUpdates()) {
            return;
        }
        if (this.\u0130 == null) {
            this.\u0130 = new JGoDocumentEvent(this, n, n2, object, n3, object2);
        } else {
            this.\u0130.\u0136(n);
            this.\u0130.setFlags(n2);
            this.\u0130.\u0137(object);
            this.\u0130.\u0139(n3);
            this.\u0130.\u0138(object2);
        }
        JGoDocumentEvent jGoDocumentEvent = this.\u0130;
        this.\u0130 = null;
        Vector vector = this.\u012c();
        int n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            JGoDocumentListener jGoDocumentListener = (JGoDocumentListener)vector.elementAt(n5);
            jGoDocumentListener.documentChanged(jGoDocumentEvent);
            ++n5;
        }
        this.\u0130 = jGoDocumentEvent;
        this.\u0130.\u0137(null);
    }

    public void fireForedate(int n, int n2, Object object) {
        this.\u012d(n |= 0x8000, n2, object, 0, null);
    }

    public final void update() {
        this.fireUpdate(1, 0, null, 0, null);
    }

    public boolean isSuspendUpdates() {
        return this.\u012c;
    }

    public void setSuspendUpdates(boolean bl) {
        boolean bl2 = this.isSuspendUpdates();
        if (bl2 != bl) {
            this.\u012c = bl;
            this.update();
        }
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 2: {
                return;
            }
            case 3: {
                JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
                jGoObject.copyOldValueForUndo(jGoDocumentChangedEdit);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                jGoDocumentChangedEdit.setOldValue(new Dimension((Dimension)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 6: {
                return;
            }
            case 8: {
                return;
            }
            case 9: {
                jGoDocumentChangedEdit.setOldValue(new Point((Point)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 10: {
                return;
            }
            case 11: {
                return;
            }
            case 12: {
                return;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return;
            }
            case 18: {
                JGoDocumentChangedEdit jGoDocumentChangedEdit2;
                if (!jGoDocumentChangedEdit.isBeforeChanging() && (jGoDocumentChangedEdit2 = jGoDocumentChangedEdit.findBeforeChangingEdit()) != null) {
                    jGoDocumentChangedEdit.setOldValue(jGoDocumentChangedEdit2.getNewValue());
                }
                return;
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 2: {
                return;
            }
            case 3: {
                JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
                jGoObject.copyNewValueForRedo(jGoDocumentChangedEdit);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                jGoDocumentChangedEdit.setNewValue(new Dimension(this.getDocumentSize()));
                return;
            }
            case 6: {
                jGoDocumentChangedEdit.setNewValue(this.getPaperColor());
                return;
            }
            case 8: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.isModifiable());
                return;
            }
            case 9: {
                jGoDocumentChangedEdit.setNewValue(new Point(this.getDocumentTopLeft()));
                return;
            }
            case 10: {
                return;
            }
            case 11: {
                return;
            }
            case 12: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValue(jGoLayer.getNextLayer());
                return;
            }
            case 13: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValueBoolean(jGoLayer.isVisible());
                return;
            }
            case 14: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValueBoolean(jGoLayer.isModifiable());
                return;
            }
            case 15: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValue(new Float(jGoLayer.getTransparency()));
                return;
            }
            case 16: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValueInt(jGoLayer.\u0134());
                return;
            }
            case 17: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoDocumentChangedEdit.setNewValue(jGoLayer.getIdentifier());
                return;
            }
            case 18: {
                Vector<Serializable> vector = new Vector<Serializable>();
                int n = 0;
                JGoListPosition jGoListPosition = this.getFirstObjectPos();
                while (jGoListPosition != null) {
                    Serializable serializable;
                    JGoObject jGoObject = this.getObjectAtPos(jGoListPosition);
                    jGoListPosition = this.getNextObjectPosAtTop(jGoListPosition);
                    vector.add(n++, jGoObject);
                    if (jGoObject instanceof JGoLink) {
                        serializable = (JGoLink)jGoObject;
                        Vector vector2 = ((JGoStroke)serializable).copyPoints();
                        vector.add(n++, vector2);
                        continue;
                    }
                    serializable = jGoObject.getBoundingRect();
                    vector.add(n++, new Rectangle((Rectangle)serializable));
                }
                jGoDocumentChangedEdit.setNewValue(vector);
                return;
            }
        }
        if (jGoDocumentChangedEdit.getHint() >= 65535) {
            throw new IllegalArgumentException("unknown JGoDocumentEvent hint: " + Integer.toString(jGoDocumentChangedEdit.getHint()));
        }
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getHint()) {
            case 2: {
                if (bl) {
                    JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
                    this.removeObject(jGoObject);
                } else {
                    this.\u012e(jGoDocumentChangedEdit);
                }
                return;
            }
            case 3: {
                JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
                jGoObject.changeValue(jGoDocumentChangedEdit, bl);
                return;
            }
            case 4: {
                if (bl) {
                    this.\u012e(jGoDocumentChangedEdit);
                } else {
                    JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
                    this.removeObject(jGoObject);
                }
                return;
            }
            case 5: {
                this.setDocumentSize((Dimension)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 6: {
                this.setPaperColor((Color)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 8: {
                this.setModifiable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 9: {
                this.setDocumentTopLeft((Point)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 10: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                if (bl) {
                    this.removeLayer(jGoLayer);
                } else {
                    JGoLayer jGoLayer2 = (JGoLayer)jGoDocumentChangedEdit.getOldValue();
                    switch (jGoDocumentChangedEdit.getOldValueInt()) {
                        case 8: {
                            this.\u0130(jGoLayer2, jGoLayer);
                            break;
                        }
                        case 4: {
                            this.\u012f(jGoLayer2, jGoLayer);
                        }
                    }
                }
                return;
            }
            case 11: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                if (bl) {
                    JGoLayer jGoLayer3 = (JGoLayer)jGoDocumentChangedEdit.getOldValue();
                    if (jGoLayer3 != null) {
                        this.\u0130(jGoLayer3, jGoLayer);
                    } else {
                        this.insertLayerAfter(this.getLastLayer(), jGoLayer);
                    }
                } else {
                    this.removeLayer(jGoLayer);
                }
                return;
            }
            case 12: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                JGoLayer jGoLayer4 = (JGoLayer)jGoDocumentChangedEdit.getValue(bl);
                if (jGoLayer4 != null) {
                    this.insertLayerBefore(jGoLayer4, jGoLayer);
                } else {
                    this.insertLayerAfter(this.getLastLayer(), jGoLayer);
                }
                return;
            }
            case 13: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoLayer.setVisible(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 14: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoLayer.setModifiable(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 15: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                Float f = (Float)jGoDocumentChangedEdit.getValue(bl);
                jGoLayer.setTransparency(f.floatValue());
                return;
            }
            case 16: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoLayer.\u0135(jGoDocumentChangedEdit.getValueInt(bl));
                return;
            }
            case 17: {
                JGoLayer jGoLayer = (JGoLayer)jGoDocumentChangedEdit.getObject();
                jGoLayer.setIdentifier(jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 18: {
                Vector vector = (Vector)jGoDocumentChangedEdit.getValue(bl);
                int n = 0;
                while (n < vector.size()) {
                    Cloneable cloneable;
                    JGoObject jGoObject = (JGoObject)vector.get(n);
                    if (jGoObject instanceof JGoLink) {
                        cloneable = (Vector)vector.get(n + 1);
                        JGoLink jGoLink = (JGoLink)jGoObject;
                        jGoLink.setPoints((Vector)cloneable);
                    } else {
                        cloneable = (Rectangle)vector.get(n + 1);
                        jGoObject.setBoundingRect((Rectangle)cloneable);
                    }
                    n += 2;
                }
                this.update();
                return;
            }
        }
        if (jGoDocumentChangedEdit.getHint() >= 65535) {
            throw new IllegalArgumentException("unknown JGoDocumentEvent hint: " + Integer.toString(jGoDocumentChangedEdit.getHint()));
        }
    }

    void \u012e(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        JGoObject jGoObject = (JGoObject)jGoDocumentChangedEdit.getObject();
        switch (jGoDocumentChangedEdit.getOldValueInt()) {
            case 2: {
                JGoObjectCollection jGoObjectCollection = (JGoObjectCollection)jGoDocumentChangedEdit.getOldValue();
                jGoObjectCollection.addObjectAtTail(jGoObject);
                break;
            }
            case 6: {
                JGoObjectCollection jGoObjectCollection = (JGoObjectCollection)jGoDocumentChangedEdit.getOldValue();
                jGoObjectCollection.addObjectAtHead(jGoObject);
                break;
            }
            case 8: {
                JGoObject jGoObject2 = (JGoObject)jGoDocumentChangedEdit.getOldValue();
                JGoLayer jGoLayer = jGoObject2.getLayer();
                if (jGoLayer == null) break;
                JGoListPosition jGoListPosition = jGoLayer.findObject(jGoObject2);
                if (jGoListPosition != null) {
                    jGoLayer.insertObjectBefore(jGoListPosition, jGoObject);
                    break;
                }
                jGoLayer.addObjectAtTail(jGoObject);
                break;
            }
            case 4: {
                JGoObject jGoObject3 = (JGoObject)jGoDocumentChangedEdit.getOldValue();
                JGoLayer jGoLayer = jGoObject3.getLayer();
                if (jGoLayer == null) break;
                JGoListPosition jGoListPosition = jGoLayer.findObject(jGoObject3);
                if (jGoListPosition != null) {
                    jGoLayer.insertObjectAfter(jGoListPosition, jGoObject);
                    break;
                }
                jGoLayer.addObjectAtTail(jGoObject);
                break;
            }
            case 0: {
                JGoObject jGoObject4;
                JGoListPosition jGoListPosition;
                Object[] objectArray = (Object[])jGoDocumentChangedEdit.getOldValue();
                JGoObjectCollection jGoObjectCollection = (JGoObjectCollection)objectArray[0];
                if (objectArray[1] != null && (jGoListPosition = jGoObjectCollection.findObject(jGoObject4 = (JGoObject)objectArray[1])) != null) {
                    jGoObjectCollection.insertObjectAfter(jGoListPosition, jGoObject);
                    return;
                }
                if (objectArray[2] != null && (jGoListPosition = jGoObjectCollection.findObject(jGoObject4 = (JGoObject)objectArray[2])) != null) {
                    jGoObjectCollection.insertObjectBefore(jGoListPosition, jGoObject);
                    return;
                }
                jGoObjectCollection.addObjectAtTail(jGoObject);
            }
        }
    }

    public static DataFlavor getStandardDataFlavor() {
        if (\u012d == null) {
            try {
                \u012d = new DataFlavor(Class.forName("com.nwoods.jgo.JGoSelection"), "JGo Selection");
                DataFlavor[] dataFlavorArray = new DataFlavor[]{\u012d};
                \u012e = dataFlavorArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return \u012d;
    }

    public DataFlavor[] getTransferDataFlavors() {
        JGoDocument.getStandardDataFlavor();
        return \u012e;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(JGoDocument.getStandardDataFlavor());
    }

    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(JGoDocument.getStandardDataFlavor())) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public JGoCopyEnvironment createDefaultCopyEnvironment() {
        return new JGoCopyMap();
    }

    public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection jGoObjectSimpleCollection) {
        return this.copyFromCollection(jGoObjectSimpleCollection, new Point(), null);
    }

    public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection jGoObjectSimpleCollection, Point point, JGoCopyEnvironment jGoCopyEnvironment) {
        Object object;
        Object object2;
        Serializable serializable;
        if (jGoCopyEnvironment == null) {
            jGoCopyEnvironment = this.createDefaultCopyEnvironment();
        }
        Point point2 = new Point();
        JGoListPosition jGoListPosition = jGoObjectSimpleCollection.getFirstObjectPos();
        while (jGoListPosition != null) {
            serializable = jGoObjectSimpleCollection.getObjectAtPos(jGoListPosition);
            jGoListPosition = jGoObjectSimpleCollection.getNextObjectPosAtTop(jGoListPosition);
            JGoObject jGoObject = ((JGoObject)(serializable = ((JGoObject)serializable).getTopLevelObject())).copyObject(jGoCopyEnvironment);
            if (jGoObject == null) continue;
            point2 = jGoObject.getLocation(point2);
            jGoObject.setLocationOffset(point2, point);
            object2 = ((JGoObject)serializable).getLayer();
            object = null;
            if (object2 != null) {
                object = ((JGoLayer)object2).getDocument() == this ? object2 : this.findLayer(((JGoLayer)object2).getIdentifier());
            }
            if (object == null) {
                object = this.getDefaultLayer();
            }
            ((JGoLayer)object).addObjectAtTail(jGoObject);
        }
        serializable = jGoCopyEnvironment.getDelayeds();
        int n = 0;
        while (n < ((Vector)serializable).size()) {
            object2 = ((Vector)serializable).get(n);
            if (object2 instanceof JGoLink) {
                object = (JGoLink)object2;
                JGoLink jGoLink = (JGoLink)jGoCopyEnvironment.get(object);
                JGoPort jGoPort = ((JGoLink)object).getFromPort();
                JGoPort jGoPort2 = ((JGoLink)object).getToPort();
                JGoPort jGoPort3 = (JGoPort)jGoCopyEnvironment.get(jGoPort);
                JGoPort jGoPort4 = (JGoPort)jGoCopyEnvironment.get(jGoPort2);
                if (jGoPort3 != null && jGoPort4 != null) {
                    jGoLink.setFromPort(jGoPort3);
                    jGoLink.setToPort(jGoPort4);
                } else {
                    this.removeObject(jGoLink);
                }
            }
            ++n;
        }
        return jGoCopyEnvironment;
    }

    public int getNumLayers() {
        int n = 0;
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            ++n;
            jGoLayer = jGoLayer.getNextLayer();
        }
        return n;
    }

    public JGoLayer getFirstLayer() {
        return this.myFirstLayer;
    }

    public JGoLayer getLastLayer() {
        return this.myLastLayer;
    }

    public JGoLayer getNextLayer(JGoLayer jGoLayer) {
        if (jGoLayer == null) {
            return null;
        }
        return jGoLayer.getNextLayer();
    }

    public JGoLayer getPrevLayer(JGoLayer jGoLayer) {
        if (jGoLayer == null) {
            return null;
        }
        return jGoLayer.getPrevLayer();
    }

    public JGoLayer getDefaultLayer() {
        return this.myDefaultLayer;
    }

    public void setDefaultLayer(JGoLayer jGoLayer) {
        if (jGoLayer.getDocument() != this) {
            return;
        }
        this.myDefaultLayer = jGoLayer;
    }

    public JGoLayer addLayerAfter(JGoLayer jGoLayer) {
        if (jGoLayer == null) {
            jGoLayer = this.getLastLayer();
        }
        JGoLayer jGoLayer2 = new JGoLayer();
        jGoLayer2.\u00c0(this);
        return this.\u012f(jGoLayer, jGoLayer2);
    }

    JGoLayer \u012f(JGoLayer jGoLayer, JGoLayer jGoLayer2) {
        jGoLayer2.\u0132(jGoLayer.getNextLayer(), jGoLayer);
        if (jGoLayer2.getNextLayer() == null) {
            this.myLastLayer = jGoLayer2;
        }
        this.fireUpdate(10, 0, jGoLayer2, 4, jGoLayer);
        return jGoLayer2;
    }

    public JGoLayer addLayerBefore(JGoLayer jGoLayer) {
        if (jGoLayer == null) {
            jGoLayer = this.getFirstLayer();
        }
        JGoLayer jGoLayer2 = new JGoLayer();
        jGoLayer2.\u00c0(this);
        return this.\u0130(jGoLayer, jGoLayer2);
    }

    JGoLayer \u0130(JGoLayer jGoLayer, JGoLayer jGoLayer2) {
        jGoLayer2.\u0132(jGoLayer, jGoLayer.getPrevLayer());
        if (jGoLayer2.getPrevLayer() == null) {
            this.myFirstLayer = jGoLayer2;
        }
        this.fireUpdate(10, 0, jGoLayer2, 8, jGoLayer);
        return jGoLayer2;
    }

    public void removeLayer(JGoLayer jGoLayer) {
        if (jGoLayer.getDocument() != this) {
            return;
        }
        if (jGoLayer == this.getFirstLayer() && jGoLayer == this.getLastLayer()) {
            return;
        }
        JGoLayer jGoLayer2 = jGoLayer.getNextLayer();
        jGoLayer.removeAll();
        if (jGoLayer.getPrevLayer() == null) {
            this.myFirstLayer = jGoLayer;
        }
        if (jGoLayer2 == null) {
            this.myLastLayer = jGoLayer;
        }
        jGoLayer.\u0133();
        if (jGoLayer == this.getDefaultLayer()) {
            if (jGoLayer.getNextLayer() != null) {
                this.setDefaultLayer(jGoLayer.getNextLayer());
            } else if (jGoLayer.getPrevLayer() != null) {
                this.setDefaultLayer(jGoLayer.getPrevLayer());
            } else {
                this.setDefaultLayer(this.getLastLayer());
            }
        }
        this.fireUpdate(11, 0, jGoLayer, 0, jGoLayer2);
    }

    public void insertLayerAfter(JGoLayer jGoLayer, JGoLayer jGoLayer2) {
        if (jGoLayer.getDocument() != this || jGoLayer2.getDocument() != this || jGoLayer == jGoLayer2 || jGoLayer2.getPrevLayer() == jGoLayer) {
            return;
        }
        JGoLayer jGoLayer3 = jGoLayer2.getNextLayer();
        if (this.myFirstLayer == jGoLayer2) {
            this.myFirstLayer = jGoLayer3;
        }
        jGoLayer2.\u0133();
        jGoLayer2.\u0132(jGoLayer.getNextLayer(), jGoLayer);
        if (this.myLastLayer == jGoLayer) {
            this.myLastLayer = jGoLayer2;
        }
        this.fireUpdate(12, 0, jGoLayer2, 0, jGoLayer3);
    }

    public void insertLayerBefore(JGoLayer jGoLayer, JGoLayer jGoLayer2) {
        if (jGoLayer.getDocument() != this || jGoLayer2.getDocument() != this || jGoLayer == jGoLayer2 || jGoLayer2.getNextLayer() == jGoLayer) {
            return;
        }
        JGoLayer jGoLayer3 = jGoLayer2.getNextLayer();
        if (this.myLastLayer == jGoLayer2) {
            this.myLastLayer = jGoLayer2.getPrevLayer();
        }
        jGoLayer2.\u0133();
        jGoLayer2.\u0132(jGoLayer, jGoLayer.getPrevLayer());
        if (this.myFirstLayer == jGoLayer) {
            this.myFirstLayer = jGoLayer2;
        }
        this.fireUpdate(12, 0, jGoLayer2, 0, jGoLayer3);
    }

    public void bringLayerToFront(JGoLayer jGoLayer) {
        this.insertLayerAfter(this.getLastLayer(), jGoLayer);
    }

    public void sendLayerToBack(JGoLayer jGoLayer) {
        this.insertLayerBefore(this.getFirstLayer(), jGoLayer);
    }

    public JGoLayer findLayer(Object object) {
        if (object == null) {
            return null;
        }
        JGoLayer jGoLayer = this.getFirstLayer();
        while (jGoLayer != null) {
            Object object2 = jGoLayer.getIdentifier();
            if (object2 != null && object2.equals(object)) {
                return jGoLayer;
            }
            jGoLayer = jGoLayer.getNextLayer();
        }
        return null;
    }

    void \u0131(JGoDocument jGoDocument) {
        JGoLayer jGoLayer;
        Object object;
        JGoLayer jGoLayer2 = jGoDocument.getFirstLayer();
        while (jGoLayer2 != null) {
            object = jGoLayer2.getIdentifier();
            if (object != null && this.findLayer(object) == null) {
                jGoLayer = this.addLayerAfter(this.getLastLayer());
                jGoLayer.setIdentifier(object);
            }
            jGoLayer2 = jGoDocument.getNextLayer(jGoLayer2);
        }
        object = jGoDocument.getDefaultLayer().getIdentifier();
        jGoLayer = this.findLayer(object);
        if (jGoLayer != null) {
            this.setDefaultLayer(jGoLayer);
        }
    }

    public JGoUndoManager getUndoManager() {
        return this.\u011e;
    }

    public void setUndoManager(JGoUndoManager jGoUndoManager) {
        JGoUndoManager jGoUndoManager2 = this.getUndoManager();
        if (jGoUndoManager2 != jGoUndoManager) {
            if (jGoUndoManager2 != null) {
                this.removeDocumentListener(jGoUndoManager2);
            }
            this.\u011e = jGoUndoManager;
            if (jGoUndoManager != null) {
                this.addDocumentListener(jGoUndoManager);
            }
        }
    }

    public boolean canUndo() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            return jGoUndoManager.canUndo();
        }
        return false;
    }

    public void undo() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            try {
                jGoUndoManager.undo();
                this.update();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public boolean canRedo() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            return jGoUndoManager.canRedo();
        }
        return false;
    }

    public void redo() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            try {
                jGoUndoManager.redo();
                this.update();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    public void startTransaction() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            jGoUndoManager.startTransaction();
        }
    }

    public void endTransaction(boolean bl) {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            jGoUndoManager.endTransaction(bl);
        }
    }

    public void endTransaction(String string) {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            jGoUndoManager.endTransaction(string);
        }
    }

    public void discardAllEdits() {
        JGoUndoManager jGoUndoManager = this.getUndoManager();
        if (jGoUndoManager != null) {
            jGoUndoManager.discardAllEdits();
        }
    }
}

