/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public abstract class JGoDrawable
extends JGoObject {
    private JGoPen myCurrentPen = JGoPen.black;
    private JGoBrush myCurrentBrush = null;

    public JGoDrawable() {
    }

    public JGoDrawable(Rectangle rectangle) {
        super(rectangle);
    }

    public JGoDrawable(Point point, Dimension dimension) {
        super(point, dimension);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoDrawable jGoDrawable = (JGoDrawable)super.copyObject(jGoCopyEnvironment);
        if (jGoDrawable != null) {
            jGoDrawable.myCurrentPen = this.myCurrentPen;
            jGoDrawable.myCurrentBrush = this.myCurrentBrush;
        }
        return jGoDrawable;
    }

    public void setPen(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.getPen();
        if (jGoPen2 != jGoPen) {
            this.myCurrentPen = jGoPen;
            this.update(11, 0, jGoPen2);
        }
    }

    public JGoPen getPen() {
        return this.myCurrentPen;
    }

    public void setBrush(JGoBrush jGoBrush) {
        JGoBrush jGoBrush2 = this.getBrush();
        if (jGoBrush2 != jGoBrush) {
            this.myCurrentBrush = jGoBrush;
            this.update(12, 0, jGoBrush2);
        }
    }

    public JGoBrush getBrush() {
        return this.myCurrentBrush;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 11: {
                jGoDocumentChangedEdit.setNewValue(this.getPen());
                return;
            }
            case 12: {
                jGoDocumentChangedEdit.setNewValue(this.getBrush());
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 11: {
                this.setPen((JGoPen)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 12: {
                this.setBrush((JGoBrush)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        if (this.getPen() != null) {
            int n = this.getPen().getWidth();
            rectangle.grow(n, n);
        }
    }

    public static void drawLine(Graphics2D graphics2D, JGoPen jGoPen, int n, int n2, int n3, int n4) {
        Stroke stroke;
        if (jGoPen != null && jGoPen.getStyle() != 0 && (stroke = jGoPen.getStroke()) != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawLine(n, n2, n3, n4);
        }
    }

    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawLine(graphics2D, this.getPen(), n, n2, n3, n4);
    }

    public static void drawEllipse(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillOval(n, n2, n3, n4);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawOval(n, n2, n3, n4);
        }
    }

    public void drawEllipse(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawEllipse(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4);
    }

    public void drawEllipse(Graphics2D graphics2D, Rectangle rectangle) {
        JGoDrawable.drawEllipse(graphics2D, this.getPen(), this.getBrush(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRect(n, n2, n3, n4);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawRect(n, n2, n3, n4);
        }
    }

    public void drawRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        JGoDrawable.drawRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4);
    }

    public void drawRect(Graphics2D graphics2D, Rectangle rectangle) {
        JGoDrawable.drawRect(graphics2D, this.getPen(), this.getBrush(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawRoundRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
        if (jGoPen != null && jGoPen.getStyle() != 0 && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawRoundRect(n, n2, n3, n4, n5, n6);
        }
    }

    public void drawRoundRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        JGoDrawable.drawRoundRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4, n5, n6);
    }

    public static void draw3DRect(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fill3DRect(n, n2, n3, n4, bl);
        }
        if (jGoPen != null && jGoPen.getStyle() == 65535 && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.draw3DRect(n, n2, n3, n4, bl);
        }
    }

    public void draw3DRect(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        JGoDrawable.draw3DRect(graphics2D, this.getPen(), this.getBrush(), n, n2, n3, n4, bl);
    }

    public static void drawPolygon(Graphics2D graphics2D, JGoPen jGoPen, JGoBrush jGoBrush, int[] nArray, int[] nArray2, int n) {
        Object object;
        if (jGoBrush != null && (object = jGoBrush.getPaint()) != null) {
            graphics2D.setPaint((Paint)object);
            graphics2D.fillPolygon(nArray, nArray2, n);
        }
        if (jGoPen != null && (object = jGoPen.getStroke()) != null) {
            graphics2D.setStroke((Stroke)object);
            graphics2D.setColor(jGoPen.getColor());
            graphics2D.drawPolygon(nArray, nArray2, n);
        }
    }

    public void drawPolygon(Graphics2D graphics2D, int[] nArray, int[] nArray2, int n) {
        JGoDrawable.drawPolygon(graphics2D, this.getPen(), this.getBrush(), nArray, nArray2, n);
    }
}

