/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import java.io.Serializable;

class JGoObjList
implements Serializable {
    protected JGoListPosition myHead = null;
    protected JGoListPosition myTail = null;
    protected int myNumObjects = 0;
    protected boolean myOwner = false;

    public JGoObjList() {
    }

    public JGoObjList(boolean bl) {
        this.myOwner = bl;
    }

    public int getNumObjects() {
        return this.myNumObjects;
    }

    public boolean isEmpty() {
        return this.myHead == null;
    }

    public JGoListPosition addObjectAtHead(JGoObject jGoObject) {
        if (jGoObject == null) {
            return null;
        }
        JGoListPosition jGoListPosition = new JGoListPosition(jGoObject, null, this.myHead);
        if (this.myHead != null) {
            this.myHead.prev = jGoListPosition;
        }
        this.myHead = jGoListPosition;
        if (this.myTail == null) {
            this.myTail = this.myHead;
        }
        ++this.myNumObjects;
        if (this.myOwner) {
            jGoObject.\u010a(this.myHead);
        }
        return this.myHead;
    }

    public JGoListPosition addObjectAtTail(JGoObject jGoObject) {
        if (jGoObject == null) {
            return null;
        }
        JGoListPosition jGoListPosition = new JGoListPosition(jGoObject, this.myTail, null);
        if (this.myTail != null) {
            this.myTail.next = jGoListPosition;
        }
        this.myTail = jGoListPosition;
        if (this.myHead == null) {
            this.myHead = this.myTail;
        }
        ++this.myNumObjects;
        if (this.myOwner) {
            jGoObject.\u010a(this.myTail);
        }
        return this.myTail;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition jGoListPosition, JGoObject jGoObject) {
        if (jGoListPosition == null || jGoObject == null) {
            return null;
        }
        JGoListPosition jGoListPosition2 = new JGoListPosition(jGoObject, jGoListPosition.prev, jGoListPosition);
        if (jGoListPosition.prev != null) {
            jGoListPosition.prev.next = jGoListPosition2;
        } else {
            this.myHead = jGoListPosition2;
        }
        jGoListPosition.prev = jGoListPosition2;
        ++this.myNumObjects;
        if (this.myOwner) {
            jGoObject.\u010a(jGoListPosition2);
        }
        return jGoListPosition2;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition jGoListPosition, JGoObject jGoObject) {
        if (jGoListPosition == null || jGoObject == null) {
            return null;
        }
        JGoListPosition jGoListPosition2 = new JGoListPosition(jGoObject, jGoListPosition, jGoListPosition.next);
        if (jGoListPosition.next != null) {
            jGoListPosition.next.prev = jGoListPosition2;
        } else {
            this.myTail = jGoListPosition2;
        }
        jGoListPosition.next = jGoListPosition2;
        ++this.myNumObjects;
        if (this.myOwner) {
            jGoObject.\u010a(jGoListPosition2);
        }
        return jGoListPosition2;
    }

    public void removeObject(JGoObject jGoObject) {
        JGoListPosition jGoListPosition = this.findObject(jGoObject);
        this.removeObjectAtPos(jGoListPosition);
    }

    public JGoObject removeObjectAtPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        JGoObject jGoObject = jGoListPosition.obj;
        if (jGoListPosition == this.myHead) {
            this.myHead = jGoListPosition.next;
        }
        if (jGoListPosition == this.myTail) {
            this.myTail = jGoListPosition.prev;
        }
        if (jGoListPosition.prev != null) {
            jGoListPosition.prev.next = jGoListPosition.next;
        }
        if (jGoListPosition.next != null) {
            jGoListPosition.next.prev = jGoListPosition.prev;
        }
        jGoListPosition.prev = null;
        jGoListPosition.next = null;
        if (this.myOwner) {
            jGoObject.\u010a(null);
        }
        --this.myNumObjects;
        return jGoObject;
    }

    public JGoListPosition getFirstObjectPos() {
        return this.myHead;
    }

    public JGoListPosition getLastObjectPos() {
        return this.myTail;
    }

    public JGoListPosition getNextObjectPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        return jGoListPosition.next;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        return jGoListPosition.prev;
    }

    public JGoObject getObjectAtPos(JGoListPosition jGoListPosition) {
        if (jGoListPosition == null) {
            return null;
        }
        return jGoListPosition.obj;
    }

    public JGoListPosition findObject(JGoObject jGoObject) {
        JGoListPosition jGoListPosition = null;
        if (this.myOwner && (jGoListPosition = jGoObject.\u010b()) != null) {
            return jGoListPosition;
        }
        jGoListPosition = this.myHead;
        while (jGoListPosition != null) {
            if (jGoListPosition.obj == jGoObject) {
                return jGoListPosition;
            }
            jGoListPosition = jGoListPosition.next;
        }
        return null;
    }
}

