/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.PrintWriter;

class SGraphImage
extends SGraphCommand {
    private float[] m_ax;
    private float[] m_ay;
    private float[] m_az;
    private float m_zMissing;
    private float m_zMin;
    private float m_zMax;
    private byte[] m_colorR;
    private byte[] m_colorG;
    private byte[] m_colorB;
    private byte[] m_colorA;
    private boolean m_useRGBA;
    private boolean m_useQuickImage = false;
    private transient byte[] m_quickImageBytes = null;
    private transient boolean m_quickImageBytesFlippedX = false;
    private transient boolean m_quickImageBytesFlippedY = false;
    private transient int[] m_quickImageInts = null;
    private transient boolean m_quickImageIntsFlippedX = false;
    private transient boolean m_quickImageIntsFlippedY = false;
    private transient Image m_quickImage = null;

    void graphSizeChanged() {
        this.m_quickImage = null;
    }

    public void releaseMemory() {
        this.m_quickImage = null;
        this.m_quickImageBytes = null;
    }

    public SGraphImage(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3) {
        this(fArray, fArray2, fArray3, f, f2, f3, null, null, null, null);
    }

    public SGraphImage(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2, float f3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.m_zMin = f;
        this.m_zMax = f2;
        this.m_zMissing = f3;
        if (this.m_zMin == this.m_zMax) {
            this.m_zMax += 1.0f;
        }
        this.m_ax = fArray;
        this.m_ay = fArray2;
        this.m_az = fArray3;
        boolean bl = this.m_useRGBA = byArray != null && byArray2 != null && byArray3 != null && byArray4 != null && byArray.length > 0 && byArray.length == byArray2.length && byArray.length == byArray3.length && byArray.length == byArray4.length;
        if (this.m_useRGBA) {
            this.m_colorR = byArray;
            this.m_colorG = byArray2;
            this.m_colorB = byArray3;
            this.m_colorA = byArray4;
        } else {
            this.m_colorR = null;
            this.m_colorG = null;
            this.m_colorB = null;
            this.m_colorA = null;
        }
        this.m_useQuickImage = this.regularScale(this.m_ax) && this.regularScale(this.m_ay) && !this.anyMissingPixels(this.m_az, this.m_zMin, this.m_zMax, this.m_zMissing);
    }

    boolean regularScale(float[] fArray) {
        int n = fArray.length;
        float f = (fArray[n - 1] - fArray[0]) / (float)(n - 1);
        if (f < 0.0f) {
            f = -f;
        }
        float f2 = f * 0.9f;
        float f3 = f * 1.1f;
        for (int i = 1; i < n; ++i) {
            f = fArray[i] - fArray[i - 1];
            if (f < 0.0f) {
                f = -f;
            }
            if (!(f < f2) && !(f > f3)) continue;
            return false;
        }
        return true;
    }

    boolean anyMissingPixels(float[] fArray, float f, float f2, float f3) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float f4 = fArray[i];
            if (f4 != f3 && !(f4 < f) && !(f4 > f2)) continue;
            return true;
        }
        return false;
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        Rectangle rectangle = this.setParClip(sCanvasAWT, graphics);
        try {
            boolean bl = false;
            try {
                if (this.m_useQuickImage) {
                    this.displayQuickImage(sCanvasAWT, graphics);
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!bl) {
                this.displaySlowImage(sCanvasAWT, graphics);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.resetClip(sCanvasAWT, graphics, rectangle);
    }

    int getNumColors() {
        return this.m_useRGBA ? this.m_colorR.length : 256;
    }

    void displaySlowImage(SCanvasAWT sCanvasAWT, Graphics graphics) {
        int n;
        int[] nArray = new int[this.m_ax.length];
        int[] nArray2 = new int[this.m_ay.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.valToWindowX(sCanvasAWT, this.m_ax[n]);
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = this.valToWindowY(sCanvasAWT, this.m_ay[n]);
        }
        n = 0;
        float f = (float)this.getNumColors() / (this.m_zMax - this.m_zMin);
        for (int i = 0; i < nArray2.length - 1; ++i) {
            int n2 = nArray2[i];
            int n3 = nArray2[i + 1] - n2;
            if (n3 < 0) {
                n2 = nArray2[i + 1];
                n3 = -n3;
            }
            for (int j = 0; j < nArray.length - 1; ++j) {
                Color color;
                float f2;
                if ((f2 = this.m_az[n++]) == this.m_zMissing || !(f2 >= this.m_zMin) || !(f2 <= this.m_zMax)) continue;
                int n4 = nArray[j];
                int n5 = nArray[j + 1] - n4;
                if (n5 < 0) {
                    n4 = nArray[j + 1];
                    n5 = -n5;
                }
                if (this.m_useRGBA) {
                    int n6 = (int)((f2 - this.m_zMin) * f);
                    int n7 = this.getColorIntFromByteArray(this.m_colorR, n6);
                    int n8 = this.getColorIntFromByteArray(this.m_colorG, n6);
                    int n9 = this.getColorIntFromByteArray(this.m_colorB, n6);
                    int n10 = this.getColorIntFromByteArray(this.m_colorA, n6);
                    color = SGraphCommand.getFactory().createColor(n7, n8, n9, n10);
                } else {
                    color = sCanvasAWT.getImageColor(1 + (int)((f2 - this.m_zMin) * f));
                }
                graphics.setColor(color);
                graphics.fillRect(n4, n2, n5, n3);
            }
        }
    }

    int getColorIntFromByteArray(byte[] byArray, int n) {
        int n2;
        if (n < 0) {
            n = 0;
        } else if (n >= byArray.length) {
            n = byArray.length - 1;
        }
        int n3 = n2 = byArray[n];
        if (n3 < 0) {
            n3 += 256;
        }
        return n3;
    }

    void displayQuickImage(SCanvasAWT sCanvasAWT, Graphics graphics) {
        int n = this.valToWindowX(sCanvasAWT, this.m_ax[0]);
        int n2 = this.valToWindowX(sCanvasAWT, this.m_ax[this.m_ax.length - 1]);
        int n3 = this.valToWindowY(sCanvasAWT, this.m_ay[0]);
        int n4 = this.valToWindowY(sCanvasAWT, this.m_ay[this.m_ay.length - 1]);
        int n5 = Math.abs(n2 - n);
        int n6 = Math.abs(n4 - n3);
        int n7 = Math.min(n, n2);
        int n8 = Math.min(n3, n4);
        if (this.m_useRGBA) {
            this.displayQuickImageRGBA(sCanvasAWT, graphics, n, n2, n3, n4, n5, n6, n7, n8);
        } else {
            this.displayQuickImageBytes(sCanvasAWT, graphics, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }

    void displayQuickImageBytes(SCanvasAWT sCanvasAWT, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (this.m_quickImageBytes == null) {
            int n10 = this.m_az.length;
            this.m_quickImageBytes = new byte[n10];
            float f = (float)this.getNumColors() / (this.m_zMax - this.m_zMin);
            for (n9 = 0; n9 < n10; ++n9) {
                float f2 = this.m_az[n9];
                if (f2 < this.m_zMin) {
                    f2 = this.m_zMin;
                } else if (f2 > this.m_zMax) {
                    f2 = this.m_zMax;
                }
                int n11 = (int)((f2 - this.m_zMin) * f);
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 > 255) {
                    n11 = 255;
                }
                this.m_quickImageBytes[n9] = (byte)n11;
            }
            this.m_quickImageBytesFlippedX = false;
            this.m_quickImageBytesFlippedY = false;
        }
        this.QuickImageBytesFlipX(n2 < n);
        this.QuickImageBytesFlipY(n4 < n3);
        if (this.m_quickImage == null) {
            Image image;
            IndexColorModel indexColorModel = sCanvasAWT.getImageIndexColorModel();
            int n12 = this.m_ax.length - 1;
            n9 = this.m_ay.length - 1;
            this.m_quickImage = image = SGraphCommand.createImage(new MemoryImageSource(n12, n9, (ColorModel)indexColorModel, this.m_quickImageBytes, 0, n12));
        }
        graphics.drawImage(this.m_quickImage, n7, n8, n5, n6, null);
    }

    void QuickImageBytesFlipX(boolean bl) {
        if (this.m_quickImageBytesFlippedX == bl) {
            return;
        }
        int n = this.m_ax.length - 1;
        int n2 = n / 2;
        int n3 = this.m_ay.length - 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            for (int j = 0; j < n2; ++j) {
                int n5 = n4 + j;
                int n6 = n4 + (n - j - 1);
                byte by = this.m_quickImageBytes[n5];
                this.m_quickImageBytes[n5] = this.m_quickImageBytes[n6];
                this.m_quickImageBytes[n6] = by;
            }
        }
        this.m_quickImageBytesFlippedX = bl;
        this.m_quickImage = null;
    }

    void QuickImageBytesFlipY(boolean bl) {
        if (this.m_quickImageBytesFlippedY == bl) {
            return;
        }
        int n = this.m_ax.length - 1;
        int n2 = this.m_ay.length - 1;
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            int n5 = (n2 - i - 1) * n;
            for (int j = 0; j < n; ++j) {
                int n6 = n4 + j;
                int n7 = n5 + j;
                byte by = this.m_quickImageBytes[n6];
                this.m_quickImageBytes[n6] = this.m_quickImageBytes[n7];
                this.m_quickImageBytes[n7] = by;
            }
        }
        this.m_quickImageBytesFlippedY = bl;
        this.m_quickImage = null;
    }

    void displayQuickImageRGBA(SCanvasAWT sCanvasAWT, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (this.m_quickImageInts == null) {
            int n10 = this.m_az.length;
            this.m_quickImageInts = new int[n10];
            n9 = this.getNumColors();
            float f = (float)n9 / (this.m_zMax - this.m_zMin);
            for (int i = 0; i < n10; ++i) {
                float f2 = this.m_az[i];
                if (f2 < this.m_zMin) {
                    f2 = this.m_zMin;
                } else if (f2 > this.m_zMax) {
                    f2 = this.m_zMax;
                }
                int n11 = (int)((f2 - this.m_zMin) * f);
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 >= n9) {
                    n11 = n9 - 1;
                }
                this.m_quickImageInts[i] = n11;
            }
            this.m_quickImageBytesFlippedX = false;
            this.m_quickImageBytesFlippedY = false;
        }
        this.QuickImageIntsFlipX(n2 < n);
        this.QuickImageIntsFlipY(n4 < n3);
        if (this.m_quickImage == null) {
            Image image;
            IndexColorModel indexColorModel = sCanvasAWT.getImageIndexColorModel(this.m_colorR, this.m_colorG, this.m_colorB, this.m_colorA);
            n9 = this.m_ax.length - 1;
            int n12 = this.m_ay.length - 1;
            this.m_quickImage = image = SGraphCommand.createImage(new MemoryImageSource(n9, n12, (ColorModel)indexColorModel, this.m_quickImageInts, 0, n9));
        }
        graphics.drawImage(this.m_quickImage, n7, n8, n5, n6, null);
    }

    void QuickImageIntsFlipX(boolean bl) {
        if (this.m_quickImageIntsFlippedX == bl) {
            return;
        }
        int n = this.m_ax.length - 1;
        int n2 = n / 2;
        int n3 = this.m_ay.length - 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            for (int j = 0; j < n2; ++j) {
                int n5 = n4 + j;
                int n6 = n4 + (n - j - 1);
                int n7 = this.m_quickImageInts[n5];
                this.m_quickImageInts[n5] = this.m_quickImageInts[n6];
                this.m_quickImageInts[n6] = n7;
            }
        }
        this.m_quickImageIntsFlippedX = bl;
        this.m_quickImage = null;
    }

    void QuickImageIntsFlipY(boolean bl) {
        if (this.m_quickImageIntsFlippedY == bl) {
            return;
        }
        int n = this.m_ax.length - 1;
        int n2 = this.m_ay.length - 1;
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n;
            int n5 = (n2 - i - 1) * n;
            for (int j = 0; j < n; ++j) {
                int n6 = n4 + j;
                int n7 = n5 + j;
                int n8 = this.m_quickImageInts[n6];
                this.m_quickImageInts[n6] = this.m_quickImageInts[n7];
                this.m_quickImageInts[n7] = n8;
            }
        }
        this.m_quickImageIntsFlippedY = bl;
        this.m_quickImage = null;
    }

    public String getXMLTag() {
        return "IMAGE";
    }

    public void writeXMLProperties(PrintWriter printWriter) {
        XML.writeProperty(printWriter, "ZMIN", this.m_zMin);
        XML.writeProperty(printWriter, "ZMAX", this.m_zMax);
        XML.writeProperty(printWriter, "ZMISS", this.m_zMissing);
    }

    public void writeXMLContents(PrintWriter printWriter) {
        XML.writeData(printWriter, "X", this.m_ax);
        XML.writeData(printWriter, "Y", this.m_ay);
        XML.writeData(printWriter, "Z", this.m_az);
        if (this.m_useRGBA) {
            int n = this.m_colorR.length;
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.getColorIntFromByteArray(this.m_colorR, i);
                int n3 = this.getColorIntFromByteArray(this.m_colorG, i);
                int n4 = this.getColorIntFromByteArray(this.m_colorB, i);
                int n5 = this.getColorIntFromByteArray(this.m_colorA, i);
                stringArray[i] = SGraphCommand.createRGBAString(n2, n3, n4, n5);
            }
            XML.writeData(printWriter, "C", stringArray);
        }
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        float f = XML.getFloatProperty(xMLElement, "ZMIN", iDHash);
        float f2 = XML.getFloatProperty(xMLElement, "ZMAX", iDHash);
        float f3 = XML.getFloatProperty(xMLElement, "ZMISS", iDHash);
        float[] fArray = XML.getFloatArrayData(xMLElement, "X");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y");
        float[] fArray3 = XML.getFloatArrayData(xMLElement, "Z");
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        String[] stringArray = XML.getStringArrayData(xMLElement, "C");
        if (stringArray != null || stringArray.length > 0) {
            int n = stringArray.length;
            byArray = new byte[n];
            byArray2 = new byte[n];
            byArray3 = new byte[n];
            byArray4 = new byte[n];
            for (int i = 0; i < n; ++i) {
                int[] nArray = SGraphCommand.readRGBAString(stringArray[i]);
                if (nArray == null) {
                    nArray = new int[]{0, 0, 0, 255};
                    break;
                }
                byArray[i] = (byte)nArray[0];
                byArray2[i] = (byte)nArray[1];
                byArray3[i] = (byte)nArray[2];
                byArray4[i] = (byte)nArray[3];
            }
        }
        return new SGraphImage(fArray, fArray2, fArray3, f, f2, f3, byArray, byArray2, byArray3, byArray4);
    }
}

