/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.frameworkadmin;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;

public class ConfigData {
    private final String fwName;
    private final String fwVersion;
    private final String launcherName;
    private final String launcherVersion;
    private int beginningFwStartLevel = -1;
    private int initialBundleStartLevel = -1;
    private LinkedHashSet bundlesList = new LinkedHashSet();
    private Properties fwIndependentProps = new Properties();
    private Properties fwDependentProps = new Properties();

    private static Properties appendProperties(Properties to, Properties from) {
        if (from != null) {
            if (to == null) {
                to = new Properties();
            }
            Enumeration<Object> enumeration = from.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                to.setProperty(key, from.getProperty(key));
            }
        }
        return to;
    }

    public ConfigData(String fwName, String fwVersion, String launcherName, String launcherVersion) {
        this.fwName = fwName;
        this.fwVersion = fwVersion;
        this.launcherName = launcherName;
        this.launcherVersion = launcherVersion;
        this.initialize();
    }

    public void addBundle(BundleInfo bundleInfo) {
        this.bundlesList.add(bundleInfo);
    }

    public int getBeginingFwStartLevel() {
        return this.beginningFwStartLevel;
    }

    public BundleInfo[] getBundles() {
        if (this.bundlesList.size() == 0) {
            return new BundleInfo[0];
        }
        BundleInfo[] ret = new BundleInfo[this.bundlesList.size()];
        this.bundlesList.toArray(ret);
        return ret;
    }

    public String getFwDependentProp(String key) {
        return this.fwDependentProps.getProperty(key);
    }

    public Properties getFwDependentProps() {
        Properties ret = new Properties();
        ConfigData.appendProperties(ret, this.fwDependentProps);
        return ret;
    }

    public String getFwIndependentProp(String key) {
        return this.fwIndependentProps.getProperty(key);
    }

    public Properties getFwIndependentProps() {
        Properties ret = new Properties();
        ConfigData.appendProperties(ret, this.fwIndependentProps);
        return ret;
    }

    public String getFwName() {
        return this.fwName;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public String getLauncherName() {
        return this.launcherName;
    }

    public String getLauncherVersion() {
        return this.launcherVersion;
    }

    public void initialize() {
        this.beginningFwStartLevel = -1;
        this.initialBundleStartLevel = -1;
        this.bundlesList.clear();
        this.fwIndependentProps.clear();
        this.fwDependentProps.clear();
    }

    public void removeBundle(BundleInfo bundleInfo) {
        this.bundlesList.remove(bundleInfo);
    }

    public void setBeginningFwStartLevel(int startLevel) {
        this.beginningFwStartLevel = startLevel;
    }

    public void setBundles(BundleInfo[] bundleInfos) {
        this.bundlesList.clear();
        if (bundleInfos != null) {
            int i = 0;
            while (i < bundleInfos.length) {
                this.bundlesList.add(bundleInfos[i]);
                ++i;
            }
        }
    }

    public void setFwDependentProp(String key, String value) {
        this.fwDependentProps.setProperty(key, value);
    }

    public void setFwDependentProps(Properties props) {
        this.fwDependentProps.clear();
        ConfigData.appendProperties(this.fwDependentProps, props);
    }

    public void setFwIndependentProp(String key, String value) {
        this.fwIndependentProps.setProperty(key, value);
    }

    public void setFwIndependentProps(Properties props) {
        this.fwIndependentProps.clear();
        ConfigData.appendProperties(this.fwIndependentProps, props);
    }

    public void setInitialBundleStartLevel(int startLevel) {
        this.initialBundleStartLevel = startLevel;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Class:" + this.getClass().getName() + "\n");
        sb.append("============Independent===============\n");
        sb.append("fwName=" + this.fwName + "\n");
        sb.append("fwVersion=" + this.fwVersion + "\n");
        sb.append("launcherName=" + this.launcherName + "\n");
        sb.append("launcherVersion=" + this.launcherVersion + "\n");
        sb.append("beginningFwStartLevel=" + this.beginningFwStartLevel + "\n");
        sb.append("initialBundleStartLevel=" + this.initialBundleStartLevel + "\n");
        if (this.bundlesList.size() == 0) {
            sb.append("bundlesList=null\n");
        } else {
            sb.append("bundlesList=\n");
            int i = 0;
            Iterator iter = this.bundlesList.iterator();
            while (iter.hasNext()) {
                sb.append("\tbundlesList[" + i + "]=" + iter.next().toString() + "\n");
                ++i;
            }
        }
        sb.append("============ Fw Independent Props ===============\n");
        sb.append("fwIndependentProps=");
        ConfigData.setPropsStrings(sb, this.fwIndependentProps);
        sb.append("============ Fw Dependent Props ===============\n");
        sb.append("fwDependentProps=");
        ConfigData.setPropsStrings(sb, this.fwDependentProps);
        return sb.toString();
    }

    private static void setPropsStrings(StringBuffer sb, Properties props) {
        if (props.size() > 0) {
            sb.append("\n");
            Enumeration<Object> enumeration = props.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = props.getProperty(key);
                if (value == null || value.equals("")) continue;
                sb.append("\t{" + key + " ,\t" + value + "}\n");
            }
        } else {
            sb.append("empty\n");
        }
    }
}

