/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourcesDescriptor;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class DeleteResourcesProcessor
extends DeleteProcessor {
    private IResource[] fResources;
    private boolean fDeleteContents;
    static /* synthetic */ Class class$0;

    public DeleteResourcesProcessor(IResource[] resources) {
        this(resources, false);
    }

    public DeleteResourcesProcessor(IResource[] resources, boolean deleteContents) {
        this.fResources = DeleteResourcesProcessor.removeDescendants(resources);
        this.fDeleteContents = deleteContents;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public boolean isDeleteContents() {
        return this.fDeleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.fDeleteContents = deleteContents;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < this.fResources.length) {
                IResource resource = this.fResources[i];
                if (!resource.isSynchronized(2)) {
                    if (resource instanceof IFile) {
                        result.addInfo(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_file, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                    } else {
                        result.addInfo(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_warning_out_of_sync_container, BasicElementLabels.getPathLabel(resource.getFullPath(), false)));
                    }
                }
                ++i;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(clazz);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i2 = 0;
            while (i2 < this.fResources.length) {
                if (this.fResources[i2].isPhantom()) {
                    result.addFatalError(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_phantom, BasicElementLabels.getPathLabel(this.fResources[i2].getFullPath(), false)));
                } else if (this.fDeleteContents && Resources.isReadOnly(this.fResources[i2])) {
                    result.addFatalError(Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_read_only, BasicElementLabels.getPathLabel(this.fResources[i2].getFullPath(), false)));
                } else {
                    deltaFactory.delete(this.fResources[i2]);
                }
                ++i2;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!Resources.containsOnlyProjects(this.fResources) && !Resources.containsOnlyNonProjects(this.fResources)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.DeleteResourcesProcessor_delete_error_mixed_types);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(RefactoringCoreMessages.DeleteResourcesProcessor_create_task, this.fResources.length);
        try {
            RefactoringChangeDescriptor descriptor = new RefactoringChangeDescriptor(this.createDescriptor());
            CompositeChange change = new CompositeChange(RefactoringCoreMessages.DeleteResourcesProcessor_change_name);
            change.markAsSynthetic();
            int i = 0;
            while (i < this.fResources.length) {
                pm.worked(1);
                DeleteResourceChange dc = new DeleteResourceChange(this.fResources[i].getFullPath(), true, this.fDeleteContents);
                dc.setDescriptor(descriptor);
                change.add(dc);
                ++i;
            }
            CompositeChange compositeChange = change;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    protected DeleteResourcesDescriptor createDescriptor() {
        DeleteResourcesDescriptor descriptor = new DeleteResourcesDescriptor();
        descriptor.setProject(null);
        descriptor.setDescription(this.getDeleteDescription());
        descriptor.setComment(descriptor.getDescription());
        descriptor.setFlags(7);
        descriptor.setDeleteContents(this.fDeleteContents);
        descriptor.setResources(this.fResources);
        return descriptor;
    }

    private String getDeleteDescription() {
        if (this.fResources.length == 1) {
            return Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_description_single, BasicElementLabels.getPathLabel(this.fResources[0].getFullPath(), false));
        }
        return Messages.format(RefactoringCoreMessages.DeleteResourcesProcessor_description_multi, new Integer(this.fResources.length));
    }

    public Object[] getElements() {
        return this.fResources;
    }

    public String getIdentifier() {
        return "org.eclipse.ltk.core.refactoring.deleteResourcesProcessor";
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteResourcesProcessor_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        int i = 0;
        while (i < this.fResources.length) {
            if (!this.canDelete(this.fResources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean canDelete(IResource res) {
        return res.isAccessible() && !res.isPhantom();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<DeleteParticipant> result = new ArrayList<DeleteParticipant>();
        if (!this.isApplicable()) {
            return new RefactoringParticipant[0];
        }
        String[] affectedNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        DeleteArguments deleteArguments = new DeleteArguments();
        int i = 0;
        while (i < this.fResources.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadDeleteParticipants(status, this, this.fResources[i], deleteArguments, affectedNatures, sharedParticipants)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private static IResource[] removeDescendants(IResource[] resources) {
        ArrayList<IResource> subResources = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource subResource = resources[i];
            int j = 0;
            while (j < resources.length) {
                IResource superResource = resources[j];
                if (DeleteResourcesProcessor.isDescendantOf(subResource, superResource)) {
                    subResources.add(subResource);
                }
                ++j;
            }
            ++i;
        }
        IResource[] nestedResourcesRemoved = new IResource[resources.length - subResources.size()];
        int j = 0;
        int i2 = 0;
        while (i2 < resources.length) {
            if (!subResources.contains(resources[i2])) {
                nestedResourcesRemoved[j] = resources[i2];
                ++j;
            }
            ++i2;
        }
        return nestedResourcesRemoved;
    }

    private static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals((Object)superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }
}

