/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.controls;

import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusLabelBox;
import java.awt.Dimension;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

public class SplusListBox
extends SplusLabelBox
implements SplusControlMethods {
    private JList list;
    JScrollPane scrollPane;
    private static final int listFontHeight = new JList().getFontMetrics(new JList().getFont()).getHeight();
    String[] prependString = null;
    String[] appendString = null;

    public SplusListBox() {
        this("", new String[]{""});
    }

    public SplusListBox(String string) {
        this(string, new String[]{""});
    }

    public SplusListBox(String string, char c) {
        this(string, new String[]{""});
        this.setMnemonic(c);
    }

    public SplusListBox(String string, int n) {
        this(string, new String[]{""});
        this.setMnemonic(n);
    }

    public SplusListBox(String string, char c, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(c);
    }

    public SplusListBox(String string, int n, String[] stringArray) {
        this(string, stringArray);
        this.setMnemonic(n);
    }

    public SplusListBox(String string, String[] stringArray) {
        super(string);
        this.list = new JList<String>(stringArray);
        this.list.setFixedCellHeight(listFontHeight);
        Dimension dimension = new Dimension(SplusListBox.labelDimension.width, SplusListBox.labelDimension.height * 4);
        this.scrollPane = new JScrollPane(this.list, 20, 31);
        this.scrollPane.setPreferredSize(dimension);
        this.scrollPane.setMinimumSize(dimension);
        this.setActionControl(this.scrollPane);
        this.setLabelFor(this.list);
    }

    public String getValue() {
        String[] stringArray = this.getValues();
        String string = "";
        if (stringArray != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append("," + stringArray[i]);
            }
            string = stringBuffer.toString();
        }
        if (string.endsWith("\\") && !string.endsWith("\\\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String[] getValues() {
        int[] nArray = this.list.getSelectedIndices();
        ListModel listModel = this.list.getModel();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)listModel.getElementAt(nArray[i]);
        }
        return stringArray;
    }

    public void setValue(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.setValues(stringArray);
    }

    public void setValues(String[] stringArray) {
        this.list.clearSelection();
        for (int i = 0; i < stringArray.length; ++i) {
            this.list.setSelectedValue(stringArray[i], true);
        }
    }

    public String[] getOptionList() {
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = listModel.getElementAt(i).toString();
        }
        return stringArray;
    }

    public void setOptionList(String[] stringArray) {
        if (this.appendString == null && this.prependString == null) {
            this.list.setListData(stringArray);
        } else {
            int n;
            Vector<String> vector = new Vector<String>();
            if (this.prependString != null) {
                for (n = 0; n < this.prependString.length; ++n) {
                    vector.add(this.prependString[n]);
                }
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    vector.add(stringArray[n]);
                }
            }
            if (this.appendString != null) {
                for (n = 0; n < this.appendString.length; ++n) {
                    vector.add(this.appendString[n]);
                }
            }
            this.list.setListData(vector.toArray());
        }
    }

    public boolean isEnabled() {
        return this.list.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.list.setEnabled(bl);
        this.scrollPane.setEnabled(bl);
        this.setLabelEnabled(bl);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.list.getSelectedIndices();
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public void setSelectedIndices(int[] nArray) {
        this.list.setSelectedIndices(nArray);
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public void setPrepend(String[] stringArray) {
        this.prependString = stringArray;
        this.setOptionList(this.getOptionList());
    }

    public String[] getPrepend() {
        return this.prependString;
    }

    public void setAppend(String[] stringArray) {
        this.appendString = stringArray;
        this.setOptionList(this.getOptionList());
    }

    public String[] getAppend() {
        return this.appendString;
    }
}

