/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.PrintWriter;

class SGraphTextAWT
extends SGraphCommand {
    String m_txt;
    float m_degrees_rotation;
    float m_fontSize;
    float m_x;
    float m_y;
    float m_justification;
    float m_fontNumber;

    public SGraphTextAWT(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        this.m_x = f;
        this.m_y = f2;
        this.m_txt = string;
        this.m_degrees_rotation = (float)((double)f3 % 360.0);
        if (this.m_degrees_rotation < 0.0f) {
            this.m_degrees_rotation += 360.0f;
        }
        this.m_fontSize = f5;
        this.m_justification = f4;
        this.m_fontNumber = f6;
    }

    void print(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.setTextColor(sCanvasAWT, graphics);
        Font font = sCanvasAWT.getFont(this.m_fontSize, this.m_fontNumber);
        String string = sCanvasAWT.getFontText(this.m_txt, this.m_fontNumber);
        graphics.setFont(font);
        int n = this.valToWindowX(sCanvasAWT, this.m_x);
        int n2 = this.valToWindowY(sCanvasAWT, this.m_y);
        SGraphTextAWT.paintTextPixels(graphics, string, n, n2, this.m_degrees_rotation, this.m_justification, true);
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        this.setTextColor(sCanvasAWT, graphics);
        Font font = sCanvasAWT.getFont(this.m_fontSize, this.m_fontNumber);
        String string = sCanvasAWT.getFontText(this.m_txt, this.m_fontNumber);
        graphics.setFont(font);
        int n = this.valToWindowX(sCanvasAWT, this.m_x);
        int n2 = this.valToWindowY(sCanvasAWT, this.m_y);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.getDescent();
        int n5 = fontMetrics.getHeight();
        int n6 = fontMetrics.stringWidth(string);
        int n7 = (int)Math.floor(0.5 * (double)(n3 + n4));
        if ((double)this.m_degrees_rotation < 3.0 || (double)this.m_degrees_rotation > 357.0) {
            int n8 = n - (int)((float)n6 * this.m_justification);
            int n9 = n2 - n7;
            graphics.drawString(string, n8, n9 + n3);
            return;
        }
        Object[] objectArray = SGraphTextAWT.getRotatedTextInfo(font, string, n6, n5, this.m_degrees_rotation, this.m_justification, true);
        byte[] byArray = (byte[])objectArray[0];
        Rectangle rectangle = (Rectangle)objectArray[1];
        if (byArray == null || rectangle == null) {
            return;
        }
        Color color = sCanvasAWT.getTextColor(this);
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, new byte[]{-1, 0, 0, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()}, 0, false, 0);
        MemoryImageSource memoryImageSource = new MemoryImageSource(rectangle.width, rectangle.height, (ColorModel)indexColorModel, byArray, 0, rectangle.width);
        Image image = SGraphTextAWT.createImage(memoryImageSource);
        graphics.drawImage(image, n - rectangle.x, n2 - rectangle.y, null);
    }

    static void paintTextPixels(Graphics graphics, String string, int n, int n2, float f, float f2, boolean bl) {
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.stringWidth(string);
        Object[] objectArray = SGraphTextAWT.getRotatedTextInfo(font, string, n4, n3, f, f2, bl);
        byte[] byArray = (byte[])objectArray[0];
        Rectangle rectangle = (Rectangle)objectArray[1];
        if (byArray == null || rectangle == null) {
            return;
        }
        int n5 = n - rectangle.x;
        int n6 = n2 - rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                if (byArray[i * n7 + j] == 0) continue;
                graphics.fillRect(n5 + j, n6 + i, 1, 1);
            }
        }
    }

    static Object[] getRotatedTextInfo(Font font, String string, int n, int n2, float f, float f2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n + 5;
        int n8 = n2;
        Image image = SGraphTextAWT.createImage(n7, n8);
        Graphics graphics = image.getGraphics();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = fontMetrics.getAscent();
        int n10 = fontMetrics.getDescent();
        double d = bl ? 0.5 * (double)(n9 + n10) : (double)n9;
        int n11 = (int)Math.floor(d);
        Color color = Color.black;
        Color color2 = Color.white;
        graphics.setColor(color2);
        graphics.fillRect(0, 0, n7, n8);
        graphics.setColor(color);
        graphics.drawString(string, 0, n9);
        graphics.dispose();
        int[] nArray = new int[n7 * n8];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n7, n8, nArray, 0, n7);
        try {
            boolean bl2 = pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = null;
        Rectangle rectangle = null;
        int n12 = nArray[n7 - 1];
        if ((double)f < 3.0 || (double)f > 357.0) {
            byArray = new byte[n7 * n8];
            int n13 = n7 * n8;
            for (int i = 0; i < n13; ++i) {
                int n14 = nArray[i];
                if (n14 == n12) continue;
                byArray[i] = 1;
            }
            rectangle = new Rectangle((int)((float)n * f2), n11, n7, n8);
            return new Object[]{byArray, rectangle};
        }
        if ((double)f < 95.0 && (double)f > 85.0) {
            byArray = new byte[n7 * n8];
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < n7; ++j) {
                    int n15 = i * n7 + j;
                    int n16 = nArray[n15];
                    if (n16 == n12) continue;
                    int n17 = i + (n7 - 1 - j) * n8;
                    byArray[n17] = 1;
                }
            }
            rectangle = new Rectangle(n11, (int)((float)n * (1.0f - f2)) + 5, n8, n7);
            return new Object[]{byArray, rectangle};
        }
        double d2 = Math.PI * (double)f / 180.0;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        int n18 = (int)((double)n * Math.abs(d3)) + n9 * 2;
        int n19 = (int)((double)n * Math.abs(d4)) + n9 * 2;
        if ((double)f <= 90.0) {
            n6 = n9;
            n5 = n19 - n9;
        } else if ((double)f <= 180.0) {
            n6 = n18 - n9;
            n5 = n19 - n9;
        } else if ((double)f <= 270.0) {
            n6 = n18 - n9;
            n5 = n9;
        } else {
            n6 = n9;
            n5 = n9;
        }
        byArray = new byte[n18 * n19];
        for (n4 = 0; n4 < n19; ++n4) {
            for (n3 = 0; n3 < n18; ++n3) {
                int n20;
                int n21 = n3 - n6;
                int n22 = n4 - n5;
                int n23 = (int)Math.round(d3 * (double)n21 - d4 * (double)n22);
                int n24 = n9 - (int)Math.round(-d4 * (double)n21 - d3 * (double)n22);
                if (n23 < 0 || n23 >= n7 || n24 < 0 || n24 >= n8 || (n20 = nArray[n23 + n24 * n7]) == n12) continue;
                byArray[n4 * n18 + n3] = 1;
            }
        }
        n4 = n6 - (int)Math.round(-d3 * (double)n * (double)f2 + d4 * ((double)n9 - d));
        n3 = n5 - (int)Math.round(d4 * (double)n * (double)f2 + d3 * ((double)n9 - d));
        rectangle = new Rectangle(n4, n3, n18, n19);
        return new Object[]{byArray, rectangle};
    }

    public String getXMLTag() {
        return "TEXT";
    }

    public void writeXMLProperties(PrintWriter printWriter) {
        XML.writeProperty(printWriter, "X", this.m_x);
        XML.writeProperty(printWriter, "Y", this.m_y);
        XML.writeProperty(printWriter, "TEXT", this.m_txt);
        XML.writeProperty(printWriter, "FONTSIZE", this.m_fontSize);
        XML.writeProperty(printWriter, "FONTNUMBER", this.m_fontNumber);
        XML.writeProperty(printWriter, "JUST", this.m_justification);
        XML.writeProperty(printWriter, "ROT", this.m_degrees_rotation);
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        float f = XML.getFloatProperty(xMLElement, "X", iDHash);
        float f2 = XML.getFloatProperty(xMLElement, "Y", iDHash);
        String string = XML.getStringProperty(xMLElement, "TEXT", iDHash);
        float f3 = XML.getFloatProperty(xMLElement, "FONTSIZE", iDHash);
        float f4 = XML.getFloatProperty(xMLElement, "FONTNUMBER", iDHash);
        float f5 = XML.getFloatProperty(xMLElement, "JUST", iDHash);
        float f6 = XML.getFloatProperty(xMLElement, "ROT", iDHash);
        return new SGraphTextAWT(string, f, f2, f6, f5, f3, f4);
    }
}

