/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.ExtHelpManager;
import com.insightful.splus.SplusHelpManagerInstance;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.commands.CommandsWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import javax.help.HelpSetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SplusHelpManagerInstanceImpl
extends UnicastRemoteObject
implements SplusHelpManagerInstance {
    private ExtHelpManager jhmanager = null;
    private Object helpLock = new Object();
    private boolean helpStarted = false;
    private Vector setsToLoad = new Vector();
    private Vector pathsToLoad = new Vector();
    private Vector setsToRemove = new Vector();
    private CommandsWindow cWindow = null;

    public SplusHelpManagerInstanceImpl(CommandsWindow commandsWindow, boolean bl) throws RemoteException {
        if (bl) {
            new Thread(){

                public void run() {
                    SplusHelpManagerInstanceImpl.this.launchHelp();
                }
            }.start();
        }
        this.cWindow = commandsWindow;
    }

    public SplusHelpManagerInstanceImpl(CommandsWindow commandsWindow) throws RemoteException {
        this(commandsWindow, true);
    }

    public SplusHelpManagerInstanceImpl() throws RemoteException {
        new Thread(){

            public void run() {
                SplusHelpManagerInstanceImpl.this.launchHelp();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtHelpManager getHelpManager() {
        Object object = this.helpLock;
        synchronized (object) {
            return this.jhmanager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean launchHelp() {
        try {
            String string = System.getProperty("splus.help.host");
            String string2 = null;
            String string3 = null;
            if (string != null) {
                if (string.toLowerCase().startsWith("http://")) {
                    string = string.substring(7);
                }
                if (string.length() > 0) {
                    int n = string.indexOf("/");
                    if (n != -1) {
                        string2 = string.substring(0, n);
                        string3 = string.length() > n + 1 ? string.substring(n + 1) : "";
                    } else {
                        string2 = string;
                    }
                }
            }
            Object object = this.helpLock;
            synchronized (object) {
                try {
                    this.jhmanager = new ExtHelpManager(string2, string3);
                    SplusHelpManagerInstanceImpl splusHelpManagerInstanceImpl = this;
                    splusHelpManagerInstanceImpl.jhmanager.createJhelp();
                }
                catch (HelpSetException helpSetException) {
                    System.out.println("Cannot find helpset (default.hs).");
                    this.helpStarted = false;
                    return false;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return false;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void addHelpSet(String string, String string2) throws RemoteException {
        if (this.getHelpManager() != null || this.launchHelp()) {
            this.setsToLoad.add(string2);
            this.pathsToLoad.add(string);
        }
    }

    public void removeHelpSet(String string) throws RemoteException {
        if (this.getHelpManager() != null || this.launchHelp()) {
            this.setsToRemove.add(string);
        }
    }

    private void updateHelpSets(HelpProgressDialog helpProgressDialog) {
        if (this.jhmanager != null) {
            String string;
            int n;
            boolean bl;
            boolean bl2 = bl = !this.helpStarted;
            if (!this.helpStarted) {
                try {
                    helpProgressDialog.setProgressString("default.hs", 1, this.setsToLoad.size() + 1, true);
                    ExtHelpManager.setMainHelpSet("default.hs");
                    helpProgressDialog.incrementProgressBar();
                    this.helpStarted = true;
                }
                catch (HelpSetException helpSetException) {
                    System.out.println("Cannot find helpset (default.hs).");
                    this.helpStarted = false;
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    this.helpStarted = false;
                    return;
                }
            }
            for (n = 0; n < this.setsToLoad.size(); ++n) {
                string = (String)this.setsToLoad.get(n);
                String string2 = (String)this.pathsToLoad.get(n);
                helpProgressDialog.setProgressString(string, bl ? n + 2 : n + 1, this.setsToLoad.size() + 1, true);
                try {
                    ExtHelpManager.addHelpSet(string2, string);
                }
                catch (HelpSetException helpSetException) {
                    System.out.println("Cannot find helpset (" + string + ") in specified path: " + string2);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("Error encountered loading helpset (" + string + ") from specified path: " + string2);
                }
                helpProgressDialog.incrementProgressBar();
            }
            this.setsToLoad.removeAllElements();
            this.pathsToLoad.removeAllElements();
            for (n = 0; n < this.setsToRemove.size(); ++n) {
                string = (String)this.setsToRemove.get(n);
                helpProgressDialog.setProgressString(string, n + 1, this.setsToRemove.size(), false);
                ExtHelpManager.removeHelpSet(string);
                helpProgressDialog.incrementProgressBar();
            }
            this.setsToRemove.removeAllElements();
        }
    }

    public void openJhelp() throws RemoteException {
        if (this.getHelpManager() != null || this.launchHelp()) {
            int n = this.setsToLoad.size() + this.setsToRemove.size();
            if (!this.helpStarted) {
                ++n;
            }
            if (n > 0) {
                final HelpProgressDialog helpProgressDialog = new HelpProgressDialog(n);
                HelpSetThread helpSetThread = new HelpSetThread(helpProgressDialog, true, null);
                helpProgressDialog.setThread(helpSetThread);
                new Thread(){

                    public void run() {
                        helpProgressDialog.show();
                    }
                }.start();
            } else {
                SplusHelpManagerInstanceImpl splusHelpManagerInstanceImpl = this;
                splusHelpManagerInstanceImpl.jhmanager.openJhelp();
            }
        }
    }

    public void openJhelp(String string) throws RemoteException {
        if (this.jhmanager != null || this.launchHelp()) {
            int n = this.setsToLoad.size() + this.setsToRemove.size();
            if (!this.helpStarted) {
                ++n;
            }
            if (n > 0) {
                final HelpProgressDialog helpProgressDialog = new HelpProgressDialog(n);
                HelpSetThread helpSetThread = new HelpSetThread(helpProgressDialog, true, string);
                helpProgressDialog.setThread(helpSetThread);
                new Thread(){

                    public void run() {
                        helpProgressDialog.show();
                    }
                }.start();
            } else {
                ExtHelpManager.openJhelp(string);
            }
        }
    }

    public void displayJhelp(String string) throws RemoteException {
        if (this.getHelpManager() != null || this.launchHelp()) {
            int n = this.setsToLoad.size() + this.setsToRemove.size();
            if (!this.helpStarted) {
                ++n;
            }
            if (n > 0) {
                final HelpProgressDialog helpProgressDialog = new HelpProgressDialog(n);
                HelpSetThread helpSetThread = new HelpSetThread(helpProgressDialog, false, string);
                helpProgressDialog.setThread(helpSetThread);
                new Thread(){

                    public void run() {
                        helpProgressDialog.show();
                    }
                }.start();
            } else {
                ExtHelpManager.displayJhelp(string);
            }
        }
    }

    public void closeJhelp() throws RemoteException {
        if (this.getHelpManager() != null || this.launchHelp()) {
            this.getHelpManager();
            ExtHelpManager.closeJhelp();
        }
    }

    public void createJhelp(String string) throws RemoteException {
    }

    public void createJhelp(String string, int n, int n2) throws RemoteException {
    }

    private class HelpSetThread
    extends Thread {
        private HelpProgressDialog m_dialog;
        private boolean m_open = true;
        private String m_arg = null;

        public HelpSetThread(HelpProgressDialog helpProgressDialog, boolean bl, String string) {
            this.m_dialog = helpProgressDialog;
            this.m_open = bl;
            this.m_arg = string;
        }

        public void run() {
            try {
                SplusHelpManagerInstanceImpl.this.updateHelpSets(this.m_dialog);
                this.m_dialog.setVisible(false);
                if (SplusHelpManagerInstanceImpl.this.helpStarted) {
                    if (this.m_open) {
                        if (this.m_arg == null) {
                            SplusHelpManagerInstanceImpl.this.jhmanager;
                            ExtHelpManager.openJhelp();
                        } else {
                            SplusHelpManagerInstanceImpl.this.jhmanager;
                            ExtHelpManager.openJhelp(this.m_arg);
                        }
                    } else {
                        SplusHelpManagerInstanceImpl.this.jhmanager;
                        ExtHelpManager.displayJhelp(this.m_arg);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.m_dialog.setVisible(false);
            }
        }
    }

    private class HelpProgressDialog
    extends JDialog {
        private Thread m_thread;
        private JProgressBar m_progress;
        private JLabel m_countLabel;
        private JLabel m_nameLabel;
        private int m_value;
        private int m_seconds;

        public HelpProgressDialog(int n) {
            super(SplusSystem.getDefaultFrame(), "Loading/Removing HelpSets", true);
            this.m_thread = null;
            this.m_progress = null;
            this.m_countLabel = null;
            this.m_nameLabel = null;
            this.m_value = 0;
            this.m_seconds = 20;
            this.m_value = 0;
            this.m_progress = new JProgressBar(0, 0, n * this.m_seconds);
            this.m_countLabel = new JLabel("Loading/Removing HelpSets");
            this.m_nameLabel = new JLabel("");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.m_countLabel, "North");
            jPanel.add((Component)this.m_nameLabel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(jPanel);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)this.m_progress, "Center");
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel2, "South");
            container.add((Component)jPanel3, "Center");
            this.pack();
            this.setSize(200, 100);
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = SplusSystem.getDefaultFrame().getBounds();
            Point point = new Point((rectangle2.x + rectangle2.width) / 2 - rectangle.width / 2, (rectangle2.y + rectangle2.height) / 2 - rectangle.height / 2);
            if (rectangle2.width == 0 && rectangle2.height == 0) {
                Dimension dimension = this.getToolkit().getScreenSize();
                point = new Point((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
            }
            this.setLocation(point);
        }

        public void show() {
            if (this.m_thread != null) {
                this.m_thread.start();
                new SecondsProgress().start();
            }
            super.show();
        }

        public void setVisible(boolean bl) {
            if (bl && this.m_thread != null) {
                this.m_thread.start();
                new SecondsProgress().start();
            }
            super.setVisible(bl);
        }

        public void setThread(Thread thread) {
            this.m_thread = thread;
        }

        public void incrementProgressBar() {
            this.m_value = (this.m_value / this.m_seconds + 1) * this.m_seconds;
            this.m_progress.setValue(this.m_value);
        }

        public void setProgressString(String string, int n, int n2, boolean bl) {
            String string2 = bl ? "Loading Help Set " : "Removing Help Set ";
            this.m_countLabel.setText(string2 + "(" + n + " of " + n2 + ")");
            this.m_nameLabel.setText(string);
        }

        private class SecondsProgress
        extends Thread {
            private SecondsProgress() {
            }

            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            if (HelpProgressDialog.this.m_seconds != 1 && (HelpProgressDialog.this.m_value + 1) % HelpProgressDialog.this.m_seconds != 0) {
                                HelpProgressDialog.this.m_value++;
                            }
                            if (!HelpProgressDialog.this.isVisible()) break block2;
                            HelpProgressDialog.this.m_progress.setValue(HelpProgressDialog.this.m_value);
                            SecondsProgress.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }
    }
}

