/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFileSystemView;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URL;

public class ServerFile
extends File {
    char sepChar = (char)47;
    String sepString = "/";
    public static final String SERVER_ROOT = "/SERVERROOT";
    public static final int SERVER_ROOT_LENGTH = "/SERVERROOT".length();
    private String parentName;
    private String fileName;
    private long lastMod = -1L;
    private long length = -1L;
    private boolean canRead = true;
    private boolean canWrite = true;
    private boolean exists = true;
    private boolean isDir = true;
    private boolean setCanRead = false;
    private boolean setCanWrite = false;
    private boolean setExists = false;
    private boolean setDir = false;
    private boolean knowDirStatus = false;
    private boolean dirStatus = false;
    private static File[] rootFiles;
    private static boolean checkWritable;
    private static boolean checkReadable;
    private static boolean checkExists;

    public ServerFile(String string) {
        super(".");
        this.processPathname(string);
    }

    public ServerFile(File file, String string) {
        super(".");
        this.parentName = file.getPath();
        this.fileName = string;
    }

    public ServerFile(String string, String string2) {
        super(".");
        this.parentName = string;
        this.fileName = string2;
    }

    public ServerFile(String string, boolean bl) {
        super(".");
        this.processPathname(string);
        this.knowDirStatus = true;
        this.dirStatus = bl;
    }

    public ServerFile(File file, String string, boolean bl) {
        super(".");
        this.parentName = file.getPath();
        this.fileName = string;
        this.knowDirStatus = true;
        this.dirStatus = bl;
    }

    public ServerFile(String string, String string2, boolean bl) {
        super(".");
        this.parentName = string;
        this.fileName = string2;
        this.knowDirStatus = true;
        this.dirStatus = bl;
    }

    public static String convertServerFilePath(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(SERVER_ROOT)) {
            return string.substring(SERVER_ROOT_LENGTH, string.length());
        }
        return string;
    }

    public void setCanRead(boolean bl) {
        this.canRead = bl;
        this.setCanRead = true;
    }

    public void setCanWrite(boolean bl) {
        this.canWrite = bl;
        this.setCanWrite = true;
    }

    public boolean canRead() {
        ServerFileSystemView serverFileSystemView;
        ServerFile[] serverFileArray;
        if (!this.setCanRead && (serverFileArray = (serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView()).clientSideFileInfoQuery(this.getPath(), false, false)) != null && serverFileArray.length > 0) {
            this.canRead = serverFileArray[0].canRead();
            this.setCanRead = true;
        }
        return this.canRead;
    }

    public boolean canWrite() {
        ServerFileSystemView serverFileSystemView;
        ServerFile[] serverFileArray;
        if (!this.setCanWrite && (serverFileArray = (serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView()).clientSideFileInfoQuery(this.getPath(), false, false)) != null && serverFileArray.length > 0) {
            this.canWrite = serverFileArray[0].canWrite();
            this.setCanWrite = true;
        }
        return this.canWrite;
    }

    public int compareTo(File file) {
        if (file instanceof ServerFile) {
            return this.getPath().compareTo(file.getPath());
        }
        throw new ClassCastException("pathname is not a ServerFile");
    }

    public boolean createNewFile() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public static File createTempFile(String string, String string2) {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public static File createTempFile(String string, String string2, File file) {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public void deleteOnExit() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public boolean equals(Object object) {
        if (object instanceof ServerFile) {
            return this.getPath().equals(((ServerFile)object).getPath());
        }
        return false;
    }

    public void setExists(boolean bl) {
        this.exists = bl;
        this.setExists = true;
    }

    public boolean exists() {
        ServerFileSystemView serverFileSystemView;
        ServerFile[] serverFileArray;
        if (!this.setExists && (serverFileArray = (serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView()).clientSideFileInfoQuery(this.getPath(), false, false)) != null && serverFileArray.length > 0) {
            this.exists = serverFileArray[0].exists();
            this.setExists = true;
        }
        return this.exists;
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        return this.getPath(true);
    }

    public File getCanonicalFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.getPath(true);
    }

    public String getName() {
        return this.fileName;
    }

    public String getParent() {
        return this.parentName;
    }

    public File getParentFile() {
        if (this.parentName == null || this.fileName.length() == 0) {
            return null;
        }
        return SplusSystem.getServerFileHandler().getServerFileSystemView().createFileObject(this.parentName);
    }

    private String getPath(boolean bl) {
        String string;
        String string2 = string = bl ? SERVER_ROOT : "";
        if (this.parentName == null || this.parentName.equals(this.sepString)) {
            return string + this.sepString + this.fileName;
        }
        if (this.parentName.endsWith(this.sepString)) {
            return string + this.parentName + this.fileName;
        }
        return string + this.parentName + this.sepString + this.fileName;
    }

    public String getPath() {
        return this.getPath(false);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean isAbsolute() {
        if (this.parentName != null) {
            return this.parentName.startsWith(this.sepString);
        }
        return this.fileName.startsWith(this.sepString);
    }

    public void setIsDir(boolean bl) {
        this.isDir = bl;
        this.setDir = true;
    }

    public boolean isDirectory() {
        ServerFileSystemView serverFileSystemView;
        ServerFile[] serverFileArray;
        if (!this.setDir && (serverFileArray = (serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView()).clientSideFileInfoQuery(this.getPath(), false, false)) != null && serverFileArray.length > 0) {
            this.isDir = serverFileArray[0].isDirectory();
            this.setDir = true;
        }
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        return this.fileName.startsWith(".");
    }

    public long lastModified() {
        if (this.lastMod == -1L) {
            ServerFileSystemView serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView();
            ServerFile[] serverFileArray = serverFileSystemView.clientSideFileInfoQuery(this.getPath(), false, false);
            if (serverFileArray != null && serverFileArray.length > 0) {
                this.lastMod = serverFileArray[0].lastModified();
            } else {
                return 0L;
            }
        }
        return this.lastMod;
    }

    public long length() {
        if (this.length == -1L) {
            ServerFileSystemView serverFileSystemView = (ServerFileSystemView)SplusSystem.getServerFileHandler().getServerFileSystemView();
            ServerFile[] serverFileArray = serverFileSystemView.clientSideFileInfoQuery(this.getPath(), false, false);
            if (serverFileArray != null && serverFileArray.length > 0) {
                this.length = serverFileArray[0].length();
            } else {
                return 0L;
            }
        }
        return this.length;
    }

    public String[] list() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public String[] list(FilenameFilter filenameFilter) {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public File[] listFiles() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public File[] listFiles(FileFilter fileFilter) {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public static File[] listRoots() {
        if (rootFiles == null) {
            File file = SplusSystem.getServerFileHandler().getServerFileSystemView().createFileObject("/");
            rootFiles = new File[]{file};
        }
        return rootFiles;
    }

    public boolean mkdir() {
        return ServerFile.processMkdir(this.getPath());
    }

    public boolean mkdirs() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public boolean renameTo(File file) {
        boolean bl = ServerFile.processRename(this.getPath(), file.getPath());
        if (bl) {
            this.fileName = file.getName();
            this.parentName = file.getParent();
        }
        return bl;
    }

    public boolean setLastModified(long l) {
        this.lastMod = l;
        return true;
    }

    public boolean setLength(long l) {
        this.length = l;
        return true;
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public String toString() {
        return this.getPath();
    }

    public URL toURL() {
        throw new UnsupportedOperationException("Method not implemented for ServerFile.");
    }

    public static boolean setCheckReadable(boolean bl) {
        boolean bl2 = checkReadable;
        checkReadable = bl;
        return bl2;
    }

    public static boolean setCheckWritable(boolean bl) {
        boolean bl2 = checkWritable;
        checkWritable = bl;
        return bl2;
    }

    public static boolean setCheckExists(boolean bl) {
        boolean bl2 = checkExists;
        checkExists = bl;
        return bl2;
    }

    private void processPathname(String string) {
        int n;
        if (string.endsWith(this.sepString)) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf(this.sepString)) < 0) {
            this.parentName = null;
            this.fileName = string;
        } else {
            this.parentName = string.substring(0, n);
            if (this.parentName.endsWith(this.sepString)) {
                this.parentName = this.parentName.substring(0, this.parentName.length() - 1);
            }
            this.fileName = string.substring(n + 1);
        }
    }

    private static boolean processMkdir(String string) {
        boolean bl = false;
        try {
            String string2 = "as.character(mkdir('" + string + "'))";
            SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string2);
            bl = splusDataResult.getStringData()[0].equals("TRUE");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private static boolean processRename(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = "as.character(rename.files('" + string + "', '" + string2 + "')==0)";
            SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string3);
            bl = splusDataResult.getStringData()[0].equals("TRUE");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    static {
        checkWritable = false;
        checkReadable = true;
        checkExists = true;
    }
}

