/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.dataview;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusInvisibleControl;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.controls.SplusWideComboBox;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class ImportDataDialog
extends SplusDialog {
    SplusFunctionInfo funcInfo;
    SplusWideTextField fileName;
    SplusWideTextField keepCols;
    SplusWideTextField dropCols;
    SplusWideTextField filterRows;
    ImportFileTypeControl fileTypeControl;
    SplusInvisibleControl fileTypeCode;
    SplusButton fileButton;
    JFileChooser fileChooser;
    SplusTextField saveName;
    SplusTextField startCol;
    SplusTextField endCol;
    SplusTextField startRow;
    SplusTextField endRow;
    SplusTextField pageNumber;
    SplusTextField colNames;
    SplusTextField rowNames;
    SplusTextField textDelimiter;
    SplusTextField textFormat;
    SplusTextField centuryCutoff;
    SplusCheckBox stringsAsFactors;
    SplusCheckBox sortFactorLevels;
    SplusCheckBox valueLabelAsNumber;
    int fileChooserReturnValue = 1;
    JDialog fileChooserDialog = null;
    private static String[] typeCodeList = new String[]{"", "ASCII", "ASCII", "ASCII", "ASCII", "ASCII", "DBASE", "EXCEL", "EXCELX", "FASCII", "GAUSS", "GAUSS96", "LOTUS", "MATLAB", "MINITAB", "QUATTRO", "SAS7", "SAS", "SAS1", "SAS4", "SAS_TPT", "SPSS", "SPSSP", "STATA", "SYSTAT"};
    private static String[] typeDescriptionList = new String[]{"Unspecified file format", "ASCII file - whitespace delimited (*.asc;*.dat;*.txt;*.prn)", "ASCII file - space delimited (*.asc;*.dat;*.txt;*.prn)", "ASCII file - tab delimited (*.asc;*.dat;*.txt;*.prn)", "ASCII file - comma delimited (*.csv)", "ASCII file - user-defined delimiter (*.asc;*.dat;*.txt;*.prn)", "dBASE file (*.dbf)", "Excel Worksheet (*.xls)", "Excel 2007 Worksheet (*.xlsx)", "Fixed Format ASCII File (*.fix;*.fsc)", "Gauss Data File (*.dat)", "Gauss Data File - Unix (*.dat)", "Lotus 1-2-3 Worksheet (*.wks;*.wk1;*.wk3;*.wk4;*.wrk)", "Matlab Matrix (*.mat)", "Mintab Workbook (*.mtw)", "Quattro Pro Worksheet (*.wq1;*.wb2;*.wb3)", "SAS Version 7/8/9 (*.sas7bdat)", "SAS - Windows/OS2 (*.sd2)", "SAS - HP IBM & SUN Unix (*.ssd01)", "SAS - Dec Unix (*.ssd04)", "SAS Transport File (*.tpt;*.xpt)", "SPSS Data File (*.sav)", "SPSS Portable Data File (*.por)", "Stata Data File (*.dta)", "Systat File (*.syd, *.sys)"};
    private static String[][] extensionList = new String[][]{{""}, {".asc", ".dat", ".txt", ".prn"}, {".asc", ".dat", ".txt", ".prn"}, {".asc", ".dat", ".txt", ".prn"}, {".csv"}, {".asc", ".dat", ".txt", ".prn"}, {".dbf"}, {".xls"}, {".xlsx"}, {".fix", ".fsc"}, {".dat"}, {".dat"}, {".wks", ".wk1", ".wk3", ".wk4", ".wrk"}, {".mat"}, {".mtw"}, {".wq1", ".wb2", ".wb3"}, {".sas7bdat"}, {".sd2"}, {".ssd01"}, {".ssd04"}, {".tpt", ".xpt"}, {".sav"}, {".por"}, {".dta"}, {".syd", ".sys"}};
    private static int FCD_EXTRA_WIDTH = 50;

    public ImportDataDialog() {
        super("Import Data");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuImportData");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Data", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box2.add(box3);
        box2.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("File");
        box.add(splusGroupPanel);
        this.fileName = new SplusWideTextField("File Name", 'N');
        splusGroupPanel.add(this.fileName);
        splusFunctionInfo.add(this.fileName, "file", true);
        this.fileButton = new SplusButton("Browse", 'B');
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (ImportDataDialog.this.fileChooser == null) {
                    ImportDataDialog.this.fileChooser = new JFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
                    ImportDataDialog.this.fileChooser.setDialogTitle("Select File");
                    for (n = 1; n < extensionList.length; ++n) {
                        ImportDataDialog.this.fileChooser.addChoosableFileFilter(new LocalExtensionFileFilter(extensionList[n], typeDescriptionList[n]));
                    }
                    ImportDataDialog.this.fileChooser.setFileFilter(ImportDataDialog.this.fileChooser.getAcceptAllFileFilter());
                }
                if ((n = ImportDataDialog.this.showFileChooserDialog()) == 0) {
                    ImportDataDialog.this.fileName.setValue(ServerFile.convertServerFilePath(ImportDataDialog.this.fileChooser.getSelectedFile().getAbsolutePath()));
                    String string = ImportDataDialog.this.fileChooser.getFileFilter().getDescription();
                    if (!string.startsWith("All")) {
                        ImportDataDialog.this.fileTypeControl.setValue(string);
                    }
                    SplusSystem.setCwd(ImportDataDialog.this.fileChooser.getCurrentDirectory());
                }
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalGlue());
        box5.add(this.fileButton);
        box5.add(Box.createHorizontalStrut(10));
        splusGroupPanel.add(Box.createVerticalStrut(5));
        splusGroupPanel.add(box5);
        splusGroupPanel.add(Box.createVerticalStrut(5));
        splusGroupPanel.add(Box.createVerticalStrut(SplusControlMetrics.getFullDimension().height));
        this.fileTypeControl = new ImportFileTypeControl();
        splusGroupPanel.add(this.fileTypeControl);
        splusFunctionInfo.add(this.fileTypeControl, "");
        this.fileTypeCode = new SplusInvisibleControl("");
        splusGroupPanel.add(this.fileTypeCode);
        splusFunctionInfo.add(this.fileTypeCode, "type", true);
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Data Set Name");
        box3.add(splusGroupPanel2);
        this.saveName = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(this.saveName);
        splusFunctionInfo.add(this.saveName, "save.name", true);
        box3.add(new SplusBoxFiller());
        box4.add(new SplusBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Filter", jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Select Columns");
        jPanel2.add(splusGroupPanel3);
        this.keepCols = new SplusWideTextField("Keep Columns", 'K');
        splusGroupPanel3.add(this.keepCols);
        splusFunctionInfo.add(this.keepCols, "keep", true, true);
        this.dropCols = new SplusWideTextField("Drop Columns", 'D');
        splusGroupPanel3.add(this.dropCols);
        splusFunctionInfo.add(this.dropCols, "drop", true, true);
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Select Rows");
        jPanel2.add(splusGroupPanel4);
        this.filterRows = new SplusWideTextField("Filter Rows", 'F');
        splusGroupPanel4.add(this.filterRows);
        splusFunctionInfo.add(this.filterRows, "filter", true);
        jPanel2.add(new SplusWideBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Format", jPanel3);
        Box box6 = new Box(1);
        Box box7 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box6);
        jPanel3.add(box7);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Factor Columns");
        box6.add(splusGroupPanel5);
        this.stringsAsFactors = new SplusCheckBox("Import Strings as Factors", 'I');
        this.stringsAsFactors.setValue("T");
        splusGroupPanel5.add(this.stringsAsFactors);
        splusFunctionInfo.add(this.stringsAsFactors, "stringsAsFactors");
        this.sortFactorLevels = new SplusCheckBox("Sort Factor Levels", 'S');
        this.sortFactorLevels.setValue("T");
        splusGroupPanel5.add(this.sortFactorLevels);
        splusFunctionInfo.add(this.sortFactorLevels, "sortFactorLevels");
        this.valueLabelAsNumber = new SplusCheckBox("Labeled Values as Numbers", 'L');
        this.valueLabelAsNumber.setEnabled(false);
        splusGroupPanel5.add(this.valueLabelAsNumber);
        splusFunctionInfo.add(this.valueLabelAsNumber, "valueLabelAsNumber");
        box6.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Text Files");
        box7.add(splusGroupPanel6);
        this.textDelimiter = new SplusTextField("Column Delimiter", 'D');
        this.textDelimiter.setEnabled(false);
        splusGroupPanel6.add(this.textDelimiter);
        splusFunctionInfo.add(this.textDelimiter, "delimiter", true);
        this.textFormat = new SplusTextField("Format String", 'F');
        this.textFormat.setEnabled(false);
        splusGroupPanel6.add(this.textFormat);
        splusFunctionInfo.add(this.textFormat, "format", true);
        this.centuryCutoff = new SplusTextField("Century Cutoff", 'C');
        this.centuryCutoff.setEnabled(false);
        this.centuryCutoff.setValue("1930");
        splusGroupPanel6.add(this.centuryCutoff);
        splusFunctionInfo.add(this.centuryCutoff, "centuryCutoff");
        box7.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Range", jPanel4);
        Box box8 = new Box(1);
        Box box9 = new Box(1);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(box8);
        jPanel4.add(box9);
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Column Range");
        box8.add(splusGroupPanel7);
        this.startCol = new SplusTextField("Start Column", 'S');
        this.startCol.setEnabled(false);
        splusGroupPanel7.add(this.startCol);
        splusFunctionInfo.add(this.startCol, "startCol");
        this.endCol = new SplusTextField("End Column", 'E');
        this.endCol.setEnabled(false);
        splusGroupPanel7.add(this.endCol);
        splusFunctionInfo.add(this.endCol, "endCol");
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Row Range");
        box8.add(splusGroupPanel8);
        this.startRow = new SplusTextField("Start Row", 'T');
        this.startRow.setEnabled(false);
        splusGroupPanel8.add(this.startRow);
        splusFunctionInfo.add(this.startRow, "startRow");
        this.endRow = new SplusTextField("End Row", 'D');
        this.endRow.setEnabled(false);
        splusGroupPanel8.add(this.endRow);
        splusFunctionInfo.add(this.endRow, "endRow");
        box8.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Names");
        box9.add(splusGroupPanel9);
        this.rowNames = new SplusTextField("Col of Row Names", 'R');
        splusGroupPanel9.add(this.rowNames);
        splusFunctionInfo.add(this.rowNames, "rowNamesCol", true);
        this.colNames = new SplusTextField("Row of Col Names", 'C');
        this.colNames.setEnabled(false);
        splusGroupPanel9.add(this.colNames);
        splusFunctionInfo.add(this.colNames, "colNameRow", true);
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Page");
        box9.add(splusGroupPanel10);
        this.pageNumber = new SplusTextField("Page Number", 'P');
        this.pageNumber.setEnabled(false);
        splusGroupPanel10.add(this.pageNumber);
        splusFunctionInfo.add(this.pageNumber, "pageNumber");
        box9.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this.warnIfEmpty(this.fileName) && this.warnIfEmpty(this.saveName);
        if (bl && this.fileTypeCode.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, "File format must be specified.", "File Format Not Specified", 2);
            bl = false;
        }
        if (bl && !this.keepCols.getValue().equals("") && !this.dropCols.getValue().equals("")) {
            JOptionPane.showMessageDialog(this, "Only one of Keep and Drop may be specified.", "Inconsistent Field Values", 2);
            bl = false;
        }
        return bl;
    }

    private int showFileChooserDialog() {
        if (this.fileChooserDialog == null) {
            this.fileChooser.setApproveButtonText("OK");
            this.fileChooser.setDialogType(2);
            String string = this.fileChooser.getDialogTitle();
            if (string == null) {
                string = this.fileChooser.getUI().getDialogTitle(this.fileChooser);
            }
            this.fileChooserDialog = new JDialog(SplusSystem.getDefaultFrame(), string, true);
            Container container = this.fileChooserDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this.fileChooser, "Center");
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    ImportDataDialog.this.fileChooserReturnValue = string.equals("ApproveSelection") ? 0 : (string.equals("CancelSelection") ? 1 : -1);
                    if (ImportDataDialog.this.fileChooserDialog != null) {
                        ImportDataDialog.this.fileChooserDialog.setVisible(false);
                    }
                }
            });
        }
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooserReturnValue = 1;
        this.fileChooserDialog.setSize(new Dimension(this.getSize().width + FCD_EXTRA_WIDTH, this.getSize().height));
        this.fileChooserDialog.setLocationRelativeTo(SplusSystem.getDefaultFrame());
        this.fileChooserDialog.show();
        return this.fileChooserReturnValue;
    }

    private class LocalExtensionFileFilter
    extends FileFilter {
        String[] extList;
        String description;

        public LocalExtensionFileFilter(String string, String string2) {
            this.extList = new String[]{string};
            this.description = string2;
        }

        public LocalExtensionFileFilter(String[] stringArray, String string) {
            this.extList = stringArray;
            this.description = string;
        }

        public boolean accept(File file) {
            boolean bl = true;
            boolean bl2 = bl = file.isDirectory() || this.extList[0].equals("");
            if (!bl) {
                String string = file.getName().toLowerCase();
                for (int i = 0; i < this.extList.length; ++i) {
                    bl = bl || string.endsWith(this.extList[i]);
                }
            }
            return bl;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ImportFileTypeListener
    implements ActionListener {
        int indexValue;
        String codeValue;
        String delimiterValue;
        boolean isAscii;
        boolean isUserDelimiter;
        boolean isFascii;
        boolean isSpreadsheet;
        boolean isSasOrSpss;

        ImportFileTypeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.indexValue = ImportDataDialog.this.fileTypeControl.getSelectedIndex();
            this.codeValue = typeCodeList[this.indexValue];
            ImportDataDialog.this.fileTypeCode.setValue(this.codeValue);
            this.isAscii = this.codeValue.startsWith("ASCII");
            this.isFascii = this.codeValue.startsWith("FASCII");
            this.isSpreadsheet = this.codeValue.startsWith("EXCEL") || this.codeValue.startsWith("LOTUS") || this.codeValue.startsWith("QUATTRO");
            this.isSasOrSpss = this.codeValue.startsWith("SAS") || this.codeValue.startsWith("SPSS");
            this.isUserDelimiter = this.indexValue == 5;
            ImportDataDialog.this.textDelimiter.setEnabled(this.isUserDelimiter);
            this.delimiterValue = "";
            if (this.isAscii) {
                switch (this.indexValue) {
                    case 2: {
                        this.delimiterValue = "<SPACE>";
                        break;
                    }
                    case 3: {
                        this.delimiterValue = "<TAB>";
                        break;
                    }
                    case 4: {
                        this.delimiterValue = ",";
                        break;
                    }
                }
            }
            ImportDataDialog.this.textDelimiter.setValue(this.delimiterValue);
            ImportDataDialog.this.textFormat.setEnabled(this.isFascii);
            ImportDataDialog.this.centuryCutoff.setEnabled(this.isAscii || this.isFascii);
            ImportDataDialog.this.startCol.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.endCol.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.startRow.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.endRow.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.pageNumber.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.colNames.setEnabled(this.isSpreadsheet);
            ImportDataDialog.this.valueLabelAsNumber.setEnabled(this.isSasOrSpss);
        }
    }

    private class ImportFileTypeControl
    extends SplusWideComboBox {
        ImportFileTypeControl() {
            super("File Format", 'F', typeDescriptionList);
            this.setValue("Unspecified file format");
            this.setEditable(false);
            this.addActionListener(new ImportFileTypeListener());
        }
    }
}

