/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse;

import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.ClientUtilities;
import com.insightful.splus.FileInputStreamProxy;
import com.insightful.splus.FileOutputStreamProxy;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusOutputHandler;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.eclipse.SplusEclipseSessionImpl;
import com.insightful.splus.eclipse.SplusRemoteEclipseSession;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class SplusRemoteEclipseSessionImpl
extends UnicastRemoteObject
implements SplusRemoteEclipseSession,
Remote,
SplusOutputHandler,
SplusWinSessionListener,
SplusDebugListener {
    private SplusEclipseSessionImpl m_session;
    private Vector m_debugListenerClasses;
    private Vector m_winSssionListenerClasses;
    private Vector m_storedEngineOutput = null;

    public SplusEclipseSessionImpl getSession() {
        return this.m_session;
    }

    public SplusRemoteEclipseSessionImpl(String[] stringArray) throws RemoteException, SplusLicenseException {
        this.m_session = new SplusEclipseSessionImpl(stringArray);
        this.init();
    }

    public SplusRemoteEclipseSessionImpl() throws RemoteException, SplusLicenseException {
        this.m_session = new SplusEclipseSessionImpl();
        this.init();
    }

    private void init() throws RemoteException {
        this.m_winSssionListenerClasses = new Vector();
        this.m_session.addListener(this);
        this.m_session.startPollOutput(this);
        this.m_debugListenerClasses = new Vector();
        this.m_session.addSplusDebugListener(this);
    }

    public void setClientObjectFactory(ClientObjectFactory clientObjectFactory) throws RemoteException {
        this.m_session.setClientObjectFactory(clientObjectFactory);
        this.flushOutput();
    }

    public void writeSplusIn(String string) throws RemoteException {
        this.m_session.writeSplusIn(string);
    }

    public void writeSplusData(String string) throws RemoteException {
        this.m_session.writeSplusData(string);
    }

    public String readSplusOut() throws RemoteException {
        return this.m_session.readSplusOut();
    }

    public String readSplusErr() throws RemoteException {
        return this.m_session.readSplusErr();
    }

    public SplusDataResult evalDataQuery(String string) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string);
    }

    public SplusDataResult evalDataQuery(String string, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, n);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, bl, bl2);
    }

    public SplusDataResult evalDataQuery(String string, int n, boolean bl, boolean bl2) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, n, bl, bl2);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, bl, bl2, bl3, bl4, bl5);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, n);
    }

    public SplusDataResult evalDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6, boolean bl7) throws RemoteException, SplusEngineBusyException, SplusIncompleteExpressionException {
        return this.m_session.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, n, bl6, bl7);
    }

    public void Interrupt() throws RemoteException {
        this.m_session.Interrupt();
    }

    public FileInputStreamProxy getFileInputStream(String string) throws FileNotFoundException, RemoteException {
        return this.m_session.getFileInputStream(string);
    }

    public FileOutputStreamProxy getFileOutputStream(String string) throws FileNotFoundException, RemoteException {
        return this.m_session.getFileOutputStream(string);
    }

    public boolean isRemote() throws RemoteException {
        return true;
    }

    public void sessionExit() throws RemoteException {
        this.m_session.sessionExit();
    }

    public void sessionExit(boolean bl) throws RemoteException {
        this.m_session.sessionExit(bl);
    }

    public void startPollOutput(SplusOutputHandler splusOutputHandler) throws RemoteException {
        this.m_session.startPollOutput(splusOutputHandler);
    }

    public String getCertFilename() throws RemoteException {
        return this.m_session.getCertFilename();
    }

    public char[] getCertAccess() throws RemoteException {
        return this.m_session.getCertAccess();
    }

    public ClientUtilities getClientUtilities() throws RemoteException {
        return this.m_session.getClientUtilities();
    }

    public void addListener(SplusWinSessionListener splusWinSessionListener) throws RemoteException {
        this.addSessionListener(splusWinSessionListener.getClass().toString());
    }

    public void addSessionListener(String string) throws RemoteException {
        this.m_winSssionListenerClasses.add(string);
    }

    public String getPendingInputString() throws RemoteException {
        return this.m_session.getPendingInputString();
    }

    public int parseSplusString(String string) throws RemoteException {
        return this.m_session.parseSplusString(string);
    }

    public void removeListener(SplusWinSessionListener splusWinSessionListener) throws RemoteException {
        this.removeSessionListener(splusWinSessionListener.getClass().toString());
    }

    public void removeSessionListener(String string) throws RemoteException {
        this.m_winSssionListenerClasses.remove(string);
    }

    public void setPromptFlag(boolean bl) throws RemoteException {
        this.m_session.setPromptFlag(bl);
    }

    public void write(String string, boolean bl) throws RemoteException {
        boolean bl2;
        boolean bl3 = bl2 = SplusEclipseSessionImpl.getClientObjectFactory() == null;
        if (bl2) {
            if (this.m_storedEngineOutput == null) {
                this.m_storedEngineOutput = new Vector();
            }
            this.m_storedEngineOutput.add(string);
        } else {
            this.flushOutput();
        }
        this.invokeClientCall("com.insightful.splus.eclipse.connection.ConsoleOutputHandler", "staticWrite", new Class[]{String.class, Boolean.TYPE}, new Object[]{string, new Boolean(bl)});
    }

    private void flushOutput() throws RemoteException {
        boolean bl;
        boolean bl2 = bl = SplusEclipseSessionImpl.getClientObjectFactory() == null;
        if (!bl && this.m_storedEngineOutput != null) {
            for (int i = 0; i < this.m_storedEngineOutput.size(); ++i) {
                this.invokeClientCall("com.insightful.splus.eclipse.connection.ConsoleOutputHandler", "staticWrite", new Class[]{String.class, Boolean.TYPE}, new Object[]{this.m_storedEngineOutput.get(i).toString(), new Boolean(false)});
            }
            this.m_storedEngineOutput = null;
        }
    }

    private void doSessionListenerCall(String string, Object object) {
        String string2 = "com.insightful.splus.eclipse.connection.DefaultConnection";
        try {
            this.invokeClientCall(string2, string, new Class[]{object.getClass()}, new Object[]{object});
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    private void doDebugListenerCall(String string, Object object) {
        this.doDebugListenerCall(string, new Class[]{SplusDebugHandlerInterface.class}, new Object[]{object});
    }

    private void doDebugListenerCall(String string, Class[] classArray, Object[] objectArray) {
        try {
            String string2 = "com.insightful.splus.eclipse.debug.core.model.SplusDebugManager";
            this.invokeClientCall(string2, string, classArray, objectArray);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }

    public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) throws RemoteException {
        this.doSessionListenerCall("staticEventOccurred", splusWinSessionEvent);
    }

    public void breakpointHit(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.doDebugListenerCall("breakpointHit", splusDebugHandlerInterface);
    }

    public void callStackRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.doDebugListenerCall("callStackRetrieved", splusDebugHandlerInterface);
    }

    public void evalInfoRetrieved(String string, SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.doDebugListenerCall("evalInfoRetrieved", new Class[]{String.class, SplusDebugHandlerInterface.class}, new Object[]{string, splusDebugHandlerInterface});
    }

    public void objectsRetrieved(SplusDebugHandlerInterface splusDebugHandlerInterface) {
        this.doDebugListenerCall("objectsRetrieved", splusDebugHandlerInterface);
    }

    private void invokeClientCall(String string, String string2, Class[] classArray, Object[] objectArray) throws RemoteException {
        if (SplusEclipseSessionImpl.getClientObjectFactory() == null) {
            return;
        }
        ClientUtilities clientUtilities = SplusEclipseSessionImpl.getClientObjectFactory().getClientUtilities();
        if (clientUtilities != null) {
            try {
                clientUtilities.invokeStaticMethod(string, string2, classArray, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void start() throws RemoteException {
        this.m_session.start();
    }

    public void addSplusDebugListener(SplusDebugListener splusDebugListener) throws RemoteException {
        this.addSplusDebugListener(splusDebugListener.getClass().toString());
    }

    public void addSplusDebugListener(String string) throws RemoteException {
        this.m_debugListenerClasses.add(string);
    }

    public void removeSplusDebugListener(SplusDebugListener splusDebugListener) throws RemoteException {
        this.removeSplusDebugListener(splusDebugListener.getClass().toString());
    }

    public void removeSplusDebugListener(String string) throws RemoteException {
        this.m_debugListenerClasses.remove(string);
    }

    public void addBreakpoint(String string, String string2, long[] lArray) throws RemoteException {
        this.m_session.addBreakpoint(string, string2, lArray);
    }

    public void doCallStack(long l) throws RemoteException {
        this.m_session.doCallStack(l);
    }

    public void doEvaluate(long l, String string) throws RemoteException {
        this.m_session.doEvaluate(l, string);
    }

    public void doFrameDown(long l) throws RemoteException {
        this.m_session.doFrameDown(l);
    }

    public void doFrameUp(long l) throws RemoteException {
        this.m_session.doFrameUp(l);
    }

    public void doInvisibleEvaluate(long l, String string) throws RemoteException {
        this.m_session.doInvisibleEvaluate(l, string);
    }

    public void doObjects(long l) throws RemoteException {
        this.m_session.doObjects(l);
    }

    public boolean doParse(String string) throws RemoteException {
        return this.m_session.doParse(string);
    }

    public void doPause(long l) throws RemoteException {
        this.m_session.doPause(l);
    }

    public void doResume(long l) throws RemoteException {
        this.m_session.doResume(l);
    }

    public void doSetCommandLine(boolean bl) throws RemoteException {
        this.m_session.doSetCommandLine(bl);
    }

    public long doStart(String string) throws RemoteException {
        return this.m_session.doStart(string);
    }

    public void doStep(long l) throws RemoteException {
        this.m_session.doStep(l);
    }

    public void doStepIn(long l) throws RemoteException {
        this.m_session.doStepIn(l);
    }

    public void doStepOut(long l) throws RemoteException {
        this.m_session.doStepOut(l);
    }

    public void doStop(long l) throws RemoteException {
        this.m_session.doStop(l);
    }

    public long[] getBreakAddress() throws RemoteException {
        return this.m_session.getBreakAddress();
    }

    public String getBreakInfo() throws RemoteException {
        return this.m_session.getBreakInfo();
    }

    public String getCall(int n) throws RemoteException {
        return this.m_session.getCall(n);
    }

    public String getCallName(int n) throws RemoteException {
        return this.m_session.getCallName(n);
    }

    public String getContainerCallName(int n) throws RemoteException {
        return this.m_session.getContainerCallName(n);
    }

    public String getEval(String string, int n) throws RemoteException {
        return this.m_session.getEval(string, n);
    }

    public int getNumCalls() throws RemoteException {
        return this.m_session.getNumCalls();
    }

    public int getNumEvals(String string) throws RemoteException {
        return this.m_session.getNumEvals(string);
    }

    public int getNumObjects() throws RemoteException {
        return this.m_session.getNumObjects();
    }

    public String[] getObjectData(int n) throws RemoteException {
        return this.m_session.getObjectData(n);
    }

    public String getObjectName(int n) throws RemoteException {
        return this.m_session.getObjectName(n);
    }

    public void removeBreakpoint(String string, String string2, long[] lArray) throws RemoteException {
        this.m_session.removeBreakpoint(string, string2, lArray);
    }

    public void setDebugMode(boolean bl) throws RemoteException {
        this.m_session.setDebugMode(bl);
    }

    public void setErrorBreakpoint(boolean bl) throws RemoteException {
        this.m_session.setErrorBreakpoint(bl);
    }

    public void setWarningBreakpoint(boolean bl) throws RemoteException {
        this.m_session.setWarningBreakpoint(bl);
    }

    public String getConnectionVersion() throws RemoteException {
        return this.m_session.getConnectionVersion();
    }

    public void rebind(String string, int n) throws RemoteException {
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            Naming.rebind(SplusRemoteEclipseSessionImpl.getRmiString(string2, n, string), this);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SplusRemoteEclipseSessionImpl.createRmiRegistry();
        try {
            System.setProperty("splus.interactive.commandline", "T");
            SplusRemoteEclipseSessionImpl splusRemoteEclipseSessionImpl = new SplusRemoteEclipseSessionImpl(stringArray);
            String string = SplusRemoteEclipseSessionImpl.getRmiString(InetAddress.getLocalHost().getHostName(), Integer.parseInt(System.getProperty("splus.server.rmiport")));
            try {
                Naming.unbind(string);
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            Naming.rebind(string, splusRemoteEclipseSessionImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getRmiSessionId() {
        return "SplusRemoteEclipseSession";
    }

    public static String getRmiString(String string, int n) {
        return SplusRemoteEclipseSessionImpl.getRmiString(string, n, SplusRemoteEclipseSessionImpl.getRmiSessionId());
    }

    public static String getRmiString(String string, int n, String string2) {
        return "rmi://" + string + ":" + n + "/" + string2;
    }

    public static void createRmiRegistry() {
        try {
            int n = Integer.parseInt(System.getProperty("splus.server.rmiport", "1099"));
            LocateRegistry.createRegistry(n);
        }
        catch (ExportException exportException) {
            exportException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }
}

