/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.record;

import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusControlMetrics;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.record.UserInputPlayer;
import com.insightful.splus.record.UserInputRecorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class UserInputRecordingDialog
extends JDialog {
    Frame parent;
    JPanel centerPanel;
    JPanel buttonPanel;
    JButton closeButton;
    LocalButtonListener buttonListener;
    JDialog thisDialog = this;
    SplusGroupPanel recordGroup;
    SplusGroupPanel playGroup;
    SplusButton recordStartButton;
    SplusButton recordStopButton;
    SplusButton recordSaveButton;
    SplusButton playLoadButton;
    SplusButton playStartButton;
    SplusButton playStopButton;
    File recordFile;
    File playFile;
    UserInputPlayer player;
    UserInputRecorder recorder;

    public UserInputRecordingDialog(Frame frame) {
        super(frame, "User Input Recording");
        this.parent = frame;
        this.setDefaultCloseOperation(2);
        this.buttonListener = new LocalButtonListener();
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 0));
        this.recordGroup = new SplusGroupPanel("Record");
        this.centerPanel.add(this.recordGroup);
        this.recordStartButton = new SplusButton("Start", 'S');
        this.recordStartButton.addActionListener(this.buttonListener);
        this.recordStopButton = new SplusButton("Stop", 'T');
        this.recordStopButton.addActionListener(this.buttonListener);
        this.recordStopButton.setEnabled(false);
        this.recordSaveButton = new SplusButton("Save", 'A');
        this.recordSaveButton.addActionListener(this.buttonListener);
        this.recordSaveButton.setEnabled(false);
        this.recordGroup.add(this.recordStartButton);
        this.recordGroup.add(this.recordStopButton);
        this.recordGroup.add(this.recordSaveButton);
        this.playGroup = new SplusGroupPanel("Play");
        this.centerPanel.add(Box.createHorizontalStrut(SplusControlMetrics.getLabelDimension().width));
        this.playLoadButton = new SplusButton("Load", 'L');
        this.playLoadButton.addActionListener(this.buttonListener);
        this.playStartButton = new SplusButton("Start", 'R');
        this.playStartButton.addActionListener(this.buttonListener);
        this.playStartButton.setEnabled(false);
        this.playStopButton = new SplusButton("Stop", 'O');
        this.playStopButton.addActionListener(this.buttonListener);
        this.playStopButton.setEnabled(false);
        this.playGroup.add(this.playLoadButton);
        this.playGroup.add(this.playStartButton);
        this.playGroup.add(this.playStopButton);
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this.buttonListener);
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public static void showNewDialog() {
        UserInputRecordingDialog userInputRecordingDialog = new UserInputRecordingDialog(SplusSystem.getDefaultFrame());
        userInputRecordingDialog.show();
    }

    public static void main(String[] stringArray) {
        UserInputRecordingDialog.showNewDialog();
    }

    private void disableButtons(JButton[] jButtonArray) {
        if (jButtonArray != null) {
            for (int i = 0; i < jButtonArray.length; ++i) {
                jButtonArray[i].setEnabled(false);
            }
        }
    }

    private void enableButtons(JButton[] jButtonArray) {
        if (jButtonArray != null) {
            for (int i = 0; i < jButtonArray.length; ++i) {
                jButtonArray[i].setEnabled(true);
            }
        }
    }

    private class LocalButtonListener
    implements ActionListener {
        private LocalButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == UserInputRecordingDialog.this.closeButton) {
                UserInputRecordingDialog.this.dispose();
            } else if (jButton == UserInputRecordingDialog.this.recordStartButton) {
                UserInputRecordingDialog.this.recorder = new UserInputRecorder(UserInputRecordingDialog.this.parent);
                UserInputRecordingDialog.this.recorder.start();
                UserInputRecordingDialog.this.recordStopButton.setEnabled(true);
                UserInputRecordingDialog.this.disableButtons(new JButton[]{UserInputRecordingDialog.this.recordStartButton, UserInputRecordingDialog.this.recordSaveButton, UserInputRecordingDialog.this.playStartButton, UserInputRecordingDialog.this.playStopButton, UserInputRecordingDialog.this.playLoadButton});
            } else if (jButton == UserInputRecordingDialog.this.recordStopButton) {
                if (UserInputRecordingDialog.this.recorder != null) {
                    UserInputRecordingDialog.this.recorder.stop();
                }
                UserInputRecordingDialog.this.recordStopButton.setEnabled(false);
                UserInputRecordingDialog.this.enableButtons(new JButton[]{UserInputRecordingDialog.this.recordStartButton, UserInputRecordingDialog.this.recordSaveButton, UserInputRecordingDialog.this.playLoadButton});
                if (UserInputRecordingDialog.this.player != null) {
                    UserInputRecordingDialog.this.playStartButton.setEnabled(true);
                }
            } else if (jButton == UserInputRecordingDialog.this.recordSaveButton) {
                if (UserInputRecordingDialog.this.recorder == null) {
                    JOptionPane.showMessageDialog(UserInputRecordingDialog.this.thisDialog, "No recording has been made.  Cannot save.", "Save Error", 0);
                } else {
                    JFileChooser jFileChooser = new JFileChooser(UserInputRecordingDialog.this.recordFile, SplusSystem.getServerFileHandler().getServerFileSystemView());
                    jFileChooser.setDialogType(1);
                    if (jFileChooser.showSaveDialog(UserInputRecordingDialog.this.thisDialog) == 0) {
                        UserInputRecordingDialog.this.recordFile = jFileChooser.getSelectedFile();
                        try {
                            UserInputRecordingDialog.this.recorder.save(ServerFile.convertServerFilePath(UserInputRecordingDialog.this.recordFile.getAbsolutePath()));
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(UserInputRecordingDialog.this.thisDialog, "Error saving file:\n" + exception.toString(), "Save Error", 0);
                        }
                    }
                }
            } else if (jButton == UserInputRecordingDialog.this.playStartButton) {
                if (UserInputRecordingDialog.this.player == null) {
                    UserInputRecordingDialog.this.playLoadButton.doClick();
                } else {
                    UserInputRecordingDialog.this.playStopButton.setEnabled(true);
                    UserInputRecordingDialog.this.disableButtons(new JButton[]{UserInputRecordingDialog.this.recordStartButton, UserInputRecordingDialog.this.recordStopButton, UserInputRecordingDialog.this.recordSaveButton, UserInputRecordingDialog.this.playStartButton, UserInputRecordingDialog.this.playLoadButton});
                    UserInputRecordingDialog.this.player.start();
                }
            } else if (jButton == UserInputRecordingDialog.this.playStopButton) {
                if (UserInputRecordingDialog.this.player != null) {
                    UserInputRecordingDialog.this.player.stop();
                }
                UserInputRecordingDialog.this.playStopButton.setEnabled(false);
                UserInputRecordingDialog.this.enableButtons(new JButton[]{UserInputRecordingDialog.this.recordStartButton, UserInputRecordingDialog.this.playStartButton, UserInputRecordingDialog.this.playLoadButton});
                if (UserInputRecordingDialog.this.recorder != null) {
                    UserInputRecordingDialog.this.recordSaveButton.setEnabled(true);
                }
            } else if (jButton == UserInputRecordingDialog.this.playLoadButton) {
                JFileChooser jFileChooser = new JFileChooser(UserInputRecordingDialog.this.playFile, SplusSystem.getServerFileHandler().getServerFileSystemView());
                jFileChooser.setDialogType(0);
                if (jFileChooser.showOpenDialog(UserInputRecordingDialog.this.thisDialog) == 0) {
                    UserInputRecordingDialog.this.playFile = jFileChooser.getSelectedFile();
                    try {
                        UserInputRecordingDialog.this.player = new UserInputPlayer(UserInputRecordingDialog.this.parent, ServerFile.convertServerFilePath(UserInputRecordingDialog.this.playFile.getAbsolutePath()));
                        UserInputRecordingDialog.this.playStartButton.setEnabled(true);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(UserInputRecordingDialog.this.thisDialog, "Error loading file:\n" + exception.toString(), "Load Error", 0);
                    }
                }
            }
        }
    }
}

