/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibBandCombineOpImage
extends PointOpImage {
    private double[] cmat = new double[9];
    private double[] offset = new double[3];
    private boolean isOffsetNonZero = false;

    public MlibBandCombineOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[][] dArray) {
        super(renderedImage, tileCache, imageLayout, true);
        int n = dArray.length;
        if (this.getSampleModel().getNumBands() != n) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getDataType(), this.tileWidth, this.tileHeight, n);
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 8 - 3 * n2;
            int n4 = 0;
            while (n4 < 3) {
                this.cmat[n3--] = dArray[n2][n4];
                ++n4;
            }
            this.offset[2 - n2] = dArray[n2][3];
            if (this.offset[n2] != 0.0) {
                this.isOffsetNonZero = true;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])this.cmat, (double[])this.offset);
                    } else {
                        Image.ColorConvert1((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (double[])this.cmat);
                    }
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    if (this.isOffsetNonZero) {
                        Image.ColorConvert2_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.cmat, (double[])this.offset);
                    } else {
                        Image.ColorConvert1_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])this.cmat);
                    }
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(String.valueOf(string) + JaiI18N.getString("MlibUshort"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

