/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;

final class MeanOpImage
extends StatisticsOpImage {
    private double[] totalPixelValue;
    private int totalPixelCount;
    private PixelAccessor srcPA;
    private int srcPixelType;

    public MeanOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, int n5, int n6) {
        super(renderedImage, rOI, n, n2, n3, n4, n5, n6);
        this.srcPA = new PixelAccessor(renderedImage);
        this.srcPixelType = this.srcPA.pixelType == -1 ? 0 : this.srcPA.pixelType;
        this.totalPixelValue = new double[this.srcPA.numBands];
        this.totalPixelCount = 0;
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        LinkedList linkedList;
        Rectangle rectangle = this.source0.getBounds().intersection(raster.getBounds());
        if (this.roi == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = rectangle.intersection((Rectangle)listIterator.next());
            int n = rectangle2.x;
            int n2 = rectangle2.y;
            rectangle2.x = this.startPosition(n, this.xStart, this.xPeriod);
            rectangle2.y = this.startPosition(n2, this.yStart, this.yPeriod);
            rectangle2.width = n + rectangle2.width - rectangle2.x;
            rectangle2.height = n2 + rectangle2.height - rectangle2.y;
            if (rectangle2.isEmpty()) continue;
            UnpackedPixelData unpackedPixelData = this.srcPA.getData(raster, rectangle2, this.srcPixelType, false);
            switch (unpackedPixelData.dataType) {
                case 0: {
                    this.accumulateStatisticsByte(unpackedPixelData);
                    break;
                }
                case 1: {
                    this.accumulateStatisticsUShort(unpackedPixelData);
                    break;
                }
                case 2: {
                    this.accumulateStatisticsShort(unpackedPixelData);
                    break;
                }
                case 3: {
                    this.accumulateStatisticsInt(unpackedPixelData);
                    break;
                }
                case 4: {
                    this.accumulateStatisticsFloat(unpackedPixelData);
                    break;
                }
                case 5: {
                    this.accumulateStatisticsDouble(unpackedPixelData);
                    break;
                }
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        byte[][] byArray = unpackedPixelData.getByteData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            byte[] byArray2 = byArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + (double)(byArray2[n9] & 0xFF);
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsDouble(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        double[][] dArray = unpackedPixelData.getDoubleData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            double[] dArray2 = dArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + dArray2[n9];
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsFloat(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        float[][] fArray = unpackedPixelData.getFloatData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            float[] fArray2 = fArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + (double)fArray2[n9];
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsInt(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        int[][] nArray = unpackedPixelData.getIntData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            int[] nArray2 = nArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + (double)nArray2[n9];
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + (double)sArray2[n9];
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    private void accumulateStatisticsUShort(UnpackedPixelData unpackedPixelData) {
        Rectangle rectangle = unpackedPixelData.rect;
        short[][] sArray = unpackedPixelData.getShortData();
        int n = unpackedPixelData.lineStride;
        int n2 = unpackedPixelData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        int n5 = 0;
        while (n5 < this.srcPA.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = unpackedPixelData.offsets[n5] + rectangle.height * n;
            int n7 = unpackedPixelData.offsets[n5];
            while (n7 < n6) {
                int n8 = n7 + rectangle.width * n2;
                int n9 = n7;
                while (n9 < n8) {
                    int n10 = n5;
                    this.totalPixelValue[n10] = this.totalPixelValue[n10] + (double)(sArray2[n9] & 0xFFFF);
                    n9 += n4;
                }
                n7 += n3;
            }
            ++n5;
        }
        this.totalPixelCount += (int)Math.ceil((double)rectangle.height / (double)this.yPeriod) * (int)Math.ceil((double)rectangle.width / (double)this.xPeriod);
    }

    protected Object createStatistics(String string) {
        Object object = string.equalsIgnoreCase("mean") ? (Object)new double[this.srcPA.numBands] : Image.UndefinedProperty;
        return object;
    }

    public Object getProperty(String string) {
        Hashtable hashtable = this.getProperties();
        Object object = hashtable.get(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            MeanOpImage meanOpImage = this;
            synchronized (meanOpImage) {
                object = this.createStatistics(string);
                if (!object.equals(Image.UndefinedProperty)) {
                    int n = this.source0.getMinTileX();
                    int n2 = this.source0.getMaxTileX();
                    int n3 = this.source0.getMinTileY();
                    int n4 = this.source0.getMaxTileY();
                    int n5 = n3;
                    while (n5 <= n4) {
                        int n6 = n;
                        while (n6 <= n2) {
                            if (this.tileIntersectsROI(n6, n5)) {
                                this.accumulateStatistics(string, this.getTile(n6, n5), null);
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    double[] dArray = (double[])object;
                    if (this.totalPixelCount != 0) {
                        int n7 = 0;
                        while (n7 < this.srcPA.numBands) {
                            dArray[n7] = this.totalPixelValue[n7] / (double)this.totalPixelCount;
                            ++n7;
                        }
                    }
                }
                this.setProperty(string, object);
                this.properties.put(string, object);
            }
        }
        return object;
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"mean"};
        return stringArray;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        if (n4 == 0) {
            return n;
        }
        return n + (n3 - n4);
    }

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }
}

