/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.MeterDataset;

public class DefaultMeterDataset
extends AbstractDataset
implements MeterDataset {
    static final double DEFAULT_ADJ = 1.0;
    Number minCritical;
    Number maxCritical;
    Number minWarning;
    Number maxWarning;
    Number minNormal;
    Number maxNormal;
    Number min;
    Number max;
    Number value;

    public DefaultMeterDataset() {
        this(new Double(0.0), new Double(0.0), new Double(0.0));
    }

    public DefaultMeterDataset(Number number, Number number2, Number number3) {
        this(number, number2, number3, null, null, null, null, null, null);
    }

    public DefaultMeterDataset(Number number, Number number2, Number number3, Number number4, Number number5, Number number6, Number number7, Number number8, Number number9) {
        this.setRange(number, number2);
        this.setValue(number3);
        this.setCriticalRange(number4, number5);
        this.setWarningRange(number6, number7);
        this.setNormalRange(number8, number9);
    }

    public Number getMinimumCriticalValue() {
        return this.minCritical;
    }

    public Number getMaximumCriticalValue() {
        return this.maxCritical;
    }

    public Number getMinimumWarningValue() {
        return this.minWarning;
    }

    public Number getMaximumWarningValue() {
        return this.maxWarning;
    }

    public Number getMinimumNormalValue() {
        return this.minNormal;
    }

    public Number getMaximumNormalValue() {
        return this.maxNormal;
    }

    public Number getMinimumValue() {
        return this.min;
    }

    public Number getMaximumValue() {
        return this.max;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Value should not be null");
        }
        if (number.doubleValue() < this.min.doubleValue() || number.doubleValue() > this.max.doubleValue()) {
            throw new IllegalArgumentException("Value is out of range for min/max");
        }
        this.value = number;
        this.fireDatasetChanged();
    }

    public void setRange(Number number, Number number2) {
        if (number == null || number2 == null) {
            throw new IllegalArgumentException("Min/Max should not be null");
        }
        if (number.doubleValue() > number2.doubleValue()) {
            Number number3 = number;
            number = number2;
            number2 = number3;
        }
        if (number.doubleValue() == number2.doubleValue()) {
            number = new Double(this.value.doubleValue() - 1.0);
            number2 = new Double(this.value.doubleValue() + 1.0);
        }
        this.min = number;
        this.max = number2;
        this.fireDatasetChanged();
    }

    public void setNormalRange(Number number, Number number2) {
        this.minNormal = number;
        this.maxNormal = number2;
        this.fireDatasetChanged();
    }

    public void setWarningRange(Number number, Number number2) {
        this.minWarning = number;
        this.maxWarning = number2;
        this.fireDatasetChanged();
    }

    public void setCriticalRange(Number number, Number number2) {
        this.minCritical = number;
        this.maxCritical = number2;
        this.fireDatasetChanged();
    }
}

