/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.CollapsedNodeDialog;
import com.insightful.miner.WorksheetDocument;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class BaseNodePort
extends JGoPort {
    public static final Rectangle DEFAULT_RECTANGLE = new Rectangle(0, 0, 8, 8);
    private Cursor portCursor = new Cursor(1);
    private boolean m_singleLink = true;
    private Rectangle myHitTestRect = new Rectangle();

    public BaseNodePort() {
    }

    public BaseNodePort(boolean input, boolean singleLink, JGoArea parent) {
        super(DEFAULT_RECTANGLE);
        this.initialize(input, singleLink, parent);
    }

    public void initialize(boolean input, boolean singleLink, JGoArea parent) {
        this.m_singleLink = singleLink;
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        this.setVisible(true);
        this.setPen(JGoPen.darkGray);
        this.setBrush(JGoBrush.lightGray);
        if (input) {
            this.setStyle(singleLink ? 3 : 5);
            this.setValidSource(false);
            this.setValidDestination(true);
            this.setToSpot(8);
        } else {
            this.setStyle(3);
            this.setValidSource(true);
            this.setValidDestination(false);
            this.setFromSpot(4);
        }
        this.setTopLeft(parent.getLeft(), parent.getTop());
        parent.addObjectAtTail((JGoObject)this);
    }

    public void setBoundingRect(int x, int y, int width, int height) {
        super.setBoundingRect(x, y, width, height);
        this.myHitTestRect = new Rectangle(x, y - height / 2, 2 * width, 2 * height);
        if (this.isInput()) {
            this.myHitTestRect.x -= width;
        }
    }

    public boolean isPointInObj(Point pnt) {
        return this.myHitTestRect.contains(pnt.x, pnt.y);
    }

    public final boolean isCurrentlyLinkable() {
        return !this.isSingle() || this.hasNoLinks();
    }

    public final boolean isInput() {
        return this.isValidDestination();
    }

    public final boolean isOutput() {
        return this.isValidSource();
    }

    public final boolean isSingle() {
        return this.m_singleLink;
    }

    public boolean validLink(JGoPort to) {
        boolean thatIsInputValidLink;
        boolean noLinksCurrently;
        boolean differentParentNodes;
        if (!(to instanceof BaseNodePort)) {
            return false;
        }
        BaseNodePort that = to instanceof CollapsedNodeArea.CollapsedNodePort ? ((CollapsedNodeArea.CollapsedNodePort)to).getRepresentedPort() : (BaseNodePort)to;
        BaseNodePort this_one = this instanceof CollapsedNodeArea.CollapsedNodePort ? ((CollapsedNodeArea.CollapsedNodePort)this).getRepresentedPort() : this;
        BaseNodeArea thatArea = (BaseNodeArea)that.getParent();
        BaseNodeArea thisArea = (BaseNodeArea)this_one.getParent();
        CollapsedNodeArea.CollapsedNodePort cnaThat = null;
        WorksheetDocument doc = thatArea.getDoc();
        if (doc instanceof CollapsedNodeDialog.DummyDocument) {
            CollapsedNodeArea area = ((CollapsedNodeDialog.DummyDocument)doc).m_cna;
            Vector inputPorts = area.getInputPorts();
            for (int i = 0; i < inputPorts.size(); ++i) {
                CollapsedNodeArea.CollapsedNodePort cPort = (CollapsedNodeArea.CollapsedNodePort)((Object)inputPorts.get(i));
                BaseNodePort rPort = cPort.getRepresentedPort();
                if (rPort != to) continue;
                cnaThat = cPort;
                break;
            }
        }
        boolean bl = differentParentNodes = thisArea != thatArea;
        if (!differentParentNodes) {
            return false;
        }
        JGoListPosition pos = that.getFirstLinkPos();
        boolean bl2 = noLinksCurrently = pos == null;
        if (!noLinksCurrently) {
            noLinksCurrently = that.getLinkAtPos(pos).getFromPort().getParent() == null;
        } else if (cnaThat != null) {
            noLinksCurrently = cnaThat.getFirstLinkPos() == null;
        } else if (that != to) {
            Vector links = ((CollapsedNodeArea)to.getParent()).links;
            for (int link = 0; noLinksCurrently && link < links.size(); ++link) {
                JGoLink containedLink = (JGoLink)links.get(link);
                if (that != containedLink.getToPort() && that != containedLink.getFromPort()) continue;
                noLinksCurrently = false;
            }
        }
        boolean bl3 = thatIsInputValidLink = that.isInput() && (!that.isSingle() || noLinksCurrently) && this_one.isOutput();
        if (!thatIsInputValidLink) {
            return false;
        }
        if (this.alreadyLinked(to)) {
            return false;
        }
        boolean circular = true;
        if (thatArea instanceof ActivityNodeArea && thisArea instanceof ActivityNodeArea) {
            circular = ((ActivityNodeArea)thatArea).getNodeModel().isChild(((ActivityNodeArea)thisArea).getNodeModel());
        }
        return !circular;
    }

    public boolean alreadyLinked(JGoPort dst) {
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            if (link.getToPort() == dst) {
                return true;
            }
            pos = this.getNextLinkPos(pos);
        }
        return false;
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        BaseNodePort newobj = (BaseNodePort)super.copyObject(env);
        newobj.m_singleLink = this.m_singleLink;
        return newobj;
    }

    public String formatToolTip(boolean input, String label, int portNum) {
        String toolTip = label + ": ";
        String end = input ? "Input " : "Output ";
        end = end + Integer.toString(portNum);
        BaseNodeArea area = this.getNode();
        if (area instanceof ActivityNodeArea) {
            end = ((ActivityNodeArea)area).getNodeModel().getPortToolTip(input, portNum - 1);
        }
        return toolTip + end;
    }

    public String getToolTipText() {
        BaseNodeArea area = this.getNode();
        Vector portList = this.isInput() ? area.getInputPorts() : area.getOutputPorts();
        for (int i = 0; i < portList.size(); ++i) {
            if (this != portList.get(i)) continue;
            String defaultTip = this.formatToolTip(this.isInput(), area.getLabel().getText(), i + 1);
            return defaultTip;
        }
        return area.getLabel().getText();
    }

    public boolean doUncapturedMouseMove(int flags, Point dc, Point vc, JGoView view) {
        view.setCursor(this.portCursor);
        return true;
    }

    public BaseNodeArea getNode() {
        return (BaseNodeArea)this.getParent();
    }
}

