/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerClassificationTreeGUI;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.TreeDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Frame;
import java.util.Vector;

public class ClassificationTreeNodeModel
extends PredictableNodeModel
implements ColumnFilterGenerator {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{"copyInputColumns", "independent"}, props.getValue(new String[]{"copyInputColumns", "independent"}, "false"));
        props.set(new String[]{"copyInputColumns", "dependent"}, props.getValue(new String[]{"copyInputColumns", "dependent"}, "true"));
        props.set(new String[]{"copyInputColumns", "other"}, props.getValue(new String[]{"copyInputColumns", "other"}, "false"));
        props.set(new String[]{"newColumns", "probability"}, props.getValue(new String[]{"newColumns", "probability"}, "true"));
        props.set(new String[]{"newColumns", "classification"}, props.getValue(new String[]{"newColumns", "classification"}, "true"));
        props.set(new String[]{"newColumns", "agreement"}, props.getValue(new String[]{"newColumns", "agreement"}, "false"));
        props.set("tree.ensemble", props.getBoolean("tree.ensemble", false));
        props.set("rows.per.tree", props.getInt("rows.per.tree", 10000));
        props.set("max.rows", props.getInt("max.rows", 10000));
        props.set("useGlobal", false);
        if (props.getBoolean("tree.ensemble")) {
            props.set("rowsToChunk", props.getValue("rows.per.tree"));
        } else {
            props.set("rowsToChunk", props.getValue("max.rows"));
        }
    }

    public void showPropertiesDialog(boolean modality) {
        TreeDialog dialog = TreeDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, 1);
    }

    public boolean isPropertiesValid() {
        String role;
        int i;
        boolean indepValid = false;
        boolean depValid = false;
        XTProps props = this.getXTProps();
        Vector roleVec = props.getSubPropertyValues("columnRoles");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                Vector columns = props.getSubProperties("columnRoles");
                for (i = columns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)columns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i2 = 0; !(depValid && indepValid || i2 >= roleVec.size()); ++i2) {
            role = (String)roleVec.get(i2);
            if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) {
                depValid = true;
            }
            if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
            indepValid = true;
        }
        if (this.getState() != null && this.isInputValid()) {
            try {
                XTMetaData md = this.getInputMetaData(0);
                if (md != null) {
                    roleVec = md.getColumnRoles();
                    for (i = 0; !(depValid && indepValid || i >= roleVec.size()); ++i) {
                        role = (String)roleVec.get(i);
                        if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role) && md.isCategoricalColumn(i)) {
                            depValid = true;
                        }
                        if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
                        indepValid = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return indepValid && depValid;
    }

    public String[] getFilterColumnsToExclude() {
        String[] colNames = null;
        double[] importanceValues = null;
        try {
            XTMetaData md = this.getInputMetaData(0);
            TreeCollection treeCollection = new TreeCollection(this.getFittedModel(), md, this.getID(), this.getDocument().getWorksheetID());
            colNames = treeCollection.getIndependentColNames();
            importanceValues = treeCollection.getImportanceValues();
            return ColumnFilterTools.showDefaultFilterSpecificationDialog(colNames, importanceValues, MinerApp.getText("ColumnFilterSpecificationDialog_treeFiltering_statistic"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                XTMetaData md = this.getInputMetaData(0);
                TreeCollection treeCollection = new TreeCollection(xt, md, this.getID(), this.getDocument().getWorksheetID());
                MinerClassificationTreeGUI gui = new MinerClassificationTreeGUI(treeCollection, this.getLabelText());
                gui.setLocation(MinerApp.getNextWindowLocation());
                gui.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getModelOutputType() {
        return "classification";
    }

    public String getModelAlgorithm() {
        return "tree";
    }

    public String getDependentVariable() {
        XTMetaData md = null;
        try {
            md = this.getInputMetaData(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return PredictEngineNode.getFirstDependentVar(this.getXTProps(), md, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
    }
}

