/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.CreateColumnsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CreateColumnsDialog
extends NodeDialog {
    private NodeDialog.DialogTable table;
    private CCTableModel tableModel;
    private JButton createColumnButton;
    private JButton removeColumnButton;
    private JComboBox globalTypeComboBox;
    private JTextField stringSizeTextField;
    private NodeDialog.ExistingColumnInformationPanel existVarPanel;
    private static final int nameColumn = 0;
    private static final int typeColumn = 1;
    private static final int expressionColumn = 2;
    private static final String[] dataTypes = new String[]{XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG};
    private AbstractAction createColumnAction;
    private AbstractAction removeColumnAction;
    private static CreateColumnsDialog instance = null;

    public static CreateColumnsDialog getInstance() {
        if (instance == null) {
            instance = new CreateColumnsDialog();
        }
        return instance;
    }

    protected CreateColumnsDialog() {
        Dimension min = new Dimension(525, 600);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.tableModel.clearTable();
        XTProps props = this.getNodeModel().getXTProps();
        String[] propertyString = new String[]{CreateColumnsEngineNode.NEW_COLUMNS_ATTRIBUTE_TAG, "", ""};
        Vector names = props.getSubProperties(CreateColumnsEngineNode.NEW_COLUMNS_ATTRIBUTE_TAG);
        for (int i = 0; i < names.size(); ++i) {
            String name;
            propertyString[1] = name = (String)names.get(i);
            propertyString[2] = CreateColumnsEngineNode.TYPE_ATTRIBUTE_TAG;
            String type = props.getValue(propertyString);
            propertyString[2] = CreateColumnsEngineNode.EXPRESSION_ATTRIBUTE_TAG;
            String expression = props.getValue(propertyString);
            this.tableModel.addRow(new Object[]{name, type, expression});
        }
        if (this.tableModel.getRowCount() > 0) {
            this.removeColumnButton.setEnabled(true);
        }
        int size = props.getInt(CreateColumnsEngineNode.STRING_SIZE_ATTRIBUTE_TAG, -1);
        this.stringSizeTextField.setText(ModifyColumnsPanel.stringSizeIntToUserString(size));
        propertyString = null;
        try {
            this.existVarPanel.restoreProperties(this.getNodeModel().getInputMetaData(0));
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.saveProperties();
        Vector<String> inputNames = new Vector<String>();
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String name = (String)this.table.getValueAt(i, 0);
            String expression = (String)this.table.getValueAt(i, 2);
            if (name == null || name.equals("")) {
                throw new NodeDialog.DialogException(MinerApp.getText("CreateColumnsDialog_nameFieldError"));
            }
            if (expression == null || expression.equals("")) {
                throw new NodeDialog.DialogException(MinerApp.getText("CreateColumnsDialog_columnExpressionFieldError"));
            }
            int inputNameSize = inputNames.size();
            for (int j = 0; j < inputNameSize; ++j) {
                if (!inputNames.get(j).equals(name)) continue;
                throw new NodeDialog.DialogException(MinerApp.getText("CreateColumnsDialog_uniqueNameError"));
            }
            inputNames.add(name);
        }
        XTProps props = this.getNodeModel().getXTProps();
        this.updatePropertiesFromTable(props);
    }

    private void updatePropertiesFromTable(XTProps props) {
        props.removeProperty(new String[]{CreateColumnsEngineNode.NEW_COLUMNS_ATTRIBUTE_TAG});
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        String[] propertyString = new String[]{CreateColumnsEngineNode.NEW_COLUMNS_ATTRIBUTE_TAG, "", ""};
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String name = (String)this.table.getValueAt(i, 0);
            String type = (String)this.table.getValueAt(i, 1);
            String expression = (String)this.table.getValueAt(i, 2);
            propertyString[1] = name;
            propertyString[2] = CreateColumnsEngineNode.TYPE_ATTRIBUTE_TAG;
            props.set(propertyString, type);
            propertyString[2] = CreateColumnsEngineNode.EXPRESSION_ATTRIBUTE_TAG;
            props.set(propertyString, expression);
        }
        String sizeString = this.stringSizeTextField.getText();
        int sizeInt = ModifyColumnsPanel.userStringToStringSizeInt(this, sizeString);
        props.set(CreateColumnsEngineNode.STRING_SIZE_ATTRIBUTE_TAG, sizeInt < 0 ? "" : Integer.toString(sizeInt));
        propertyString = null;
    }

    private void tryParsingExpressions() {
        String parseErrors = "";
        try {
            XTProps props = (XTProps)this.getNodeModel().getXTProps().clone();
            this.updatePropertiesFromTable(props);
            this.getNodeModel().saveGuiNetworkToEngine();
            parseErrors = (String)this.getNodeModel().sendMessageToEngine("getParseErrors", new Object[]{props});
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (parseErrors == null || parseErrors.equals("")) {
            parseErrors = "No parsing errors found.";
        }
        JTextArea errorText = new JTextArea(8, 30);
        errorText.setText(parseErrors);
        errorText.setEditable(false);
        errorText.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane errorScrollPane = new JScrollPane(errorText);
        errorScrollPane.getViewport().setPreferredSize(errorText.getPreferredSize());
        AcceleratorOptionPane.showOKDialog(this.tabbedPane, errorScrollPane, MinerApp.getText("CreateColumnsDialog_message_parsingErrors"), 1);
    }

    public void createActions() {
        super.createActions();
        this.createColumnAction = new AbstractAction(MinerApp.getText("CreateColumnsDialog_add")){

            public void actionPerformed(ActionEvent e) {
                if (CreateColumnsDialog.this.table.isEditing()) {
                    CreateColumnsDialog.this.table.getCellEditor().stopCellEditing();
                }
                CreateColumnsDialog.this.tableModel.addRow(new Object[]{"", CreateColumnsDialog.this.globalTypeComboBox.getSelectedItem(), ""});
                if (CreateColumnsDialog.this.tableModel.getRowCount() > 0) {
                    CreateColumnsDialog.this.removeColumnButton.setEnabled(true);
                }
            }
        };
        this.removeColumnAction = new AbstractAction(MinerApp.getText("CreateColumnsDialog_remove")){

            public void actionPerformed(ActionEvent e) {
                if (CreateColumnsDialog.this.table.isEditing()) {
                    CreateColumnsDialog.this.table.getCellEditor().stopCellEditing();
                }
                int[] rows = CreateColumnsDialog.this.table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    CreateColumnsDialog.this.tableModel.removeRow(rows[i]);
                }
                if (CreateColumnsDialog.this.table.getRowCount() < 1) {
                    CreateColumnsDialog.this.removeColumnButton.setEnabled(false);
                }
                rows = null;
            }
        };
    }

    public NodeDialog.ExistingColumnInformationPanel createExistingColumnInformationPanel() {
        return new NodeDialog.ExistingColumnInformationPanel(false, 400, 100);
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("CreateColumnsDialog_createNewColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Dimension buttonSize = new Dimension(100, 21);
        this.createColumnButton = new JButton(this.createColumnAction);
        this.createColumnButton.setMnemonic(MinerApp.getText("CreateColumnsDialog_createColumnHotkey").charAt(0));
        this.createColumnButton.setPreferredSize(buttonSize);
        this.createColumnButton.setMinimumSize(buttonSize);
        String typeString = MinerApp.getText("CreateColumnsDialog_selectType");
        JLabel typeLabel = new JLabel(typeString);
        this.globalTypeComboBox = new JComboBox<String>(dataTypes);
        this.globalTypeComboBox.setMinimumSize(buttonSize);
        this.globalTypeComboBox.setPreferredSize(buttonSize);
        typeLabel.setLabelFor(this.globalTypeComboBox);
        typeLabel.setDisplayedMnemonic(MinerApp.getText("CreateColumnsDialog_typeHotkey").charAt(0));
        this.tableModel = new CCTableModel();
        this.tableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("NodeDialog_name"), MinerApp.getText("NodeDialog_type"), MinerApp.getText("CreateColumnsDialog_columnCreationExpression")});
        this.table = new NodeDialog.DialogTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setRowHeight(25);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        JComboBox<String> typeComboBox = new JComboBox<String>(dataTypes);
        int columnCount = this.tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumn(this.table.getColumnName(i));
            column.setCellRenderer(new NodeDialog.LeftJustifiedStringRenderer());
            if (i == 0) {
                column.setPreferredWidth(100);
                continue;
            }
            if (i == 1) {
                column.setCellEditor(new DefaultCellEditor(typeComboBox));
                column.setPreferredWidth(100);
                continue;
            }
            column.setPreferredWidth(285);
        }
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        this.existVarPanel = this.createExistingColumnInformationPanel();
        this.removeColumnButton = new JButton(this.removeColumnAction);
        this.removeColumnButton.setPreferredSize(buttonSize);
        this.removeColumnButton.setMinimumSize(buttonSize);
        this.removeColumnButton.setMnemonic(MinerApp.getText("CreateColumnsDialog_removeColumnHotkey").charAt(0));
        this.removeColumnButton.setEnabled(false);
        JLabel stringSizeLabel = new JLabel(MinerApp.getText("CreateColumnsDialog_stringSize"));
        this.stringSizeTextField = new JTextField(8);
        this.stringSizeTextField.setDocument(new NodeDialog.InputIntegerDoc());
        stringSizeLabel.setDisplayedMnemonic(MinerApp.getText("CreateColumnsDialog_stringSizeHotkey").charAt(0));
        stringSizeLabel.setLabelFor(this.stringSizeTextField);
        JButton parseButton = new JButton(new AbstractAction("Parse Expressions"){

            public void actionPerformed(ActionEvent e) {
                CreateColumnsDialog.this.tryParsingExpressions();
            }
        });
        parseButton.setMnemonic('P');
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(this.createColumnButton);
        topPanel.add(Box.createGlue());
        topPanel.add(typeLabel);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.globalTypeComboBox);
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        optionsPanel.add((Component)topPanel, constraints);
        int gridy = 1;
        constraints.gridy = gridy++;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        constraints.insets = new Insets(10, 0, 10, 0);
        constraints.fill = 1;
        optionsPanel.add((Component)scrollingTable, constraints);
        JPanel midPanel = new JPanel();
        midPanel.setLayout(new BorderLayout());
        midPanel.add((Component)this.removeColumnButton, "West");
        JPanel middle = new JPanel();
        middle.setLayout(new BoxLayout(middle, 0));
        middle.add(Box.createGlue());
        middle.add(parseButton);
        middle.add(Box.createGlue());
        middle.add(stringSizeLabel);
        middle.add(Box.createHorizontalStrut(5));
        midPanel.add((Component)middle, "Center");
        midPanel.add((Component)this.stringSizeTextField, "East");
        constraints.gridy = gridy++;
        constraints.insets = new Insets(5, 0, 15, 0);
        constraints.gridwidth = 0;
        constraints.fill = 2;
        optionsPanel.add((Component)midPanel, constraints);
        constraints.gridy = gridy++;
        constraints.weightx = 1.0;
        constraints.weighty = 2.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.gridheight = 0;
        optionsPanel.add((Component)this.existVarPanel, constraints);
        return optionsPanel;
    }

    private class CCTableModel
    extends DefaultTableModel {
        private CCTableModel() {
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }
}

