/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.miner.XTMetaData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class DataCacheRowBuf {
    protected static final byte[] headerString = new byte[]{66, 76, 66, 0};
    protected static final byte[] trailerString = new byte[]{69, 76, 66, 0};
    private int m_numColumns;
    private int[] m_columnOffsets;
    private int[] m_columnWidths;
    private byte[] m_columnTypes;
    private int m_bytesPerRow;
    private byte[] m_rowBytes = null;
    private int m_rowBytesOffset = 0;
    private static final byte FACTOR_TYPE = 0;
    private static final byte STRING_TYPE = 1;
    private static final byte DOUBLE_TYPE = 2;
    private static final byte TIMEDATE_TYPE = 3;
    private static final byte BLOB_TYPE = 4;
    private RandomAccessFile m_readBlobFile = null;
    private OutputStream m_writeBlobFile = null;
    private long m_writeBlobFileOffset = 0L;
    private boolean m_containsBlobs = false;
    private byte[] m_copyBlobCache = null;

    private DataCacheRowBuf() {
    }

    public DataCacheRowBuf(XTMetaData md, boolean allocateData) {
        this.m_numColumns = md.getNumColumns();
        this.m_columnOffsets = new int[this.m_numColumns];
        this.m_columnWidths = new int[this.m_numColumns];
        this.m_columnTypes = new byte[this.m_numColumns];
        this.m_bytesPerRow = DataCacheRowBuf.calcColumnInfoFromMetaData(md, null, this.m_columnOffsets, this.m_columnWidths, this.m_columnTypes);
        this.m_containsBlobs = false;
        for (int i = 0; i < this.m_numColumns; ++i) {
            if (this.m_columnTypes[i] != 4) continue;
            this.m_containsBlobs = true;
            break;
        }
        this.m_rowBytes = null;
        this.m_rowBytesOffset = 0;
        if (allocateData) {
            this.allocateData();
        }
    }

    public DataCacheRowBuf(XTMetaData md) {
        this(md, true);
    }

    private static int calcColumnInfoFromMetaData(XTMetaData md, int[] columnNums, int[] columnOffsets, int[] columnWidths, byte[] columnTypes) {
        int numColumns = columnNums != null ? columnNums.length : md.getNumColumns();
        int bytesPerRow = 0;
        for (int i = 0; i < numColumns; ++i) {
            int columnWidth;
            int columnType;
            int columnNum = columnNums != null ? columnNums[i] : i;
            int columnOffset = bytesPerRow;
            if (md.isCategoricalColumn(columnNum)) {
                columnType = 0;
                columnWidth = 2;
            } else if (md.isStringColumn(columnNum)) {
                columnType = 1;
                columnWidth = md.getStringDataFieldWidth(columnNum);
                if (columnWidth < 4) {
                    columnWidth = 4;
                }
            } else if (md.isDateTimeColumn(columnNum)) {
                columnType = 3;
                columnWidth = 8;
            } else if (md.isBlobColumn(columnNum)) {
                columnType = 4;
                columnWidth = 16;
            } else {
                columnType = 2;
                columnWidth = 8;
            }
            if (columnOffsets != null) {
                columnOffsets[i] = columnOffset;
            }
            if (columnTypes != null) {
                columnTypes[i] = columnType;
            }
            if (columnWidths != null) {
                columnWidths[i] = columnWidth;
            }
            bytesPerRow += columnWidth;
        }
        return bytesPerRow;
    }

    public static int getDCFBytesPerRow(XTMetaData md) {
        return DataCacheRowBuf.calcColumnInfoFromMetaData(md, null, null, null, null);
    }

    public static int getDCFBytesPerRow(XTMetaData md, int[] columnNums) {
        return DataCacheRowBuf.calcColumnInfoFromMetaData(md, columnNums, null, null, null);
    }

    public static long getDCFFileBytes(XTMetaData md) {
        int bytesPerRow = DataCacheRowBuf.getDCFBytesPerRow(md);
        long numRows = md.getNumRows();
        return numRows * (long)bytesPerRow;
    }

    public DataCacheRowBuf copy(boolean allocateData) {
        DataCacheRowBuf buf = new DataCacheRowBuf();
        buf.m_numColumns = this.m_numColumns;
        buf.m_columnOffsets = this.m_columnOffsets;
        buf.m_columnWidths = this.m_columnWidths;
        buf.m_columnTypes = this.m_columnTypes;
        buf.m_bytesPerRow = this.m_bytesPerRow;
        buf.m_rowBytes = null;
        buf.m_rowBytesOffset = 0;
        if (allocateData) {
            buf.allocateData();
        }
        return buf;
    }

    public DataCacheRowBuf copy() {
        return this.copy(true);
    }

    public void allocateData() {
        this.m_rowBytes = new byte[this.m_bytesPerRow];
        this.m_rowBytesOffset = 0;
    }

    public void setData(byte[] data, int offset) {
        this.m_rowBytes = data;
        this.m_rowBytesOffset = offset;
    }

    public int getNumColumns() {
        return this.m_numColumns;
    }

    public void setDouble(int colNum, double val) {
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                int offset = this.getColumnOffset(colNum);
                long longVersion = Double.doubleToLongBits(val);
                for (int i = 7; i >= 0; --i) {
                    this.m_rowBytes[offset + i] = (byte)(longVersion & 0xFFL);
                    longVersion >>= 8;
                }
                break;
            }
            case 0: {
                this.setLevelNum(colNum, CNKObj.convertDoubleToLevelNum(val));
            }
        }
    }

    public void setLevelNum(int colNum, int val) {
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                this.setDouble(colNum, CNKObj.convertLevelNumToDouble(val));
                break;
            }
            case 0: {
                int offset = this.getColumnOffset(colNum);
                if (CNKObj.isLevelNumNA(val)) {
                    val = 65535;
                }
                this.m_rowBytes[offset] = (byte)(val >> 8 & 0xFF);
                this.m_rowBytes[offset + 1] = (byte)(val & 0xFF);
            }
        }
    }

    public void setString(int colNum, String val) {
        switch (this.m_columnTypes[colNum]) {
            case 1: {
                try {
                    if (val == null) {
                        val = CNKObj.getStringNA();
                    }
                    byte[] stringBytes = val.getBytes("UTF-8");
                    int offset = this.getColumnOffset(colNum);
                    int bytesToCopy = stringBytes.length;
                    int width = this.m_columnWidths[colNum];
                    if (bytesToCopy >= width) {
                        bytesToCopy = width - 1;
                    }
                    System.arraycopy(stringBytes, 0, this.m_rowBytes, offset, bytesToCopy);
                    for (int i = bytesToCopy; i < width; ++i) {
                        this.m_rowBytes[offset + i] = 0;
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setTimeDate(int colNum, long val) {
        switch (this.m_columnTypes[colNum]) {
            case 3: {
                try {
                    int offset = this.getColumnOffset(colNum);
                    long longVersion = val;
                    for (int i = 7; i >= 0; --i) {
                        this.m_rowBytes[offset + i] = (byte)(longVersion & 0xFFL);
                        longVersion >>= 8;
                    }
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void setBlobOffsetLength(int colNum, long blobOffset, long blobLength) {
        switch (this.m_columnTypes[colNum]) {
            case 4: {
                try {
                    int offset = this.getColumnOffset(colNum);
                    long longBlobOffset = blobOffset;
                    long longBlobLength = blobLength;
                    for (int i = 7; i >= 0; --i) {
                        this.m_rowBytes[offset + i] = (byte)(longBlobOffset & 0xFFL);
                        longBlobOffset >>= 8;
                        this.m_rowBytes[offset + i + 8] = (byte)(longBlobLength & 0xFFL);
                        longBlobLength >>= 8;
                    }
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void setNA(int colNum) {
        switch (this.m_columnTypes[colNum]) {
            case 1: {
                this.setString(colNum, null);
                break;
            }
            case 2: {
                this.setDouble(colNum, CNKObj.getDoubleNA());
                break;
            }
            case 0: {
                this.setLevelNum(colNum, CNKObj.getLevelNumNA());
                break;
            }
            case 3: {
                this.setTimeDate(colNum, CNKObj.getTimeDateNA());
                break;
            }
            case 4: {
                this.setBlobOffsetLength(colNum, -1L, -1L);
            }
        }
    }

    public double getDouble(int colNum) {
        double val = 0.0;
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                int offset = this.getColumnOffset(colNum);
                long bytesAsLong = 0L;
                for (int i = 0; i < 8; ++i) {
                    bytesAsLong <<= 8;
                    bytesAsLong += (long)this.m_rowBytes[offset + i] & 0xFFL;
                }
                val = Double.longBitsToDouble(bytesAsLong);
                break;
            }
            case 0: {
                val = CNKObj.convertLevelNumToDouble(this.getLevelNum(colNum));
            }
        }
        return val;
    }

    public int getLevelNum(int colNum) {
        int val = 0;
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                val = CNKObj.convertDoubleToLevelNum(this.getDouble(colNum));
                break;
            }
            case 0: {
                int offset = this.getColumnOffset(colNum);
                int highbyte = this.m_rowBytes[offset] & 0xFF;
                int lowbyte = this.m_rowBytes[offset + 1] & 0xFF;
                val = (highbyte << 8) + lowbyte;
                if (val < 65535) break;
                val = CNKObj.getLevelNumNA();
            }
        }
        return val;
    }

    public String getString(int colNum) {
        String val = "";
        switch (this.m_columnTypes[colNum]) {
            case 1: {
                int actualWidth;
                int offset = this.getColumnOffset(colNum);
                int width = this.m_columnWidths[colNum];
                for (actualWidth = 0; actualWidth < width && this.m_rowBytes[offset + actualWidth] != 0; ++actualWidth) {
                }
                try {
                    val = new String(this.m_rowBytes, offset, actualWidth, "UTF-8");
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return val;
    }

    public long getTimeDate(int colNum) {
        long val = CNKObj.getTimeDateNA();
        switch (this.m_columnTypes[colNum]) {
            case 3: {
                int offset = this.getColumnOffset(colNum);
                long bytesAsLong = 0L;
                for (int i = 0; i < 8; ++i) {
                    bytesAsLong <<= 8;
                    bytesAsLong += (long)this.m_rowBytes[offset + i] & 0xFFL;
                }
                val = bytesAsLong;
            }
        }
        return val;
    }

    public long getBlobOffset(int colNum) {
        long val = -1L;
        switch (this.m_columnTypes[colNum]) {
            case 4: {
                int offset = this.getColumnOffset(colNum);
                long bytesAsLong = 0L;
                for (int i = 0; i < 8; ++i) {
                    bytesAsLong <<= 8;
                    bytesAsLong += (long)this.m_rowBytes[offset + i] & 0xFFL;
                }
                val = bytesAsLong;
            }
        }
        return val;
    }

    public long getBlobLength(int colNum) {
        long val = -1L;
        switch (this.m_columnTypes[colNum]) {
            case 4: {
                int offset = this.getColumnOffset(colNum);
                long bytesAsLong = 0L;
                for (int i = 0; i < 8; ++i) {
                    bytesAsLong <<= 8;
                    bytesAsLong += (long)this.m_rowBytes[offset + i + 8] & 0xFFL;
                }
                val = bytesAsLong;
            }
        }
        return val;
    }

    public void copyColumn(int colNum, int inputColNum, DataCacheRowBuf buf) {
        int offset = this.getColumnOffset(colNum);
        int otherOffset = buf.getColumnOffset(inputColNum);
        int width = this.m_columnWidths[colNum];
        int otherWidth = buf.m_columnWidths[inputColNum];
        if (width == otherWidth && this.m_columnTypes[colNum] == buf.m_columnTypes[inputColNum] && this.m_columnTypes[colNum] != 4) {
            System.arraycopy(buf.m_rowBytes, otherOffset, this.m_rowBytes, offset, width);
        } else {
            switch (this.m_columnTypes[colNum]) {
                case 2: {
                    this.setDouble(colNum, buf.getDouble(inputColNum));
                    break;
                }
                case 0: {
                    this.setLevelNum(colNum, buf.getLevelNum(inputColNum));
                    break;
                }
                case 1: {
                    if (buf.m_columnTypes[inputColNum] != 1) break;
                    for (int i = 0; i < width && i < otherWidth; ++i) {
                        byte b;
                        this.m_rowBytes[offset + i] = b = buf.m_rowBytes[otherOffset + i];
                        if (b == 0) break;
                    }
                    this.m_rowBytes[offset + width - 1] = 0;
                    break;
                }
                case 3: {
                    this.setTimeDate(colNum, buf.getTimeDate(inputColNum));
                    break;
                }
                case 4: {
                    if (buf.m_columnTypes[inputColNum] != 4) break;
                    this.copyBlobColumn(colNum, inputColNum, buf);
                }
            }
        }
    }

    private void copyBlobColumn(int colNum, int inputColNum, DataCacheRowBuf buf) {
        this.setNA(colNum);
        RandomAccessFile readBlobFile = buf.getReadBlobFile();
        OutputStream writeBlobFile = this.getWriteBlobFile();
        if (readBlobFile == null || writeBlobFile == null || buf.isNA(inputColNum)) {
            return;
        }
        try {
            int cacheLength;
            int len;
            long inputOffset = buf.getBlobOffset(inputColNum);
            long inputLength = buf.getBlobLength(inputColNum);
            readBlobFile.seek(inputOffset);
            int totalLength = DataCacheRowBuf.getTotalBlobLength(inputLength);
            if (this.m_copyBlobCache == null || this.m_copyBlobCache.length < totalLength) {
                this.m_copyBlobCache = new byte[totalLength];
            }
            for (cacheLength = 0; cacheLength < totalLength && (len = readBlobFile.read(this.m_copyBlobCache, cacheLength, totalLength - cacheLength)) >= 1; cacheLength += len) {
            }
            if (cacheLength < totalLength) {
                return;
            }
            if (!DataCacheRowBuf.blobHeaderTrailerOK(this.m_copyBlobCache, 0, inputOffset, inputLength)) {
                return;
            }
            DataCacheRowBuf.setBlobCacheOffset(this.m_copyBlobCache, 0, this.m_writeBlobFileOffset);
            writeBlobFile.write(this.m_copyBlobCache, 0, totalLength);
            this.setBlobOffsetLength(colNum, this.m_writeBlobFileOffset, inputLength);
            this.m_writeBlobFileOffset += (long)totalLength;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected static int getTotalBlobLength(long blobDataLength) {
        if (blobDataLength > Integer.MAX_VALUE) {
            throw new RuntimeException("DataCacheRowBuf.getTotalBlobLength: blob length too big: " + blobDataLength);
        }
        return (int)(blobDataLength + 12L + 12L);
    }

    protected static boolean blobHeaderTrailerOK(byte[] cache, int offset, long blobOffset, long blobLength) {
        return DataCacheRowBuf.byteMatch(cache, offset, headerString) && DataCacheRowBuf.readLongFromBytes(cache, offset + 4) == blobOffset && DataCacheRowBuf.readLongFromBytes(cache, offset + 12 + (int)blobLength) == blobLength && DataCacheRowBuf.byteMatch(cache, offset + 12 + (int)blobLength + 8, trailerString);
    }

    protected static void setBlobCacheOffset(byte[] b, int offset, long val) {
        DataCacheRowBuf.writeLongToBytes(b, offset + 4, val);
    }

    protected static boolean byteMatch(byte[] b1, int offset, byte[] b2) {
        if (b1 == null || b2 == null || offset < 0 || offset + b2.length > b1.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            if (b1[offset + i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    protected static long readLongFromBytes(byte[] b, int offset) {
        if (b == null || offset < 0 || b.length < offset + 8) {
            return -1L;
        }
        long val = 0L;
        for (int i = 0; i < 8; ++i) {
            int bi = b[offset + i];
            if (bi < 0) {
                bi += 256;
            }
            val = val << 8 | (long)bi;
        }
        return val;
    }

    protected static void writeLongToBytes(byte[] b, int offset, long val) {
        if (b == null || offset < 0 || b.length < offset + 8) {
            return;
        }
        for (int i = 7; i >= 0; --i) {
            b[offset + i] = (byte)(val & 0xFFL);
            val >>= 8;
        }
    }

    public byte[] getDataBytes() {
        return this.m_rowBytes;
    }

    public int getDataOffset() {
        return this.m_rowBytesOffset;
    }

    public int getBytesPerRow() {
        return this.m_bytesPerRow;
    }

    public void readRowUnsafe(DataInput in) throws Exception {
        in.readFully(this.m_rowBytes, this.m_rowBytesOffset, this.m_bytesPerRow);
    }

    public void readRow(DataInput in) {
        try {
            this.readRowUnsafe(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeRowUnsafe(DataOutput out) throws Exception {
        out.write(this.m_rowBytes, this.m_rowBytesOffset, this.m_bytesPerRow);
    }

    public void writeRow(DataOutput out) {
        try {
            this.writeRowUnsafe(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readRow(byte[] sourceBytes, int offset) {
        System.arraycopy(sourceBytes, offset, this.m_rowBytes, this.m_rowBytesOffset, this.m_bytesPerRow);
    }

    public void writeRow(byte[] destBytes, int offset) {
        System.arraycopy(this.m_rowBytes, this.m_rowBytesOffset, destBytes, offset, this.m_bytesPerRow);
    }

    public void copyAllColumns(DataCacheRowBuf buf) {
        if (this.m_containsBlobs) {
            for (int i = 0; i < this.m_numColumns; ++i) {
                this.copyColumn(i, i, buf);
            }
        } else {
            System.arraycopy(buf.m_rowBytes, buf.m_rowBytesOffset, this.m_rowBytes, this.m_rowBytesOffset, this.m_bytesPerRow);
        }
    }

    public boolean isSame(DataCacheRowBuf buf, int[] columnsToCompare) {
        for (int i = 0; i < columnsToCompare.length; ++i) {
            int colNum = columnsToCompare[i];
            if (this.isSame(buf, colNum)) continue;
            return false;
        }
        return true;
    }

    public boolean isSame(DataCacheRowBuf buf, int colNum) {
        block0 : switch (this.m_columnTypes[colNum]) {
            case 2: {
                double dVal1 = this.getDouble(colNum);
                double dVal2 = buf.getDouble(colNum);
                if (CNKObj.isDoubleNA(dVal1) && CNKObj.isDoubleNA(dVal2)) {
                    return true;
                }
                if (dVal1 == dVal2) break;
                return false;
            }
            case 0: {
                int level1 = this.getLevelNum(colNum);
                int level2 = buf.getLevelNum(colNum);
                if (level1 == level2) break;
                return false;
            }
            case 1: {
                int offset = this.getColumnOffset(colNum);
                int otherOffset = buf.getColumnOffset(colNum);
                int width = this.m_columnWidths[colNum];
                for (int i = 0; i < width; ++i) {
                    byte b1 = this.m_rowBytes[offset + i];
                    byte b2 = buf.m_rowBytes[otherOffset + i];
                    if (b1 != b2) {
                        return false;
                    }
                    if (b1 == 0) break block0;
                }
                break;
            }
            case 3: {
                long td1 = this.getTimeDate(colNum);
                long td2 = buf.getTimeDate(colNum);
                if (CNKObj.isTimeDateNA(td1) && CNKObj.isTimeDateNA(td2)) {
                    return true;
                }
                if (td1 == td2) break;
                return false;
            }
            case 4: {
                if (this.isNA(colNum) && buf.isNA(colNum)) {
                    return true;
                }
                long off1 = this.getBlobOffset(colNum);
                long off2 = buf.getBlobOffset(colNum);
                long len1 = this.getBlobLength(colNum);
                long len2 = buf.getBlobLength(colNum);
                if (off1 == off2 && len1 == len2) break;
                return false;
            }
        }
        return true;
    }

    public int compareTo(DataCacheRowBuf buf, int colNum) {
        if (this.isSame(buf, colNum)) {
            return 0;
        }
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                double dVal1 = this.getDouble(colNum);
                double dVal2 = buf.getDouble(colNum);
                if (dVal1 > dVal2) {
                    return 1;
                }
                if (!(dVal1 < dVal2)) break;
                return -1;
            }
            case 0: {
                int level1 = this.getLevelNum(colNum);
                int level2 = buf.getLevelNum(colNum);
                if (level1 > level2) {
                    return 1;
                }
                if (level1 >= level2) break;
                return -1;
            }
            case 1: {
                int offset = this.getColumnOffset(colNum);
                int otherOffset = buf.getColumnOffset(colNum);
                int width = this.m_columnWidths[colNum];
                for (int i = 0; i < width; ++i) {
                    int b1 = this.m_rowBytes[offset + i] & 0xFF;
                    int b2 = buf.m_rowBytes[otherOffset + i] & 0xFF;
                    if (b1 > 127 || b2 > 127) {
                        String str1 = this.getString(colNum);
                        String str2 = buf.getString(colNum);
                        return str1.compareTo(str2);
                    }
                    if (b1 > b2) {
                        return 1;
                    }
                    if (b1 < b2) {
                        return -1;
                    }
                    if (b1 != 0) continue;
                    return 0;
                }
                break;
            }
            case 3: {
                long td1 = this.getTimeDate(colNum);
                long td2 = buf.getTimeDate(colNum);
                if (td1 > td2) {
                    return 1;
                }
                if (td1 >= td2) break;
                return -1;
            }
            case 4: {
                long len2;
                long off1 = this.getBlobOffset(colNum);
                long off2 = buf.getBlobOffset(colNum);
                if (off1 > off2) {
                    return 1;
                }
                if (off1 < off2) {
                    return -1;
                }
                long len1 = this.getBlobLength(colNum);
                if (len1 > (len2 = buf.getBlobLength(colNum))) {
                    return 1;
                }
                if (len1 >= len2) break;
                return -1;
            }
        }
        return 0;
    }

    public int compareToRow(DataCacheRowBuf buf, int[] sortColumns, boolean[] sortAscending, boolean[] sortNAatTop, String[][] factorLevels, boolean absoluteVals) {
        block7: for (int sortColNum = 0; sortColNum < sortColumns.length; ++sortColNum) {
            int colNum = sortColumns[sortColNum];
            switch (this.m_columnTypes[colNum]) {
                case 2: {
                    double dv1 = this.getDouble(colNum);
                    double dv2 = buf.getDouble(colNum);
                    boolean na1 = CNKObj.isDoubleNA(dv1);
                    boolean na2 = CNKObj.isDoubleNA(dv2);
                    if (na1) {
                        if (na2) continue block7;
                        return sortNAatTop[sortColNum] ? -1 : 1;
                    }
                    if (na2) {
                        return sortNAatTop[sortColNum] ? 1 : -1;
                    }
                    if (absoluteVals) {
                        dv1 = Math.abs(dv1);
                        dv2 = Math.abs(dv2);
                    }
                    if (dv1 < dv2) {
                        return sortAscending[sortColNum] ? -1 : 1;
                    }
                    if (!(dv1 > dv2)) continue block7;
                    return sortAscending[sortColNum] ? 1 : -1;
                }
                case 0: {
                    int iv1 = this.getLevelNum(colNum);
                    int iv2 = buf.getLevelNum(colNum);
                    boolean na1 = CNKObj.isLevelNumNA(iv1);
                    boolean na2 = CNKObj.isLevelNumNA(iv2);
                    if (na1) {
                        if (na2) continue block7;
                        return sortNAatTop[sortColNum] ? -1 : 1;
                    }
                    if (na2) {
                        return sortNAatTop[sortColNum] ? 1 : -1;
                    }
                    if (factorLevels != null && factorLevels[sortColNum] != null) {
                        String str1 = factorLevels[sortColNum][iv1];
                        String str2 = factorLevels[sortColNum][iv2];
                        int comp = str1.compareTo(str2);
                        if (comp == 0) continue block7;
                        return sortAscending[sortColNum] ? comp : -comp;
                    }
                    if (iv1 < iv2) {
                        return sortAscending[sortColNum] ? -1 : 1;
                    }
                    if (iv1 <= iv2) continue block7;
                    return sortAscending[sortColNum] ? 1 : -1;
                }
                case 1: {
                    boolean na1 = this.isNA(colNum);
                    boolean na2 = buf.isNA(colNum);
                    if (na1) {
                        if (na2) continue block7;
                        return sortNAatTop[sortColNum] ? -1 : 1;
                    }
                    if (na2) {
                        return sortNAatTop[sortColNum] ? 1 : -1;
                    }
                    int offset = this.getColumnOffset(colNum);
                    int otherOffset = buf.getColumnOffset(colNum);
                    int width = this.m_columnWidths[colNum];
                    for (int i = 0; i < width; ++i) {
                        int b1 = this.m_rowBytes[offset + i] & 0xFF;
                        int b2 = buf.m_rowBytes[otherOffset + i] & 0xFF;
                        if (b1 == 0 && b2 == 0) continue block7;
                        if (b1 > 127 || b2 > 127) {
                            String str2;
                            String str1 = this.getString(colNum);
                            int comp = str1.compareTo(str2 = buf.getString(colNum));
                            if (comp == 0) continue block7;
                            return sortAscending[sortColNum] ? comp : -comp;
                        }
                        if (b1 < b2) {
                            return sortAscending[sortColNum] ? -1 : 1;
                        }
                        if (b1 <= b2) continue;
                        return sortAscending[sortColNum] ? 1 : -1;
                    }
                    continue block7;
                }
                case 3: {
                    long tv1 = this.getTimeDate(colNum);
                    long tv2 = buf.getTimeDate(colNum);
                    boolean na1 = CNKObj.isTimeDateNA(tv1);
                    boolean na2 = CNKObj.isTimeDateNA(tv2);
                    if (na1) {
                        if (na2) continue block7;
                        return sortNAatTop[sortColNum] ? -1 : 1;
                    }
                    if (na2) {
                        return sortNAatTop[sortColNum] ? 1 : -1;
                    }
                    if (tv1 < tv2) {
                        return sortAscending[sortColNum] ? -1 : 1;
                    }
                    if (tv1 <= tv2) continue block7;
                    return sortAscending[sortColNum] ? 1 : -1;
                }
                case 4: {
                    boolean na2;
                    long off1 = this.getBlobOffset(colNum);
                    long off2 = buf.getBlobOffset(colNum);
                    long len1 = this.getBlobLength(colNum);
                    long len2 = buf.getBlobLength(colNum);
                    boolean na1 = off1 < 0L || len1 < 0L;
                    boolean bl = na2 = off2 < 0L || len2 < 0L;
                    if (na1) {
                        if (na2) continue block7;
                        return sortNAatTop[sortColNum] ? -1 : 1;
                    }
                    if (na2) {
                        return sortNAatTop[sortColNum] ? 1 : -1;
                    }
                    if (off1 < off2) {
                        return sortAscending[sortColNum] ? -1 : 1;
                    }
                    if (off1 > off2) {
                        return sortAscending[sortColNum] ? 1 : -1;
                    }
                    if (len1 < len2) {
                        return sortAscending[sortColNum] ? -1 : 1;
                    }
                    if (len1 >= len2) continue block7;
                    return sortAscending[sortColNum] ? 1 : -1;
                }
            }
        }
        return 0;
    }

    public boolean isNA(int colNum) {
        switch (this.m_columnTypes[colNum]) {
            case 2: {
                return CNKObj.isDoubleNA(this.getDouble(colNum));
            }
            case 0: {
                return CNKObj.isLevelNumNA(this.getLevelNum(colNum));
            }
            case 1: {
                int offset = this.getColumnOffset(colNum);
                return this.m_rowBytes[offset] == 239 && this.m_rowBytes[offset + 1] == 191 && this.m_rowBytes[offset + 2] == 191 && this.m_rowBytes[offset + 3] == 0;
            }
            case 3: {
                return CNKObj.isTimeDateNA(this.getTimeDate(colNum));
            }
            case 4: {
                return this.getBlobOffset(colNum) < 0L || this.getBlobLength(colNum) < 0L;
            }
        }
        return false;
    }

    public boolean isFactor(int colNum) {
        return this.m_columnTypes[colNum] == 0;
    }

    public boolean isString(int colNum) {
        return this.m_columnTypes[colNum] == 1;
    }

    public boolean isDouble(int colNum) {
        return this.m_columnTypes[colNum] == 2;
    }

    public boolean isTimeDate(int colNum) {
        return this.m_columnTypes[colNum] == 3;
    }

    public boolean isBlob(int colNum) {
        return this.m_columnTypes[colNum] == 4;
    }

    public int getColumnOffset(int colNum) {
        return this.m_rowBytesOffset + this.m_columnOffsets[colNum];
    }

    public void setReadBlobFile(RandomAccessFile val) {
        this.m_readBlobFile = val;
    }

    public RandomAccessFile getReadBlobFile() {
        return this.m_readBlobFile;
    }

    public void setWriteBlobFile(OutputStream val) {
        this.m_writeBlobFile = val;
    }

    public OutputStream getWriteBlobFile() {
        return this.m_writeBlobFile;
    }

    public boolean containsBlobs() {
        return this.m_containsBlobs;
    }
}

