/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ClusterFrame;
import com.insightful.miner.InsChartPanel;
import com.insightful.miner.InsDefaultHistogramDataset;
import com.insightful.miner.InsDefaultQuantileDataset;
import com.insightful.miner.InsHistogramPlot;
import com.insightful.miner.InsHistogramRenderer;
import com.insightful.miner.InsHorizontalBarRenderer;
import com.insightful.miner.InsHorizontalBoxRenderer;
import com.insightful.miner.InsHorizontalCategoryPlot;
import com.insightful.miner.InsHorizontalDotRenderer;
import com.insightful.miner.InsStandardBoxPlotToolTipGenerator;
import com.insightful.miner.InsStandardCategoryToolTipGenerator;
import com.insightful.miner.InsVerticalCategoryPlot;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.PrintPreview;
import com.insightful.miner.StatsPanel;
import com.insightful.miner.graph.ExportGraphCommand;
import com.insightful.miner.tree.gui.ColorBroker;
import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.TickUnit;
import com.jrefinery.chart.TickUnits;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.PieDataset;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;

public class DataPanel
extends JPanel
implements ActionListener,
Printable,
ClipboardOwner {
    public static final String DRILLDOWN_ACTION_COMMAND = "DRILLDOWN";
    public static final String PROPERTIES_ACTION_COMMAND = "PROPERTIES";
    public static final String SAVE_ACTION_COMMAND = "SAVE";
    public static final String PRINT_ACTION_COMMAND = "PRINT";
    private static Font legibleTitleFont = new Font(JFreeChart.DEFAULT_TITLE_FONT.getFontName(), JFreeChart.DEFAULT_TITLE_FONT.getStyle(), JFreeChart.DEFAULT_TITLE_FONT.getSize() + 10);
    private ChartBuilder chartBuilder = null;
    private InsChartPanel chartPanel = null;
    private boolean isSelected = false;
    private ColorBroker colorBroker = null;
    public JMenuItem drillDownMenuItem = null;
    public JMenuItem saveMenuItem = null;
    public JMenuItem printMenuItem = null;
    public JMenuItem copyMenuItem = null;
    private JMenuItem properties = null;
    protected JPopupMenu popup = null;
    public String colName = "";
    private int currentChart = 0;
    private StatsPanel statsPanel = null;
    private boolean showCountsByPercent = false;
    private int chartType = 0;
    private double minVal = Double.NaN;
    private double maxVal = Double.NaN;
    private double maxChartCount = 0.0;
    private Hashtable groupBySpecification = null;
    public static final int PREFERRED_MINIMUM_WIDTH = 100;
    public static final int PREFERRED_MINIMUM_HEIGHT = 100;
    public static final int PREFERRED_MINIMUM_HEIGHT_WITH_STATS = 160;
    public static final int DATA_PANEL_MINIMUM_HEIGHT = 60;
    private static TickUnits m_integerTicks = null;
    private static TickUnits m_units = null;
    boolean myPrintBegun = false;
    Dimension myPrintDocSize = null;
    Point myPrintDocTopLeft = null;
    Rectangle2D.Double myPrintPageRect = null;
    int myPrintNumPagesAcross = 1;
    int myPrintNumPagesDown = 1;
    double myPrintHorizScale = 1.0;
    double myPrintVertScale = 1.0;

    public DataPanel(String column, Hashtable conditions, ChartBuilder cBuilder, int chType, int currChart, boolean enableDrillDown, boolean showCountPercents) {
        this.chartBuilder = cBuilder;
        this.colName = column;
        this.groupBySpecification = conditions;
        this.currentChart = currChart;
        this.chartType = chType;
        this.showCountsByPercent = showCountPercents;
        this.popup = this.createPopupMenu();
        this.drillDownMenuItem.setEnabled(enableDrillDown);
        this.setRequestFocusEnabled(true);
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartBackgroundColor"), 2));
        this.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        this.chartPanel = this.createChartPanel(this.colName, this.groupBySpecification, this.currentChart, this.chartType, showCountPercents);
        this.statsPanel = new StatsPanel(this.colName, this.groupBySpecification, this.chartBuilder, this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setToolTipText(this.colName);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.chartPanel));
        this.chartPanel.setToolTipText(this.colName);
        ToolTipManager.sharedInstance().registerComponent(this.statsPanel);
        this.statsPanel.setToolTipText(this.colName);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 2, 5);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)((Object)this.chartPanel), c);
        c.insets = new Insets(0, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 15;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.statsPanel, c);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                Font statsFont;
                if (!((DataPanel)DataPanel.this).chartBuilder.chartsAreDisplayed) {
                    return;
                }
                DataPanel dp = DataPanel.this.getDataPanel();
                int w = dp.getWidth();
                int h = dp.getHeight();
                int panelheight = 0;
                int panelwidth = 0;
                if (w > 250 && h > 300) {
                    statsFont = MinerApp.getFont(0, 12);
                    panelheight = 100;
                    panelwidth = 200;
                } else {
                    statsFont = MinerApp.getFont(0, 9);
                    panelheight = 55;
                    panelwidth = 80;
                }
                DataPanel.this.getStatsPanel().rescale(statsFont, panelheight, panelwidth);
                dp.revalidate();
                dp.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (!DataPanel.this.hasFocus()) {
                    DataPanel.this.requestFocus();
                }
                if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) == 16) {
                    DataPanel.this.handleDoubleClick();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }
        });
        this.setOpaque(true);
        if (this.chartBuilder.statsVisible()) {
            this.setMinimumSize(new Dimension(100, 160));
            this.setPreferredSize(new Dimension(100, 160));
        } else {
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(100, 100));
        }
    }

    public String getToolTipText() {
        String str = super.getToolTipText();
        return str;
    }

    public void updatePanel(ChartBuilder cBuilder) {
        this.chartBuilder = cBuilder;
        if (this.chartBuilder.isContinuous(this.colName) || this.chartBuilder.isDate(this.colName)) {
            this.chartPanel.setChart(this.createHistogram(this.colName, this.groupBySpecification, this.currentChart));
            this.statsPanel.setContinuousLabels(this.colName, this.groupBySpecification, this.chartBuilder);
        } else {
            this.chartPanel.setChart(this.createBarChart(this.colName, this.groupBySpecification, this.currentChart, false));
            this.statsPanel.setCategoricalLabels(this.colName, this.groupBySpecification, this.chartBuilder);
        }
    }

    private DataPanel getDataPanel() {
        return this;
    }

    private StatsPanel getStatsPanel() {
        return this.statsPanel;
    }

    public void clearMemory() {
        this.remove(this.statsPanel);
        this.statsPanel = null;
        this.remove((Component)((Object)this.chartPanel));
        this.chartPanel = null;
    }

    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if ((e.getModifiers() & 0x10) == 16) {
            this.handleLeftClick(e);
        } else if ((e.getModifiers() & 4) == 4) {
            this.handleRightClick(e);
        }
    }

    public void handleLeftClick(MouseEvent e) {
        if (e.isControlDown() || e.isShiftDown()) {
            this.chartBuilder.selectChart(this, true);
        } else {
            this.chartBuilder.selectChart(this, false);
        }
    }

    public void handleRightClick(MouseEvent e) {
        if (!this.chartBuilder.areMultipleChartsSelected()) {
            this.handleLeftClick(e);
        }
        if (this.popup != null) {
            this.popup.show(this, e.getX(), e.getY());
        }
    }

    public void handleDoubleClick() {
        if (this.drillDownMenuItem.isEnabled()) {
            this.chartBuilder.showDrillDownCharts();
        }
    }

    protected JPopupMenu createPopupMenu() {
        MinerPopupMenu result = new MinerPopupMenu(ChartBuilder.getText("clusterFrame_popup_title"));
        this.properties = new JMenuItem(ChartBuilder.getText("clusterFrame_chartproperties"));
        this.properties.setActionCommand(PROPERTIES_ACTION_COMMAND);
        this.properties.addActionListener(this);
        if (this.chartType == 4) {
            this.properties.setEnabled(false);
        }
        result.add(this.properties);
        result.addSeparator();
        this.drillDownMenuItem = new JMenuItem(ChartBuilder.getText("clusterFrame_viewchart"));
        this.drillDownMenuItem.setActionCommand(DRILLDOWN_ACTION_COMMAND);
        this.drillDownMenuItem.addActionListener(this);
        result.add(this.drillDownMenuItem);
        JMenuItem showStatsMenuItem = new JMenuItem(new AbstractAction(ChartBuilder.getText("clusterFrame_toggleStats")){

            public void actionPerformed(ActionEvent e) {
                boolean showStats = !DataPanel.this.statsPanel.isVisible();
                DataPanel.this.chartBuilder.showStats(showStats, true);
            }
        });
        result.add(showStatsMenuItem);
        JMenuItem toggleLegendMenuItem = new JMenuItem(new AbstractAction(ChartBuilder.getText("clusterFrame_toggleLegend")){

            public void actionPerformed(ActionEvent e) {
                boolean showLegend = DataPanel.this.getChartPanel().getChart().getLegend() == null;
                DataPanel.this.chartBuilder.showLegend(showLegend, true);
            }
        });
        result.add(toggleLegendMenuItem);
        result.addSeparator();
        this.saveMenuItem = new JMenuItem(ChartBuilder.getText("clusterFrame_filesave"));
        this.saveMenuItem.setActionCommand(SAVE_ACTION_COMMAND);
        this.saveMenuItem.addActionListener(this);
        result.add(this.saveMenuItem);
        this.copyMenuItem = new JMenuItem(new AbstractAction(ChartBuilder.getText("clusterFrame_filecopy")){

            public void actionPerformed(ActionEvent e) {
                Toolkit toolkit = DataPanel.this.getToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                ClusterFrame.copyToClipboard(clipboard, DataPanel.this, DataPanel.this);
            }
        });
        result.add(this.copyMenuItem);
        this.printMenuItem = new JMenuItem(ChartBuilder.getText("clusterFrame_fileprint"));
        this.printMenuItem.setActionCommand(PRINT_ACTION_COMMAND);
        this.printMenuItem.addActionListener(this);
        result.add(this.printMenuItem);
        return result;
    }

    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public void showStatsPanel() {
        this.statsPanel.setVisible(true);
    }

    public void hideStatsPanel() {
        this.statsPanel.setVisible(false);
    }

    public void disableChartProperties() {
        this.properties.setEnabled(false);
    }

    public void enableChartProperties() {
        this.properties.setEnabled(true);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(DRILLDOWN_ACTION_COMMAND)) {
            this.chartBuilder.showDrillDownCharts();
        } else if (command.equals(SAVE_ACTION_COMMAND)) {
            this.saveAs();
        } else if (command.equals(PRINT_ACTION_COMMAND)) {
            this.print();
        } else if (command.equals(PROPERTIES_ACTION_COMMAND)) {
            this.chartPanel.actionPerformed(event);
        }
    }

    private void saveAs() {
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartBackgroundColor"), 2));
        ExportGraphCommand egc = new ExportGraphCommand((Frame)this.chartBuilder.frame, this);
        egc.doExecute();
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartSelectionColor"), 2));
    }

    public DataPanel copy(boolean enableDrillDown) {
        DataPanel dp = new DataPanel(this.colName, this.groupBySpecification, this.chartBuilder, this.chartType, this.currentChart, enableDrillDown, this.showCountsByPercent);
        JFreeChart originalchart = this.chartPanel.getChart();
        JFreeChart newchart = dp.getChartPanel().getChart();
        newchart.setBackgroundPaint(originalchart.getBackgroundPaint());
        newchart.setAntiAlias(originalchart.getAntiAlias());
        newchart.setTitles(originalchart.getTitles());
        newchart.getPlot().setBackgroundPaint(originalchart.getPlot().getBackgroundPaint());
        newchart.getPlot().setOutlinePaint(originalchart.getPlot().getOutlinePaint());
        newchart.getPlot().setInsets(originalchart.getPlot().getInsets());
        newchart.getPlot().setOutlineStroke(originalchart.getPlot().getOutlineStroke());
        newchart.getPlot().setHorizontalAxis((Axis)originalchart.getPlot().getHorizontalAxis());
        newchart.getPlot().setVerticalAxis((Axis)originalchart.getPlot().getVerticalAxis());
        return dp;
    }

    public String getDisplayColName() {
        return this.colName;
    }

    public InsChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public boolean matchConditions(Hashtable conditions, int colIndex) {
        if (conditions == null) {
            return false;
        }
        String[] byCols = (String[])this.groupBySpecification.get("bycols");
        String[] levels = (String[])this.groupBySpecification.get("levels");
        String[] byCols2 = (String[])conditions.get("bycols");
        String[] levels2 = (String[])conditions.get("levels");
        if (colIndex >= byCols2.length) {
            return false;
        }
        for (int i = 0; i <= colIndex; ++i) {
            if (byCols2[i].equals(byCols[i]) && levels2[i].equals(levels[i])) continue;
            return false;
        }
        return true;
    }

    public void paintSelectedBorders() {
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartSelectionColor"), 2));
        this.repaint();
    }

    public void clearSelectedBorders() {
        this.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartBackgroundColor"), 2));
        this.repaint();
    }

    private void setSelected(boolean b) {
        this.isSelected = b;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private InsChartPanel createChartPanel(String colName, Hashtable groupBySpecification, int currentChart, int chartType, boolean showPercents) {
        JFreeChart chart = null;
        switch (chartType) {
            case 0: {
                chart = this.createHistogram(colName, groupBySpecification, currentChart);
                break;
            }
            case 1: {
                chart = this.createBoxPlot(colName, groupBySpecification, currentChart);
                break;
            }
            case 2: {
                chart = this.createDotChart(colName, groupBySpecification, currentChart, showPercents);
                break;
            }
            case 3: {
                chart = this.createBarChart(colName, groupBySpecification, currentChart, showPercents);
                break;
            }
            case 4: {
                chart = this.createPieChart(colName, groupBySpecification);
                break;
            }
            case 5: {
                chart = this.createColumnChart(colName, groupBySpecification, currentChart, showPercents);
                break;
            }
            default: {
                System.out.println("Error: no chart type.");
            }
        }
        InsChartPanel chartpanel = new InsChartPanel(this, chart);
        if (chartType == 3 || chartType == 2 || chartType == 4) {
            chartpanel.setLegend(chart.getLegend());
        }
        return chartpanel;
    }

    public void showLegend(boolean b) {
        InsChartPanel icp = this.getChartPanel();
        if (b) {
            icp.getChart().setLegend(icp.getLegend());
        } else {
            icp.getChart().setLegend(null);
        }
    }

    private JFreeChart createHistogram(String colName, Hashtable conditions, int currentChart) {
        Object[][] data = null;
        InsDefaultHistogramDataset histogramData = null;
        JFreeChart chart = null;
        data = this.chartBuilder.getCountsForCharting(colName, conditions);
        this.minVal = this.chartBuilder.getMinValue(colName);
        this.maxVal = this.chartBuilder.getMaxValue(colName);
        if (Double.isNaN(this.minVal)) {
            this.minVal = -1.0;
        }
        if (Double.isNaN(this.maxVal)) {
            this.maxVal = 1.0;
        }
        if (this.maxVal < this.minVal) {
            this.maxVal = this.minVal + 1.0;
        }
        if (this.minVal == this.maxVal) {
            if (this.minVal == 0.0) {
                this.maxVal = 1.0;
                this.minVal = -1.0;
            } else {
                double buffer = Math.abs(this.minVal * 0.25);
                this.minVal -= buffer;
                this.maxVal += buffer;
            }
            data[data.length / 2][0] = data[0][0];
            data[0][0] = new Double(0.0);
        }
        histogramData = new InsDefaultHistogramDataset(data);
        try {
            boolean date = this.chartBuilder.isDate(colName);
            DateCognizantHorizontalAxis horizontalAxis = new DateCognizantHorizontalAxis(ChartBuilder.getText("clusterFrame_binrange"), date){};
            horizontalAxis.setAxisRange(this.minVal, this.maxVal);
            horizontalAxis.setTickMarksVisible(true);
            horizontalAxis.setGridLinesVisible(false);
            horizontalAxis.setStandardTickUnits(DataPanel.createStandardTickUnits());
            VerticalNumberAxis verticalAxis = null;
            InsHistogramPlot plot = null;
            if (this.chartBuilder.useRelative()) {
                Double[] colRange = this.chartBuilder.getRangeForCharting(colName, conditions);
                this.maxChartCount = colRange[1];
            } else {
                this.maxChartCount = this.chartBuilder.getMaxChartCount(currentChart);
            }
            if (this.maxChartCount == 0.0) {
                this.maxChartCount += 1.0;
            }
            verticalAxis = new VerticalNumberAxis(ChartBuilder.getText("clusterFrame_countsLabel"));
            verticalAxis.setAxisRange(0.0, this.maxChartCount);
            verticalAxis.setAutoRange(false);
            verticalAxis.setStandardTickUnits(DataPanel.createIntegerTickUnits());
            verticalAxis.setGridLinesVisible(false);
            verticalAxis.setTickMarksVisible(true);
            InsHistogramRenderer renderer = new InsHistogramRenderer();
            plot = new InsHistogramPlot((Axis)horizontalAxis, (Axis)verticalAxis, renderer);
            Paint[] chartcolor = new Paint[this.chartBuilder.getNumBins()];
            for (int i = 0; i < this.chartBuilder.getNumBins(); ++i) {
                chartcolor[i] = ColorBroker.getColor("histogramColor");
            }
            plot.setSeriesPaint(chartcolor);
            plot.setInsets(new Insets(5, 2, 5, 10));
            chart = new JFreeChart((Dataset)histogramData, (Plot)plot, colName, legibleTitleFont, false);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createHistogram(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createHistogram(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        String subtitle = this.createSubtitle(conditions);
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        return chart;
    }

    private JFreeChart createBoxPlot(String colName, Hashtable conditions, int currentChart) {
        Number[][][] data = this.chartBuilder.getQuantileData(colName, conditions);
        InsDefaultQuantileDataset quantileData = new InsDefaultQuantileDataset(data);
        this.minVal = this.chartBuilder.getMinValue(colName);
        this.maxVal = this.chartBuilder.getMaxValue(colName);
        if (Double.isNaN(this.minVal)) {
            this.minVal = -1.0;
        }
        if (Double.isNaN(this.maxVal)) {
            this.maxVal = 1.0;
        }
        if (this.maxVal < this.minVal) {
            this.maxVal = this.minVal + 1.0;
        }
        if (this.minVal == this.maxVal) {
            if (this.minVal == 0.0) {
                this.maxVal = 1.0;
                this.minVal = -1.0;
            } else {
                double buffer = Math.abs(this.minVal * 0.25);
                this.minVal -= buffer;
                this.maxVal += buffer;
            }
        }
        double margin = (this.maxVal - this.minVal) / 5.0;
        this.minVal -= margin;
        this.maxVal += margin;
        String subtitle = this.createSubtitle(conditions);
        JFreeChart chart = null;
        try {
            boolean date = this.chartBuilder.isDate(colName);
            VerticalCategoryAxis categoryAxis = new VerticalCategoryAxis(ChartBuilder.getText("clusterFrame_levels"));
            DateCognizantHorizontalAxis valueAxis = new DateCognizantHorizontalAxis(ChartBuilder.getText("clusterFrame_quantiles"), date);
            valueAxis.setAxisRange(this.minVal, this.maxVal);
            valueAxis.setStandardTickUnits(DataPanel.createStandardTickUnits());
            InsHorizontalBoxRenderer renderer = new InsHorizontalBoxRenderer();
            InsHorizontalCategoryPlot plot = new InsHorizontalCategoryPlot((Axis)valueAxis, (Axis)categoryAxis, renderer, new InsStandardBoxPlotToolTipGenerator());
            plot.setSeriesPaint(DataPanel.getChartColors());
            plot.setInsets(new Insets(0, 0, 0, 10));
            VerticalCategoryAxis va = (VerticalCategoryAxis)plot.getAxis(1);
            va.setTickLabelsVisible(false);
            chart = new JFreeChart((Dataset)quantileData, (Plot)plot, colName, legibleTitleFont, false);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createBoxPlot(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createBoxPlot(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        return chart;
    }

    private JFreeChart createDotChart(String colName, Hashtable conditions, int currentChart, boolean showCountPercents) {
        Number[][] data = showCountPercents ? this.chartBuilder.getCountPercentsForCharting(colName, conditions) : this.chartBuilder.getCountsForCharting(colName, conditions);
        String subtitle = this.createSubtitle(conditions);
        DefaultCategoryDataset categoryData = new DefaultCategoryDataset(data);
        Vector bars = this.chartBuilder.getLevels(colName);
        bars.add(ChartBuilder.getText("clusterFrame_missingLabel"));
        categoryData.setSeriesNames(DataPanel.vectorToString(bars));
        bars.remove(ChartBuilder.getText("clusterFrame_missingLabel"));
        JFreeChart chart = null;
        try {
            VerticalCategoryAxis categoryAxis = new VerticalCategoryAxis(ChartBuilder.getText("clusterFrame_levels"));
            HorizontalNumberAxis valueAxis = showCountPercents ? new HorizontalNumberAxis(ChartBuilder.getText("clusterFrame_percentsLabel")) : new HorizontalNumberAxis(ChartBuilder.getText("clusterFrame_countsLabel"));
            InsHorizontalDotRenderer renderer = new InsHorizontalDotRenderer();
            InsHorizontalCategoryPlot plot = new InsHorizontalCategoryPlot((Axis)valueAxis, (Axis)categoryAxis, (CategoryItemRenderer)renderer, (CategoryToolTipGenerator)new InsStandardCategoryToolTipGenerator());
            plot.setSeriesPaint(DataPanel.getChartColors());
            plot.setInsets(new Insets(0, 0, 0, 10));
            NumberAxis na = (NumberAxis)plot.getAxis(0);
            na.setAutoRange(false);
            if (showCountPercents) {
                na.setMaximumAxisValue(100.0);
            } else {
                double maxVal = this.chartBuilder.getRangeForCharting(colName, conditions)[1];
                na.setMaximumAxisValue(maxVal);
            }
            na.setTickLabelsVisible(true);
            na.setStandardTickUnits(DataPanel.createIntegerTickUnits());
            VerticalCategoryAxis va = (VerticalCategoryAxis)plot.getAxis(1);
            va.setTickLabelsVisible(false);
            chart = new JFreeChart((Dataset)categoryData, (Plot)plot, colName, legibleTitleFont, true);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        return chart;
    }

    private JFreeChart createBarChart(String colName, Hashtable conditions, int currentChart, boolean showCountPercents) {
        Number[][] data = showCountPercents ? this.chartBuilder.getCountPercentsForCharting(colName, conditions) : this.chartBuilder.getCountsForCharting(colName, conditions);
        String subtitle = this.createSubtitle(conditions);
        DefaultCategoryDataset categoryData = new DefaultCategoryDataset(data);
        Vector bars = this.chartBuilder.getLevels(colName);
        bars.add(ChartBuilder.getText("clusterFrame_missingLabel"));
        categoryData.setSeriesNames(DataPanel.vectorToString(bars));
        bars.remove(ChartBuilder.getText("clusterFrame_missingLabel"));
        JFreeChart chart = null;
        try {
            VerticalCategoryAxis categoryAxis = new VerticalCategoryAxis(ChartBuilder.getText("clusterFrame_levels"));
            HorizontalNumberAxis valueAxis = showCountPercents ? new HorizontalNumberAxis(ChartBuilder.getText("clusterFrame_percentsLabel")) : new HorizontalNumberAxis(ChartBuilder.getText("clusterFrame_countsLabel"));
            InsHorizontalBarRenderer renderer = new InsHorizontalBarRenderer();
            InsHorizontalCategoryPlot plot = new InsHorizontalCategoryPlot((Axis)valueAxis, (Axis)categoryAxis, renderer, (CategoryToolTipGenerator)new InsStandardCategoryToolTipGenerator());
            plot.setSeriesPaint(DataPanel.getChartColors());
            plot.setInsets(new Insets(0, 0, 0, 10));
            NumberAxis na = (NumberAxis)plot.getAxis(0);
            na.setAutoRange(false);
            if (showCountPercents) {
                na.setMaximumAxisValue(100.0);
            } else {
                double maxVal = this.chartBuilder.getRangeForCharting(colName, conditions)[1];
                na.setMaximumAxisValue(maxVal);
            }
            na.setTickLabelsVisible(true);
            na.setStandardTickUnits(DataPanel.createIntegerTickUnits());
            VerticalCategoryAxis va = (VerticalCategoryAxis)plot.getAxis(1);
            va.setTickLabelsVisible(false);
            chart = new JFreeChart((Dataset)categoryData, (Plot)plot, colName, legibleTitleFont, true);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        return chart;
    }

    private JFreeChart createColumnChart(String colName, Hashtable conditions, int currentChart, boolean showCountPercents) {
        Number[][] data = showCountPercents ? this.chartBuilder.getCountPercentsForCharting(colName, conditions) : this.chartBuilder.getCountsForCharting(colName, conditions);
        String subtitle = this.createSubtitle(conditions);
        DefaultCategoryDataset categoryData = new DefaultCategoryDataset(data);
        Vector bars = this.chartBuilder.getLevels(colName);
        bars.add(ChartBuilder.getText("clusterFrame_missingLabel"));
        categoryData.setSeriesNames(DataPanel.vectorToString(bars));
        bars.remove(ChartBuilder.getText("clusterFrame_missingLabel"));
        JFreeChart chart = null;
        try {
            HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(ChartBuilder.getText("clusterFrame_levels"));
            VerticalNumberAxis valueAxis = showCountPercents ? new VerticalNumberAxis(ChartBuilder.getText("clusterFrame_percentsLabel")) : new VerticalNumberAxis(ChartBuilder.getText("clusterFrame_countsLabel"));
            VerticalBarRenderer renderer = new VerticalBarRenderer();
            InsVerticalCategoryPlot plot = new InsVerticalCategoryPlot((Axis)categoryAxis, (Axis)valueAxis, (CategoryItemRenderer)renderer, (CategoryToolTipGenerator)new InsStandardCategoryToolTipGenerator());
            plot.setSeriesPaint(DataPanel.getChartColors());
            plot.setInsets(new Insets(0, 0, 0, 10));
            NumberAxis na = (NumberAxis)plot.getAxis(1);
            na.setAutoRange(false);
            if (showCountPercents) {
                na.setMaximumAxisValue(100.0);
            } else {
                double maxVal = this.chartBuilder.getRangeForCharting(colName, conditions)[1];
                na.setMaximumAxisValue(maxVal);
            }
            na.setTickLabelsVisible(true);
            na.setStandardTickUnits(DataPanel.createIntegerTickUnits());
            HorizontalCategoryAxis ha = (HorizontalCategoryAxis)plot.getAxis(0);
            ha.setTickLabelsVisible(false);
            chart = new JFreeChart((Dataset)categoryData, (Plot)plot, colName, legibleTitleFont, true);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createBarChart(...) : plot not compatible.");
        }
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        return chart;
    }

    private JFreeChart createPieChart(String colName, Hashtable conditions) {
        Number[][] data = this.chartBuilder.getCountsForCharting(colName, conditions);
        String subtitle = this.createSubtitle(conditions);
        DefaultCategoryDataset categoryData = new DefaultCategoryDataset(data);
        Vector bars = this.chartBuilder.getLevels(colName);
        bars.add(ChartBuilder.getText("clusterFrame_missingLabel"));
        categoryData.setSeriesNames(DataPanel.vectorToString(bars));
        List cats = categoryData.getCategories();
        String firstCat = cats.size() > 0 ? cats.get(0) : "bad categoryData - no categories";
        PieDataset extracted = DatasetUtilities.createPieDataset((CategoryDataset)categoryData, (Object)firstCat);
        bars.remove(ChartBuilder.getText("clusterFrame_missingLabel"));
        JFreeChart chart = null;
        try {
            PiePlot plot = new PiePlot();
            plot.setOutlinePaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
            plot.setSeriesPaint(DataPanel.getChartColors());
            chart = new JFreeChart((Dataset)extracted, (Plot)plot, colName, legibleTitleFont, true);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("ClusterFrame.createPieChart(...) : axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("ClusterFrame.createPieChart(...) : plot not compatible.");
        }
        chart.setLegend(null);
        chart.addTitle((AbstractTitle)new TextTitle(subtitle, ClusterFrame.smallTitleFont));
        chart.setBackgroundPaint((Paint)ColorBroker.getColor("chartBackgroundColor"));
        PiePlot pie = (PiePlot)chart.getPlot();
        pie.setSectionLabelType(5);
        pie.setSectionLabelFont(ClusterFrame.pieFont);
        pie.setCircular(true);
        return chart;
    }

    private String createSubtitle(Hashtable conditions) {
        String title = "";
        if (this.chartBuilder.noConditionBys) {
            title = title + "(All data)";
        } else {
            String[] byCols = (String[])conditions.get("bycols");
            String[] levels = (String[])conditions.get("levels");
            title = title + " (";
            for (int i = 0; i < byCols.length; ++i) {
                title = title + byCols[i] + "=" + levels[i];
                title = byCols.length - i > 1 ? title + ", " : title + ")";
            }
        }
        return title;
    }

    public static String[] vectorToString(Vector v) {
        String[] array = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            array[i] = (String)v.elementAt(i);
        }
        return array;
    }

    public static Paint[] getChartColors() {
        Paint[] paints = new Paint[10];
        for (int i = 0; i < 10; ++i) {
            paints[i] = ColorBroker.getSeriesColor(i);
        }
        return paints;
    }

    public int getChartType() {
        return this.chartType;
    }

    public double getMaxVal() {
        if (this.chartType == 0) {
            return this.maxChartCount;
        }
        return this.maxVal;
    }

    public double getMinVal() {
        if (this.chartType == 0) {
            return 1.0;
        }
        return this.minVal;
    }

    public static TickUnits createIntegerTickUnits() {
        if (m_integerTicks != null) {
            return m_integerTicks;
        }
        TickUnits units = new TickUnits();
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(2L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(3L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(5L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(20L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(25L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(30L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(50L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100L), (NumberFormat)new DecimalFormat("0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1000L), (NumberFormat)new DecimalFormat("#,##0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10000L), (NumberFormat)new DecimalFormat("#,##0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100000L), (NumberFormat)new DecimalFormat("#,##0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1000000L), (NumberFormat)new DecimalFormat("#,###,##0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10000000L), (NumberFormat)new DecimalFormat("#,###,##0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(1000000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(10000000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        units.add((TickUnit)new NumberTickUnit((Number)new Long(100000000000000L), (NumberFormat)new DecimalFormat("0.###E0")));
        m_integerTicks = units;
        return units;
    }

    public static TickUnits createStandardTickUnits() {
        if (m_units != null) {
            return m_units;
        }
        m_units = new TickUnits(){

            public TickUnit getNearestTickUnit(TickUnit tickUnit) {
                TickUnit tu = super.getNearestTickUnit(tickUnit);
                return tu;
            }

            public TickUnit getNearestTickUnit(Number number) {
                TickUnit tu = super.getNearestTickUnit(number);
                return tu;
            }
        };
        DecimalFormat[] fmts = new DecimalFormat[]{new DecimalFormat("0.###E0"), new DecimalFormat("0.0000000"), new DecimalFormat("0.000000"), new DecimalFormat("0.00000"), new DecimalFormat("0.0000"), new DecimalFormat("0.000"), new DecimalFormat("0.00"), new DecimalFormat("0.00"), new DecimalFormat("0"), new DecimalFormat("#,##0"), new DecimalFormat("#,###,##0"), new DecimalFormat("0.###E0")};
        int index = 0;
        for (int i = -308; i < 309; ++i) {
            index = i > 8 ? 11 : (i > 4 ? 10 : (i > 2 ? 9 : (i > -1 ? 8 : (i > -2 ? 7 : (i > -3 ? 6 : (i > -4 ? 5 : (i > -5 ? 4 : (i > -6 ? 3 : (i > -7 ? 2 : (i > -8 ? 1 : 0))))))))));
            double val = Math.pow(10.0, i);
            if (index == 8 && (i != 2 || i != 3)) {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.25 * val), (NumberFormat)fmts[7]));
            } else {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.25 * val), (NumberFormat)fmts[index]));
            }
            if (index == 8 && (i != 2 || i != 3)) {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.5 * val), (NumberFormat)fmts[7]));
            } else {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.5 * val), (NumberFormat)fmts[index]));
            }
            if (index == 8 && (i != 2 || i != 3)) {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.75 * val), (NumberFormat)fmts[7]));
            } else {
                m_units.add((TickUnit)new NumberTickUnit((Number)new Double(0.75 * val), (NumberFormat)fmts[index]));
            }
            m_units.add((TickUnit)new NumberTickUnit((Number)new Double(val), (NumberFormat)fmts[index]));
        }
        return m_units;
    }

    public void printPreview() {
        Thread runner = new Thread(){

            public void run() {
                if (MinerApp.getMainFrame() == null) {
                    new PrintPreview(DataPanel.this.getDataPanel(), DataPanel.this.getDataPanel());
                } else {
                    Component comp = MinerApp.getMainFrame().getGlassPane();
                    Cursor oldCursor = comp.getCursor();
                    comp.setCursor(Cursor.getPredefinedCursor(3));
                    comp.setVisible(true);
                    new PrintPreview(DataPanel.this.getDataPanel(), DataPanel.this.getDataPanel());
                    comp.setCursor(oldCursor);
                    comp.setVisible(false);
                }
            }
        };
        runner.start();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h1 = pf.getImageableHeight() * 0.6;
        double h2 = pf.getImageableHeight();
        this.getChartPanel().getChart().draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y, w, h1), null);
        if (this.chartBuilder.statsVisible()) {
            this.getStatsPanel().print(g2, pf, pageIndex, new Rectangle2D.Double(x + w / 2.0 - 60.0, y + h1 + 20.0, 150.0, h2 - h1));
        }
        return 0;
    }

    protected class PrintThread
    extends Thread {
        private DataPanel m_ui;

        public PrintThread(DataPanel ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            if (MinerApp.getMainFrame() != null) {
                MinerApp.getMainFrame().requestFocus();
            }
            this.m_ui.requestFocus();
        }
    }

    private class DateCognizantHorizontalAxis
    extends HorizontalNumberAxis {
        private boolean m_date;
        private HashMap m_labelGuard;

        public DateCognizantHorizontalAxis(String str, boolean date) {
            super(str);
            this.m_date = false;
            this.m_labelGuard = new HashMap();
            this.m_date = date;
            this.setVerticalTickLabels(date);
        }

        public String valueToString(double val) {
            if (this.m_date) {
                String str;
                if (val == this.minimumAxisValue) {
                    this.m_labelGuard.clear();
                }
                if (this.m_labelGuard.get(str = MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(val)) != null) {
                    return "";
                }
                this.m_labelGuard.put(str, str);
                return str;
            }
            return super.valueToString(val);
        }

        public int calculateVisibleTickCount() {
            double unit = this.getTickUnit().getValue().doubleValue();
            if (Double.isInfinite(this.maximumAxisValue)) {
                return 1;
            }
            return (int)(Math.floor(this.maximumAxisValue / unit) - Math.ceil(this.minimumAxisValue / unit) + 1.0);
        }
    }
}

