/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.DuplicatedEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DuplicatedRowsDialog
extends NodeDialog {
    private static DuplicatedRowsDialog instance = null;
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane selectedScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDList selectedList;
    private NodeDialog.DNDListModel selectedListModel;
    private JCheckBox includeFirstOccurrenceCheckBox;
    private JCheckBox duplicateStateCheckBox;
    private JTextField duplicatedStateColumnName;
    private JCheckBox copyInputsCheckBox;
    private JRadioButton[] outputRowsButtons;
    private static final int outputAll = 0;
    private static final int outputUnique = 1;
    private static final int outputDuplicated = 2;
    private AbstractAction addAction;
    private AbstractAction removeAction;

    public static DuplicatedRowsDialog getInstance() {
        if (instance == null) {
            instance = new DuplicatedRowsDialog();
        }
        return instance;
    }

    private DuplicatedRowsDialog() {
        Dimension dim = new Dimension(400, 525);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.selectedListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        Vector propNames = props.getSubProperties(DuplicatedEngineNode.EQUALITY_COLUMNS_ATTRIBUTE_TAG);
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String type = (String)types.get(i);
            String role = (String)roles.get(i);
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (propNames.contains(name)) {
                this.selectedListModel.addElement(info);
                continue;
            }
            this.availableListModel.addElement(info);
        }
        int runType = props.getInt("run", 0);
        this.outputRowsButtons[0].setSelected(runType == 0);
        this.outputRowsButtons[1].setSelected(runType == 1);
        this.outputRowsButtons[2].setSelected(runType == 2);
        this.duplicatedStateColumnName.setText(props.getValue("duplicateColumn", "DUPLICATED"));
        this.copyInputsCheckBox.setSelected(props.getBoolean("keepOrigColumns", true));
        boolean addStateCol = props.getBoolean("addStateColumn", true);
        this.duplicateStateCheckBox.setSelected(addStateCol);
        this.duplicatedStateColumnName.setEnabled(addStateCol);
        this.includeFirstOccurrenceCheckBox.setSelected(props.getBoolean("includeFirst", true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{DuplicatedEngineNode.EQUALITY_COLUMNS_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration selectedColumns = this.selectedListModel.elements();
        while (selectedColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)selectedColumns.nextElement();
            props.set(DuplicatedEngineNode.EQUALITY_COLUMNS_ATTRIBUTE_TAG, object.getText(), "");
        }
        if (this.outputRowsButtons[2].isSelected()) {
            props.set("run", 2);
        } else if (this.outputRowsButtons[1].isSelected()) {
            props.set("run", 1);
        } else {
            props.set("run", 0);
        }
        props.set("duplicateColumn", this.duplicatedStateColumnName.getText());
        props.set("keepOrigColumns", this.copyInputsCheckBox.isSelected());
        props.set("includeFirst", this.includeFirstOccurrenceCheckBox.isSelected());
        props.set("addStateColumn", this.duplicateStateCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.addAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!DuplicatedRowsDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = DuplicatedRowsDialog.this.availableList.getSelectedValues();
                    int[] indices = DuplicatedRowsDialog.this.availableList.getSelectedIndices();
                    DuplicatedRowsDialog.this.availableList.getSelectionModel().clearSelection();
                    DuplicatedRowsDialog.this.availableListModel.removeListDataListeners();
                    DuplicatedRowsDialog.this.selectedListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        DuplicatedRowsDialog.this.availableListModel.removeElementAt(indices[i] - i);
                        DuplicatedRowsDialog.this.selectedListModel.addElement(values[i]);
                    }
                    DuplicatedRowsDialog.this.availableListModel.undoRemoveListDataListeners();
                    DuplicatedRowsDialog.this.selectedListModel.undoRemoveListDataListeners();
                    DuplicatedRowsDialog.this.selectedScrollPane.sort();
                    DuplicatedRowsDialog.this.availableListModel.listContentsChanged();
                    DuplicatedRowsDialog.this.selectedListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!DuplicatedRowsDialog.this.selectedList.isSelectionEmpty()) {
                    Object[] values = DuplicatedRowsDialog.this.selectedList.getSelectedValues();
                    int[] indices = DuplicatedRowsDialog.this.selectedList.getSelectedIndices();
                    DuplicatedRowsDialog.this.selectedList.getSelectionModel().clearSelection();
                    DuplicatedRowsDialog.this.selectedListModel.removeListDataListeners();
                    DuplicatedRowsDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        DuplicatedRowsDialog.this.selectedListModel.removeElementAt(indices[i] - i);
                        DuplicatedRowsDialog.this.availableListModel.addElement(values[i]);
                    }
                    DuplicatedRowsDialog.this.selectedListModel.undoRemoveListDataListeners();
                    DuplicatedRowsDialog.this.availableListModel.undoRemoveListDataListeners();
                    DuplicatedRowsDialog.this.availableScrollPane.sort();
                    DuplicatedRowsDialog.this.selectedListModel.listContentsChanged();
                    DuplicatedRowsDialog.this.availableListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.getSelectColumnsPanel(), "Center");
        optionsPanel.add((Component)this.getIncludeFirstPanel(), "South");
        return optionsPanel;
    }

    public Vector createOtherTabs() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.getOutputPanel(), "Center");
        optionsPanel.setName(MinerApp.getText("DuplicatedRowsDialog_output"));
        Vector<JPanel> ret = new Vector<JPanel>();
        ret.add(optionsPanel);
        return ret;
    }

    private JPanel getSelectColumnsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DuplicatedRowsDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel availableLabel = new JLabel(MinerApp.getText("DuplicatedRowsDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 10;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addButton = new JButton(this.addAction);
        JButton removeButton = new JButton(this.removeAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        JLabel selectedLabel = new JLabel(MinerApp.getText("DuplicatedRowsDialog_selectedColumns"));
        selectedLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.selectedListModel = new NodeDialog.DNDListModel();
        this.selectedList = new NodeDialog.DNDList(this.selectedListModel);
        this.selectedList.setCellRenderer(renderer);
        this.selectedList.setSelectionMode(2);
        this.selectedScrollPane = new NodeDialog.SortingScrollPane(this.selectedList);
        this.selectedScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)selectedLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 8;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.selectedScrollPane, constraints);
        return selectColumnsPanel;
    }

    private JPanel getIncludeFirstPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DuplicatedRowsDialog_duplicateDefinition")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.includeFirstOccurrenceCheckBox = new JCheckBox(MinerApp.getText("DuplicatedRowsDialog_includeFirst"));
        panel.add((Component)this.includeFirstOccurrenceCheckBox, "Center");
        return panel;
    }

    private JPanel getOutputPanel() {
        JPanel outputPanel = new JPanel(new BorderLayout());
        outputPanel.setName(MinerApp.getText("DuplicatedRowsDialog_output"));
        outputPanel.add((Component)this.getColumnsPanel(), "Center");
        outputPanel.add((Component)this.getRowsPanel(), "South");
        return outputPanel;
    }

    private JPanel getColumnsPanel() {
        JPanel newColumnsPanel = new JPanel(new GridBagLayout());
        newColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DuplicatedRowsDialog_newColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.duplicateStateCheckBox = new JCheckBox(MinerApp.getText("DuplicatedRowsDialog_duplicatedState"));
        this.duplicateStateCheckBox.setMnemonic('s');
        JLabel stateLabel = new JLabel(MinerApp.getText("DuplicatedRowsDialog_stateColumnName"));
        this.duplicatedStateColumnName = new JTextField();
        stateLabel.setDisplayedMnemonic('n');
        stateLabel.setLabelFor(this.duplicatedStateColumnName);
        this.duplicateStateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DuplicatedRowsDialog.this.duplicatedStateColumnName.setEnabled(DuplicatedRowsDialog.this.duplicateStateCheckBox.isSelected());
            }
        });
        JPanel columnNamePanel = new JPanel();
        columnNamePanel.setLayout(new BoxLayout(columnNamePanel, 0));
        columnNamePanel.add(stateLabel);
        columnNamePanel.add(Box.createHorizontalStrut(5));
        columnNamePanel.add(this.duplicatedStateColumnName);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridy = 0;
        constraints.gridx = 0;
        newColumnsPanel.add((Component)this.duplicateStateCheckBox, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 12;
        newColumnsPanel.add((Component)columnNamePanel, constraints);
        constraints.gridx = 0;
        JPanel inputColumnsPanel = new JPanel(new GridBagLayout());
        inputColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DuplicatedRowsDialog_inputColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.copyInputsCheckBox = new JCheckBox(MinerApp.getText("DuplicatedRowsDialog_copyAll"));
        this.copyInputsCheckBox.setMnemonic('c');
        GridBagConstraints inputConstraints = new GridBagConstraints();
        inputConstraints.anchor = 18;
        inputConstraints.gridx = 0;
        inputConstraints.weightx = 1.0;
        inputConstraints.weighty = 1.0;
        inputColumnsPanel.add((Component)this.copyInputsCheckBox, inputConstraints);
        JPanel columnsPanel = new JPanel();
        columnsPanel.setLayout(new BoxLayout(columnsPanel, 0));
        columnsPanel.add(newColumnsPanel);
        columnsPanel.add(Box.createHorizontalStrut(5));
        columnsPanel.add(inputColumnsPanel);
        return columnsPanel;
    }

    private JPanel getRowsPanel() {
        JPanel rowsPanel = new JPanel(new GridBagLayout());
        rowsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DuplicatedRowsDialog_rows")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup outputRowsGroup = new ButtonGroup();
        this.outputRowsButtons = new JRadioButton[3];
        JRadioButton outputAllRadioButton = new JRadioButton(MinerApp.getText("DuplicatedRowsDialog_outputAllInputRows"));
        outputAllRadioButton.setMnemonic('a');
        outputRowsGroup.add(outputAllRadioButton);
        this.outputRowsButtons[0] = outputAllRadioButton;
        JRadioButton outputNonDuplicateRadioButton = new JRadioButton(MinerApp.getText("DuplicatedRowsDialog_outputUniqueRowsOnly"));
        outputNonDuplicateRadioButton.setMnemonic('n');
        outputRowsGroup.add(outputNonDuplicateRadioButton);
        this.outputRowsButtons[1] = outputNonDuplicateRadioButton;
        JRadioButton outputDuplicateRadioButton = new JRadioButton(MinerApp.getText("DuplicatedRowsDialog_outputDuplicatedRowsOnly"));
        outputDuplicateRadioButton.setMnemonic('d');
        outputRowsGroup.add(outputDuplicateRadioButton);
        this.outputRowsButtons[2] = outputDuplicateRadioButton;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        rowsPanel.add((Component)outputAllRadioButton, constraints);
        constraints.gridy = 1;
        rowsPanel.add((Component)outputNonDuplicateRadioButton, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        rowsPanel.add((Component)outputDuplicateRadioButton, constraints);
        return rowsPanel;
    }
}

