/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.EngineWorksheetManager;
import com.insightful.miner.GuiMessageHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EngineMessageHandler {
    static EngineWorksheetManager m_worksheetMgr = new EngineWorksheetManager();

    public static Object sendMessageToApp(String msg, Object[] args) {
        return GuiMessageHandler.dispatchMessageToApp(msg, args);
    }

    public static Object sendMessageToGui(String worksheetID, String nodeID, String msg, Object[] args) {
        Object val = GuiMessageHandler.dispatchMessageToGui(worksheetID, nodeID, msg, args);
        return val;
    }

    public static Object dispatchMessageToEngine(String worksheetID, String nodeID, String msg, Object[] args) {
        Object obj = m_worksheetMgr.getMessageSendee(worksheetID, nodeID);
        Object val = EngineMessageHandler.dispatchMessage(obj, msg, args);
        return val;
    }

    public static String argsToString(Object[] args) {
        if (args == null) {
            return "{}";
        }
        String buf = "{";
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buf = buf + ",";
            }
            buf = buf + String.valueOf(args[i]);
        }
        buf = buf + "}";
        return buf;
    }

    public static Object dispatchMessage(Object obj, String methodName, Object[] args) {
        if (obj == null) {
            return null;
        }
        return EngineMessageHandler.dispatchToObjectAndClass(obj, obj.getClass(), methodName, args);
    }

    public static Object dispatchClassMessage(Class cl, String methodName, Object[] args) {
        return EngineMessageHandler.dispatchToObjectAndClass(null, cl, methodName, args);
    }

    private static Object dispatchToObjectAndClass(Object obj, Class cl, String methodName, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        Object val = null;
        Throwable valException = null;
        try {
            Class[] paramTypeList = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<Object> pClass;
                Class clazz = pClass = args[i] == null ? Object.class : args[i].getClass();
                if (pClass.equals(Boolean.class)) {
                    pClass = Boolean.TYPE;
                } else if (pClass.equals(Long.class)) {
                    pClass = Long.TYPE;
                } else if (pClass.equals(Integer.class)) {
                    pClass = Integer.TYPE;
                } else if (pClass.equals(Double.class)) {
                    pClass = Double.TYPE;
                } else if (pClass.equals(Short.class)) {
                    pClass = Short.TYPE;
                } else if (pClass.equals(Float.class)) {
                    pClass = Float.TYPE;
                }
                paramTypeList[i] = pClass;
            }
            Method methodToCall = cl.getMethod(methodName, paramTypeList);
            val = methodToCall.invoke(obj, args);
        }
        catch (NoSuchMethodException ex) {
            System.out.println("dispatchMessage: sendee=" + obj + " undefined mt=" + methodName + ": " + ex);
            System.out.println("obj class=" + cl);
            for (int i = 0; i < args.length; ++i) {
                System.out.println("arg=" + i + " class=" + args[i].getClass());
            }
            valException = ex;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace(System.out);
            valException = ex.getTargetException();
        }
        catch (Exception ex) {
            System.out.println("dispatchMessage exception: " + ex);
            ex.printStackTrace(System.out);
            valException = ex;
        }
        return valException == null ? val : valException;
    }
}

