/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.CommentUtilities;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SplusScriptDialog;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.WorksheetPropertiesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;

public class FilePropertiesDialog
extends NodeDialog {
    private static FilePropertiesDialog m_instance = null;
    private WorksheetDocument m_document;
    private WorksheetPropertiesPanel m_worksheetPropertyPanel;
    private SplusScriptDialog.NameValuePanel m_worksheetParameterPanel;
    private JTextField m_author;
    private JTextField m_version;
    private JTextField m_name;
    private JTextField m_path;
    private JTextField m_size;
    private JTextField m_cacheSize;
    private JTextField m_created;
    private JTextField m_modified;

    public static FilePropertiesDialog getInstance() {
        if (m_instance == null) {
            m_instance = new FilePropertiesDialog();
        }
        return m_instance;
    }

    public void showFileProperties(WorksheetDocument doc) {
        this.m_document = doc;
        this.show(null);
    }

    protected FilePropertiesDialog() {
        this.setTitle(MinerApp.getText("FilePropertiesDialog_title"));
        this.getApplyButton().setVisible(false);
        this.getAddButton().setVisible(false);
        Dimension min = new Dimension(600, 580);
        this.setMinimumSize(min);
        this.setSize(min);
        this.setLocationRelativeTo(MinerApp.getMainFrame());
    }

    public JPanel createAdvancedPanel() {
        this.m_worksheetPropertyPanel = new WorksheetPropertiesPanel(false);
        return this.m_worksheetPropertyPanel;
    }

    public Vector createOtherTabs() {
        Vector<SplusScriptDialog.NameValuePanel> otherTabs = new Vector<SplusScriptDialog.NameValuePanel>();
        if ("visible".equals(System.getProperty("parameters.gui"))) {
            this.m_worksheetParameterPanel = new SplusScriptDialog.NameValuePanel(true);
            this.m_worksheetParameterPanel.setName(MinerApp.getText("FilePropertiesDialog_parameters"));
            otherTabs.add(this.m_worksheetParameterPanel);
        }
        return otherTabs;
    }

    public JPanel createOptionsPanel() {
        this.m_name = new JTextField(35);
        this.m_path = new JTextField(35);
        this.m_size = new JTextField(35);
        this.m_cacheSize = new JTextField(35);
        this.m_created = new JTextField(35);
        this.m_modified = new JTextField(35);
        JPanel generalPanel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_fileNameLabel"));
        JLabel pathLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_pathLabel"));
        JLabel sizeLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_sizeLabel"));
        JLabel cacheSizeLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_cacheSizeLabel"));
        JLabel createdLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_createdLabel"));
        JLabel modifiedLabel = new JLabel(MinerApp.getText("FilePropertiesDialog_modifiedLabel"));
        JButton commentsButton = WorksheetPropertiesPanel.createButton("FilePropertiesDialog_commentsButtonLabel", "FilePropertiesDialog_commentsButtonHotkey", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.onComments();
            }
        });
        this.m_author = WorksheetPropertiesPanel.createTextField(35, null);
        JLabel authorLabel = WorksheetPropertiesPanel.createLabel(this.m_author, "FilePropertiesDialog_authorLabel", "FilePropertiesDialog_authorHotkey");
        this.m_version = WorksheetPropertiesPanel.createTextField(35, null);
        JLabel versionLabel = WorksheetPropertiesPanel.createLabel(this.m_version, "FilePropertiesDialog_versionLabel", "FilePropertiesDialog_versionHotkey");
        this.m_name.setOpaque(false);
        this.m_name.setEditable(false);
        this.m_path.setOpaque(false);
        this.m_path.setEditable(false);
        this.m_size.setOpaque(false);
        this.m_size.setEditable(false);
        this.m_created.setOpaque(false);
        this.m_created.setEditable(false);
        this.m_modified.setOpaque(false);
        this.m_modified.setEditable(false);
        this.m_cacheSize.setOpaque(false);
        this.m_cacheSize.setEditable(false);
        generalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("FilePropertiesDialog_borderTitle")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        int gridy = 0;
        Insets separatorIndent = new Insets(10, 10, 10, 10);
        GridBagConstraints constraints = new GridBagConstraints();
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, nameLabel, this.m_name, gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, pathLabel, this.m_path, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, sizeLabel, this.m_size, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, createdLabel, this.m_created, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, modifiedLabel, this.m_modified, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, cacheSizeLabel, this.m_cacheSize, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, authorLabel, this.m_author, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(generalPanel, versionLabel, this.m_version, ++gridy, constraints);
        WorksheetPropertiesPanel.addGB(generalPanel, commentsButton, constraints, 0, ++gridy, 0, 1, 1.0, 1.0, 18, 0, separatorIndent);
        ++gridy;
        return generalPanel;
    }

    public void restoreProperties() {
        try {
            this.m_worksheetPropertyPanel.restoreProperties(this.m_document.getWorksheetProperties());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if ("visible".equals(System.getProperty("parameters.gui"))) {
            this.m_worksheetParameterPanel.restoreProperties(this.m_document.getWorksheetParameters(), new String[0]);
        }
        this.m_author.setText(this.m_document.getAuthor());
        this.m_version.setText(this.m_document.getVersion());
        String filePath = this.m_document.getLocation();
        File file = new File(filePath);
        boolean fileExists = filePath != null && !filePath.equals("") && file.exists();
        this.m_name.setText(!fileExists ? "" : file.getName());
        this.m_path.setText(!fileExists ? "" : file.getAbsolutePath());
        String fileSize = "";
        String fileModified = "";
        String fileCreated = "";
        if (fileExists) {
            long fileLength = file.length();
            fileSize = fileLength > 1024L ? new Double(Math.round((double)fileLength / 1024.0)).toString() + "KB (" + new Long(fileLength).toString() + " bytes)" : new Long((int)fileLength).toString() + " bytes";
            fileModified = new Date(file.lastModified()).toString();
            long temp = this.m_document.getCreatedDate();
            if (temp != 0L) {
                fileCreated = new Date(temp).toString();
            }
        }
        this.m_size.setText(fileSize);
        this.m_modified.setText(fileModified);
        this.m_created.setText(fileCreated);
        String cacheSize = this.askEngineForCacheSize();
        this.m_cacheSize.setText(cacheSize);
    }

    private String askEngineForCacheSize() {
        String id = this.m_document.getWorksheetID();
        if (id == null || id.equals("") || this.m_document.isDummyEngineConnection()) {
            return "";
        }
        Object obj = GuiMessageHandler.sendMessageToEngine(id, null, "getTotalCacheSizeString", null);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public void saveProperties() throws NodeDialog.DialogException {
        boolean isDirty = false;
        XTProps oldProps = this.m_document.getWorksheetProperties();
        XTProps newProps = null;
        try {
            newProps = new XTProps();
            this.m_worksheetPropertyPanel.saveProperties(newProps);
            if ("visible".equals(System.getProperty("parameters.gui"))) {
                XTProps oldWorksheetParameters = this.m_document.getWorksheetParameters();
                XTProps worksheetParameters = new XTProps();
                this.m_worksheetParameterPanel.saveProperties(worksheetParameters, new String[0]);
                if (!XTMetaData.nullCognizantCompare(oldWorksheetParameters, worksheetParameters)) {
                    this.m_document.setWorksheetParameters(worksheetParameters);
                    this.m_document.setEngineNetworkDirty();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String oldWSD = WorksheetPropertiesManager.getWSDDirectoryFromProps(oldProps);
        String newWSD = WorksheetPropertiesManager.getWSDDirectoryFromProps(newProps);
        if (!oldWSD.equals(newWSD) && MinerApp.isRunning()) {
            throw new NodeDialog.DialogException("Can't change worksheet directory while executing the worksheet");
        }
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(newProps, MinerApp.getGlobalOptions());
        if (!newProps.equals(oldProps)) {
            this.m_document.setWorksheetProperties(newProps);
            isDirty = true;
        }
        String newAuthor = this.m_author.getText();
        String newVersion = this.m_version.getText();
        if (!newAuthor.equals(this.m_document.getAuthor()) || !newVersion.equals(this.m_document.getVersion())) {
            isDirty = true;
        }
        this.m_document.setAuthor(newAuthor);
        this.m_document.setVersion(newVersion);
        if (isDirty) {
            this.m_document.setEngineNetworkDirty();
            this.m_document.setModified(true);
        }
        MinerApp.updateWorksheetPropertiesManager();
        if (!oldWSD.equals(newWSD)) {
            MinerApp.changeDocWorksheetDir(this.m_document, true);
        }
    }

    protected void onComments() {
        try {
            Element newComments = CommentUtilities.editComments(this.m_document.getComments(), this.m_document.getName());
            this.m_document.setComments(newComments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

