/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsDefaultHistogramDataset;
import com.insightful.miner.InsHistogramPlot;
import com.jrefinery.chart.ValueAxis;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class InsHistogramRenderer {
    public int barWidthsPerBin(InsDefaultHistogramDataset data) {
        return data.getItemCount();
    }

    public Shape drawBar(Graphics2D g2, Rectangle2D plotArea, InsHistogramPlot plot, ValueAxis valueAxis, InsDefaultHistogramDataset data, int item, double translatedZero, double itemWidth) {
        Number value = data.getCount(item);
        Rectangle2D.Double bar = null;
        if (value != null) {
            double rectX = plotArea.getX();
            int itemCount = data.getItemCount();
            rectX += (double)item * plotArea.getWidth() / (double)itemCount;
            double translatedValue = valueAxis.translateValueToJava2D(value.doubleValue(), plotArea);
            double zeroInJava2D = valueAxis.translateValueToJava2D(0.0, plotArea);
            double rectY = Math.min(zeroInJava2D, translatedValue);
            double rectWidth = itemWidth;
            double rectHeight = Math.abs(translatedValue - zeroInJava2D);
            bar = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(0);
            g2.setPaint(seriesPaint);
            g2.fill(bar);
            if (itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesStroke(0));
                g2.setPaint(plot.getSeriesOutlinePaint(0));
                g2.draw(bar);
            }
        }
        return bar;
    }
}

