/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsHorizontalBarRenderer;
import com.insightful.miner.InsQuantileDataset;
import com.insightful.miner.tree.gui.ColorBroker;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class InsHorizontalBoxRenderer
extends InsHorizontalBarRenderer {
    public Shape drawCategoryItem(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, int series, Object category, int categoryIndex, Object previousCategory) {
        Rectangle2D.Double result = null;
        InsQuantileDataset idata = (InsQuantileDataset)data;
        boolean allPos = false;
        Number maxValue = idata.getMaxValue(series, category);
        Number topQuantileValue = idata.get75PercentValue(series, category);
        Number medianValue = idata.get50PercentValue(series, category);
        Number lowerQuantileValue = idata.get25PercentValue(series, category);
        Number minValue = idata.getMinValue(series, category);
        if (maxValue != null && topQuantileValue != null && medianValue != null && lowerQuantileValue != null && minValue != null) {
            if (Double.isNaN(maxValue.doubleValue()) || Double.isNaN(topQuantileValue.doubleValue()) || Double.isNaN(medianValue.doubleValue()) || Double.isNaN(lowerQuantileValue.doubleValue()) || Double.isNaN(minValue.doubleValue())) {
                return null;
            }
            if (maxValue.doubleValue() > 0.0 && topQuantileValue.doubleValue() > 0.0 && medianValue.doubleValue() > 0.0 && lowerQuantileValue.doubleValue() > 0.0 && minValue.doubleValue() > 0.0) {
                allPos = true;
            }
            double translatedMax = axis.translateValueToJava2D(maxValue.doubleValue(), dataArea);
            double translatedTopQuantile = axis.translateValueToJava2D(topQuantileValue.doubleValue(), dataArea);
            double translatedMedian = axis.translateValueToJava2D(medianValue.doubleValue(), dataArea);
            double translatedLowerQuantile = axis.translateValueToJava2D(lowerQuantileValue.doubleValue(), dataArea);
            double translatedMin = axis.translateValueToJava2D(minValue.doubleValue(), dataArea);
            double rectX = translatedLowerQuantile;
            if (allPos) {
                rectX = Math.max(this.zeroInJava2D, translatedLowerQuantile);
            }
            double rectY = dataArea.getY() + dataArea.getHeight() * plot.getIntroGapPercent();
            int categories = idata.getCategoryCount();
            int seriesCount = idata.getSeriesCount();
            if (categories > 1) {
                rectY = rectY + (double)categoryIndex * this.categorySpan / (double)categories + (double)categoryIndex * this.categoryGapSpan / (double)(categories - 1) + (double)series * this.itemSpan / (double)(categories * seriesCount);
                if (seriesCount > 1) {
                    rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
                }
            } else if (seriesCount > 1) {
                rectY += (double)series * this.itemSpan / (double)(categories * seriesCount);
                rectY += (double)series * this.itemGapSpan / (double)(categories * (seriesCount - 1));
            } else {
                rectY -= dataArea.getHeight() * plot.getIntroGapPercent();
                rectY += dataArea.getHeight() / 2.0;
                rectY -= this.itemWidth / 2.0;
            }
            double rectHeight = this.itemWidth;
            double rectWidth = Math.abs(translatedTopQuantile - translatedLowerQuantile);
            double rightWhiskerX = translatedMax;
            if (allPos) {
                rightWhiskerX = Math.max(this.zeroInJava2D, translatedMax);
            }
            double medianX = translatedMedian;
            if (allPos) {
                medianX = Math.max(this.zeroInJava2D, translatedMedian);
            }
            double leftWhiskerX = translatedMin;
            if (allPos) {
                leftWhiskerX = Math.max(this.zeroInJava2D, translatedMin);
            }
            Rectangle2D.Double box = new Rectangle2D.Double(rectX, rectY, rectWidth, rectHeight);
            Paint seriesPaint = plot.getSeriesPaint(20);
            g2.setPaint(seriesPaint);
            g2.fill(box);
            if (this.itemWidth > 3.0) {
                g2.setStroke(plot.getSeriesStroke(1));
                g2.setPaint(ColorBroker.getColor("chartBoxplotOutlineColor"));
                g2.draw(box);
                g2.fillArc((int)medianX - 2, (int)(rectY + this.itemWidth / 2.0) - 2, 4, 4, 0, 360);
                g2.setPaint(ColorBroker.getColor("chartBoxplotOutlineColor"));
                g2.drawLine((int)leftWhiskerX, (int)(rectY + this.itemWidth / 2.0), (int)rectX, (int)(rectY + this.itemWidth / 2.0));
                g2.drawLine((int)leftWhiskerX, (int)(rectY + this.itemWidth / 8.0), (int)leftWhiskerX, (int)(rectY + this.itemWidth * 7.0 / 8.0));
                g2.drawLine((int)(rectX + rectWidth), (int)(rectY + this.itemWidth / 2.0), (int)rightWhiskerX, (int)(rectY + this.itemWidth / 2.0));
                g2.drawLine((int)rightWhiskerX, (int)(rectY + this.itemWidth / 8.0), (int)rightWhiskerX, (int)(rectY + this.itemWidth * 7.0 / 8.0));
            }
            result = box;
        }
        return result;
    }
}

