/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibraryManagerDialog
extends JDialog {
    private ExplorerPane m_explorerPane;
    private LibraryTableModel m_model;
    private Vector m_removalList = new Vector();
    private JTable m_table;
    private static int FILE_COLUMN_WIDTH = 500;
    private static int NAME_COLUMN_WIDTH = 150;
    private static int DISPLAY_COLUMN_WIDTH = 50;

    public LibraryManagerDialog(ExplorerPane pane) {
        super((Frame)MinerApp.getMainFrame(), MinerApp.getText("LibraryManagerDialog_libraryManager"));
        this.m_explorerPane = pane;
        this.init();
        this.setSize(640, 350);
        this.setLocationRelativeTo(MinerApp.getMainFrame());
    }

    private void init() {
        this.m_model = new LibraryTableModel(this.m_explorerPane);
        this.m_table = new JTable(this.m_model);
        NodeDialog.addKeyboardNavigation(this.m_table);
        this.m_table.setAutoResizeMode(0);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowHeight(25);
        this.m_table.setDefaultRenderer(String.class, new NodeDialog.LeftJustifiedStringRenderer());
        TableColumnModel cm = this.m_table.getColumnModel();
        JCheckBox testWidth = new JCheckBox();
        testWidth.setHorizontalAlignment(0);
        cm.getColumn(0).setCellEditor(new DefaultCellEditor(testWidth));
        cm.getColumn(0).setCellRenderer(new BooleanRenderer());
        cm.getColumn(0).setPreferredWidth(DISPLAY_COLUMN_WIDTH);
        cm.getColumn(1).setPreferredWidth(NAME_COLUMN_WIDTH);
        cm.getColumn(2).setPreferredWidth(FILE_COLUMN_WIDTH);
        JButton browse = new JButton(new AbstractAction(MinerApp.getText("LibraryManagerDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onBrowse();
            }
        });
        browse.setMnemonic(MinerApp.getText("LibraryManagerDialog_browseHotkey").charAt(0));
        JButton remove = new JButton(new AbstractAction(MinerApp.getText("LibraryManagerDialog_remove")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onRemove();
            }
        });
        remove.setMnemonic(MinerApp.getText("LibraryManagerDialog_removeHotkey").charAt(0));
        JButton newLib = new JButton(new AbstractAction(MinerApp.getText("LibraryManagerDialog_new")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onNew();
            }
        });
        newLib.setMnemonic(MinerApp.getText("LibraryManagerDialog_newHotkey").charAt(0));
        JButton ok = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_ok")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onOK();
            }
        });
        ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
        JButton cancel = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_cancel")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onCancel();
            }
        });
        cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
        cancel.registerKeyboardAction(cancel.getAction(), KeyStroke.getKeyStroke("ESCAPE"), 2);
        JButton help = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_help")){

            public void actionPerformed(ActionEvent e) {
                LibraryManagerDialog.this.onHelp();
            }
        });
        help.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
        JPanel tableButtonPanel = new JPanel();
        tableButtonPanel.setLayout(new BoxLayout(tableButtonPanel, 0));
        tableButtonPanel.add(remove);
        tableButtonPanel.add(Box.createHorizontalGlue());
        tableButtonPanel.add(browse);
        tableButtonPanel.add(Box.createHorizontalStrut(5));
        tableButtonPanel.add(newLib);
        JPanel dialogButtonPanel = new JPanel();
        dialogButtonPanel.setLayout(new BoxLayout(dialogButtonPanel, 0));
        dialogButtonPanel.add(Box.createHorizontalGlue());
        dialogButtonPanel.add(ok);
        dialogButtonPanel.add(Box.createHorizontalStrut(5));
        dialogButtonPanel.add(cancel);
        dialogButtonPanel.add(Box.createHorizontalStrut(5));
        dialogButtonPanel.add(help);
        JPanel dialogPanel = new JPanel(new GridBagLayout());
        dialogPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("LibraryManagerDialog_editLibraries")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        dialogPanel.add((Component)tableButtonPanel, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.insets = new Insets(0, 5, 0, 5);
        dialogPanel.add((Component)new JScrollPane(this.m_table), gbc);
        gbc.fill = 2;
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        dialogPanel.add((Component)dialogButtonPanel, gbc);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        container.add((Component)dialogPanel, gbc);
    }

    private String getTitle(XMLTree tree) {
        NodeList list;
        Element element = tree.getXML();
        String title = element.getNodeName();
        if (element.getNodeName().equals("ExplorerTree") && (list = element.getElementsByTagName("ExplorerPage")) != null && list.getLength() > 0) {
            return ((Element)list.item(0)).getAttribute("labelText");
        }
        return title;
    }

    private XMLTree getTree(String editName, String origPath) {
        try {
            File explorerFile = new File(ExplorerPane.SETTINGS_DIR + editName);
            if (explorerFile.exists()) {
                try {
                    return XMLTree.readFromFile(explorerFile.getAbsolutePath());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if ((explorerFile = new File(origPath)).exists()) {
                return XMLTree.readFromFile(explorerFile.getAbsolutePath());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private void onOK() {
        String[] libPath = new String[]{"ExplorerPage", ""};
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            boolean show = (Boolean)this.m_model.getValueAt(i, 0);
            String title = (String)this.m_model.getValueAt(i, 1);
            libPath[1] = this.m_model.getFilepathAt(i);
            this.m_explorerPane.changeVisibility(this.m_model.getEditNameAt(i), libPath[1], show, title, i);
        }
        this.m_explorerPane.save();
        XTProps globalOptions = MinerApp.getGlobalOptions();
        for (int i = 0; i < this.m_removalList.size(); ++i) {
            libPath[1] = (String)this.m_removalList.get(i);
            globalOptions.removeProperty(libPath);
            int tabIndex = this.m_explorerPane.getTabPosition(libPath[1]);
            if (tabIndex <= -1) continue;
            this.m_explorerPane.removeTreeTab(tabIndex);
        }
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void onHelp() {
        MinerApp.getHelpManager().showTopic("Library_Manager");
    }

    private void onRemove() {
        String editName;
        int i;
        int[] rows = this.m_table.getSelectedRows();
        for (int i2 = rows.length - 1; i2 >= 0; --i2) {
            if (this.m_model.isCellEditable(rows[i2], 0)) continue;
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("LibraryManagerDialog_cannotRemoveUserText"), MinerApp.getText("LibraryManagerDialog_cannotRemove"), 2);
            return;
        }
        boolean insightfulLibraryExtensions = false;
        LibraryFilenameFilter filter = new LibraryFilenameFilter();
        String homeDir = new File(ExplorerPane.XML_DIR).getAbsolutePath();
        String extensionPrefix = "extension_";
        for (i = rows.length - 1; i >= 0; --i) {
            editName = this.m_model.getEditNameAt(rows[i]);
            String origPath = new File(this.m_model.getFilepathAt(rows[i])).getAbsolutePath();
            if (!editName.startsWith(extensionPrefix) && (!origPath.startsWith(homeDir) || !filter.accept(null, editName))) continue;
            insightfulLibraryExtensions = true;
            break;
        }
        if (insightfulLibraryExtensions) {
            if (AcceleratorOptionPane.showOKCancelDialog(this, MinerApp.getText("LibraryManagerDialog_cannotRemoveText"), MinerApp.getText("LibraryManagerDialog_cannotRemove"), 2) == 0) {
                for (i = rows.length - 1; i >= 0; --i) {
                    this.m_model.setValueAt(new Boolean(false), rows[i], 0);
                }
            }
            return;
        }
        if (rows.length > 0 && AcceleratorOptionPane.showOKCancelDialog(this, MinerApp.getText("LibraryManagerDialog_removeWarning"), MinerApp.getText("LibraryManagerDialog_removeWarningTitle"), 2) == 2) {
            return;
        }
        for (i = rows.length - 1; i >= 0; --i) {
            editName = this.m_model.getEditNameAt(rows[i]);
            this.m_removalList.add(editName);
            this.m_model.removeRow(rows[i]);
        }
    }

    private void onBrowse() {
        String path = ExplorerPane.openLibrary(this, true);
        if (path == null) {
            return;
        }
        DragAndDropTree tree = null;
        boolean isSplusLib = path.endsWith(ExplorerPane.SPLUS_LIBRARY_FILE_NAME);
        if (MinerApp.shouldSplusBeHidden() && isSplusLib && new File(ExplorerPane.SETTINGS_DIR + ExplorerPane.SPLUS_LIBRARY_FILE_NAME).exists()) {
            tree = ExplorerPane.getLibrary(ExplorerPane.SPLUS_LIBRARY_FILE_NAME, path);
        } else {
            tree = ExplorerPane.getLibrary(path);
            tree.setEditableFilename(this.m_model.generateUniqueEditName(tree.getEditableFilename()));
        }
        int rowNum = this.m_model.m_editNames.indexOf(tree.getEditableFilename());
        if (rowNum != -1) {
            this.m_table.setRowSelectionInterval(rowNum, rowNum);
        } else {
            this.m_model.addRow(true, tree.getTitle(), path, tree.getEditableFilename());
        }
    }

    private void onNew() {
        String[] pathAndTitle = ExplorerPane.openNewLibrary(this);
        if (pathAndTitle == null) {
            return;
        }
        String editName = this.m_model.generateUniqueEditName(pathAndTitle[0]);
        String origPath = ExplorerPane.SETTINGS_DIR + editName;
        DragAndDropTree tree = new DragAndDropTree();
        tree.setOriginalFilepath(origPath);
        tree.setEditableFilename(editName);
        this.m_model.addRow(true, pathAndTitle[1], origPath, editName);
    }

    private class LibraryFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith("Library.iml") || name.equals(ExplorerPane.EXPLORER_FILE_NAME) || name.equals("UserLibrary.iml");
        }
    }

    private class BooleanRenderer
    implements TableCellRenderer {
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            this.rend.setEnabled(row != table.getRowCount() - 1);
            this.rend.setHorizontalAlignment(0);
            return this.rend;
        }
    }

    private class LibraryTableModel
    extends DefaultTableModel {
        private boolean m_userLibPresent;
        private XTProps m_props;
        private Vector m_filepaths;
        private Vector m_editNames;
        private Vector m_new;

        public LibraryTableModel(ExplorerPane explorer) {
            super(new Object[]{MinerApp.getText("LibraryManagerDialog_show"), MinerApp.getText("LibraryManagerDialog_libraryName"), MinerApp.getText("LibraryManagerDialog_file")}, 0);
            this.m_userLibPresent = true;
            this.m_props = null;
            this.m_filepaths = new Vector();
            this.m_editNames = new Vector();
            this.m_new = new Vector();
            this.m_userLibPresent = false;
            this.m_props = MinerApp.getGlobalOptions();
            Vector editNames = this.m_props.getSubProperties("ExplorerPage");
            Vector origNames = this.m_props.getSubPropertyValues("ExplorerPage");
            String[] libPath = new String[]{"ExplorerPage", "", "show"};
            for (int i = 0; i < origNames.size(); ++i) {
                String origPath = (String)origNames.get(i);
                libPath[1] = (String)editNames.get(i);
                if (libPath[1].equals(ExplorerPane.SPLUS_LIBRARY_FILE_NAME) && MinerApp.shouldSplusBeHidden()) continue;
                boolean showing = this.m_props.getBoolean(libPath, true);
                this.addRowToTable(libPath[1], origPath, showing, false);
            }
            DragAndDropTree uLib = explorer.getUserLibrary();
            this.addRowToTable(uLib.getEditableFilename(), uLib.getOriginalFilepath(), true, false);
            this.m_userLibPresent = true;
        }

        public void addRowToTable(String filename, String origPath, boolean showing, boolean createNewTree) {
            int tabNum = LibraryManagerDialog.this.m_explorerPane.getTabPosition(filename);
            if (tabNum > -1) {
                DragAndDropTree tree = LibraryManagerDialog.this.m_explorerPane.getTreeAtTab(tabNum);
                if (tree != null) {
                    this.addRow(showing, tree.getTitle(), origPath, filename);
                }
            } else {
                XMLTree tree = LibraryManagerDialog.this.getTree(filename, origPath);
                if (tree != null) {
                    this.addRow(showing, LibraryManagerDialog.this.getTitle(tree), origPath, filename);
                }
            }
        }

        public boolean isNewLibrary(String str) {
            String[] path = new String[]{"ExplorerPage", new File(str).getName()};
            boolean noVal = this.m_props.getBoolean(path, false) != this.m_props.getBoolean(path, true);
            int index = this.m_filepaths.indexOf(str);
            if (index > -1 && !((Boolean)this.m_new.get(index)).booleanValue()) {
                return false;
            }
            return noVal;
        }

        public void addRow(boolean include, String libName, String origPath, String editName) {
            this.addRowAt(include, libName, origPath, editName, -1);
        }

        public void addRowAt(boolean include, String libName, String origPath, String editName, int location) {
            Object[] rowData = new Object[]{new Boolean(include), libName, origPath};
            this.addRowAt(rowData, origPath, editName, location);
        }

        private void addRowAt(Object[] data, String origPath, String editName, int location) {
            int num;
            int n = num = location < 0 ? this.getRowCount() : location;
            if (this.m_userLibPresent) {
                --num;
            }
            this.insertRow(num, data);
            this.m_filepaths.insertElementAt(origPath, num);
            this.m_editNames.insertElementAt(editName, num);
            this.m_new.insertElementAt(new Boolean(editName.length() == 0), num);
        }

        public void removeRow(int row) {
            this.m_filepaths.remove(row);
            this.m_editNames.remove(row);
            this.m_new.remove(row);
            super.removeRow(row);
        }

        public String getFilepathAt(int row) {
            return (String)this.m_filepaths.get(row);
        }

        public String getEditNameAt(int row) {
            return (String)this.m_editNames.get(row);
        }

        public boolean isCellEditable(int row, int col) {
            return row < this.getRowCount() - 1 && col == 0;
        }

        public boolean isVisibleLibrary(String library) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!((Boolean)this.getValueAt(i, 0)).booleanValue() || !library.equals(this.getValueAt(i, 1))) continue;
                return true;
            }
            return false;
        }

        public String generateUniqueEditName(String desiredName) {
            String extension = "";
            String fileName = desiredName;
            String tFileName = desiredName;
            int extensionLoc = desiredName.lastIndexOf(".");
            if (extensionLoc > -1) {
                tFileName = fileName = desiredName.substring(0, extensionLoc);
                extension = desiredName.substring(extensionLoc);
            }
            int num = 2;
            String saveDir = ExplorerPane.SETTINGS_DIR;
            File editTree = new File(saveDir + fileName + extension);
            while (this.m_editNames.contains(fileName + extension) || editTree.exists()) {
                fileName = tFileName + Integer.toString(num++);
                editTree = new File(saveDir + fileName + extension);
            }
            return fileName + extension;
        }
    }
}

