/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.BaseNodeLabel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MultiLineDocument;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.dndtree.DragOverData;
import com.nwoods.jgo.JGo3DRect;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoText;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.w3c.dom.Element;

public class MinerTextNode
extends JGoArea
implements Transferable,
DragOverData {
    static final String HELP_TOPIC = "Annotation";
    public static final int LabelChanged = 75556;
    public static final int RectChanged = 75557;
    public static final int InPortChanged = 75558;
    public static final int OutPortChanged = 75559;
    public static final int ObjectChanged = 75560;
    public static final String DEFAULT_TEXT = "New Annotation";
    public String container = null;
    private JGoText myLabel = null;
    private JGoRectangle myRect = null;
    private int m_currentEffect;
    public static DataFlavor nodeFlavor = BaseNodeArea.nodeFlavor;
    private Object myObject = null;

    public MinerTextNode() {
    }

    public MinerTextNode(String s) {
        this.initialize(s);
    }

    public void initialize(String s) {
        this.setResizable(false);
        this.setGrabChildSelection(true);
        this.myRect = new JGo3DRect();
        this.myRect.setSelectable(false);
        this.myLabel = new BaseNodeLabel();
        this.myLabel.setMultiline(true);
        this.myLabel.setSelectable(false);
        this.myLabel.setResizable(false);
        this.myLabel.setDraggable(false);
        this.myLabel.setEditable(true);
        this.myLabel.setEditOnSingleClick(true);
        this.myLabel.setTransparent(true);
        this.myLabel.setText(MultiLineDocument.formatString(s, true));
        this.addObjectAtHead((JGoObject)this.myRect);
        this.addObjectAtTail((JGoObject)this.myLabel);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        MinerTextNode newobj = (MinerTextNode)super.copyObject(env);
        if (newobj != null) {
            newobj.myObject = this.myObject;
        }
        return newobj;
    }

    public void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        MinerTextNode newobj = (MinerTextNode)newarea;
        if (this.myRect != null) {
            newobj.myRect = (JGoRectangle)this.myRect.copyObject(env);
            newobj.addObjectAtHead((JGoObject)newobj.myRect);
        }
        if (this.myLabel != null) {
            newobj.myLabel = (JGoText)this.myLabel.copyObject(env);
            newobj.addObjectAtTail((JGoObject)newobj.myLabel);
        }
    }

    public void showHelp() {
        MinerApp.getHelpManager().showTopic(HELP_TOPIC);
    }

    public XTNetwork.TextNodeInfo createTextNodeInfo() {
        XTNetwork.TextNodeInfo info = new XTNetwork.TextNodeInfo();
        info.labelText = this.getText();
        info.x = this.getTopLeft().x;
        info.y = this.getTopLeft().y;
        info.fontName = this.myLabel.getFaceName();
        info.fontSize = this.myLabel.getFontSize();
        info.italic = this.myLabel.isItalic();
        info.bold = this.myLabel.isBold();
        info.fontColor = this.getTextColor().getRGB();
        info.backgroundColor = this.getBackground().getRGB();
        info.container = this.container;
        return info;
    }

    public static MinerTextNode buildTextNodeFromInfo(XTNetwork.TextNodeInfo info) {
        MinerTextNode mtn = new MinerTextNode(info.labelText);
        mtn.setTopLeft(info.x, info.y);
        mtn.myLabel.setFaceName(info.fontName);
        mtn.myLabel.setFontSize(info.fontSize);
        mtn.myLabel.setItalic(info.italic);
        mtn.myLabel.setBold(info.bold);
        mtn.setTextColor(new Color(info.fontColor));
        mtn.setBackground(new Color(info.backgroundColor));
        return mtn;
    }

    public static MinerTextNode buildTextNodeFromXML(Element xml) {
        XTNetwork.TextNodeInfo info = new XTNetwork.TextNodeInfo();
        info.convertFromXML(xml);
        return MinerTextNode.buildTextNodeFromInfo(info);
    }

    public void setBackground(Color newBk) {
        JGoPen oldPen = this.myRect.getPen();
        JGoPen newPen = new JGoPen(oldPen.getStyle(), oldPen.getWidth(), newBk);
        this.myRect.setPen(newPen);
        JGoBrush oldBrush = this.myRect.getBrush();
        JGoBrush newBrush = new JGoBrush(oldBrush.getStyle(), newBk);
        this.myRect.setBrush(newBrush);
    }

    public void setTextColor(Color newFr) {
        this.myLabel.setTextColor(newFr);
    }

    public void setItalic(boolean i) {
        this.myLabel.setItalic(i);
    }

    public void setBold(boolean b) {
        this.myLabel.setBold(b);
    }

    public void setFont(Font f) {
        this.myLabel.setFaceName(f.getName());
        this.myLabel.setFontSize(f.getSize());
        this.myLabel.setItalic(f.isItalic());
        this.myLabel.setBold(f.isBold());
    }

    public Font getFont() {
        int style = 0;
        if (this.isBold()) {
            style |= 1;
        }
        if (this.isItalic()) {
            style |= 2;
        }
        return new Font(this.myLabel.getFaceName(), style, this.myLabel.getFontSize());
    }

    public Color getBackground() {
        return this.myRect.getPen().getColor();
    }

    public Color getTextColor() {
        return this.myLabel.getTextColor();
    }

    public boolean isItalic() {
        return this.myLabel.isItalic();
    }

    public boolean isBold() {
        return this.myLabel.isBold();
    }

    protected boolean geometryChangeChild(JGoObject child, Rectangle prevRect) {
        if (super.geometryChangeChild(child, prevRect)) {
            if (child == this.getLabel()) {
                this.layoutChildren();
            }
            return true;
        }
        return false;
    }

    protected void layoutChildren() {
        JGoText label = this.getLabel();
        if (label != null && this.getRect() != null) {
            this.getRect().setBoundingRect(label.getLeft() - 2, label.getTop(), label.getWidth() + 4, label.getHeight() + 2);
        }
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc, JGoView view) {
        JGoText lab = this.getLabel();
        if (lab != null && lab.isEditable() && lab.isEditOnSingleClick() && view.getSelection().isInSelection((JGoObject)this)) {
            lab.doStartEdit(view, vc);
            return true;
        }
        return false;
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText lab) {
        JGoText oldLabel = this.getLabel();
        if (oldLabel != lab) {
            if (oldLabel != null) {
                this.removeObject((JGoObject)oldLabel);
            }
            this.myLabel = lab;
            if (lab != null) {
                this.addObjectAtTail((JGoObject)lab);
            }
            this.update(75556, 0, oldLabel);
        }
    }

    public JGoRectangle getRect() {
        return this.myRect;
    }

    public void setRect(JGoRectangle rect) {
        JGoRectangle oldRect = this.getRect();
        if (oldRect != rect) {
            if (oldRect != null) {
                this.removeObject((JGoObject)oldRect);
            }
            this.myRect = rect;
            if (rect != null) {
                this.addObjectAtHead((JGoObject)rect);
            }
            this.update(75557, 0, oldRect);
        }
    }

    public Object getObject() {
        return this.myObject;
    }

    public void setObject(Object obj) {
        Object oldObject = this.getObject();
        if (oldObject != obj) {
            this.myObject = obj;
            this.update(75560, 0, oldObject);
        }
    }

    public String getText() {
        return this.getLabel().getText();
    }

    public void setText(String s) {
        this.getLabel().setText(s);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 75556: {
                e.setNewValue((Object)this.getLabel());
                return;
            }
            case 75557: {
                e.setNewValue((Object)this.getRect());
                return;
            }
            case 75560: {
                e.setNewValue(this.getObject());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 75556: {
                this.setLabel((JGoText)e.getValue(undo));
                return;
            }
            case 75557: {
                this.setRect((JGoRectangle)e.getValue(undo));
                return;
            }
            case 75560: {
                this.setObject(e.getValue(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{nodeFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(nodeFlavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(nodeFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void setCurrentEffect(int eff) {
        this.m_currentEffect = eff;
    }

    public int getCurrentEffect() {
        return this.m_currentEffect;
    }
}

