/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;

public class PredictorPort
extends JGoPort {
    private static Rectangle DEFAULT_RECTANGLE = new Rectangle(0, 0, 6, 6);
    private Cursor portCursor = new Cursor(12);
    private Rectangle myHitTestRect = new Rectangle();
    private boolean m_singleLink = true;

    public PredictorPort() {
    }

    public PredictorPort(JGoArea parent, ActivityNodeModel model) {
        super(DEFAULT_RECTANGLE);
        this.setSelectable(false);
        this.setDraggable(false);
        this.setResizable(false);
        boolean importable = model instanceof PMMLImportable;
        boolean exportable = model instanceof PMMLExportable;
        boolean visible = exportable || importable;
        this.setVisible(visible);
        this.setValidSource(exportable);
        this.setValidDestination(importable);
        this.setStyle(2);
        this.setPen(JGoPen.darkGray);
        this.setBrush(JGoBrush.lightGray);
        parent.addObjectAtHead((JGoObject)this);
    }

    public boolean alreadyLinked(JGoPort dst) {
        JGoListPosition pos = this.getFirstLinkPos();
        while (pos != null) {
            JGoLink link = this.getLinkAtPos(pos);
            if (link.getToPort() == dst) {
                return true;
            }
            pos = this.getNextLinkPos(pos);
        }
        return false;
    }

    void setValidLink(boolean valid) {
        if (valid) {
            this.setFlags(this.getFlags() | 0x8000);
        } else {
            this.setFlags(this.getFlags() & 0xFFFF7FFF);
        }
    }

    public boolean validLink(JGoPort to) {
        if (to instanceof PredictorPort) {
            boolean thatIsInputValidLink;
            boolean noLinksCurrently;
            PredictorPort that = (PredictorPort)to;
            PredictorPort this_one = this;
            BaseNodeArea thatArea = (BaseNodeArea)that.getParent();
            BaseNodeArea thisArea = (BaseNodeArea)this_one.getParent();
            if (thisArea == thatArea) {
                return false;
            }
            JGoListPosition pos = that.getFirstLinkPos();
            boolean bl = noLinksCurrently = pos == null;
            if (!noLinksCurrently) {
                noLinksCurrently = that.getLinkAtPos(pos).getFromPort().getParent() == null;
            }
            boolean bl2 = thatIsInputValidLink = that.isValidDestination() && (!that.m_singleLink || noLinksCurrently) && this.isValidSource();
            if (!thatIsInputValidLink) {
                return false;
            }
            if (this.alreadyLinked(that)) {
                return false;
            }
            return super.validLink(to);
        }
        return false;
    }

    public String getToolTipText() {
        String toolTip = ((BaseNodeArea)this.getParent()).getLabel().getText() + ": ";
        String end = (this.isValidDestination() ? "Input " : "Output ") + "PMML";
        return toolTip + end;
    }

    public boolean doUncapturedMouseMove(int flags, Point dc, Point vc, JGoView view) {
        view.setCursor(this.portCursor);
        return true;
    }

    public void setBoundingRect(int x, int y, int width, int height) {
        super.setBoundingRect(x, y, width, height);
        this.myHitTestRect = new Rectangle(x, y - height / 2, 2 * width, 2 * height);
        if (this.isValidDestination()) {
            this.myHitTestRect.x -= width;
        }
    }

    public boolean isPointInObj(Point pnt) {
        return this.myHitTestRect.contains(pnt.x, pnt.y);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        PredictorPort newobj = (PredictorPort)super.copyObject(env);
        newobj.m_singleLink = this.m_singleLink;
        return newobj;
    }
}

