/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadExcelFileDialog
extends ReadOtherFileDialog {
    private JTextField m_worksheetTextField;
    private static String[] m_typeCodeList = new String[]{"EXCEL", "EXCELX"};
    private static String[] m_typeDescriptionList = new String[]{"Microsoft Excel (*.xls)", "Microsoft Excel 2007 (*.xlsx)"};
    private static String[][] m_extensionList = new String[][]{{".xls"}, {".xlsx"}};
    private static ReadExcelFileDialog m_ReadExcelFileDialog = null;

    public static ReadExcelFileDialog getReadExcelFileDialog() {
        if (m_ReadExcelFileDialog == null) {
            m_ReadExcelFileDialog = new ReadExcelFileDialog();
        }
        return m_ReadExcelFileDialog;
    }

    protected ReadExcelFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        String worksheet = props.getValue("worksheet");
        this.m_worksheetTextField.setText(worksheet);
        String currentPath = props.getValue("filePath");
        this.m_fileNameTextField.setText(currentPath);
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        String worksheet = this.m_worksheetTextField.getText();
        props.set("worksheet", worksheet);
        props.set("fileType", m_typeCodeList[0]);
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadExcelFileDialog.this.m_fileNameTextField, m_extensionList, ReadExcelFileDialog.this.m_typeComboBox);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadExcelFileDialog.this.m_fileNameTextField, m_extensionList, null);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadExcelFileDialog, ReadExcelFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel worksheetLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_worksheet"));
        worksheetLabel.setDisplayedMnemonic(MinerApp.getText("ReadOtherFileDialog_worksheetHotkey").charAt(0));
        this.m_worksheetTextField = new JTextField(25);
        worksheetLabel.setLabelFor(this.m_worksheetTextField);
        JButton wrkshtBrowse = new JButton(new AbstractAction(MinerApp.getText("ReadExcelFileDialog_selectSheet")){

            public void actionPerformed(ActionEvent e) {
                ReadExcelFileDialog.this.browseExcelPages();
            }
        });
        wrkshtBrowse.setMnemonic(MinerApp.getText("ReadExcelFileDialog_selectSheetHotkey").charAt(0));
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('t');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        Insets noIndent = new Insets(0, 0, 0, 8);
        Insets indent = new Insets(0, 5, 0, 8);
        int gridy = 1;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)worksheetLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_worksheetTextField, optionsConstraints);
        optionsConstraints.gridx = 2;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        moreOptionsPanel.add((Component)wrkshtBrowse, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        topPanel.add((Component)this.createSamplePanel(true), "South");
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)this.createPreviewPanel(), "Center");
        return optionsPanel;
    }

    public void browseExcelPages() {
        try {
            ActivityNodeModel model = this.getNodeModel();
            XTProps currentProps = this.getCurrentFileProperties();
            currentProps.removeProperty(new String[]{"worksheet"});
            this.getNodeModel().saveGuiNetworkToEngine();
            if (this.getNodeModel().getDocument().isDummyEngineConnection()) {
                return;
            }
            String[] pageList = (String[])model.sendMessageToEngine("getExcelPageList", new Object[]{currentProps});
            XTProps dataInfo = (XTProps)model.sendMessageToEngine("getNodeCacheXTProps", new Object[]{"datasourceInfo"});
            ReadOtherFileDialog.checkForErrorInDataSourceProps(this, dataInfo, "", false);
            if (pageList != null && pageList.length > 0) {
                WorksheetSelectionDialog dlg = new WorksheetSelectionDialog(this, pageList, this.m_worksheetTextField);
                dlg.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ScrollingPane
    extends NodeDialog.SortingScrollPane {
        private String[] m_dataSet;

        public ScrollingPane(NodeDialog.DNDList list, String[] dataSet) {
            super(list);
            this.m_dataSet = dataSet;
        }

        public void sort() {
            if (this.currentComparator == null) {
                NodeDialog.DNDListModel model = (NodeDialog.DNDListModel)this.list.getModel();
                model.removeAllElements();
                model.addElements(this.m_dataSet);
            } else {
                super.sort();
            }
        }

        protected void setComparators() {
            this.azSortCompare = new myAZSortComparator();
            this.zaSortCompare = new myZASortComparator();
        }

        class myAZSortComparator
        implements Comparator {
            myAZSortComparator() {
            }

            public int compare(Object o1, Object o2) {
                String str1 = o1.toString();
                String str2 = o2.toString();
                return str1.compareTo(str2);
            }
        }

        class myZASortComparator
        implements Comparator {
            myZASortComparator() {
            }

            public int compare(Object o1, Object o2) {
                String str1 = o1.toString();
                String str2 = o2.toString();
                return str2.compareTo(str1);
            }
        }
    }

    static class WorksheetSelectionDialog
    extends JDialog {
        private JTextField m_worksheetTextField;
        private NodeDialog.DNDList m_list;

        public WorksheetSelectionDialog(NodeDialog dialog, String[] worksheetList, JTextField worksheetTextField) {
            super(dialog, MinerApp.getText("ReadExcelFileDialog_selectWorksheetDialog"), true);
            this.m_worksheetTextField = worksheetTextField;
            NodeDialog.DNDListModel model = new NodeDialog.DNDListModel();
            model.addElements(worksheetList);
            this.m_list = new NodeDialog.DNDList(model);
            ScrollingPane sp = new ScrollingPane(this.m_list, worksheetList);
            JButton ok = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_ok")){

                public void actionPerformed(ActionEvent e) {
                    String str = (String)WorksheetSelectionDialog.this.m_list.getSelectedValue();
                    if (str != null && str.length() > 0) {
                        WorksheetSelectionDialog.this.m_worksheetTextField.setText(str);
                    }
                    WorksheetSelectionDialog.this.dispose();
                }
            });
            ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
            JButton cancel = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_cancel")){

                public void actionPerformed(ActionEvent e) {
                    WorksheetSelectionDialog.this.dispose();
                }
            });
            cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
            JButton help = new JButton(new AbstractAction(MinerApp.getText("NodeDialog_help")){

                public void actionPerformed(ActionEvent e) {
                    String str = MinerApp.getText("ReadExcelFileDialog_selectWorksheetDialog");
                    MinerApp.getHelpManager().showTopic(str);
                }
            });
            help.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
            JPanel listPanel = new JPanel(new BorderLayout());
            listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadExcelFileDialog_selectWorksheet")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            listPanel.add((Component)sp, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(ok);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(cancel);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(help);
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            container.add((Component)listPanel, gbc);
            gbc.fill = 2;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(10, 0, 5, 0);
            container.add((Component)buttonsPanel, gbc);
            this.setSize(350, 400);
            this.setLocationRelativeTo(dialog);
        }
    }
}

