/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcRpart;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNode;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.TreeCollection;
import com.insightful.miner.tree.model.TreePredictor;
import java.io.File;
import java.util.Vector;

public class RegressionRpartEngineNode
extends EngineNode {
    public static final String MINSIZE_ATTRIBUTE_TAG = "min.size";
    public static final String MINCUT_ATTRIBUTE_TAG = "min.cut";
    public static final String MIN_DEVIANCE_ATTRIBUTE_TAG = "min.dev";
    public static final String NTREES_ATTRIBUTE_TAG = "n.trees";
    public static final String TREE_ENSEMBLE_ATTRIBUTE_TAG = "tree.ensemble";
    public static final String TREE_SPLIT_ENTROPY_ATTRIBUTE_TAG = "split.entropy";
    public static final String SINGLE_TREE_MAXIMUM_ROWS_ATTRIBUTE_TAG = "max.rows";
    public static final String COMPLEXITY_ATTRIBUTE_TAG = "cp";
    public static final String CROSSVALIDATE_K_ATTRIBUTE_TAG = "CV.k";
    public static final String PRUNING_CRITERION_ATTRIBUTE_TAG = "prune.criterion";
    public static final String ROWS_PER_TREE_ATTRIBUTE_TAG = "rows.per.tree";
    public static final boolean TREE_ENSEMBLE_DEFAULT = false;
    public static final boolean TREE_SPLIT_ENTROPY_DEFAULT = true;
    public static final int MINSIZE_DEFAULT = 10;
    public static final int MINCUT_DEFAULT = 5;
    public static final int NTREES_DEFAULT = 10;
    public static final int ROWS_PER_TREE_DEFAULT = 10000;
    public static final double MIN_DEVIANCE_DEFAULT = 0.01;
    public static final int PRUNING_CRITERION_DEFAULT = 0;
    public static final int CROSSVALIDATE_K_DEFAULT = 0;
    public static final double COMPLEXITY_DEFAULT = 0.001;
    public static final int SINGLE_TREE_MAXIMUM_ROWS_DEFAULT = 10000;
    private String m_xmlFileName = null;
    private boolean m_xmlFileOK = false;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean isRegression() {
        return true;
    }

    public void procExtractResults(CNKProc proc) {
        if (proc instanceof CNKProcRpart) {
            if (this.m_xmlFileName == null) {
                return;
            }
            this.setNodeCache("model", null);
            File fil = new File(this.m_xmlFileName);
            if (!fil.exists()) {
                this.printlnDebug("tree xml file " + this.m_xmlFileName + " doesn't exist");
                return;
            }
            long totalBytes = fil.length();
            this.printlnInformation("reading tree model xml file " + this.m_xmlFileName + " (" + totalBytes + " bytes)");
            XMLTree xt = null;
            try {
                xt = XMLTree.readFromFile(this.m_xmlFileName);
                this.m_xmlFileOK = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.printlnError("error reading tree model xml file " + this.m_xmlFileName + ": " + ex);
            }
            this.setNodeCache("model", xt);
        }
    }

    public void procDelete(CNKProc proc) {
        if (proc instanceof CNKProcRpart && this.m_xmlFileName != null) {
            File fl = new File(this.m_xmlFileName);
            if (fl.exists()) {
                this.printlnDebug("deleting tree model xml file " + this.m_xmlFileName);
                fl.delete();
            } else {
                this.printlnDebug("deleting tree model xml file " + this.m_xmlFileName + " (non-existant)");
            }
        }
        if (proc != null) {
            proc.destroyCNKObj();
        }
    }

    public Vector getOutputSpecs() {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        String depVar = this.getDepVar(props, md);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(md, props, depVar, indepVars);
        return outputSpecs;
    }

    public boolean isDataCacheProcOutputMetaDataComplete(int outputNum) {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        return this.executeRpartProc(false);
    }

    public String getDataDictionaryAsString() throws Exception {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        Vector varNames = PredictEngineNode.getIndependentVars(props, md);
        String depCol = this.getDepVar(props, md);
        Vector allNames = varNames;
        allNames.add(depCol);
        String weights = props.getValue("weightedColumn");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            allNames.add(weights);
        }
        XTMetaData mdModel = md.selectiveClone(allNames);
        for (int i = 0; i < varNames.size(); ++i) {
            mdModel.setDataFieldRole((String)varNames.get(i), "independent");
        }
        mdModel.setDataFieldRole(depCol, "dependent");
        if (weights.length() > 0 && weights.charAt(0) != ' ') {
            mdModel.setDataFieldRole(weights, "weights");
        }
        return mdModel.writeToString();
    }

    protected String getDepVar(XTProps props, XTMetaData md) {
        return PredictEngineNode.getFirstDependentVar(props, md, XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
    }

    public boolean executeRpartProc(boolean doClassification) throws Exception {
        XTMetaData md;
        boolean ok = true;
        XTProps props = this.getNodeProperties();
        String depVar = this.getDepVar(props, md = this.getInputMetaData(0));
        if (depVar == null) {
            throw new Exception("can't create tree: no dependent variable");
        }
        String depVarType = this.getInputMetaData(0).getColumnType(depVar);
        if (doClassification && !XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG.equals(depVarType)) {
            throw new Exception("can't create classification tree: dependent variable " + depVar + " not categorical!");
        }
        if (!doClassification && !XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG.equals(depVarType)) {
            throw new Exception("can't create regression tree: dependent variable " + depVar + " not continuous!");
        }
        this.setNodeCache("model", null);
        String modelXML = this.getDataDictionaryAsString();
        File tempFile = this.createWorkspaceTempFile("tree", ".xml");
        this.m_xmlFileName = tempFile.getPath();
        String origText = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        String str = origText + ": Building model...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        CNKProcRpart proc1 = new CNKProcRpart();
        int minSize = props.getInt(MINSIZE_ATTRIBUTE_TAG, 10);
        int minCut = props.getInt(MINCUT_ATTRIBUTE_TAG, 5);
        boolean entropy = this.isRegression() ? false : props.getBoolean(TREE_SPLIT_ENTROPY_ATTRIBUTE_TAG, true);
        int seed = (int)(this.getRandomSeed() & 0xFFFFL);
        proc1.setRpartProperties(modelXML, minSize, minCut, entropy, seed);
        if (props.getBoolean(TREE_ENSEMBLE_ATTRIBUTE_TAG, false)) {
            int ntrees = props.getInt(NTREES_ATTRIBUTE_TAG, 10);
            int nrow = props.getInt(ROWS_PER_TREE_ATTRIBUTE_TAG, 10000);
            double mindev = props.getDouble(MIN_DEVIANCE_ATTRIBUTE_TAG, 0.01);
            proc1.setRpartEnsembleProperties(ntrees, nrow, mindev);
        } else {
            int maxRows = props.getInt(SINGLE_TREE_MAXIMUM_ROWS_ATTRIBUTE_TAG, 10000);
            double cp = props.getDouble(COMPLEXITY_ATTRIBUTE_TAG, 0.001);
            int kCV = props.getInt(CROSSVALIDATE_K_ATTRIBUTE_TAG, 0);
            int prune = props.getInt(PRUNING_CRITERION_ATTRIBUTE_TAG, 0);
            proc1.setRpartSingleProperties(maxRows, cp, kCV, prune);
        }
        proc1.setFile(this.m_xmlFileName);
        this.printlnVerbose("creating tree model");
        this.m_xmlFileOK = false;
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc1);
        this.procDelete(proc1);
        if (!ok || !this.m_xmlFileOK) {
            return false;
        }
        Vector outputSpecs = this.getOutputSpecs();
        PredictEngineNode.isConflictingIO(outputSpecs, this);
        if (outputSpecs.size() < 1) {
            return ok;
        }
        str = origText + ": Predicting...";
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{str});
        XMLTree tree = this.getNodeCache("model");
        if (tree == null) {
            this.printlnError("no tree model for prediction!");
            return false;
        }
        String idString = this.getNetworkManager().getWorksheetID();
        TreeCollection treeColl = new TreeCollection(tree, this.getInputMetaData(0), Integer.parseInt(this.getNodeID()), idString);
        TreePredictor treePredictor = new TreePredictor(treeColl);
        treePredictor.setOutputSpecs(outputSpecs);
        treePredictor.initExecute();
        CNKProcJavaTransform proc2 = new CNKProcJavaTransform();
        proc2.setExecObject(treePredictor);
        this.printlnVerbose("generating prediction from training data.");
        ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc2);
        this.procDelete(proc2);
        EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{origText});
        return ok;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }
}

