/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;

public class SelectColumnsPanel
extends JPanel {
    protected NodeDialog.SortingScrollPane incomingScrollPane;
    protected NodeDialog.SortingScrollPane outgoingScrollPane;
    protected NodeDialog.DNDListModel incomingListModel;
    protected NodeDialog.DNDList incomingList;
    protected NodeDialog.DNDListModel outgoingListModel;
    protected NodeDialog.DNDList outgoingList;
    private JLabel incomingColumnsLabel;
    private JLabel outgoingColumnsLabel;
    private Vector excludedColumnTypes = new Vector();
    private static final String addString = "SelectColumnsPanel_add";
    private static final String addAllString = "SelectColumnsPanel_addAll";
    private static final String removeString = "SelectColumnsPanel_remove";
    private static final String removeAllString = "SelectColumnsPanel_removeAll";
    private static final String availableColumnsString = "SelectColumnsPanel_availableColumns";
    private static final String selectedColumnsString = "SelectColumnsPanel_selectedColumns";
    private static final String addHotkeyString = "SelectColumnsPanel_addHotkey";
    private static final String addAllHotkeyString = "SelectColumnsPanel_addAllHotkey";
    private static final String removeHotkeyString = "SelectColumnsPanel_removeHotkey";
    private static final String removeAllHotkeyString = "SelectColumnsPanel_removeAllHotkey";
    private static final String selectColumnsString = "SelectColumnsPanel_selectColumns";
    public static final String ROLE_ATTRIBUTE_TAG = "role";
    public static final String OUTGOING_COLUMNS_ATTRIBUTE_TAG = "outgoingColumns";
    private String propertyString = "outgoingColumns";
    private AbstractAction addAction;
    private AbstractAction removeAction;
    private AbstractAction addAllAction;
    private AbstractAction removeAllAction;
    private AbstractAction okAction;

    public SelectColumnsPanel(AbstractAction okAction) {
        this.okAction = okAction;
        this.createActions();
        this.createLayout();
    }

    public SelectColumnsPanel(AbstractAction okAction, String firstListTitle, String secondListTitle) {
        this(okAction);
        this.incomingColumnsLabel.setText(firstListTitle);
        this.outgoingColumnsLabel.setText(secondListTitle);
        this.repaint();
    }

    public SelectColumnsPanel(AbstractAction okAction, String firstListTitle, String secondListTitle, String newPropertyString) {
        this(okAction, firstListTitle, secondListTitle);
        this.propertyString = newPropertyString;
    }

    public SelectColumnsPanel(AbstractAction okAction, String newPropertyString) {
        this(okAction);
        this.propertyString = newPropertyString;
    }

    public void setExcludedColumnType(String type) {
        this.excludedColumnTypes.add(type);
    }

    public void restoreProperties(ActivityNodeModel model) {
        int i;
        this.incomingListModel.removeAllElements();
        this.outgoingListModel.removeAllElements();
        XTProps props = model.getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = model.getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propNames = props.getSubProperties(this.propertyString);
        String[] path = new String[]{this.propertyString, ""};
        for (i = 0; i < names.size(); ++i) {
            String type = (String)types.get(i);
            if (this.excludedColumnTypes.contains(type)) continue;
            path[1] = (String)names.get(i);
            if (props.isPathValid(path)) continue;
            String role = (String)roles.get(i);
            this.incomingListModel.addElement(new NodeDialog.ColumnInformationObject(path[1], type, role, false, i));
        }
        for (i = 0; i < propNames.size(); ++i) {
            String type;
            String name = (String)propNames.get(i);
            int pos = metaData.nameToOrdinal(name);
            if (pos == -1 || this.excludedColumnTypes.contains(type = metaData.getColumnType(name))) continue;
            String role = metaData.getColumnRole(name);
            this.outgoingListModel.addElement(new NodeDialog.ColumnInformationObject(name, type, role, false, pos));
        }
    }

    public void saveProperties(ActivityNodeModel model) {
        XTProps props = model.getXTProps();
        props.removeProperty(new String[]{this.propertyString});
        String[] path = new String[]{this.propertyString, "", ROLE_ATTRIBUTE_TAG};
        int size = this.outgoingListModel.getSize();
        for (int i = 0; i < size; ++i) {
            NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)this.outgoingListModel.getElementAt(i);
            String name = object.getText();
            String type = object.getType();
            String role = object.getRole();
            props.set(this.propertyString, name, type);
            path[1] = name;
            props.set(path, role);
        }
    }

    public Object[] getOutputColumns() {
        return this.outgoingListModel.toArray();
    }

    public Object[] getInputColumns() {
        return this.incomingListModel.toArray();
    }

    public String[] getInputColumnNames() {
        Object[] o = this.incomingListModel.toArray();
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = ((NodeDialog.ColumnInformationObject)o[i]).getText();
        }
        return s;
    }

    public Object[] getSelectedInputColumns() {
        return this.incomingList.getSelectedValues();
    }

    public String[] getSelectedInputColumnNames() {
        Object[] o = this.incomingList.getSelectedValues();
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = ((NodeDialog.ColumnInformationObject)o[i]).getText();
        }
        return s;
    }

    public void addListSelectionListenerToInputColumns(ListSelectionListener listener) {
        this.incomingList.addListSelectionListener(listener);
    }

    public void addListSelectionListenerToOutputColumns(ListSelectionListener listener) {
        this.outgoingList.addListSelectionListener(listener);
    }

    public void createActions() {
        this.addAction = new AbstractAction(MinerApp.getText(addString)){

            public void actionPerformed(ActionEvent e) {
                if (!SelectColumnsPanel.this.incomingListModel.isEmpty()) {
                    Object[] values = SelectColumnsPanel.this.incomingList.getSelectedValues();
                    int[] indices = SelectColumnsPanel.this.incomingList.getSelectedIndices();
                    SelectColumnsPanel.this.incomingList.getSelectionModel().clearSelection();
                    SelectColumnsPanel.this.outgoingListModel.addElements(values);
                    SelectColumnsPanel.this.incomingListModel.removeElementsAt(indices);
                    SelectColumnsPanel.this.outgoingScrollPane.sort();
                    values = null;
                    indices = null;
                    if (!SelectColumnsPanel.this.outgoingListModel.isEmpty() && !SelectColumnsPanel.this.okAction.isEnabled()) {
                        SelectColumnsPanel.this.okAction.setEnabled(true);
                    }
                    SelectColumnsPanel.this.repaint();
                    SelectColumnsPanel.this.updateLists();
                }
            }
        };
        this.removeAction = new AbstractAction(MinerApp.getText(removeString)){

            public void actionPerformed(ActionEvent e) {
                if (!SelectColumnsPanel.this.outgoingListModel.isEmpty()) {
                    Object[] values = SelectColumnsPanel.this.outgoingList.getSelectedValues();
                    int[] indices = SelectColumnsPanel.this.outgoingList.getSelectedIndices();
                    SelectColumnsPanel.this.outgoingList.getSelectionModel().clearSelection();
                    SelectColumnsPanel.this.outgoingListModel.removeElementsAt(indices);
                    SelectColumnsPanel.this.incomingListModel.addElements(values);
                    SelectColumnsPanel.this.incomingScrollPane.sort();
                    values = null;
                    indices = null;
                    SelectColumnsPanel.this.repaint();
                    SelectColumnsPanel.this.updateLists();
                }
            }
        };
        this.addAllAction = new AbstractAction(MinerApp.getText(addAllString)){

            public void actionPerformed(ActionEvent e) {
                if (!SelectColumnsPanel.this.incomingListModel.isEmpty()) {
                    Object[] values = SelectColumnsPanel.this.incomingListModel.toArray();
                    SelectColumnsPanel.this.outgoingListModel.addElements(values);
                    SelectColumnsPanel.this.incomingListModel.removeAllElements();
                    SelectColumnsPanel.this.outgoingScrollPane.sort();
                    values = null;
                    SelectColumnsPanel.this.updateLists();
                }
            }
        };
        this.removeAllAction = new AbstractAction(MinerApp.getText(removeAllString)){

            public void actionPerformed(ActionEvent e) {
                if (!SelectColumnsPanel.this.outgoingListModel.isEmpty()) {
                    Object[] objects = SelectColumnsPanel.this.outgoingListModel.toArray();
                    SelectColumnsPanel.this.incomingListModel.addElements(objects);
                    SelectColumnsPanel.this.outgoingListModel.removeAllElements();
                    SelectColumnsPanel.this.incomingScrollPane.sort();
                    objects = null;
                    SelectColumnsPanel.this.repaint();
                    SelectColumnsPanel.this.updateLists();
                }
            }
        };
    }

    private void createLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText(selectColumnsString)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Dimension listDim = new Dimension(100, 200);
        this.incomingColumnsLabel = new JLabel(MinerApp.getText(availableColumnsString) + ":");
        this.incomingListModel = new NodeDialog.DNDListModel();
        this.incomingList = new NodeDialog.DNDList(this.incomingListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.incomingList.setCellRenderer(renderer);
        this.incomingList.setSelectionMode(2);
        this.incomingScrollPane = new NodeDialog.SortingScrollPane(this.incomingList);
        this.incomingScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.incomingScrollPane.setPreferredSize(listDim);
        constraints.anchor = 18;
        this.add((Component)this.incomingColumnsLabel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 0.5;
        constraints.fill = 1;
        constraints.gridheight = 0;
        this.add((Component)this.incomingScrollPane, constraints);
        Dimension buttonSize = new Dimension(125, 25);
        JButton addButton = new JButton(this.addAction);
        addButton.setMnemonic(65);
        addButton.setPreferredSize(buttonSize);
        JButton removeButton = new JButton(this.removeAction);
        removeButton.setMnemonic(82);
        removeButton.setPreferredSize(buttonSize);
        JButton addAllButton = new JButton(this.addAllAction);
        addAllButton.setMnemonic(68);
        addAllButton.setPreferredSize(buttonSize);
        JButton removeAllButton = new JButton(this.removeAllAction);
        removeAllButton.setMnemonic(77);
        removeAllButton.setPreferredSize(buttonSize);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)addButton, constraints);
        constraints.gridy = 2;
        this.add((Component)addAllButton, constraints);
        constraints.gridy = 3;
        this.add((Component)removeButton, constraints);
        constraints.gridy = 4;
        this.add((Component)removeAllButton, constraints);
        this.outgoingColumnsLabel = new JLabel(MinerApp.getText(selectedColumnsString) + ":");
        this.outgoingListModel = new NodeDialog.DNDListModel();
        this.outgoingList = new NodeDialog.DNDList(this.outgoingListModel);
        this.outgoingList.setCellRenderer(renderer);
        this.outgoingList.setSelectionMode(2);
        this.outgoingScrollPane = new NodeDialog.SortingScrollPane(this.outgoingList);
        this.outgoingList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && SelectColumnsPanel.this.removeAction.isEnabled()) {
                    SelectColumnsPanel.this.removeAction.actionPerformed(new ActionEvent(SelectColumnsPanel.this, 0, "Remove"));
                }
            }
        });
        this.outgoingScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outgoingScrollPane.setPreferredSize(listDim);
        constraints.gridy = 0;
        constraints.gridx = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        this.add((Component)this.outgoingColumnsLabel, constraints);
        constraints.gridy = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridheight = 0;
        this.add((Component)this.outgoingScrollPane, constraints);
    }

    public void updateLists() {
    }
}

