/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.SplusGraphNodeDialog;
import com.insightful.miner.graphdlg.AxesPage;
import com.insightful.miner.graphdlg.FilePage;
import com.insightful.miner.graphdlg.MultipanelPage;
import com.insightful.miner.graphdlg.TitlesPage;
import com.insightful.miner.graphdlg.controls.MinerBoxFiller;
import com.insightful.miner.graphdlg.controls.MinerComboBox;
import com.insightful.miner.graphdlg.controls.MinerDataColumnComboBox;
import com.insightful.miner.graphdlg.controls.MinerDataColumnListBox;
import com.insightful.miner.graphdlg.controls.MinerGroupPanel;
import com.insightful.miner.graphdlg.controls.MinerTextField;
import com.insightful.miner.graphdlg.controls.MinerWideBoxFiller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class HexbinPlotDialog
extends SplusGraphNodeDialog {
    MinerDataColumnComboBox xColumn;
    MinerDataColumnComboBox yColumn;
    MinerDataColumnComboBox groupVar;
    MinerDataColumnListBox conditionColumnList;
    MinerTextField plotShape;
    MinerTextField plotXbins;
    MinerComboBox regressionType;
    MinerComboBox smoothType;
    MinerComboBox smoothLoessDegree;
    MinerComboBox smoothLoessFamily;
    MinerComboBox smoothSplineDf;
    MinerTextField smoothNumPts;
    MinerTextField smoothLoessSpan;
    private static HexbinPlotDialog instance = null;

    protected HexbinPlotDialog() {
    }

    public static HexbinPlotDialog getInstance() {
        if (instance == null) {
            instance = new HexbinPlotDialog();
        }
        return instance;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> tabVec = new Vector<JPanel>();
        this.getFunctionInfo().setFunctionName("menuHexplot");
        JPanel modelPage = new JPanel();
        modelPage.setName(ChartBuilder.getText("graph_dialog_data_text"));
        tabVec.add(modelPage);
        Box modelBottomPanel = new Box(0);
        modelPage.setLayout(new BoxLayout(modelPage, 1));
        modelPage.add(modelBottomPanel);
        MinerGroupPanel variablesGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_columns_text"));
        modelBottomPanel.add(variablesGroup);
        Box varTopPanel = new Box(0);
        Box varTopLeftColumn = new Box(1);
        Box varTopRightColumn = new Box(1);
        variablesGroup.add(varTopPanel);
        varTopPanel.add(varTopLeftColumn);
        varTopPanel.add(varTopRightColumn);
        this.xColumn = new MinerDataColumnComboBox(ChartBuilder.getText("graph_dialog_xaxis_value"), 'x', this.getColumnListProvider());
        this.xColumn.setValue("");
        varTopLeftColumn.add(this.xColumn);
        this.getFunctionInfo().add(this.xColumn, "xColumn", true);
        this.yColumn = new MinerDataColumnComboBox(ChartBuilder.getText("graph_dialog_yaxis_value"), 'y', this.getColumnListProvider());
        this.yColumn.setValue("");
        varTopLeftColumn.add(this.yColumn);
        this.getFunctionInfo().add(this.yColumn, "yColumn", true);
        varTopLeftColumn.add(new MinerBoxFiller(2));
        this.conditionColumnList = new MinerDataColumnListBox(ChartBuilder.getText("graph_dialog_conditioning"), 'C', this.getColumnListProvider());
        this.conditionColumnList.setPrepend(new String[]{"<NONE>"});
        this.conditionColumnList.setValue("<NONE>");
        varTopRightColumn.add(this.conditionColumnList);
        this.getFunctionInfo().add(this.conditionColumnList, "condColumnList", true, true);
        modelPage.add(this.getSampleGroup());
        modelPage.add(new MinerWideBoxFiller());
        JPanel optionsPage = new JPanel();
        optionsPage.setName(ChartBuilder.getText("graph_dialog_plot_text"));
        tabVec.add(optionsPage);
        Box optionsLeftColumn = new Box(1);
        Box optionsRightColumn = new Box(1);
        optionsPage.setLayout(new BoxLayout(optionsPage, 0));
        optionsPage.add(optionsLeftColumn);
        optionsPage.add(optionsRightColumn);
        MinerGroupPanel plotTypeGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_hexagonal_bins"));
        optionsLeftColumn.add(plotTypeGroup);
        this.plotShape = new MinerTextField(ChartBuilder.getText("graph_dialog_shape_text"), 'P');
        this.plotShape.setValue("1.0");
        plotTypeGroup.add(this.plotShape);
        this.getFunctionInfo().add(this.plotShape, "shape");
        this.plotXbins = new MinerTextField(ChartBuilder.getText("graph_dialog_x_bins"), 'X');
        this.plotXbins.setValue("30");
        plotTypeGroup.add(this.plotXbins);
        this.getFunctionInfo().add(this.plotXbins, "xbins");
        optionsLeftColumn.add(new MinerBoxFiller());
        JPanel smoothPage = new JPanel();
        smoothPage.setName(ChartBuilder.getText("graph_dialog_fit_text"));
        tabVec.add(smoothPage);
        Box smoothLeftColumn = new Box(1);
        Box smoothRightColumn = new Box(1);
        smoothPage.setLayout(new BoxLayout(smoothPage, 0));
        smoothPage.add(smoothLeftColumn);
        smoothPage.add(smoothRightColumn);
        MinerGroupPanel regressionTypeGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_regression_text"));
        smoothLeftColumn.add(regressionTypeGroup);
        this.regressionType = new MinerComboBox(ChartBuilder.getText("graph_dialog_regression_type"), 'R', new String[]{"None", "Least Squares"});
        this.regressionType.setValue("None");
        this.regressionType.setEditable(false);
        regressionTypeGroup.add(this.regressionType);
        this.getFunctionInfo().add(this.regressionType, "regressionType", true);
        MinerGroupPanel smoothTypeGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_smooth_text"));
        smoothLeftColumn.add(smoothTypeGroup);
        this.smoothType = new MinerComboBox(ChartBuilder.getText("graph_dialog_smooth_type"), 'S', new String[]{"None", "Loess", "Smoothing Spline"});
        this.smoothType.setValue("None");
        this.smoothType.setEditable(false);
        smoothTypeGroup.add(this.smoothType);
        this.getFunctionInfo().add(this.smoothType, "smoothType", true);
        this.smoothNumPts = new MinerTextField(ChartBuilder.getText("graph_dialog_num_output_points"), 'P');
        this.smoothNumPts.setEnabled(false);
        smoothTypeGroup.add(this.smoothNumPts);
        this.getFunctionInfo().add(this.smoothNumPts, "smoothNumPts", true);
        smoothLeftColumn.add(new MinerBoxFiller());
        MinerGroupPanel loessGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_loess_specs"));
        smoothRightColumn.add(loessGroup);
        this.smoothLoessSpan = new MinerTextField(ChartBuilder.getText("graph_dialog_span_text"), 'S');
        this.smoothLoessSpan.setValue("0.75");
        this.smoothLoessSpan.setEnabled(false);
        loessGroup.add(this.smoothLoessSpan);
        this.getFunctionInfo().add(this.smoothLoessSpan, "smoothLoessSpan");
        this.smoothLoessDegree = new MinerComboBox(ChartBuilder.getText("graph_dialog_degree_text"), 'D', new String[]{"One", "Two"});
        this.smoothLoessDegree.setValue("One");
        this.smoothLoessDegree.setEditable(false);
        this.smoothLoessDegree.setEnabled(false);
        loessGroup.add(this.smoothLoessDegree);
        this.getFunctionInfo().add(this.smoothLoessDegree, "smoothLoessDegree", true);
        this.smoothLoessFamily = new MinerComboBox(ChartBuilder.getText("graph_dialog_family_text"), 'F', new String[]{"Gaussian", "Symmetric"});
        this.smoothLoessFamily.setValue("Symmetric");
        this.smoothLoessFamily.setEditable(false);
        this.smoothLoessFamily.setEnabled(false);
        loessGroup.add(this.smoothLoessFamily);
        this.getFunctionInfo().add(this.smoothLoessFamily, "smoothLoessFamily", true);
        MinerGroupPanel splineGroup = new MinerGroupPanel(ChartBuilder.getText("graph_dialog_smooth_spline_specs"));
        smoothRightColumn.add(splineGroup);
        this.smoothSplineDf = new MinerComboBox(ChartBuilder.getText("graph_dialog_degree_freedom"), 'D', new String[]{"Crossvalidate", "2", "3", "4", "6", "10"});
        this.smoothSplineDf.setValue("3");
        this.smoothSplineDf.setEnabled(false);
        splineGroup.add(this.smoothSplineDf);
        this.getFunctionInfo().add(this.smoothSplineDf, "smoothSplineDf", true);
        ActionListener smoothListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                HexbinPlotDialog.this.refreshSmoothEnabledStatus();
            }
        };
        this.smoothType.addActionListener(smoothListener);
        this.getFunctionInfo().addActionListener(smoothListener);
        smoothRightColumn.add(new MinerBoxFiller());
        tabVec.add(new TitlesPage(this.getFunctionInfo()));
        tabVec.add(new AxesPage(this.getFunctionInfo()));
        tabVec.add(new MultipanelPage(this.getFunctionInfo()));
        tabVec.add(new FilePage(this.getFunctionInfo()));
        return tabVec;
    }

    private void refreshSmoothEnabledStatus() {
        String typeValue = this.smoothType.getValue();
        if (typeValue.equals("Loess")) {
            this.smoothNumPts.setEnabled(true);
            this.smoothLoessSpan.setEnabled(true);
            this.smoothLoessDegree.setEnabled(true);
            this.smoothLoessFamily.setEnabled(true);
            this.smoothSplineDf.setEnabled(false);
        } else if (typeValue.equals("Smoothing Spline")) {
            this.smoothNumPts.setEnabled(true);
            this.smoothLoessSpan.setEnabled(false);
            this.smoothLoessDegree.setEnabled(false);
            this.smoothLoessFamily.setEnabled(false);
            this.smoothSplineDf.setEnabled(true);
        } else {
            this.smoothNumPts.setEnabled(false);
            this.smoothLoessSpan.setEnabled(false);
            this.smoothLoessDegree.setEnabled(false);
            this.smoothLoessFamily.setEnabled(false);
            this.smoothSplineDf.setEnabled(false);
        }
    }
}

