/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.lib.StringConverter;

class HsqlNameManager {
    private static HsqlNameManager staticManager = new HsqlNameManager();
    private static int serialNumber = 0;
    private int sysNumber = 0;

    HsqlNameManager() {
    }

    static HsqlName newHsqlSystemTableName(String name) {
        return new HsqlName(staticManager, name);
    }

    HsqlName newHsqlName(String name, boolean isquoted) throws HsqlException {
        return new HsqlName(this, name, isquoted);
    }

    HsqlName newHsqlName(String prefix, String name, boolean isquoted) throws HsqlException {
        return new HsqlName(this, prefix, name, isquoted);
    }

    HsqlName newHsqlName(String name) {
        return new HsqlName(this, name);
    }

    HsqlName newAutoName(String type) {
        return this.newAutoName(type, null);
    }

    HsqlName newAutoName(String type, String namepart) {
        StringBuffer sbname = new StringBuffer();
        if (type != null) {
            if (type.length() != 0) {
                sbname.append("SYS_");
                sbname.append(type);
                sbname.append('_');
                if (namepart != null) {
                    sbname.append(namepart);
                    sbname.append('_');
                }
                sbname.append(++this.sysNumber);
            }
        } else {
            sbname.append(namepart);
        }
        return new HsqlName(this, sbname.toString());
    }

    void resetNumbering() {
        this.sysNumber = 0;
        serialNumber = 0;
    }

    public static class HsqlName {
        HsqlNameManager manager;
        public String name;
        boolean isNameQuoted;
        public String statementName;
        private final int hashCode;

        private HsqlName(HsqlNameManager man) {
            this.manager = man;
            this.hashCode = serialNumber++;
        }

        private HsqlName(HsqlNameManager man, String name, boolean isquoted) throws HsqlException {
            this(man);
            this.rename(name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String prefix, String name, boolean isquoted) throws HsqlException {
            this(man);
            this.rename(prefix, name, isquoted);
        }

        private HsqlName(HsqlNameManager man, String name) {
            this(man);
            this.name = this.statementName = name;
        }

        void rename(String name, boolean isquoted) throws HsqlException {
            this.name = name;
            this.statementName = name;
            this.isNameQuoted = isquoted;
            if (name == null || name.length() == 0) {
                throw Trace.error(74);
            }
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(name, '\"', true);
            }
            if (name.startsWith("SYS_")) {
                int index = name.lastIndexOf(95) + 1;
                try {
                    int temp = Integer.parseInt(name.substring(index));
                    if (temp > this.manager.sysNumber) {
                        this.manager.sysNumber = temp;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        void rename(String prefix, String name, boolean isquoted) throws HsqlException {
            StringBuffer sbname = new StringBuffer(prefix);
            sbname.append('_');
            sbname.append(name);
            this.rename(sbname.toString(), isquoted);
        }

        public boolean equals(HsqlName other) {
            return this.hashCode == other.hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static boolean isReservedIndexName(String name) {
            return name.startsWith("SYS_IDX_") || name.startsWith("SYS_PK_") || name.startsWith("SYS_REF_");
        }

        boolean isReservedIndexName() {
            return HsqlName.isReservedIndexName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object o) {
            return this.hashCode - o.hashCode();
        }
    }
}

