/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.sql;

import com.insightful.miner.sql.HsqlDateTime;
import com.insightful.miner.sql.HsqlException;
import com.insightful.miner.sql.Trace;
import com.insightful.miner.sql.Types;
import com.insightful.miner.sql.lib.BooleanConverter;
import com.insightful.miner.sql.lib.HashMap;
import com.insightful.miner.sql.lib.IntValueHashMap;
import com.insightful.miner.sql.lib.ValuePool;
import java.math.BigDecimal;
import java.util.Locale;

public class Tokenizer {
    private static final int NO_TYPE = 0;
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int BOOLEAN = 9;
    private static final int DATE = 10;
    private static final int TIME = 11;
    private static final int TIMESTAMP = 12;
    private static final int NULL = 13;
    private static final int QUOTED_IDENTIFIER = 14;
    private static final int REMARK_LINE = 15;
    private static final int REMARK = 16;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private boolean bWait;
    private static HashMap hKeyword = new HashMap(67);
    static IntValueHashMap valueTokens;
    private boolean convertToUpperCase;

    Tokenizer() {
    }

    public Tokenizer(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
        this.convertToUpperCase = true;
    }

    void reset(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
        this.oValue = null;
        this.tokenIndex = 0;
        this.nextTokenIndex = 0;
        this.beginIndex = 0;
        this.iType = 0;
        this.sToken = null;
        this.sLongNameFirst = null;
        this.bWait = false;
        this.convertToUpperCase = true;
    }

    void setConvertToUpperCase(boolean upperCase) {
        this.convertToUpperCase = upperCase;
    }

    String normalizeCase(String str) {
        if (!this.convertToUpperCase) {
            return str;
        }
        return this.makeUpperCase(str);
    }

    String makeUpperCase(String str) {
        return str.toUpperCase(Locale.ENGLISH);
    }

    void back() throws HsqlException {
        Trace.doAssert(!this.bWait, "back");
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.tokenIndex;
        this.bWait = true;
    }

    String getThis(String match) throws HsqlException {
        this.getToken();
        if (this.sToken.compareToIgnoreCase(match) != 0) {
            throw Trace.error(11, 160, new Object[]{this.sToken, match});
        }
        return this.sToken;
    }

    String getCurrentThis(String match) throws HsqlException {
        if (!this.sToken.equals(match)) {
            throw Trace.error(11, 160, new Object[]{this.sToken, match});
        }
        return this.sToken;
    }

    boolean isGetThis(String match) throws HsqlException {
        return this.isGetThis(match, false);
    }

    boolean isGetThis(String match, boolean upper) throws HsqlException {
        String token;
        this.getToken();
        String string = token = upper ? this.sToken.toUpperCase() : this.sToken;
        if (token.equals(match)) {
            return true;
        }
        this.back();
        return false;
    }

    String getUserOrPassword() throws HsqlException {
        this.getToken();
        switch (this.iType) {
            case 6: {
                return this.normalizeCase(this.sToken);
            }
            case 1: {
                return this.sToken;
            }
            case 14: {
                return this.normalizeCase(this.sToken);
            }
        }
        throw Trace.error(11, this.sToken);
    }

    boolean wasValue() {
        switch (this.iType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    boolean wasQuotedIdentifier() {
        return this.iType == 14;
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 14) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        boolean ret = !hKeyword.containsKey(this.makeUpperCase(this.sToken));
        return ret;
    }

    boolean wasIdentifier() {
        if (this.iType == 14) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        boolean ret = !hKeyword.containsKey(this.makeUpperCase(this.sToken));
        return ret;
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getName() throws HsqlException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    String getIdentifier() throws HsqlException {
        this.getToken();
        if (!this.wasIdentifier()) {
            throw Trace.error(11, this.sToken);
        }
        return this.makeUpperCase(this.sToken);
    }

    public String getString() throws HsqlException {
        this.getToken();
        return this.makeUpperCase(this.sToken);
    }

    public String getCurrentUnalteredString() throws HsqlException {
        return this.sToken;
    }

    int getInt() throws HsqlException {
        this.getToken();
        Object o = this.getAsValue();
        int t = this.getType();
        if (t != 4) {
            throw Trace.error(16, Types.getTypeString(t));
        }
        return ((Number)o).intValue();
    }

    long getBigint() throws HsqlException {
        this.getToken();
        Object o = this.getAsValue();
        int t = this.getType();
        if (t != 4 && t != -5) {
            throw Trace.error(16, Types.getTypeString(t));
        }
        return ((Number)o).longValue();
    }

    Object getInType(int type) throws HsqlException {
        this.getToken();
        Object o = this.getAsValue();
        int t = this.getType();
        if (t != type) {
            throw Trace.error(16, Types.getTypeString(t));
        }
        return o;
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 16;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
        }
        return 0;
    }

    Object getAsValue() throws HsqlException {
        if (!this.wasValue()) {
            throw Trace.error(11, this.sToken);
        }
        switch (this.iType) {
            case 6: {
                return this.sToken;
            }
            case 7: {
                return ValuePool.getLong(Long.parseLong(this.sToken));
            }
            case 4: {
                if (this.sToken.length() < 11) {
                    try {
                        return ValuePool.getInt(Integer.parseInt(this.sToken));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                if (this.sToken.length() < 20) {
                    try {
                        this.iType = 7;
                        return ValuePool.getLong(Long.parseLong(this.sToken));
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                this.iType = 8;
                return new BigDecimal(this.sToken);
            }
            case 5: {
                double d = new Double(this.sToken);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case 8: {
                return new BigDecimal(this.sToken);
            }
            case 9: {
                return BooleanConverter.getBoolean(this.sToken);
            }
            case 10: {
                return HsqlDateTime.dateValue(this.sToken);
            }
            case 11: {
                return HsqlDateTime.timeValue(this.sToken);
            }
            case 12: {
                return HsqlDateTime.timestampValue(this.sToken);
            }
            case 13: {
                return null;
            }
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int begin, int end) {
        return this.sCommand.substring(begin, end);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int position) {
        this.beginIndex = position;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    private void getToken() throws HsqlException {
        if (this.bWait) {
            this.bWait = false;
            this.iIndex = this.nextTokenIndex;
            return;
        }
        while (this.iIndex < this.iLength && Character.isWhitespace(this.sCommand.charAt(this.iIndex))) {
            ++this.iIndex;
        }
        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        char c = this.sCommand.charAt(this.iIndex);
        boolean point = false;
        boolean digit = false;
        boolean exp = false;
        boolean afterexp = false;
        boolean end = false;
        char cfirst = '\u0000';
        if (Character.isJavaIdentifierStart(c)) {
            this.iType = 1;
        } else if (Character.isDigit(c)) {
            this.iType = 4;
            digit = true;
        } else {
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '=': 
                case '?': {
                    this.iType = 3;
                    ++this.iIndex;
                    this.sToken = String.valueOf(c);
                    return;
                }
                case '\"': {
                    this.iType = 14;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    c = this.sCommand.charAt(this.iIndex);
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.iType = 2;
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    cfirst = c;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    point = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(c));
                }
            }
        }
        int start = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                end = true;
                Trace.check(this.iType != 6 && this.iType != 14, 12);
            } else {
                c = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    int type;
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.sToken = this.normalizeCase(this.sCommand.substring(start, this.iIndex));
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.iType = 2;
                    } else if (c != '(' && (type = valueTokens.get((Object)this.sToken, -1)) != -1) {
                        this.iType = type;
                    }
                    return;
                }
                case 6: 
                case 14: {
                    break;
                }
                case 16: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 15: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c == '/' && cfirst == '/') {
                        this.iType = 15;
                        break;
                    }
                    if (c == '-' && cfirst == '-') {
                        this.iType = 15;
                        break;
                    }
                    if (c == '*' && cfirst == '/') {
                        this.iType = 16;
                        break;
                    }
                    if (c == '>' || c == '=' || c == '|') break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(c)) {
                        digit = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 8;
                        if (point) {
                            throw Trace.error(11, ".");
                        }
                        point = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (exp) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        afterexp = true;
                        point = true;
                        exp = true;
                        break;
                    }
                    if (c == '-' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    if (c == '+' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    afterexp = false;
                    if (!digit) {
                        if (point && start == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(c));
                    }
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char quoteChar) throws HsqlException {
        try {
            int nextIndex = this.iIndex;
            boolean quoteInside = false;
            while (true) {
                if ((nextIndex = this.sCommand.indexOf(quoteChar, nextIndex)) < 0) {
                    throw Trace.error(12);
                }
                if (nextIndex >= this.iLength - 1 || this.sCommand.charAt(nextIndex + 1) != quoteChar) break;
                quoteInside = true;
                nextIndex += 2;
            }
            char[] chBuffer = new char[nextIndex - this.iIndex];
            this.sCommand.getChars(this.iIndex, nextIndex, chBuffer, 0);
            int j = chBuffer.length;
            if (quoteInside) {
                j = 0;
                int i = 0;
                while (i < chBuffer.length) {
                    if (chBuffer[i] == quoteChar) {
                        ++i;
                    }
                    chBuffer[j] = chBuffer[i];
                    ++i;
                    ++j;
                }
            }
            this.iIndex = ++nextIndex;
            return new String(chBuffer, 0, j);
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    int getLength() {
        return this.iLength;
    }

    static {
        String[] keyword = new String[]{"AS", "AND", "ALL", "AVG", "BY", "BETWEEN", "BOTH", "CALL", "CASE", "CASEWHEN", "CAST", "CONVERT", "CONCAT", "COUNT", "COALESCE", "DISTINCT", "ELSE", "END", "EXISTS", "EXCEPT", "EXTRACT", "FOR", "FROM", "GROUP", "IF", "INTO", "IFNULL", "IS", "IN", "JOIN", "INTERSECT", "INNER", "LEADING", "LIKE", "MAX", "MIN", "NEXT", "NULLIF", "NOT", "MINUS", "ON", "ORDER", "OR", "OUTER", "POSITION", "PRIMARY", "SELECT", "SET", "SUBSTRING", "SUM", "THEN", "TO", "TRAILING", "TRIM", "UNIQUE", "UNION", "VALUES", "WHEN", "WHERE", "HAVING"};
        for (int i = 0; i < keyword.length; ++i) {
            hKeyword.put(keyword[i], hKeyword);
        }
        valueTokens = new IntValueHashMap(17);
        valueTokens.put("NULL", 13);
        valueTokens.put("TRUE", 9);
        valueTokens.put("FALSE", 9);
    }
}

