/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.TimeSeriesDataPair;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class TimeSeriesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset {
    protected List data = new ArrayList();
    protected Calendar workingCalendar;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(BasicTimeSeries basicTimeSeries) {
        this(basicTimeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(BasicTimeSeries basicTimeSeries, TimeZone timeZone) {
        if (basicTimeSeries != null) {
            this.data.add(basicTimeSeries);
            basicTimeSeries.addChangeListener(this);
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public BasicTimeSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimeSeriesDataset.getSeries(...): index outside valid range.");
        }
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        return basicTimeSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(BasicTimeSeries basicTimeSeries) {
        if (basicTimeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(basicTimeSeries);
        basicTimeSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getMiddle(this.workingCalendar));
    }

    public Number getStartXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getStart(this.workingCalendar));
    }

    public Number getEndXValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getEnd(this.workingCalendar));
    }

    public Number getYValue(int n, int n2) {
        BasicTimeSeries basicTimeSeries = (BasicTimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = basicTimeSeries.getDataPair(n2);
        return timeSeriesDataPair.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }
}

