/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.web.context.request.RequestAttributes;

public abstract class RequestContextHolder {
    private static final ThreadLocal requestAttributesHolder = new InheritableThreadLocal();

    public static void setRequestAttributes(RequestAttributes accessor) {
        requestAttributesHolder.set(accessor);
    }

    public static RequestAttributes getRequestAttributes() {
        return (RequestAttributes)requestAttributesHolder.get();
    }

    public static RequestAttributes currentRequestAttributes() throws IllegalStateException {
        RequestAttributes accessor = (RequestAttributes)requestAttributesHolder.get();
        if (accessor == null) {
            throw new IllegalStateException("No thread-bound request: use RequestContextFilter");
        }
        return accessor;
    }
}

