/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.UnitProcessor;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.extensions.svg.SVGObj;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SVGElement
extends SVGObj {
    public SVGElement(FONode parent) {
        super(parent);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        super.processNode(elementName, locator, attlist, propertyList);
        this.init();
    }

    public Point2D getDimension(final Point2D view) {
        Element svgRoot = this.element;
        try {
            URL baseURL = new URL(this.getUserAgent().getBaseURL() == null ? new File("").toURL().toExternalForm() : this.getUserAgent().getBaseURL());
            if (baseURL != null) {
                ((SVGOMDocument)this.doc).setURLObject(baseURL);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not set base URL for svg", e);
        }
        SVGSVGElement e = ((SVGDocument)this.doc).getRootElement();
        final float ptmm = this.getUserAgent().getPixelUnitToMillimeter();
        SVGContext dc = new SVGContext(){

            public float getPixelToMM() {
                return ptmm;
            }

            public float getPixelUnitToMillimeter() {
                return ptmm;
            }

            public Rectangle2D getBBox() {
                return new Rectangle2D.Double(0.0, 0.0, view.getX(), view.getY());
            }

            public AffineTransform getScreenTransform() {
                throw new UnsupportedOperationException("NYI");
            }

            public void setScreenTransform(AffineTransform at) {
                throw new UnsupportedOperationException("NYI");
            }

            public AffineTransform getCTM() {
                return new AffineTransform();
            }

            public AffineTransform getGlobalTransform() {
                return new AffineTransform();
            }

            public float getViewportWidth() {
                return (float)view.getX();
            }

            public float getViewportHeight() {
                return (float)view.getY();
            }

            public float getFontSize() {
                return 12.0f;
            }

            public void deselectAll() {
            }
        };
        ((SVGOMElement)e).setSVGContext(dc);
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
        int fontSize = 12;
        Point2D p2d = SVGElement.getSize(fontSize, svgRoot, this.getUserAgent().getPixelUnitToMillimeter());
        ((SVGOMElement)e).setSVGContext(null);
        return p2d;
    }

    private void init() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.doc = impl.createDocument(svgNS, "svg", null);
        this.element = this.doc.getDocumentElement();
        this.buildTopLevel(this.doc, this.element);
    }

    public static Point2D getSize(int size, Element svgRoot, float ptmm) {
        PDFUnitContext ctx = new PDFUnitContext(size, svgRoot, ptmm);
        String str = svgRoot.getAttributeNS(null, "width");
        if (str.length() == 0) {
            str = "100%";
        }
        float width = UnitProcessor.svgHorizontalLengthToUserSpace((String)str, (String)"width", (UnitProcessor.Context)ctx);
        str = svgRoot.getAttributeNS(null, "height");
        if (str.length() == 0) {
            str = "100%";
        }
        float height = UnitProcessor.svgVerticalLengthToUserSpace((String)str, (String)"height", (UnitProcessor.Context)ctx);
        return new Point2D.Float(width, height);
    }

    public static class PDFUnitContext
    implements UnitProcessor.Context {
        private Element e;
        private int fontSize;
        private float pixeltoMM;

        public PDFUnitContext(int size, Element e, float ptmm) {
            this.e = e;
            this.fontSize = size;
            this.pixeltoMM = ptmm;
        }

        public Element getElement() {
            return this.e;
        }

        public UnitProcessor.Context getParentElementContext() {
            return null;
        }

        public float getPixelToMM() {
            return this.pixeltoMM;
        }

        public float getPixelUnitToMillimeter() {
            return this.pixeltoMM;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return 100.0f;
        }

        public float getViewportHeight() {
            return 100.0f;
        }
    }
}

