/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageConsumer;

public class GifImage
extends AbstractFopImage {
    public GifImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    protected boolean loadBitmap() {
        int[] tmpMap;
        block13: {
            tmpMap = null;
            try {
                DummyConnection con = new DummyConnection(this.inputStream);
                ImageProducer ip = (ImageProducer)con.getContent();
                if (ip == null) {
                    return false;
                }
                FopImageConsumer consumer = new FopImageConsumer(ip);
                ip.startProduction(consumer);
                while (!consumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.height = consumer.getHeight();
                this.width = consumer.getWidth();
                try {
                    tmpMap = consumer.getImage();
                }
                catch (Exception ex) {
                    log.error("Image grabbing interrupted : " + ex.getMessage(), ex);
                    return false;
                }
                this.inputStream.close();
                this.inputStream = null;
                ColorModel cm = consumer.getColorModel();
                this.bitsPerPixel = 8;
                this.colorSpace = ColorSpace.getInstance(1004);
                if (cm.hasAlpha()) {
                    int transparencyType = cm.getTransparency();
                    if (transparencyType == 1) {
                        this.isTransparent = false;
                        break block13;
                    }
                    if (transparencyType == 2) {
                        if (cm instanceof IndexColorModel) {
                            IndexColorModel indexcm = (IndexColorModel)cm;
                            this.isTransparent = false;
                            byte[] alphas = new byte[indexcm.getMapSize()];
                            byte[] reds = new byte[indexcm.getMapSize()];
                            byte[] greens = new byte[indexcm.getMapSize()];
                            byte[] blues = new byte[indexcm.getMapSize()];
                            indexcm.getAlphas(alphas);
                            indexcm.getReds(reds);
                            indexcm.getGreens(greens);
                            indexcm.getBlues(blues);
                            for (int i = 0; i < indexcm.getMapSize(); ++i) {
                                if ((alphas[i] & 0xFF) != 0) continue;
                                this.isTransparent = true;
                                this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                break block13;
                            }
                            break block13;
                        }
                        this.isTransparent = false;
                        break block13;
                    }
                    this.isTransparent = false;
                    break block13;
                }
                this.isTransparent = false;
            }
            catch (Exception ex) {
                log.error("Error while loading image  : " + ex.getClass() + " - " + ex.getMessage(), ex);
                return false;
            }
        }
        this.bitmapsSize = this.width * this.height * 3;
        this.bitmaps = new byte[this.bitmapsSize];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int p = tmpMap[i * this.width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
            }
        }
        return true;
    }

    protected static class DummyConnection
    extends URLConnection {
        private InputStream inputStream;

        DummyConnection(InputStream is) {
            super(null);
            this.inputStream = is;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public void connect() throws IOException {
        }

        public String getContentType() {
            return "image/gif";
        }

        public int getContentLength() {
            try {
                return this.inputStream.available();
            }
            catch (IOException e) {
                return -1;
            }
        }
    }
}

