/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.traits.MinOptMax;

public class ElementListUtils {
    public static void removeLegalBreaks(LinkedList elements) {
        ListIterator<KnuthPenalty> i = elements.listIterator();
        while (i.hasNext()) {
            KnuthElement el = (KnuthElement)i.next();
            if (el.isPenalty()) {
                KnuthPenalty penalty = (KnuthPenalty)el;
                if (penalty.getP() >= 1000) continue;
                i.set(new KnuthPenalty(penalty.getW(), 1000, penalty.isFlagged(), penalty.getPosition(), penalty.isAuxiliary()));
                continue;
            }
            if (!el.isGlue()) continue;
            i.previous();
            if (!el.isBox()) continue;
            i.next();
            i.add(new KnuthPenalty(0, 1000, false, null, false));
        }
    }

    public static boolean removeLegalBreaks(LinkedList elements, MinOptMax constraint) {
        int len = 0;
        ListIterator<KnuthPenalty> i = elements.listIterator();
        while (i.hasNext()) {
            KnuthElement el = (KnuthElement)i.next();
            if (el.isPenalty()) {
                KnuthPenalty penalty = (KnuthPenalty)el;
                if (penalty.getP() < 1000) {
                    i.set(new KnuthPenalty(penalty.getW(), 1000, penalty.isFlagged(), penalty.getPosition(), penalty.isAuxiliary()));
                }
            } else if (el.isGlue()) {
                len += el.getW();
                i.previous();
                if (el.isBox()) {
                    i.next();
                    i.add(new KnuthPenalty(0, 1000, false, null, false));
                }
            } else {
                len += el.getW();
            }
            if (len <= constraint.opt) continue;
            return false;
        }
        return true;
    }

    public static int calcContentLength(List elems, int start, int end) {
        ListIterator iter = elems.listIterator(start);
        int count = end - start + 1;
        int len = 0;
        while (iter.hasNext()) {
            KnuthElement el = (KnuthElement)iter.next();
            if (el.isBox()) {
                len += el.getW();
            } else if (el.isGlue()) {
                len += el.getW();
            }
            if (--count != 0) continue;
            break;
        }
        return len;
    }

    public static int calcContentLength(List elems) {
        return ElementListUtils.calcContentLength(elems, 0, elems.size() - 1);
    }
}

