/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.RegionReference;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.traits.MinOptMax;

public class StaticContentLayoutManager
extends BlockStackingLayoutManager {
    private RegionReference targetRegion;
    private Block targetBlock;
    private SideRegion regionFO;

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, SideRegion reg) {
        super(node);
        this.setParent(pslm);
        this.regionFO = reg;
        this.targetRegion = this.getCurrentPV().getRegionReference(this.regionFO.getNameId());
    }

    public StaticContentLayoutManager(PageSequenceLayoutManager pslm, StaticContent node, Block block) {
        super(node);
        this.setParent(pslm);
        this.targetBlock = block;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        BlockLevelLayoutManager curLM;
        this.fobj.setLayoutDimension(PercentBase.BLOCK_IPD, context.getRefIPD());
        this.fobj.setLayoutDimension(PercentBase.BLOCK_BPD, context.getStackLimit().opt);
        BlockLevelLayoutManager prevLM = null;
        MinOptMax stackSize = new MinOptMax();
        LinkedList returnList = new LinkedList();
        while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
            LinkedList<KnuthElement> returnedList;
            if (curLM instanceof InlineLevelLayoutManager) {
                log.error("inline area not allowed under flow - ignoring");
                curLM.setFinished(true);
                continue;
            }
            MinOptMax bpd = context.getStackLimit();
            LayoutContext childLC = new LayoutContext(0);
            childLC.setStackLimit(MinOptMax.subtract(bpd, stackSize));
            childLC.setRefIPD(context.getRefIPD());
            LinkedList<KnuthElement> tempList = returnedList = curLM.getNextKnuthElements(childLC, alignment);
            returnedList = new LinkedList<KnuthElement>();
            ListIterator listIter = tempList.listIterator();
            while (listIter.hasNext()) {
                KnuthElement tempElement = (KnuthElement)listIter.next();
                tempElement.setPosition(new NonLeafPosition(this, tempElement.getPosition()));
                returnedList.add(tempElement);
            }
            if (returnedList.size() == 1 && ((KnuthElement)returnedList.getFirst()).isPenalty() && ((KnuthPenalty)returnedList.getFirst()).getP() == -1000) {
                returnList.addAll(returnedList);
                return returnList;
            }
            if (returnList.size() > 0) {
                if (prevLM.mustKeepWithNext() || curLM.mustKeepWithPrevious()) {
                    returnList.add(new KnuthPenalty(0, 1000, false, new Position(this), false));
                } else if (!((KnuthElement)returnList.getLast()).isGlue()) {
                    returnList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
            }
            if (returnedList.size() > 0) {
                returnList.addAll(returnedList);
                if (((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
                    return returnList;
                }
            }
            prevLM = curLM;
        }
        this.setFinished(true);
        if (returnList.size() > 0) {
            return returnList;
        }
        return null;
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
        this.targetRegion = null;
    }

    public void addChildArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            this.targetBlock.addBlock((Block)childArea);
        } else {
            this.targetRegion.addBlock((Block)childArea);
        }
    }

    public Area getParentArea(Area childArea) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            return this.targetBlock;
        }
        return this.targetRegion;
    }

    public void doLayout() {
        int targetIPD = 0;
        int targetBPD = 0;
        int targetAlign = 9;
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            targetIPD = this.targetBlock.getIPD();
            targetBPD = this.targetBlock.getBPD();
            targetAlign = 13;
        } else {
            targetIPD = this.targetRegion.getIPD();
            targetBPD = this.targetRegion.getBPD();
            targetAlign = this.regionFO.getDisplayAlign();
        }
        StaticContentBreaker breaker = new StaticContentBreaker(this, targetIPD, targetAlign);
        breaker.doLayout(targetBPD);
        if (breaker.isOverflow()) {
            if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator") || this.regionFO.getOverflow() == 42) {
                // empty if block
            }
            log.warn("static-content overflows the available area.");
        }
    }

    protected StaticContent getStaticContentFO() {
        return (StaticContent)this.fobj;
    }

    private class StaticContentBreaker
    extends AbstractBreaker {
        private StaticContentLayoutManager lm;
        private int displayAlign;
        private int ipd;
        private boolean overflow = false;

        public StaticContentBreaker(StaticContentLayoutManager lm, int ipd, int displayAlign) {
            this.lm = lm;
            this.ipd = ipd;
            this.displayAlign = displayAlign;
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        public boolean isOverflow() {
            return this.overflow;
        }

        protected LayoutManager getTopLevelLM() {
            return this.lm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext lc = super.createLayoutContext();
            lc.setRefIPD(this.ipd);
            return lc;
        }

        protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
            LayoutManager curLM;
            LinkedList returnList = new LinkedList();
            while ((curLM = StaticContentLayoutManager.this.getChildLM()) != null) {
                LayoutContext childLC = new LayoutContext(0);
                childLC.setStackLimit(context.getStackLimit());
                childLC.setRefIPD(context.getRefIPD());
                LinkedList returnedList = null;
                if (!curLM.isFinished()) {
                    returnedList = curLM.getNextKnuthElements(childLC, alignment);
                }
                if (returnedList == null) continue;
                this.lm.wrapPositionElements(returnedList, returnList);
            }
            StaticContentLayoutManager.this.setFinished(true);
            return returnList;
        }

        protected int getCurrentDisplayAlign() {
            return this.displayAlign;
        }

        protected boolean hasMoreContent() {
            return !this.lm.isFinished();
        }

        protected void addAreas(PositionIterator posIter, LayoutContext context) {
            AreaAdditionUtil.addAreas(this.lm, posIter, context);
        }

        protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            this.addAreas(alg, partCount, originalList, effectiveList);
            if (partCount > 1) {
                this.overflow = true;
            }
        }

        protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        }

        protected LayoutManager getCurrentChildLM() {
            return null;
        }
    }
}

