/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.traits.BorderProps;

public class TraitSetter {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$TraitSetter == null ? (class$org$apache$fop$layoutmgr$TraitSetter = TraitSetter.class$("org.apache.fop.layoutmgr.TraitSetter")) : class$org$apache$fop$layoutmgr$TraitSetter);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$TraitSetter;

    public static void setBorderPaddingTraits(Area area, CommonBorderPaddingBackground bpProps, boolean bNotFirst, boolean bNotLast) {
        int iBP = bpProps.getPadding(2, bNotFirst);
        if (iBP > 0) {
            area.addTrait(Trait.PADDING_START, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(3, bNotLast)) > 0) {
            area.addTrait(Trait.PADDING_END, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(0, false)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(1, false)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, new Integer(iBP));
        }
        TraitSetter.addBorderTrait(area, bpProps, bNotFirst, 2, 0, Trait.BORDER_START);
        TraitSetter.addBorderTrait(area, bpProps, bNotLast, 3, 0, Trait.BORDER_END);
        TraitSetter.addBorderTrait(area, bpProps, false, 0, 0, Trait.BORDER_BEFORE);
        TraitSetter.addBorderTrait(area, bpProps, false, 1, 0, Trait.BORDER_AFTER);
    }

    private static void addBorderTrait(Area area, CommonBorderPaddingBackground bpProps, boolean bDiscard, int iSide, int mode, Object oTrait) {
        int iBP = bpProps.getBorderWidth(iSide, bDiscard);
        if (iBP > 0) {
            area.addTrait(oTrait, new BorderProps(bpProps.getBorderStyle(iSide), iBP, bpProps.getBorderColor(iSide), mode));
        }
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground bordProps) {
        BorderProps bps = TraitSetter.getBorderProps(bordProps, 0);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 1)) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 2)) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getBorderProps(bordProps, 3)) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
        TraitSetter.addPadding(area, bordProps);
    }

    public static void addCollapsingBorders(Area area, CommonBorderPaddingBackground bordProps, boolean[] outer) {
        BorderProps bps = TraitSetter.getCollapsingBorderProps(bordProps, 0, outer[0]);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(bordProps, 1, outer[1])) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(bordProps, 2, outer[2])) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(bordProps, 3, outer[3])) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
        TraitSetter.addPadding(area, bordProps);
    }

    private static void addPadding(Area area, CommonBorderPaddingBackground bordProps) {
        int padding = bordProps.getPadding(2, false);
        if (padding != 0) {
            area.addTrait(Trait.PADDING_START, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(3, false)) != 0) {
            area.addTrait(Trait.PADDING_END, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(0, false)) != 0) {
            area.addTrait(Trait.PADDING_BEFORE, new Integer(padding));
        }
        if ((padding = bordProps.getPadding(1, false)) != 0) {
            area.addTrait(Trait.PADDING_AFTER, new Integer(padding));
        }
    }

    private static BorderProps getBorderProps(CommonBorderPaddingBackground bordProps, int side) {
        int width = bordProps.getBorderWidth(side, false);
        if (width != 0) {
            BorderProps bps = new BorderProps(bordProps.getBorderStyle(side), width, bordProps.getBorderColor(side), 0);
            return bps;
        }
        return null;
    }

    private static BorderProps getCollapsingBorderProps(CommonBorderPaddingBackground bordProps, int side, boolean outer) {
        int width = bordProps.getBorderWidth(side, false);
        if (width != 0) {
            BorderProps bps = new BorderProps(bordProps.getBorderStyle(side), width, bordProps.getBorderColor(side), outer ? 2 : 1);
            return bps;
        }
        return null;
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground backProps) {
        if (!backProps.hasBackground()) {
            return;
        }
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backgroundColor);
        if (backProps.getFopImage() != null) {
            back.setURL(backProps.backgroundImage);
            back.setFopImage(backProps.getFopImage());
            back.setRepeat(backProps.backgroundRepeat);
            if (backProps.backgroundPositionHorizontal != null && (back.getRepeat() == 96 || back.getRepeat() == 114)) {
                if (backProps.backgroundPositionHorizontal instanceof PercentLength) {
                    if (area.getIPD() > 0) {
                        int width = area.getIPD();
                        width += backProps.getPaddingStart(false);
                        back.setHoriz((int)((double)((width += backProps.getPaddingEnd(false)) - back.getFopImage().getIntrinsicWidth()) * ((PercentLength)backProps.backgroundPositionHorizontal).value()));
                    } else {
                        log.warn("Horizontal background image positioning ignored");
                    }
                } else {
                    back.setHoriz(backProps.backgroundPositionHorizontal.getValue());
                }
            }
            if (backProps.backgroundPositionVertical != null && (back.getRepeat() == 96 || back.getRepeat() == 113)) {
                if (backProps.backgroundPositionVertical instanceof PercentLength) {
                    if (area.getBPD() > 0) {
                        int height = area.getBPD();
                        height += backProps.getPaddingBefore(false);
                        back.setVertical((int)((double)((height += backProps.getPaddingAfter(false)) - back.getFopImage().getIntrinsicHeight()) * ((PercentLength)backProps.backgroundPositionVertical).value()));
                    } else {
                        log.warn("Vertical background image positioning ignored");
                    }
                } else {
                    back.setVertical(backProps.backgroundPositionVertical.getValue());
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, back);
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground bpProps, CommonMarginBlock marginProps) {
        int spaceEnd;
        int endIndent;
        int spaceStart;
        int startIndent = marginProps.startIndent.getValue();
        if (startIndent != 0) {
            area.addTrait(Trait.START_INDENT, new Integer(startIndent));
        }
        if ((spaceStart = marginProps.startIndent.getValue() - bpProps.getBorderStartWidth(false) - bpProps.getPaddingStart(false)) != 0) {
            area.addTrait(Trait.SPACE_START, new Integer(spaceStart));
        }
        if ((endIndent = marginProps.endIndent.getValue()) != 0) {
            area.addTrait(Trait.END_INDENT, new Integer(endIndent));
        }
        if ((spaceEnd = marginProps.endIndent.getValue() - bpProps.getBorderEndWidth(false) - bpProps.getPaddingEnd(false)) != 0) {
            area.addTrait(Trait.SPACE_END, new Integer(spaceEnd));
        }
    }

    public static void addBreaks(Area area, int breakBefore, int breakAfter) {
        area.addTrait(Trait.BREAK_AFTER, new Integer(breakAfter));
        area.addTrait(Trait.BREAK_BEFORE, new Integer(breakBefore));
    }

    public static void addTextDecoration(Area area, CommonTextDecoration deco) {
        if (deco != null) {
            if (deco.hasUnderline()) {
                area.addTrait(Trait.UNDERLINE, Boolean.TRUE);
                area.addTrait(Trait.UNDERLINE_COLOR, deco.getUnderlineColor());
            }
            if (deco.hasOverline()) {
                area.addTrait(Trait.OVERLINE, Boolean.TRUE);
                area.addTrait(Trait.OVERLINE_COLOR, deco.getOverlineColor());
            }
            if (deco.hasLineThrough()) {
                area.addTrait(Trait.LINETHROUGH, Boolean.TRUE);
                area.addTrait(Trait.LINETHROUGH_COLOR, deco.getLineThroughColor());
            }
            if (deco.isBlinking()) {
                area.addTrait(Trait.BLINK, Boolean.TRUE);
            }
        }
    }

    public static void setProducerID(Area area, String id) {
        if (id != null && id.length() > 0) {
            area.addTrait(Trait.PROD_ID, id);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

